import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';
import tailwindcss from '@tailwindcss/vite';
import { execSync } from 'child_process';

// Plugin to clear Laravel cache after build
function clearLaravelCache() {
    return {
        name: 'clear-laravel-cache',
        closeBundle() {
            try {
                console.log('🧹 Clearing Laravel caches...');
                execSync('php artisan optimize:clear', { stdio: 'inherit' });
                console.log('✅ Laravel caches cleared successfully!');
            } catch (error) {
                console.error('⚠️  Failed to clear Laravel caches:', error.message);
            }
        }
    };
}

export default defineConfig({
    plugins: [
        laravel({
            input: ['resources/css/app.css', 'resources/js/app.js'],
            refresh: true,
        }),
        tailwindcss(),
        clearLaravelCache(),
    ],
    server: {
        watch: {
            ignored: ['**/storage/framework/views/**'],
        },
    },
});
