<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Testing;

class Distribution extends \Google\Model
{
  /**
   * Output only. The estimated fraction (0-1) of the total market with this
   * configuration.
   *
   * @var 
   */
  public $marketShare;
  /**
   * Output only. The time this distribution was measured.
   *
   * @var string
   */
  public $measurementTime;

  public function setMarketShare($marketShare)
  {
    $this->marketShare = $marketShare;
  }
  public function getMarketShare()
  {
    return $this->marketShare;
  }
  /**
   * Output only. The time this distribution was measured.
   *
   * @param string $measurementTime
   */
  public function setMeasurementTime($measurementTime)
  {
    $this->measurementTime = $measurementTime;
  }
  /**
   * @return string
   */
  public function getMeasurementTime()
  {
    return $this->measurementTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Distribution::class, 'Google_Service_Testing_Distribution');
