<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\HangoutsChat;

class ChatAppLogEntry extends \Google\Model
{
  /**
   * The deployment that caused the error. For Chat apps built in Apps Script,
   * this is the deployment ID defined by Apps Script.
   *
   * @var string
   */
  public $deployment;
  /**
   * The unencrypted `callback_method` name that was running when the error was
   * encountered.
   *
   * @var string
   */
  public $deploymentFunction;
  protected $errorType = Status::class;
  protected $errorDataType = '';

  /**
   * The deployment that caused the error. For Chat apps built in Apps Script,
   * this is the deployment ID defined by Apps Script.
   *
   * @param string $deployment
   */
  public function setDeployment($deployment)
  {
    $this->deployment = $deployment;
  }
  /**
   * @return string
   */
  public function getDeployment()
  {
    return $this->deployment;
  }
  /**
   * The unencrypted `callback_method` name that was running when the error was
   * encountered.
   *
   * @param string $deploymentFunction
   */
  public function setDeploymentFunction($deploymentFunction)
  {
    $this->deploymentFunction = $deploymentFunction;
  }
  /**
   * @return string
   */
  public function getDeploymentFunction()
  {
    return $this->deploymentFunction;
  }
  /**
   * The error code and message.
   *
   * @param Status $error
   */
  public function setError(Status $error)
  {
    $this->error = $error;
  }
  /**
   * @return Status
   */
  public function getError()
  {
    return $this->error;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ChatAppLogEntry::class, 'Google_Service_HangoutsChat_ChatAppLogEntry');
