<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class InstanceGroupManagerStandbyPolicy extends \Google\Model
{
  /**
   * MIG does not automatically resume or start VMs in the standby pool when the
   * group scales out.
   */
  public const MODE_MANUAL = 'MANUAL';
  /**
   * MIG automatically resumes or starts VMs in the standby pool when the group
   * scales out, and replenishes the standby pool afterwards.
   */
  public const MODE_SCALE_OUT_POOL = 'SCALE_OUT_POOL';
  /**
   * Specifies the number of seconds that the MIG should wait to suspend or stop
   * a VM after that VM was created. The initial delay gives the initialization
   * script the time to prepare your VM for a quick scale out. The value of
   * initial delay must be between 0 and 3600 seconds. The default value is 0.
   *
   * @var int
   */
  public $initialDelaySec;
  /**
   * Defines how a MIG resumes or starts VMs from a standby pool when the group
   * scales out. The default mode is `MANUAL`.
   *
   * @var string
   */
  public $mode;

  /**
   * Specifies the number of seconds that the MIG should wait to suspend or stop
   * a VM after that VM was created. The initial delay gives the initialization
   * script the time to prepare your VM for a quick scale out. The value of
   * initial delay must be between 0 and 3600 seconds. The default value is 0.
   *
   * @param int $initialDelaySec
   */
  public function setInitialDelaySec($initialDelaySec)
  {
    $this->initialDelaySec = $initialDelaySec;
  }
  /**
   * @return int
   */
  public function getInitialDelaySec()
  {
    return $this->initialDelaySec;
  }
  /**
   * Defines how a MIG resumes or starts VMs from a standby pool when the group
   * scales out. The default mode is `MANUAL`.
   *
   * Accepted values: MANUAL, SCALE_OUT_POOL
   *
   * @param self::MODE_* $mode
   */
  public function setMode($mode)
  {
    $this->mode = $mode;
  }
  /**
   * @return self::MODE_*
   */
  public function getMode()
  {
    return $this->mode;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(InstanceGroupManagerStandbyPolicy::class, 'Google_Service_Compute_InstanceGroupManagerStandbyPolicy');
