<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class HttpRouteAction extends \Google\Collection
{
  protected $collection_key = 'weightedBackendServices';
  protected $corsPolicyType = CorsPolicy::class;
  protected $corsPolicyDataType = '';
  protected $faultInjectionPolicyType = HttpFaultInjection::class;
  protected $faultInjectionPolicyDataType = '';
  protected $maxStreamDurationType = Duration::class;
  protected $maxStreamDurationDataType = '';
  protected $requestMirrorPolicyType = RequestMirrorPolicy::class;
  protected $requestMirrorPolicyDataType = '';
  protected $retryPolicyType = HttpRetryPolicy::class;
  protected $retryPolicyDataType = '';
  protected $timeoutType = Duration::class;
  protected $timeoutDataType = '';
  protected $urlRewriteType = UrlRewrite::class;
  protected $urlRewriteDataType = '';
  protected $weightedBackendServicesType = WeightedBackendService::class;
  protected $weightedBackendServicesDataType = 'array';

  /**
   * The specification for allowing client-side cross-origin requests. For more
   * information about the W3C recommendation for cross-origin resource sharing
   * (CORS), see Fetch API Living Standard.
   *
   * Not supported when the URL map is bound to a target gRPC proxy.
   *
   * @param CorsPolicy $corsPolicy
   */
  public function setCorsPolicy(CorsPolicy $corsPolicy)
  {
    $this->corsPolicy = $corsPolicy;
  }
  /**
   * @return CorsPolicy
   */
  public function getCorsPolicy()
  {
    return $this->corsPolicy;
  }
  /**
   * The specification for fault injection introduced into traffic to test the
   * resiliency of clients to backend service failure. As part of fault
   * injection, when clients send requests to a backend service, delays can be
   * introduced by a load balancer on a percentage of requests before sending
   * those requests to the backend service. Similarly requests from clients can
   * be aborted by the load balancer for a percentage of requests.timeout and
   * retry_policy is ignored by clients that are configured with a
   * fault_injection_policy if: 1. The traffic is generated by fault injection
   * AND 2. The fault injection is not a delay fault injection. Fault injection
   * is not supported with the classic Application Load Balancer . To see which
   * load balancers support fault injection, see Load balancing: Routing and
   * traffic management features.
   *
   * @param HttpFaultInjection $faultInjectionPolicy
   */
  public function setFaultInjectionPolicy(HttpFaultInjection $faultInjectionPolicy)
  {
    $this->faultInjectionPolicy = $faultInjectionPolicy;
  }
  /**
   * @return HttpFaultInjection
   */
  public function getFaultInjectionPolicy()
  {
    return $this->faultInjectionPolicy;
  }
  /**
   * Specifies the maximum duration (timeout) for streams on the selected route.
   * Unlike the timeout field where the timeout duration starts from the time
   * the request has been fully processed (known as*end-of-stream*), the
   * duration in this field is computed from the beginning of the stream until
   * the response has been processed, including all retries. A stream that does
   * not complete in this duration is closed.
   *
   * If not specified, this field uses the maximummaxStreamDuration value among
   * all backend services associated with the route.
   *
   * This field is only allowed if the Url map is used with backend services
   * with loadBalancingScheme set toINTERNAL_SELF_MANAGED.
   *
   * @param Duration $maxStreamDuration
   */
  public function setMaxStreamDuration(Duration $maxStreamDuration)
  {
    $this->maxStreamDuration = $maxStreamDuration;
  }
  /**
   * @return Duration
   */
  public function getMaxStreamDuration()
  {
    return $this->maxStreamDuration;
  }
  /**
   * Specifies the policy on how requests intended for the route's backends are
   * shadowed to a separate mirrored backend service. The load balancer does not
   * wait for responses from the shadow service. Before sending traffic to the
   * shadow service, the host / authority header is suffixed with-shadow.
   *
   * Not supported when the URL map is bound to a target gRPC proxy that has the
   * validateForProxyless field set to true.
   *
   * @param RequestMirrorPolicy $requestMirrorPolicy
   */
  public function setRequestMirrorPolicy(RequestMirrorPolicy $requestMirrorPolicy)
  {
    $this->requestMirrorPolicy = $requestMirrorPolicy;
  }
  /**
   * @return RequestMirrorPolicy
   */
  public function getRequestMirrorPolicy()
  {
    return $this->requestMirrorPolicy;
  }
  /**
   * Specifies the retry policy associated with this route.
   *
   * @param HttpRetryPolicy $retryPolicy
   */
  public function setRetryPolicy(HttpRetryPolicy $retryPolicy)
  {
    $this->retryPolicy = $retryPolicy;
  }
  /**
   * @return HttpRetryPolicy
   */
  public function getRetryPolicy()
  {
    return $this->retryPolicy;
  }
  /**
   * Specifies the timeout for the selected route. Timeout is computed from the
   * time the request has been fully processed (known as *end-of-stream*) up
   * until the response has been processed. Timeout includes all retries.
   *
   * If not specified, this field uses the largest timeout among all backend
   * services associated with the route.
   *
   * Not supported when the URL map is bound to a target gRPC proxy that has
   * validateForProxyless field set to true.
   *
   * @param Duration $timeout
   */
  public function setTimeout(Duration $timeout)
  {
    $this->timeout = $timeout;
  }
  /**
   * @return Duration
   */
  public function getTimeout()
  {
    return $this->timeout;
  }
  /**
   * The spec to modify the URL of the request, before forwarding the request to
   * the matched service.
   *
   *  urlRewrite is the only action supported in UrlMaps for classic Application
   * Load Balancers.
   *
   * Not supported when the URL map is bound to a target gRPC proxy that has the
   * validateForProxyless field set to true.
   *
   * @param UrlRewrite $urlRewrite
   */
  public function setUrlRewrite(UrlRewrite $urlRewrite)
  {
    $this->urlRewrite = $urlRewrite;
  }
  /**
   * @return UrlRewrite
   */
  public function getUrlRewrite()
  {
    return $this->urlRewrite;
  }
  /**
   * A list of weighted backend services to send traffic to when a route match
   * occurs. The weights determine the fraction of traffic that flows to their
   * corresponding backend service. If all traffic needs to go to a single
   * backend service, there must be oneweightedBackendService with weight set to
   * a non-zero number.
   *
   * After a backend service is identified and before forwarding the request to
   * the backend service, advanced routing actions such as URL rewrites and
   * header transformations are applied depending on additional settings
   * specified in this HttpRouteAction.
   *
   * @param WeightedBackendService[] $weightedBackendServices
   */
  public function setWeightedBackendServices($weightedBackendServices)
  {
    $this->weightedBackendServices = $weightedBackendServices;
  }
  /**
   * @return WeightedBackendService[]
   */
  public function getWeightedBackendServices()
  {
    return $this->weightedBackendServices;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(HttpRouteAction::class, 'Google_Service_Compute_HttpRouteAction');
