<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AlertCenter;

class DlpRuleViolation extends \Google\Model
{
  protected $ruleViolationInfoType = RuleViolationInfo::class;
  protected $ruleViolationInfoDataType = '';

  /**
   * Details about the violated DLP rule. Admins can use the predefined
   * detectors provided by Google Cloud DLP https://cloud.google.com/dlp/ when
   * setting up a DLP rule. Matched Cloud DLP detectors in this violation if any
   * will be captured in the MatchInfo.predefined_detector.
   *
   * @param RuleViolationInfo $ruleViolationInfo
   */
  public function setRuleViolationInfo(RuleViolationInfo $ruleViolationInfo)
  {
    $this->ruleViolationInfo = $ruleViolationInfo;
  }
  /**
   * @return RuleViolationInfo
   */
  public function getRuleViolationInfo()
  {
    return $this->ruleViolationInfo;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(DlpRuleViolation::class, 'Google_Service_AlertCenter_DlpRuleViolation');
