<?php $__env->startSection('title', 'Blog Management'); ?>
<?php $__env->startSection('header_title', 'Blog Posts'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Header Actions -->
    <div class="flex justify-end">
        <a href="<?php echo e(route('admin.blog.create')); ?>" class="px-6 py-3 bg-gray-900 text-white font-bold rounded-xl shadow-lg shadow-gray-900/20 hover:bg-black hover:scale-[1.02] transition-all flex items-center gap-2">
            <i class="fa-solid fa-plus"></i>
            Create New Post
        </a>
    </div>

    <!-- Blog List -->
    <div class="bg-white rounded-3xl border border-gray-100 shadow-sm overflow-hidden">
        <?php if($posts->isNotEmpty()): ?>
            <table class="w-full text-left text-sm">
                <thead class="bg-gray-50 text-[10px] font-black uppercase text-gray-400">
                    <tr>
                        <th class="px-6 py-4">Post Details</th>
                        <th class="px-6 py-4">Category</th>
                        <th class="px-6 py-4">Author</th>
                        <th class="px-6 py-4">Status</th>
                        <th class="px-6 py-4 text-right">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-50">
                    <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="hover:bg-gray-50 transition-colors group">
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-4">
                                    <div class="w-16 h-12 rounded-lg bg-gray-100 overflow-hidden flex-shrink-0 border border-gray-100">
                                        <?php if($post->featured_image): ?>
                                            <img src="<?php echo e(Storage::url($post->featured_image)); ?>" class="w-full h-full object-cover">
                                        <?php else: ?>
                                            <div class="w-full h-full flex items-center justify-center text-gray-300">
                                                <i class="fa-solid fa-image"></i>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div>
                                        <div class="font-bold text-gray-800 line-clamp-1 group-hover:text-primary transition-colors"><?php echo e($post->title); ?></div>
                                        <div class="text-[10px] text-gray-400 font-medium truncate max-w-[200px]"><?php echo e($post->excerpt); ?></div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <span class="px-2 py-1 rounded-md bg-gray-100 text-gray-600 text-[10px] font-bold uppercase tracking-wider">
                                    <?php echo e($post->category); ?>

                                </span>
                            </td>
                            <td class="px-6 py-4">
                                <div class="font-medium text-gray-700"><?php echo e($post->author); ?></div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex flex-col gap-1">
                                    <div class="flex items-center gap-2">
                                        <span class="w-2 h-2 rounded-full <?php echo e($post->is_published ? 'bg-emerald-500' : 'bg-gray-300'); ?>"></span>
                                        <span class="text-xs font-bold <?php echo e($post->is_published ? 'text-emerald-600' : 'text-gray-500'); ?>">
                                            <?php echo e($post->is_published ? 'Published' : 'Draft'); ?>

                                        </span>
                                    </div>
                                    <?php if($post->is_featured): ?>
                                        <span class="text-[10px] font-black text-vibrant-orange uppercase tracking-wide flex items-center gap-1">
                                            <i class="fa-solid fa-star text-[8px]"></i> Featured
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td class="px-6 py-4 text-right">
                                <div class="flex items-center justify-end gap-2">
                                    <a href="<?php echo e(route('admin.blog.edit', $post)); ?>" class="w-8 h-8 rounded-lg bg-blue-50 text-blue-600 hover:bg-blue-100 flex items-center justify-center transition-colors" title="Edit">
                                        <i class="fa-solid fa-pen text-xs"></i>
                                    </a>
                                    <form action="<?php echo e(route('admin.blog.destroy', $post)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to delete this post?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="w-8 h-8 rounded-lg bg-red-50 text-red-600 hover:bg-red-100 flex items-center justify-center transition-colors" title="Delete">
                                            <i class="fa-solid fa-trash text-xs"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            
            <div class="p-6 border-t border-gray-50">
                <?php echo e($posts->links()); ?>

            </div>
        <?php else: ?>
            <div class="p-12 text-center">
                <div class="w-16 h-16 bg-gray-50 rounded-2xl flex items-center justify-center mx-auto mb-4 text-gray-300">
                    <i class="fa-solid fa-newspaper text-2xl"></i>
                </div>
                <h3 class="text-lg font-bold text-gray-900">No blog posts yet</h3>
                <p class="text-gray-500 text-sm mt-1 mb-6">Create your first blog post to verify functionalities.</p>
                <a href="<?php echo e(route('admin.blog.create')); ?>" class="inline-flex items-center gap-2 px-6 py-3 bg-gray-900 text-white font-bold rounded-xl hover:bg-black transition-all">
                    <i class="fa-solid fa-plus"></i>
                    Create Post
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/admin/blog/index.blade.php ENDPATH**/ ?>