<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title><?php echo $__env->yieldContent('title', 'Yilick - Buy and Sell in Uganda | Africa\'s Leading AI Marketplace'); ?></title>

    <meta name="description" content="<?php echo $__env->yieldContent('meta_description', 'Yilick is Uganda\'s first AI-powered marketplace. Buy and sell electronics, cars, property, and more with integrated business management tools.'); ?>">
    <meta name="keywords" content="<?php echo $__env->yieldContent('meta_keywords', 'classifieds uganda, buy and sell uganda, online marketplace africa, yilick, business tools uganda, pos uganda'); ?>">
    <meta name="author" content="Yilick">
    <meta name="robots" content="index, follow, max-image-preview:large, max-snippet:-1, max-video-preview:-1">
    <link rel="canonical" href="<?php echo e(url()->current()); ?>">

    <!-- Performance Prefetching -->
    <link rel="dns-prefetch" href="//fonts.googleapis.com">
    <link rel="dns-prefetch" href="//cdnjs.cloudflare.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    <meta property="og:title" content="<?php echo $__env->yieldContent('title', 'Yilick - Buy and Sell in Uganda'); ?>">
    <meta property="og:description" content="<?php echo $__env->yieldContent('meta_description', 'Yilick is Uganda\'s first AI-powered marketplace.'); ?>">
    <meta property="og:image" content="<?php echo $__env->yieldContent('og_image', asset('assets/icons/logo.png')); ?>">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo e(url()->current()); ?>">
    <meta property="twitter:title" content="<?php echo $__env->yieldContent('title', 'Yilick - Buy and Sell in Uganda'); ?>">
    <meta property="twitter:description" content="<?php echo $__env->yieldContent('meta_description', 'Yilick is Uganda\'s first AI-powered marketplace.'); ?>">
    <meta property="twitter:image" content="<?php echo $__env->yieldContent('og_image', asset('assets/icons/logo.png')); ?>">

    <!-- Structured Data (JSON-LD) -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@graph": [
            {
                "@type": "Organization",
                "@id": "<?php echo e(route('web.home')); ?>#organization",
                "name": "Yilick",
                "url": "<?php echo e(route('web.home')); ?>",
                "logo": {
                    "@type": "ImageObject",
                    "url": "<?php echo e(asset('assets/icons/logo.png')); ?>"
                },
                "sameAs": [
                    "https://facebook.com/yilickapp",
                    "https://twitter.com/yilickapp",
                    "https://instagram.com/yilickapp",
                    "https://linkedin.com/company/yilickapp",
                    "https://youtube.com/@yilick",
                    "https://tiktok.com/@yilick.ug"
                ]
            },
            {
                "@type": "WebSite",
                "@id": "<?php echo e(route('web.home')); ?>#website",
                "url": "<?php echo e(route('web.home')); ?>",
                "name": "Yilick",
                "publisher": { "@id": "<?php echo e(route('web.home')); ?>#organization" },
                "potentialAction": {
                    "@type": "SearchAction",
                    "target": "<?php echo e(route('listing.search')); ?>?q={search_term_string}",
                    "query-input": "required name=search_term_string"
                }
            }
        ]
    }
    </script>
    <?php echo $__env->yieldContent('header_meta'); ?>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&family=Inter:wght@400;500;600&display=swap" rel="stylesheet">

    <!-- Styles & Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?php echo e(asset('assets/icons/favicon.png')); ?>">

    <!-- Manifest & PWA -->
    <link rel="manifest" href="/manifest.json">
    <meta name="theme-color" content="#10b981">
    <script>
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', () => {
                navigator.serviceWorker.register('/sw.js');
            });
        }
    </script>

    <!-- Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <!-- Custom Styles Stack -->
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body class="bg-light-gray text-charcoal-gray selection:bg-primary/20" id="body-content">
    <!-- Topbars Container -->
    <div class="fixed top-0 left-0 right-0 z-[999] flex flex-col transition-transform duration-300" id="topbars-container">
        <!-- Download App Topbar -->
        <div id="topbar-download" class="bg-vibrant-orange text-white relative hidden">
            <div class="container mx-auto px-4 py-1 flex items-center justify-center text-[10px] sm:text-xs font-medium text-center pr-8">
                <i class="fa-solid fa-mobile-screen mr-2"></i>
                <span>Get the full experience with our mobile app! <a href="<?php echo e(route('web.download')); ?>" class="underline hover:text-orange-100 ml-1 font-bold">Download Now</a></span>
            </div>
            <button onclick="dismissTopbar('download')" class="absolute right-2 top-1/2 -translate-y-1/2 w-6 h-6 flex items-center justify-center text-white/60 hover:text-white transition-colors">
                <i class="fa-solid fa-xmark"></i>
            </button>
        </div>
    </div>
    <!-- Desktop Header -->
    <header class="hidden md:block bg-white/80 backdrop-blur-md shadow-sm sticky top-0 z-[900] border-b border-cool-gray/5">
        <div class="container mx-auto px-4 py-3 flex items-center justify-between gap-8">
            <a href="/" class="flex-shrink-0 transition-transform hover:scale-105 active:scale-95">
                <img src="/assets/icons/logo.png" alt="YILICK" class="h-10 w-auto">
            </a>



            <nav class="flex items-center gap-8">
                <div class="flex items-center gap-6 text-sm font-semibold text-charcoal-gray">
                    <a href="<?php echo e(route('listing.hot-deals')); ?>" class="hover:text-primary transition-colors flex items-center gap-2">
                        <i class="fa-solid fa-fire text-vibrant-orange"></i>
                        <span>Hot Deals</span>
                    </a>
                </div>

                <div class="h-8 w-[1px] bg-cool-gray/20"></div>

                <?php if(auth()->guard('web')->check()): ?>
                    <div class="flex items-center gap-6 text-sm font-semibold text-charcoal-gray">
                        <a href="<?php echo e(route('web.chat.inbox')); ?>" class="hover:text-primary transition-colors flex items-center gap-2">
                            <i class="fa-regular fa-comment"></i>
                            <span>Messages</span>
                        </a>
                        <a href="<?php echo e(route('web.my-ads')); ?>" class="hover:text-primary transition-colors">My Ads</a>
                    </div>

                    <div class="h-8 w-[1px] bg-cool-gray/20"></div>

                    <div class="flex items-center gap-4">
                        <!-- App Launcher -->
                        <button onclick="toggleAppLauncher()" class="w-10 h-10 rounded-full hover:bg-gray-100 flex items-center justify-center text-charcoal-gray transition-colors relative group">
                            <i class="fa-solid fa-grip text-lg group-hover:text-primary transition-colors"></i>
                        </button>

                        <a href="<?php echo e(route('listing.create')); ?>" class="btn-primary !py-2.5 !px-6 flex items-center gap-2 shadow-lg shadow-primary/20">
                            <i class="fa-solid fa-circle-plus"></i>
                            <span>Post Ad</span>
                        </a>
                        <div class="relative group pl-2 py-2">
                             <a href="<?php echo e(route('web.profile')); ?>" class="flex items-center gap-3 cursor-pointer">
                                <div class="w-10 h-10 rounded-xl bg-primary/5 flex items-center justify-center border border-primary/10 group-hover:bg-primary group-hover:text-white transition-all overflow-hidden">
                                     <?php if(auth('web')->user()->profile_photo): ?>
                                        <img src="<?php echo e(auth('web')->user()->profile_photo_url); ?>" onerror="this.src='<?php echo e(asset('assets/icons/favicon.png')); ?>'" class="w-full h-full object-cover">
                                    <?php else: ?>
                                        <i class="fa-regular fa-user"></i>
                                    <?php endif; ?>
                                </div>
                                <div class="hidden xl:block">
                                    <div class="text-[10px] text-cool-gray font-bold uppercase leading-none mb-1">Account</div>
                                    <div class="text-xs font-bold leading-none"><?php echo e(Str::limit(auth('web')->user()->full_name, 12)); ?></div>
                                </div>
                            </a>
                            
                            <!-- Dropdown -->
                            <div class="hidden group-hover:block absolute top-full right-0 mt-0 bg-white shadow-xl rounded-xl border border-gray-100 p-2 min-w-[150px] z-[910] animate-in fade-in slide-in-from-top-2 duration-200">
                                <?php if(auth('web')->user()->isAdmin()): ?>
                                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="w-full text-left px-4 py-2 text-xs font-bold text-primary hover:bg-primary/5 rounded-lg transition-colors flex items-center gap-2 mb-1">
                                        <i class="fa-solid fa-shield-halved"></i>
                                        <span>Admin Panel</span>
                                    </a>
                                <?php endif; ?>
                                <a href="<?php echo e(route('web.profile')); ?>" class="w-full text-left px-4 py-2 text-xs font-bold text-gray-700 hover:bg-gray-50 rounded-lg transition-colors flex items-center gap-2 mb-1">
                                    <i class="fa-regular fa-user"></i>
                                    <span>Profile</span>
                                </a>
                                <a href="<?php echo e(route('web.settings')); ?>" class="w-full text-left px-4 py-2 text-xs font-bold text-gray-700 hover:bg-gray-50 rounded-lg transition-colors flex items-center gap-2 mb-1">
                                    <i class="fa-solid fa-gear"></i>
                                    <span>Settings</span>
                                </a>
                                <form action="<?php echo e(route('logout')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="w-full text-left px-4 py-2 text-xs font-bold text-red-500 hover:bg-red-50 rounded-lg transition-colors flex items-center gap-2">
                                        <i class="fa-solid fa-right-from-bracket"></i>
                                        <span>Sign Out</span>
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="flex items-center gap-4">
                        <a href="<?php echo e(route('login')); ?>" class="text-sm font-bold text-charcoal-gray hover:text-primary transition-colors">Sign In</a>
                        <a href="<?php echo e(route('register')); ?>" class="btn-primary !py-2.5 !px-6 shadow-lg shadow-primary/20">
                            <span>Register</span>
                        </a>
                    </div>
                <?php endif; ?>
            </nav>
        </div>
    </header>

    <!-- Mobile Header -->
    <header class="md:hidden bg-primary text-white sticky top-0 z-[900]">
        <div class="px-4 py-4 flex items-center justify-between">
            <button onclick="openLocationModal()" class="flex items-center gap-2 hover:opacity-80 transition-opacity">
                <i class="fa-solid fa-location-dot text-sm"></i>
                <span id="mobile-location-text" class="text-sm font-semibold">All Uganda</span>
                <i class="fa-solid fa-chevron-down text-[10px]"></i>
            </button>
            <form action="<?php echo e(route('listing.search')); ?>" method="GET" class="flex-1 mx-4">
                <div class="relative">
                    <input type="text" name="q" placeholder="Search..." 
                           class="w-full bg-white/20 border-none rounded-lg py-1.5 pl-8 pr-3 text-sm placeholder:text-white/70 outline-none">
                    <i class="fa-solid fa-magnifying-glass absolute left-2.5 top-1/2 -translate-y-1/2 text-white/70 text-xs"></i>
                </div>
            </form>
            <div class="flex items-center gap-4">
                <button onclick="toggleAppLauncher()" class="text-white/90 hover:text-white transition-colors">
                    <i class="fa-solid fa-grip text-xl"></i>
                </button>
            </div>
        </div>
    </header>

    <main class="min-h-screen pb-20 md:pb-0 isolate relative z-0">
        <div id="toast-container" class="fixed top-24 right-4 z-[950] space-y-3">
            <?php if(session('success')): ?>
                <div class="toast-item animate-in fade-in slide-in-from-right-8 duration-500">
                    <div class="bg-emerald-500 text-white px-6 py-3 rounded-2xl shadow-xl shadow-emerald-500/20 flex items-center gap-3">
                        <i class="fa-solid fa-circle-check text-lg"></i>
                        <p class="font-bold text-sm"><?php echo e(session('success')); ?></p>
                    </div>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="toast-item animate-in fade-in slide-in-from-right-8 duration-500">
                    <div class="bg-red-500 text-white px-6 py-3 rounded-2xl shadow-xl shadow-red-500/20 flex items-center gap-3">
                        <i class="fa-solid fa-circle-exclamation text-lg"></i>
                        <p class="font-bold text-sm"><?php echo e(session('error')); ?></p>
                    </div>
                </div>
            <?php endif; ?>

            <?php if(session('info')): ?>
                <div class="toast-item animate-in fade-in slide-in-from-right-8 duration-500">
                    <div class="bg-blue-500 text-white px-6 py-3 rounded-2xl shadow-xl shadow-blue-500/20 flex items-center gap-3">
                        <i class="fa-solid fa-circle-info text-lg"></i>
                        <p class="font-bold text-sm"><?php echo e(session('info')); ?></p>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <!-- Global Loading Overlay -->
        <div id="global-loader" class="fixed inset-0 z-[1100] flex items-center justify-center bg-black/20 backdrop-blur-sm hidden opacity-0 transition-opacity duration-300">
            <div class="bg-white p-8 rounded-3xl shadow-2xl flex flex-col items-center gap-4 scale-90 transition-transform duration-300" id="loader-content">
                <div class="grid grid-cols-2 gap-2">
                    <div class="w-2.5 h-2.5 bg-emerald-500 rounded-full animate-pulse"></div>
                    <div class="w-2.5 h-2.5 bg-orange-500 rounded-full animate-pulse [animation-delay:0.2s]"></div>
                    <div class="w-2.5 h-2.5 bg-orange-500 rounded-full animate-pulse [animation-delay:0.4s]"></div>
                    <div class="w-2.5 h-2.5 bg-emerald-500 rounded-full animate-pulse [animation-delay:0.6s]"></div>
                </div>
                <p class="text-[10px] font-black uppercase tracking-widest text-gray-400">Loading</p>
            </div>
        </div>

        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Mobile Bottom Navigation -->
    <nav class="md:hidden fixed bottom-0 left-0 right-0 bg-white/95 backdrop-blur-xl border-t border-cool-gray/10 px-4 pt-2 pb-safe z-50 shadow-lg shadow-black/5">
        <div class="flex items-center justify-around max-w-lg mx-auto">
            <!-- Home -->
            <a href="/" class="nav-bottom-item <?php echo e(request()->routeIs('web.home') ? 'active' : ''); ?> group">
                <div class="relative flex flex-col items-center justify-center py-2 px-3 transition-all">
                    <div class="w-11 h-11 rounded-2xl flex items-center justify-center transition-all duration-300 group-[.active]:bg-primary/10">
                        <i class="fa-solid fa-house text-lg transition-all duration-300 group-[.active]:text-primary group-[.active]:scale-110"></i>
                    </div>
                    <span class="text-[10px] font-semibold mt-1.5 transition-all duration-300 group-[.active]:text-primary">Home</span>
                    <div class="absolute -top-0.5 left-1/2 -translate-x-1/2 w-8 h-0.5 bg-primary rounded-full opacity-0 group-[.active]:opacity-100 transition-opacity duration-300"></div>
                </div>
            </a>
            
            <!-- Favorites -->
            <a href="<?php echo e(auth('web')->check() ? route('web.favorites') : route('login')); ?>" class="nav-bottom-item <?php echo e(request()->routeIs('web.favorites') ? 'active' : ''); ?> group">
                <div class="relative flex flex-col items-center justify-center py-2 px-3 transition-all">
                    <div class="w-11 h-11 rounded-2xl flex items-center justify-center transition-all duration-300 group-[.active]:bg-primary/10 group-hover:bg-cool-gray/5">
                        <i class="fa-<?php echo e(request()->routeIs('web.favorites') ? 'solid' : 'regular'); ?> fa-heart text-lg transition-all duration-300 group-[.active]:text-primary group-[.active]:scale-110"></i>
                    </div>
                    <span class="text-[10px] font-semibold mt-1.5 transition-all duration-300 group-[.active]:text-primary">Favorites</span>
                    <div class="absolute -top-0.5 left-1/2 -translate-x-1/2 w-8 h-0.5 bg-primary rounded-full opacity-0 group-[.active]:opacity-100 transition-opacity duration-300"></div>
                </div>
            </a>
            
            <!-- Sell Button -->
            <a href="<?php echo e(auth('web')->check() ? route('listing.create') : route('login')); ?>" class="flex flex-col items-center justify-center -translate-y-6 group <?php echo e(request()->routeIs('listing.create') ? 'active' : ''); ?>">
                <div class="relative">
                    <div class="w-16 h-16 rounded-2xl flex items-center justify-center shadow-xl border-4 border-white transition-all duration-300 group-hover:scale-105 group-active:scale-95 group-hover:rotate-6 <?php echo e(request()->routeIs('listing.create') ? 'bg-primary shadow-primary/30' : 'bg-cool-gray shadow-cool-gray/20'); ?>">
                        <i class="fa-solid fa-plus text-white text-2xl transition-transform duration-300 group-hover:rotate-90"></i>
                    </div>
                </div>
                <span class="text-[10px] font-bold mt-2 <?php echo e(request()->routeIs('listing.create') ? 'text-primary' : 'text-cool-gray'); ?>">Sell</span>
            </a>
            
            <!-- Chat -->
            <a href="<?php echo e(auth('web')->check() ? route('web.chat.inbox') : route('login')); ?>" class="nav-bottom-item <?php echo e(request()->routeIs('web.chat.*') ? 'active' : ''); ?> group relative">
                <div class="relative flex flex-col items-center justify-center py-2 px-3 transition-all">
                    <div class="w-11 h-11 rounded-2xl flex items-center justify-center transition-all duration-300 group-[.active]:bg-primary/10 group-hover:bg-cool-gray/5">
                        <i class="fa-<?php echo e(request()->routeIs('web.chat.*') ? 'solid' : 'regular'); ?> fa-comment text-lg transition-all duration-300 group-[.active]:text-primary group-[.active]:scale-110"></i>
                    </div>
                    <span class="text-[10px] font-semibold mt-1.5 transition-all duration-300 group-[.active]:text-primary">Chat</span>
                    <!-- Optional: Notification Badge for unread chat -->
                    <div class="absolute top-1.5 right-2 w-2 h-2 bg-vibrant-orange rounded-full border-2 border-white"></div>
                    <div class="absolute -top-0.5 left-1/2 -translate-x-1/2 w-8 h-0.5 bg-primary rounded-full opacity-0 group-[.active]:opacity-100 transition-opacity duration-300"></div>
                </div>
            </a>
            
            <!-- Account -->
            <a href="<?php echo e(auth('web')->check() ? route('web.profile') : route('login')); ?>" class="nav-bottom-item <?php echo e(request()->routeIs('web.profile', 'web.settings*', 'web.my-ads', 'web.notifications', 'web.favorites') ? 'active' : ''); ?> group">
                <div class="relative flex flex-col items-center justify-center py-2 px-3 transition-all">
                    <div class="w-11 h-11 rounded-2xl flex items-center justify-center transition-all duration-300 group-hover:bg-cool-gray/5 overflow-hidden border border-transparent group-[.active]:border-primary/50 group-[.active]:bg-primary/10">
                        <?php if(auth('web')->check() && auth('web')->user()->profile_photo): ?>
                            <img src="<?php echo e(auth('web')->user()->profile_photo_url); ?>" onerror="this.src='<?php echo e(asset('assets/icons/favicon.png')); ?>'" class="w-full h-full object-cover">
                        <?php else: ?>
                            <i class="fa-<?php echo e(request()->routeIs('web.profile', 'web.settings*', 'web.my-ads') ? 'solid' : 'regular'); ?> fa-user text-lg transition-all duration-300 group-hover:scale-110 group-[.active]:text-primary group-[.active]:scale-110"></i>
                        <?php endif; ?>
                    </div>
                    <span class="text-[10px] font-semibold mt-1.5 transition-all duration-300 group-[.active]:text-primary">
                        <?php echo e(auth('web')->check() ? Str::words(auth('web')->user()->full_name, 1, '') : 'Account'); ?>

                    </span>
                    <div class="absolute -top-0.5 left-1/2 -translate-x-1/2 w-8 h-0.5 bg-primary rounded-full opacity-0 group-[.active]:opacity-100 transition-opacity duration-300"></div>
                </div>
            </a>
        </div>
    </nav>

    <!-- Footer -->
    <footer class="bg-primary text-white mt-20">
        <!-- Desktop Footer -->
        <div class="hidden md:block">
            <div class="container mx-auto px-4 py-16">
                <div class="grid grid-cols-1 md:grid-cols-5 gap-12 mb-12">
                    <!-- About Section -->
                    <div class="md:col-span-2">
                        <div class="flex items-center gap-3 mb-6">
                           <div class="sketch-logo-bg inline-flex items-center justify-center">
                                <img src="/assets/icons/logo.png" alt="YILICK" class="h-8 w-auto">
                            </div>
                        </div>
                        <p class="text-white/80 text-sm leading-relaxed mb-6 font-medium">
                            Yilick is Uganda's first AI-powered marketplace, redefining how we buy and sell. By combining advanced business insights with our <span class="font-black text-white italic"> Business Tools</span>, we created a digital environment where trust is built-in and entrepreneurs can scale with data-driven precision.
                        </p>
                        <div class="flex items-center gap-4">
                            <a href="https://facebook.com/yilick" target="_blank" class="w-10 h-10 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center transition-all">
                                <i class="fa-brands fa-facebook text-lg"></i>
                            </a>
                            <a href="https://twitter.com/yilick" target="_blank" class="w-10 h-10 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center transition-all">
                                <i class="fa-brands fa-twitter text-lg"></i>
                            </a>
                            <a href="https://instagram.com/yilick" target="_blank" class="w-10 h-10 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center transition-all">
                                <i class="fa-brands fa-instagram text-lg"></i>
                            </a>
                            <a href="https://linkedin.com/company/yilick" target="_blank" class="w-10 h-10 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center transition-all">
                                <i class="fa-brands fa-linkedin text-lg"></i>
                            </a>
                        </div>
                    </div>

                    <!-- Quick Links -->
                    <div>
                        <h4 class="font-bold text-white mb-6 text-sm uppercase tracking-wider">Company</h4>
                        <ul class="space-y-3">
                            <li><a href="<?php echo e(route('web.about')); ?>" class="text-white/90 hover:text-white transition-colors text-sm">About Us</a></li>
                            <li><a href="<?php echo e(route('web.contact')); ?>" class="text-white/90 hover:text-white transition-colors text-sm">Contact</a></li>
                            <li><a href="<?php echo e(route('web.careers')); ?>" class="text-white/90 hover:text-white transition-colors text-sm">Careers</a></li>
                            <li><a href="<?php echo e(route('web.blog')); ?>" class="text-white/90 hover:text-white transition-colors text-sm">Blog</a></li>
                        </ul>
                    </div>

                    <!-- Support -->
                    <div>
                        <h4 class="font-bold text-white mb-6 text-sm uppercase tracking-wider">Support</h4>
                        <ul class="space-y-3">
                            <li><a href="<?php echo e(route('web.help-center')); ?>" class="text-white/90 hover:text-white transition-colors text-sm">Help Center</a></li>
                            <li><a href="<?php echo e(route('web.safety-center')); ?>" class="text-white/90 hover:text-white transition-colors text-sm">Safety Tips</a></li>
                            <li><a href="<?php echo e(route('web.faqs')); ?>" class="text-white/90 hover:text-white transition-colors text-sm">FAQs</a></li>
                            <li><a href="<?php echo e(route('web.sitemap')); ?>" class="text-white/90 hover:text-white transition-colors text-sm">Sitemap</a></li>
                            <li><button onclick="openSupportModal()" class="text-white/90 hover:text-white transition-colors text-sm text-left">Report Issue</button></li>
                        </ul>
                    </div>

                    <!-- Download & PWA -->
                    <div>
                        <h4 class="font-bold text-white mb-6 text-sm uppercase tracking-wider">Get the App</h4>
                        <div class="flex flex-col gap-3">
                            <a href="#" class="group bg-white/10 hover:bg-white/20 p-3 rounded-xl flex items-center gap-3 transition-all border border-white/20">
                                <i class="fa-brands fa-apple text-2xl group-hover:scale-110 transition-transform"></i>
                                <div>
                                    <div class="text-[9px] text-white/60 leading-tight">Download on the</div>
                                    <div class="text-sm font-black leading-tight">App Store</div>
                                </div>
                            </a>
                            <a href="#" class="group bg-white/10 hover:bg-white/20 p-3 rounded-xl flex items-center gap-3 transition-all border border-white/20">
                                <i class="fa-brands fa-google-play text-2xl group-hover:scale-110 transition-transform"></i>
                                <div>
                                    <div class="text-[9px] text-white/60 leading-tight">Get it on</div>
                                    <div class="text-sm font-black leading-tight">Google Play</div>
                                </div>
                            </a>
                            <!-- PWA / Direct Install -->
                            <button id="pwa-install-btn" class="group bg-primary-dark/30 hover:bg-primary-dark/50 p-3 rounded-xl flex items-center gap-3 transition-all border border-white/10 text-left w-full hidden">
                                <i class="fa-solid fa-cloud-arrow-down text-xl group-hover:bounce transition-transform"></i>
                                <div>
                                    <div class="text-[9px] text-white/60 leading-tight">Instant Install</div>
                                    <div class="text-sm font-black leading-tight">PWA App</div>
                                </div>
                            </button>
                            <!-- Direct APK Download for Android -->
                            <a href="/assets/apps/yilick.apk" class="group bg-emerald-700/50 hover:bg-emerald-700/70 p-3 rounded-xl flex items-center gap-3 transition-all border border-white/10">
                                <i class="fa-solid fa-file-download text-xl group-hover:translate-y-1 transition-transform"></i>
                                <div>
                                    <div class="text-[9px] text-white/60 leading-tight">Android Users</div>
                                    <div class="text-sm font-black leading-tight">Direct APK</div>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Bottom Bar -->
                <div class="pt-8 border-t border-white/20">
                    <div class="flex flex-col md:flex-row items-center justify-between gap-4">
                        <p class="text-white/90 text-xs">
                            © 2023 - <?php echo e(date('Y')); ?> YILICK. All rights reserved.
                            <span class="mx-2 text-white/40">|</span>
                            A brand of <a href="https://xperbyte.xyz" target="_blank" class="hover:text-white font-medium transition-colors">Xperbyte LTD</a>
                        </p>
                        <div class="flex items-center gap-6 text-xs">
                            <a href="<?php echo e(route('web.terms')); ?>" class="text-white/90 hover:text-white transition-colors">Terms of Service</a>
                            <a href="<?php echo e(route('web.privacy')); ?>" class="text-white/90 hover:text-white transition-colors">Privacy Policy</a>
                            <a href="<?php echo e(route('web.cookie')); ?>" class="text-white/90 hover:text-white transition-colors">Cookie Policy</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Mobile Footer (Expandable/Collapsible) -->
        <div class="md:hidden">
            <div class="container mx-auto px-4 pb-24">
                <!-- Header with Logo and Toggle -->
                <div class="flex items-center justify-between py-4">
                    <div class="flex items-center gap-3">
                        <div class="sketch-logo-bg inline-flex items-center justify-center">
                            <img src="/assets/icons/logo.png" alt="YILICK" class="h-8 w-auto">
                        </div>
                    </div>
                    <button onclick="toggleMobileFooter()" id="mobile-footer-toggle" class="w-10 h-10 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center transition-all">
                        <i id="toggle-icon" class="fa-solid fa-chevron-up text-white text-lg transition-transform duration-300"></i>
                    </button>
                </div>

                <!-- Expandable Footer Content -->
                <div id="mobile-footer-content" class="hidden">
                    <div class="border-t border-white/20 pt-6 pb-4">
                        <!-- Company Section -->
                        <div class="mb-6">
                            <h4 class="font-bold text-white mb-3 text-sm uppercase tracking-wider">Company</h4>
                            <ul class="space-y-2 pl-2">
                                <li><a href="<?php echo e(route('web.about')); ?>" class="text-white/90 text-sm block">About Us</a></li>
                                <li><a href="<?php echo e(route('web.contact')); ?>" class="text-white/90 text-sm block">Contact</a></li>
                                <li><a href="<?php echo e(route('web.careers')); ?>" class="text-white/90 text-sm block">Careers</a></li>
                                <li><a href="<?php echo e(route('web.blog')); ?>" class="text-white/90 text-sm block">Blog</a></li>
                            </ul>
                        </div>

                        <!-- Support Section -->
                        <div class="mb-6">
                            <h4 class="font-bold text-white mb-3 text-sm uppercase tracking-wider">Support</h4>
                            <ul class="space-y-2 pl-2">
                                <li><a href="<?php echo e(route('web.help-center')); ?>" class="text-white/90 text-sm block">Help Center</a></li>
                                <li><a href="<?php echo e(route('web.safety-center')); ?>" class="text-white/90 text-sm block">Safety Tips</a></li>
                                <li><a href="<?php echo e(route('web.faqs')); ?>" class="text-white/90 text-sm block">FAQs</a></li>
                                <li><a href="<?php echo e(route('web.sitemap')); ?>" class="text-white/90 text-sm block">Sitemap</a></li>
                                <li><button onclick="openSupportModal()" class="text-white/90 text-sm block text-left">Report Issue</button></li>
                            </ul>
                        </div>

                        <!-- Get the App Section -->
                        <div class="mb-8">
                            <h4 class="font-bold text-white mb-4 text-sm uppercase tracking-wider">Experience Yilick Mobile</h4>
                            <div class="grid grid-cols-2 gap-3">
                                <a href="#" class="bg-white/10 p-3 rounded-xl flex items-center gap-2 border border-white/20">
                                    <i class="fa-brands fa-apple text-xl"></i>
                                    <span class="text-xs font-bold">App Store</span>
                                </a>
                                <a href="#" class="bg-white/10 p-3 rounded-xl flex items-center gap-2 border border-white/20">
                                    <i class="fa-brands fa-google-play text-xl"></i>
                                    <span class="text-xs font-bold">Play Store</span>
                                </a>
                                <button id="pwa-install-btn-mobile" class="bg-primary-dark/30 p-3 rounded-xl flex items-center gap-2 border border-white/10 hidden">
                                    <i class="fa-solid fa-mobile-button text-xl"></i>
                                    <span class="text-xs font-bold">Install PWA</span>
                                </button>
                                <a href="/assets/apps/yilick.apk" class="bg-emerald-700/40 p-3 rounded-xl flex items-center gap-2 border border-white/10">
                                    <i class="fa-solid fa-download text-xl"></i>
                                    <span class="text-xs font-bold">Direct APK</span>
                                </a>
                            </div>
                        </div>

                        <!-- Social Media -->
                        <div class="flex items-center justify-center gap-4 mb-6">
                            <a href="https://facebook.com/yilick" target="_blank" class="w-10 h-10 rounded-full bg-white/10 flex items-center justify-center">
                                <i class="fa-brands fa-facebook text-lg"></i>
                            </a>
                            <a href="https://twitter.com/yilick" target="_blank" class="w-10 h-10 rounded-full bg-white/10 flex items-center justify-center">
                                <i class="fa-brands fa-twitter text-lg"></i>
                            </a>
                            <a href="https://instagram.com/yilick" target="_blank" class="w-10 h-10 rounded-full bg-white/10 flex items-center justify-center">
                                <i class="fa-brands fa-instagram text-lg"></i>
                            </a>
                            <a href="https://linkedin.com/company/yilick" target="_blank" class="w-10 h-10 rounded-full bg-white/10 flex items-center justify-center">
                                <i class="fa-brands fa-linkedin text-lg"></i>
                            </a>
                        </div>

                        <!-- Legal Links -->
                        <div class="text-center text-white/90 text-xs mb-3">
                            © <?php echo e(date('Y')); ?> YILICK. All rights reserved.
                        </div>
                        <div class="flex items-center justify-center gap-4 text-xs text-white/90">
                            <a href="<?php echo e(route('web.terms')); ?>" class="hover:text-white">Terms</a>
                            <a href="<?php echo e(route('web.privacy')); ?>" class="hover:text-white">Privacy</a>
                            <a href="<?php echo e(route('web.cookie')); ?>" class="hover:text-white">Cookies</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- Location Selection Modal -->
    <div id="location-modal" class="fixed inset-0 z-[1000] bg-black/60 backdrop-blur-sm hidden flex items-center justify-center p-4">
        <div class="bg-white w-full max-w-md max-h-[80vh] rounded-2xl shadow-2xl flex flex-col transform transition-all duration-300 opacity-0 scale-95 overflow-hidden">
            <!-- Header -->
            <div class="px-5 py-4 border-b border-gray-100 flex items-center justify-between bg-white">
                <div>
                    <h2 class="text-lg font-bold text-gray-900">Select Location</h2>
                    <p class="text-gray-500 text-xs mt-0.5">Choose your district</p>
                </div>
                <button onclick="closeLocationModal()" class="w-8 h-8 rounded-full bg-gray-100 hover:bg-gray-200 flex items-center justify-center transition-colors">
                    <i class="fa-solid fa-xmark text-gray-500 text-sm"></i>
                </button>
            </div>

            <!-- Search -->
            <div class="px-5 py-3 bg-gray-50 border-b border-gray-100">
                <div class="relative">
                    <input type="text" 
                           id="location-search"
                           onkeyup="filterLocations(this.value)"
                           placeholder="Search districts..." 
                           class="w-full pl-10 pr-4 py-2.5 rounded-xl border border-gray-200 focus:border-primary focus:ring-2 focus:ring-primary/10 outline-none bg-white text-sm">
                    <i class="fa-solid fa-search absolute left-3.5 top-1/2 -translate-y-1/2 text-gray-400 text-sm"></i>
                </div>
            </div>

            <!-- "All Uganda" Option -->
            <button onclick="selectLocation('All Uganda')" class="px-5 py-3 flex items-center gap-3 hover:bg-primary/5 transition-colors border-b border-gray-100 text-left w-full">
                <div class="w-8 h-8 rounded-full bg-primary/10 flex items-center justify-center">
                    <i class="fa-solid fa-globe text-primary text-sm"></i>
                </div>
                <span class="font-semibold text-gray-900">All Uganda</span>
            </button>

            <!-- Districts List -->
            <div id="location-list" class="overflow-y-auto flex-1 custom-scrollbar">
                <div class="p-8 text-center text-gray-400">
                    <i class="fa-solid fa-spinner fa-spin text-2xl mb-2"></i>
                    <p class="text-sm">Loading districts...</p>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Location Data
        let allDistricts = [];
        let filteredDistricts = [];

        // Load districts on page load
        document.addEventListener('DOMContentLoaded', function() {
            loadDistricts();
            loadSavedLocation();
        });

        async function loadDistricts() {
            try {
                const response = await fetch('/assets/districts.json');
                const data = await response.json();
                allDistricts = data.map(d => d.name).sort();
                filteredDistricts = allDistricts;
                renderLocationList(filteredDistricts);
            } catch (error) {
                console.error('Failed to load districts:', error);
                document.getElementById('location-list').innerHTML = `
                    <div class="p-8 text-center text-gray-400">
                        <i class="fa-solid fa-exclamation-triangle text-2xl mb-2"></i>
                        <p class="text-sm">Failed to load districts</p>
                    </div>
                `;
            }
        }

        function loadSavedLocation() {
            const saved = localStorage.getItem('yilick_location');
            if (saved) {
                updateLocationDisplay(saved);
            }
        }

        function openLocationModal() {
            const modal = document.getElementById('location-modal');
            const search = document.getElementById('location-search');
            
            modal.classList.remove('hidden');
            document.body.style.overflow = 'hidden';
            
            setTimeout(() => {
                modal.firstElementChild.classList.remove('opacity-0', 'scale-95');
                modal.firstElementChild.classList.add('opacity-100', 'scale-100');
            }, 10);
            
            setTimeout(() => search.focus(), 50);
        }

        function closeLocationModal() {
            const modal = document.getElementById('location-modal');
            const content = modal.firstElementChild;
            
            content.classList.remove('opacity-100', 'scale-100');
            content.classList.add('opacity-0', 'scale-95');
            
            setTimeout(() => {
                modal.classList.add('hidden');
                document.body.style.overflow = '';
                document.getElementById('location-search').value = '';
                renderLocationList(allDistricts);
            }, 200);
        }

        function filterLocations(query) {
            if (!query) {
                filteredDistricts = allDistricts;
            } else {
                filteredDistricts = allDistricts.filter(d => 
                    d.toLowerCase().includes(query.toLowerCase())
                );
            }
            renderLocationList(filteredDistricts);
        }

        function renderLocationList(districts) {
            const list = document.getElementById('location-list');
            
            if (districts.length === 0) {
                list.innerHTML = `
                    <div class="p-8 text-center text-gray-400">
                        <i class="fa-solid fa-location-crosshairs text-2xl mb-2"></i>
                        <p class="text-sm">No districts found</p>
                    </div>
                `;
                return;
            }

            list.innerHTML = districts.map(district => `
                <button onclick="selectLocation('${district}')" class="w-full px-5 py-3 flex items-center gap-3 hover:bg-gray-50 transition-colors border-b border-gray-50 text-left">
                    <i class="fa-solid fa-location-dot text-gray-400"></i>
                    <span class="text-sm text-gray-700">${district}</span>
                </button>
            `).join('');
        }

        function selectLocation(location) {
            localStorage.setItem('yilick_location', location);
            updateLocationDisplay(location);
            closeLocationModal();
        }

        function updateLocationDisplay(location) {
            const displayText = location.length > 12 ? location.substring(0, 10) + '...' : location;
            
            // Update mobile header
            const mobileEl = document.getElementById('mobile-location-text');
            if (mobileEl) mobileEl.textContent = displayText;
            
            // Update desktop header (if we add one)
            const desktopEl = document.getElementById('desktop-location-text');
            if (desktopEl) desktopEl.textContent = displayText;
        }

        // Close modal on backdrop click
        document.getElementById('location-modal')?.addEventListener('click', function(e) {
            if (e.target === this) closeLocationModal();
        });

        // Close on Escape key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                const modal = document.getElementById('location-modal');
                if (modal && !modal.classList.contains('hidden')) {
                    closeLocationModal();
                }
            }
        });

        function toggleMobileFooter() {
            const content = document.getElementById('mobile-footer-content');
            const icon = document.getElementById('toggle-icon');
            const footer = document.querySelector('footer');
            
            if (content.classList.contains('hidden')) {
                content.classList.remove('hidden');
                icon.classList.remove('fa-chevron-up');
                icon.classList.add('fa-chevron-down');
                
                setTimeout(() => {
                    content.scrollIntoView({ 
                        behavior: 'smooth', 
                        block: 'nearest'
                    });
                }, 100);
            } else {
                content.classList.add('hidden');
                icon.classList.remove('fa-chevron-down');
                icon.classList.add('fa-chevron-up');
            }
        }
    </script>

<style>
/* Professional Hand-Sketch Logo Background */
.sketch-logo-bg {
    position: relative;
    padding: 8px 18px;
    font-weight: 600;
    z-index: 1;
    display: inline-block;
}

.sketch-logo-bg::before {
    content: "";
    position: absolute;
    inset: -8px -12px;
    background: linear-gradient(145deg, #ffffff 0%, #f8f9fa 100%);
    z-index: -1;
    border-radius: 4px;
    transform: rotate(-1.2deg);
    
    /* Hand-drawn irregular shape with organic edges */
    clip-path: polygon(
        1% 12%,
        8% 3%,
        22% 1%,
        45% 0%,
        68% 2%,
        85% 1%,
        96% 8%,
        99% 22%,
        98% 48%,
        100% 72%,
        97% 88%,
        89% 97%,
        68% 99%,
        42% 98%,
        18% 99%,
        6% 95%,
        2% 84%,
        0% 58%,
        1% 32%
    );
    
    /* Professional sketch shadow with depth */
    box-shadow: 
        0 2px 8px rgba(0, 0, 0, 0.08),
        inset 0 0 0 1px rgba(0, 0, 0, 0.04),
        0 4px 16px rgba(0, 0, 0, 0.05);
}

.sketch-logo-bg::after {
    content: "";
    position: absolute;
    inset: -8px -12px;
    z-index: -2;
    border-radius: 4px;
    transform: rotate(-1.2deg);
    
    /* Subtle cross-hatch pencil texture for authenticity */
    background-image: 
        repeating-linear-gradient(
            45deg,
            transparent,
            transparent 2px,
            rgba(0, 0, 0, 0.018) 2px,
            rgba(0, 0, 0, 0.018) 4px
        ),
        repeating-linear-gradient(
            -45deg,
            transparent,
            transparent 2px,
            rgba(0, 0, 0, 0.018) 2px,
            rgba(0, 0, 0, 0.018) 4px
        );
    
    clip-path: polygon(
        1% 12%,
        8% 3%,
        22% 1%,
        45% 0%,
        68% 2%,
        85% 1%,
        96% 8%,
        99% 22%,
        98% 48%,
        100% 72%,
        97% 88%,
        89% 97%,
        68% 99%,
        42% 98%,
        18% 99%,
        6% 95%,
        2% 84%,
        0% 58%,
        1% 32%
    );
}

/* Hover effect for interactive feel */
.sketch-logo-bg:hover::before {
    transform: rotate(-0.8deg);
    box-shadow: 
        0 3px 12px rgba(0, 0, 0, 0.1),
        inset 0 0 0 1px rgba(0, 0, 0, 0.05),
        0 6px 20px rgba(0, 0, 0, 0.06);
    transition: all 0.3s ease;
}

header {
    z-index: 900 !important;
}

#topbars-container {
    z-index: 999 !important;
}
</style>

<?php echo $__env->make('web.partials.support-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->yieldPushContent('scripts'); ?>
<script>
    async function toggleFavoriteGlobal(btn, type, id) {
        <?php if(auth()->guard('web')->guest()): ?>
            window.location.href = "<?php echo e(route('login')); ?>";
            return;
        <?php endif; ?>

        const isActive = btn.getAttribute('data-active') === 'true';
        const url = type === 'listing' 
            ? "<?php echo e(route('web.favorites.toggle-listing')); ?>" 
            : "<?php echo e(route('web.favorites.toggle-business')); ?>";
        
        const body = type === 'listing' ? { listing_id: id } : { business_id: id };

        // Optimistic UI update
        const icon = btn.querySelector('i');
        if (isActive) {
            btn.setAttribute('data-active', 'false');
            btn.classList.remove('text-red-500');
            btn.classList.add('text-gray-400');
            if (icon) {
                icon.classList.remove('fa-solid');
                icon.classList.add('fa-regular');
            }
        } else {
            btn.setAttribute('data-active', 'true');
            btn.classList.add('text-red-500');
            btn.classList.remove('text-gray-400');
            if (icon) {
                icon.classList.add('fa-solid');
                icon.classList.remove('fa-regular');
            }
        }

        try {
            const response = await fetch(url, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                body: JSON.stringify(body)
            });

            const data = await response.json();
            if (data.status !== 'success') {
                location.reload(); 
            }
        } catch (error) {
            console.error('Error:', error);
            location.reload();
        }
    }

    function showLoading() {
        const loader = document.getElementById('global-loader');
        const content = document.getElementById('loader-content');
        loader.classList.remove('hidden');
        setTimeout(() => {
            loader.classList.add('opacity-100');
            content.classList.add('scale-100');
        }, 10);
    }

    function hideLoading() {
        const loader = document.getElementById('global-loader');
        const content = document.getElementById('loader-content');
        loader.classList.remove('opacity-100');
        content.classList.remove('scale-100');
        setTimeout(() => {
            loader.classList.add('hidden');
        }, 300);
    }

    function showToast(message, type = 'success') {
        const container = document.getElementById('toast-container');
        const toast = document.createElement('div');
        toast.className = 'toast-item animate-in fade-in slide-in-from-right-8 duration-500';
        
        const bgColor = type === 'success' ? 'bg-emerald-500' : 'bg-red-500';
        const shadowColor = type === 'success' ? 'shadow-emerald-500/20' : 'shadow-red-500/20';
        const icon = type === 'success' ? 'fa-circle-check' : 'fa-circle-exclamation';
        
        toast.innerHTML = `
            <div class="${bgColor} text-white px-6 py-3 rounded-2xl shadow-xl ${shadowColor} flex items-center gap-3">
                <i class="fa-solid ${icon} text-lg"></i>
                <p class="font-bold text-sm text-white m-0">${message}</p>
            </div>
        `;
        
        container.appendChild(toast);
        
        // Auto remove after 5 seconds
        setTimeout(() => {
            toast.classList.add('animate-out', 'fade-out', 'slide-out-to-right-8');
            setTimeout(() => toast.remove(), 500);
        }, 5000);
    }

    // PWA Installation Logic
    let deferredPrompt;
    const pwaBtn = document.getElementById('pwa-install-btn');
    const pwaBtnMobile = document.getElementById('pwa-install-btn-mobile');

    window.addEventListener('beforeinstallprompt', (e) => {
        // Prevent Chrome 67 and earlier from automatically showing the prompt
        e.preventDefault();
        // Stash the event so it can be triggered later.
        deferredPrompt = e;
        // Update UI notify the user they can install the PWA
        if (pwaBtn) pwaBtn.classList.remove('hidden');
        if (pwaBtnMobile) pwaBtnMobile.classList.remove('hidden');
    });

    const handleInstall = async () => {
        if (!deferredPrompt) return;
        // Show the prompt
        deferredPrompt.prompt();
        // Wait for the user to respond to the prompt
        const { outcome } = await deferredPrompt.userChoice;
        if (outcome === 'accepted') {
            console.log('User accepted the PWA prompt');
        }
        deferredPrompt = null;
        if (pwaBtn) pwaBtn.classList.add('hidden');
        if (pwaBtnMobile) pwaBtnMobile.classList.add('hidden');
    };

    if (pwaBtn) pwaBtn.addEventListener('click', handleInstall);
    if (pwaBtnMobile) pwaBtnMobile.addEventListener('click', handleInstall);

    window.addEventListener('appinstalled', (evt) => {
        showToast('Yilick installed successfully!', 'success');
    });

    function toggleAppLauncher() {
        const modal = document.getElementById('app-launcher-modal');
        if (modal.classList.contains('hidden')) {
            modal.classList.remove('hidden');
        } else {
            modal.classList.add('hidden');
        }
    }

    // Topbar Logic
    document.addEventListener('DOMContentLoaded', () => {
        checkTopbars();
    });

    function checkTopbars() {
        const downloadDismissed = localStorage.getItem('hide_topbar_download');
        
        const downloadBar = document.getElementById('topbar-download');
        const bodyContent = document.getElementById('body-content');
        
        let totalHeight = 0;

        if (!downloadDismissed && downloadBar) {
            downloadBar.classList.remove('hidden');
            totalHeight += downloadBar.offsetHeight;
        }
        
        updateLayoutOffset();
    }

    function dismissTopbar(id) {
        localStorage.setItem('hide_topbar_' + id, 'true');
        const bar = document.getElementById('topbar-' + id);
        if (bar) {
            bar.classList.add('hidden');
            updateLayoutOffset();
        }
    }

    function updateLayoutOffset() {
        const container = document.getElementById('topbars-container');
        const height = container.offsetHeight;
        
        // Push the sticky header down so it sits below the fixed topbar
        // And set 'top' so it sticks at the correct position
        const headers = document.querySelectorAll('header.sticky');
        headers.forEach(header => {
            header.style.marginTop = height + 'px';
            header.style.top = height + 'px';
        });
    }
</script>

<!-- App Launcher Modal -->
<div id="app-launcher-modal" class="fixed inset-0 z-[1000] hidden" role="dialog" aria-modal="true">
    <div class="absolute inset-0 bg-transparent" onclick="toggleAppLauncher()"></div>
    <div class="absolute top-16 right-4 sm:top-20 sm:right-20 w-[320px] bg-white rounded-3xl shadow-2xl border border-gray-100 overflow-hidden animate-in fade-in zoom-in-95 duration-200 origin-top-right">
        <div class="p-4 bg-gray-50/50 border-b border-gray-100">
            <h3 class="text-sm font-bold text-gray-900">Xperbyte Brands</h3>
        </div>
        <div class="p-6 grid grid-cols-3 gap-y-6 gap-x-2">
            <a href="https://yilick.com" class="flex flex-col items-center gap-2 group">
                <div class="w-12 h-12 rounded-2xl bg-primary/5 flex items-center justify-center group-hover:bg-primary group-hover:text-white transition-all duration-300">
                    <img src="/assets/icons/favicon.png" class="w-6 h-6 object-contain">
                </div>
                <span class="text-xs font-medium text-gray-600 group-hover:text-gray-900 text-center">Yilick</span>
            </a>
            <a href="https://hostemperor.com/" target="_blank" class="flex flex-col items-center gap-2 group">
                <div class="w-12 h-12 rounded-2xl bg-indigo-50 flex items-center justify-center text-indigo-600 group-hover:bg-indigo-600 group-hover:text-white transition-all duration-300">
                    <i class="fa-solid fa-server text-xl"></i>
                </div>
                <span class="text-xs font-medium text-gray-600 group-hover:text-gray-900 text-center">HostEmperor</span>
            </a>
            <a href="https://pocketpesa.app/" target="_blank" class="flex flex-col items-center gap-2 group">
                <div class="w-12 h-12 rounded-2xl bg-emerald-50 flex items-center justify-center text-emerald-600 group-hover:bg-emerald-600 group-hover:text-white transition-all duration-300">
                    <i class="fa-solid fa-wallet text-xl"></i>
                </div>
                <span class="text-xs font-medium text-gray-600 group-hover:text-gray-900 text-center">PocketPesa</span>
            </a>
            <a href="https://zaramind.com" target="_blank" class="flex flex-col items-center gap-2 group">
                <div class="w-12 h-12 rounded-2xl bg-purple-50 flex items-center justify-center text-purple-600 group-hover:bg-purple-600 group-hover:text-white transition-all duration-300">
                    <i class="fa-solid fa-brain text-xl"></i>
                </div>
                <span class="text-xs font-medium text-gray-600 group-hover:text-gray-900 text-center">Zaramind</span>
            </a>
        </div>
        <div class="p-3 bg-gray-50 border-t border-gray-100 text-center">
            <a href="https://xperbyte.xyz" target="_blank" class="text-[10px] font-bold text-gray-400 hover:text-primary transition-colors">More from Xperbyte</a>
        </div>
    </div>
</div>
</body>
</html><?php /**PATH /home/yilickapp/resources/views/layouts/app.blade.php ENDPATH**/ ?>