<?php $__env->startSection('title', 'Yilick - Uganda\'s #1 AI Marketplace | Buy & Sell Electronics, Cars & Property'); ?>
<?php $__env->startSection('meta_description', 'Discover Yilick, the smartest way to buy and sell in Uganda. Browse thousands of electronics, fashion items, cars, and properties. Empower your business with AI tools.'); ?>
<?php $__env->startSection('meta_keywords', 'online shopping uganda, buy and sell cars kampala, property for sale uganda, electronics shops uganda, free classifieds africa'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white">
    <!-- Hero Section (Search-Focused) -->
    <section class="relative w-full overflow-hidden bg-primary py-10 md:py-14">
        <div class="container mx-auto px-4 text-center relative z-10">
            <div class="max-w-4xl mx-auto">
                <h1 class="text-2xl md:text-4xl lg:text-5xl font-extrabold text-white mb-6 md:mb-10 tracking-tight leading-tight px-4">
                    Buy and Sell Anything in Uganda
                </h1>
                
                <!-- Search Bar (Desktop Only) -->
                <form action="<?php echo e(route('listing.search')); ?>" method="GET" id="home-search-form" class="hidden md:flex items-stretch max-w-3xl mx-auto gap-3">
                    <!-- Search Input -->
                    <div class="flex-1 flex items-center px-5 py-3.5 bg-white/10 backdrop-blur-sm rounded-2xl border border-white/20 hover:bg-white/15 transition-colors">
                        <i class="fa-solid fa-search text-white/80 text-lg mr-3"></i>
                        <input 
                            type="text" 
                            name="q"
                            placeholder="What are you looking for?" 
                            class="flex-1 outline-none text-base text-white placeholder-white/70 bg-transparent"
                        >
                    </div>
                    
                    <!-- Location Selector -->
                    <button type="button" onclick="openLocationModal()" class="flex items-center px-5 py-3.5 bg-white/10 backdrop-blur-sm rounded-2xl border border-white/20 cursor-pointer hover:bg-white/15 transition-colors">
                        <i class="fa-solid fa-location-dot text-white/80 text-lg mr-3"></i>
                        <span id="desktop-location-text" class="flex-1 text-base text-white font-medium whitespace-nowrap">All Uganda</span>
                        <i class="fa-solid fa-chevron-down text-white/70 text-xs ml-2"></i>
                    </button>
                    <input type="hidden" name="location" id="home-location-input">
                    
                    <!-- Search Button -->
                    <button type="submit" class="bg-white hover:bg-white/90 text-primary font-bold px-8 py-3.5 rounded-2xl text-base transition-all hover:shadow-lg">
                        Search
                    </button>
                </form>

                <!-- Popular Searches -->
                <?php if(!empty($popularSearches)): ?>
                <div class="hidden md:flex items-center justify-center gap-3 mt-6 text-white/80 text-sm font-medium animate-fade-in">
                    <span class="text-white/60">Popular:</span>
                    <?php $__currentLoopData = $popularSearches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $term): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('listing.search', ['q' => $term])); ?>" class="hover:text-white transition-colors border-b border-transparent hover:border-white/30 pb-0.5">
                        <?php echo e(ucfirst($term)); ?>

                    </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Decorative elements -->
        <div class="absolute top-0 right-0 w-72 h-72 bg-white/5 rounded-full -translate-y-1/2 translate-x-1/2"></div>
        <div class="absolute bottom-0 left-0 w-56 h-56 bg-white/5 rounded-full translate-y-1/2 -translate-x-1/2"></div>
    </section>

    <!-- Mobile Categories Section (Flutter Style) -->
    <section class="relative md:hidden">
        <!-- Top Gradient Background (matches Flutter) -->
        <div class="absolute inset-x-0 top-0 h-48 bg-gradient-to-b from-primary via-primary/10 to-transparent pointer-events-none"></div>

        <div class="container mx-auto px-4 relative z-10 pt-4">
            <div class="bg-white rounded-3xl shadow-sm border border-cool-gray/10 overflow-hidden mx-auto max-w-lg">
                <div class="p-4">
                    <!-- Grid container with explicit mobile columns -->
                    <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 1.5rem 0.25rem;">
                        <!-- Today's Hot Deals (First Item) -->
                        <a href="<?php echo e(route('listing.hot-deals')); ?>" class="flex flex-col items-center group">
                            <div class="flex items-center justify-center mb-2 transition-transform group-hover:scale-110" style="width: 56px; height: 56px;">
                                <img src="<?php echo e(asset('assets/icons/hot_deals.svg')); ?>" alt="Hot Deals" style="width: 48px; height: 48px; object-fit: contain;">
                            </div>
                            <span class="text-11px font-medium text-center leading-tight text-charcoal-gray group-hover:text-primary transition-colors" style="font-size: 11px !important; white-space: pre-line;">Today's
Hot Deals</span>
                        </a>

                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <button 
                            onclick="openCategoryModal(<?php echo e($category['id']); ?>)"
                            class="flex flex-col items-center group bg-transparent border-0 p-0 cursor-pointer"
                        >
                            <div class="flex items-center justify-center mb-2 transition-transform group-hover:scale-110" style="width: 48px; height: 48px;">
                                <img src="<?php echo e(asset($category['icon'])); ?>" alt="<?php echo e($category['name']); ?>" style="width: 36px; height: 36px; object-fit: contain;">
                            </div>
                            <span class="text-11px font-medium text-center leading-tight text-charcoal-gray group-hover:text-primary transition-colors" style="font-size: 11px !important; white-space: pre-line;">
                                <?php echo str_replace('&', "&\n", $category['name']); ?>

                            </span>
                        </button>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Desktop Categories Section (Professional View) -->
    <section class="hidden md:block container mx-auto px-4 mt-8 relative z-10">
        <div class="bg-white rounded-[2.5rem] shadow-xl shadow-gray-200/40 border border-gray-100 p-12">
            <div class="flex items-center justify-between mb-10">
                <div>
                     <h2 class="text-1xl font-extrabold text-gray-900 tracking-tight">Explore Categories</h2>
                     <p class="text-gray-500 text-base mt-2 font-medium">Browse our extensive range of products and services</p>
                </div>
            </div>

            <div style="display: grid; grid-template-columns: repeat(8, minmax(0, 1fr)); gap: 2.5rem;">
                 <!-- Hot Deals Desktop (Premium Style) -->
                 <a href="<?php echo e(route('listing.hot-deals')); ?>" class="flex flex-col items-center group relative">
                    <div class="absolute -inset-4 bg-gradient-to-b from-orange-100/50 to-transparent rounded-[2rem] opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                    <div class="w-24 h-24 rounded-[1.8rem] bg-gradient-to-br from-orange-50 to-orange-100 flex items-center justify-center mb-5 transition-all duration-300 group-hover:-translate-y-2 group-hover:shadow-xl group-hover:shadow-orange-500/20 border border-orange-200 relative z-10">
                        <img src="<?php echo e(asset('assets/icons/hot_deals.svg')); ?>" alt="Hot Deals" class="w-12 h-12 object-contain drop-shadow-sm transform transition-transform duration-500 group-hover:scale-110 group-hover:rotate-3">
                    </div>
                    <span class="text-base font-bold text-gray-900 group-hover:text-orange-600 transition-colors relative z-10">Hot Deals</span>
                </a>

                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <button 
                    onclick="openCategoryModal(<?php echo e($category['id']); ?>)"
                    class="flex flex-col items-center group relative w-full text-left"
                >
                    <div class="w-24 h-24 rounded-[1.8rem] bg-gray-50 flex items-center justify-center mb-5 transition-all duration-300 group-hover:-translate-y-2 group-hover:bg-white group-hover:shadow-[0_8px_30px_rgb(0,0,0,0.06)] border border-gray-100 group-hover:border-primary/20">
                        <img src="<?php echo e(asset($category['icon'])); ?>" alt="<?php echo e($category['name']); ?>" class="w-12 h-12 object-contain transition-transform duration-500 group-hover:scale-110 group-hover:-rotate-3 opacity-90 group-hover:opacity-100">
                    </div>
                    <span class="text-sm font-semibold text-gray-600 text-center group-hover:text-primary transition-colors max-w-[120px] leading-snug">
                        <?php echo e($category['name']); ?>

                    </span>
                    <?php if(count($category['children']) > 0): ?>
                        <span class="absolute top-0 right-2 bg-primary/10 text-primary text-[10px] font-bold px-2 py-0.5 rounded-full opacity-0 group-hover:opacity-100 transition-opacity">
                            <?php echo e(count($category['children'])); ?>

                        </span>
                    <?php endif; ?>
                </button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>

    <!-- Trending Listings -->
    <section class="container mx-auto px-4 py-20">
        <div class="flex items-center justify-between mb-8">
            <div class="flex items-center gap-4">
                <div class="w-10 h-10 rounded-xl bg-vibrant-orange/10 flex items-center justify-center">
                    <i class="fa-solid fa-fire text-vibrant-orange"></i>
                </div>
                <div>
                    <h2 class="text-xl font-extrabold text-[#111827]">Trending Ads</h2>
                    <p class="text-cool-gray text-sm mt-0.5">Popular listings right now</p>
                </div>
            </div>
            <a href="<?php echo e(route('listing.hot-deals')); ?>" class="btn-primary !bg-white !text-primary border-2 border-primary/20 hover:border-primary/40 !py-2.5 !px-6 text-sm transition-all hover:-translate-y-0.5 shadow-sm hover:shadow-md">
                View All
            </a>
        </div>

        <div class="grid grid-cols-2 lg:grid-cols-4 xl:grid-cols-5 2xl:grid-cols-6 gap-6 md:gap-8">
            <?php $__empty_1 = true; $__currentLoopData = $promotedListings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $listing): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php if (isset($component)) { $__componentOriginal31ec1dc5dadb4835ef50de3d88e519ce = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal31ec1dc5dadb4835ef50de3d88e519ce = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.listing-card','data' => ['listing' => $listing,'boosted' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('listing-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['listing' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($listing),'boosted' => true]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal31ec1dc5dadb4835ef50de3d88e519ce)): ?>
<?php $attributes = $__attributesOriginal31ec1dc5dadb4835ef50de3d88e519ce; ?>
<?php unset($__attributesOriginal31ec1dc5dadb4835ef50de3d88e519ce); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal31ec1dc5dadb4835ef50de3d88e519ce)): ?>
<?php $component = $__componentOriginal31ec1dc5dadb4835ef50de3d88e519ce; ?>
<?php unset($__componentOriginal31ec1dc5dadb4835ef50de3d88e519ce); ?>
<?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <?php for($i = 0; $i < 5; $i++): ?>
                    <div class="animate-pulse bg-[#F8FAFC] rounded-[1.5rem] p-4 h-[320px]">
                        <div class="aspect-[4/3] bg-gray-200 rounded-xl mb-4"></div>
                        <div class="space-y-3">
                            <div class="h-4 bg-gray-200 rounded-full w-3/4"></div>
                            <div class="h-8 bg-gray-200 rounded-full w-1/2"></div>
                        </div>
                    </div>
                <?php endfor; ?>
            <?php endif; ?>
        </div>
    </section>


</div>


    <!-- Category Modal -->
    <div id="category-modal" class="fixed inset-0 z-[100] bg-black/60 backdrop-blur-md hidden flex items-center justify-center p-4">
        <div class="bg-white w-full max-w-5xl max-h-[90vh] rounded-[2.5rem] shadow-2xl flex flex-col transform transition-all duration-300 opacity-0 scale-95 overflow-hidden ring-1 ring-white/20">
            <!-- Header -->
            <div class="px-8 py-6 border-b border-gray-100 flex items-center justify-between bg-white relative z-20">
                <div>
                    <h2 class="text-2xl font-black text-gray-900 tracking-tight" id="modal-category-title">Category Name</h2>
                    <p class="text-gray-500 text-sm mt-1 font-medium">Select a sub-category to explore</p>
                </div>
                <button onclick="closeCategoryModal()" class="w-10 h-10 rounded-full bg-gray-50 hover:bg-gray-100 flex items-center justify-center transition-colors group">
                    <i class="fa-solid fa-xmark text-gray-400 group-hover:text-gray-600 text-xl transition-colors"></i>
                </button>
            </div>

            <!-- Search -->
            <div class="px-8 py-4 bg-gray-50/50 border-b border-gray-100 z-10">
                <div class="relative max-w-lg">
                    <input type="text" 
                           id="modal-search"
                           onkeyup="filterSubCategories(this.value)"
                           placeholder="Find a sub-category..." 
                           class="w-full pl-12 pr-4 py-3.5 rounded-2xl border border-gray-200 focus:border-green-500 ring-0 outline-none focus:outline-none focus:ring-4 focus:ring-green-500/10 bg-white shadow-sm text-sm font-semibold text-gray-700 placeholder:text-gray-400 transition-all caret-green-500">
                    <i class="fa-solid fa-search absolute left-4 top-1/2 -translate-y-1/2 text-gray-400"></i>
                </div>
            </div>

            <!-- Content -->
            <div class="overflow-y-auto p-8 flex-1 bg-white custom-scrollbar">
                <div id="modal-subcategories-list" class="grid grid-cols-2 min-[400px]:grid-cols-3 sm:grid-cols-4 md:grid-cols-5 lg:grid-cols-6 gap-x-4 gap-y-8">
                    <!-- Javascript will populate this -->
                </div>
            </div>
        </div>
    </div>

    <script>
        // Global Category Data for Performance
        window.categoryData = <?php echo json_encode($categories, 15, 512) ?>;

        // Category Modal Logic
        let currentSubCategories = [];
        let currentCategoryName = '';

        function openCategoryModal(categoryId) {
            // Find category data efficiently
            const category = window.categoryData.find(c => c.id == categoryId);
            if (!category) return;

            const modal = document.getElementById('category-modal');
            const title = document.getElementById('modal-category-title');
            const list = document.getElementById('modal-subcategories-list');
            const search = document.getElementById('modal-search');
            
            const subCategories = category.children || [];
            currentSubCategories = subCategories;
            currentCategoryName = category.name;
            
            title.innerText = category.name;
            search.value = ''; // Reset search
            
            renderSubCategories(subCategories);
            
            modal.classList.remove('hidden');
            document.body.style.overflow = 'hidden'; // Prevent scrolling
            
            // Animation
            setTimeout(() => {
                modal.firstElementChild.classList.remove('opacity-0', 'scale-95');
                modal.firstElementChild.classList.add('opacity-100', 'scale-100');
            }, 10);
            
            // Focus search
            setTimeout(() => search.focus(), 50);
        }

        function closeCategoryModal() {
            const modal = document.getElementById('category-modal');
            const content = modal.firstElementChild;
            
            content.classList.remove('opacity-100', 'scale-100');
            content.classList.add('opacity-0', 'scale-95');
            
            setTimeout(() => {
                modal.classList.add('hidden');
                document.body.style.overflow = ''; // Restore scrolling
            }, 200);
        }

        function filterSubCategories(query) {
            const filtered = currentSubCategories.filter(sub => 
                sub.name.toLowerCase().includes(query.toLowerCase())
            );
            renderSubCategories(filtered);
        }

        function renderSubCategories(items) {
            const list = document.getElementById('modal-subcategories-list');
            const currentLocation = localStorage.getItem('yilick_location') || 'All Uganda';
            const locationParam = currentLocation === 'All Uganda' ? '' : currentLocation;
            
            if (items.length === 0) {
                list.innerHTML = `
                    <div class="col-span-full flex flex-col items-center justify-center py-12 text-gray-400">
                        <i class="fa-solid fa-magnifying-glass text-3xl mb-3 opacity-50"></i>
                        <p class="text-sm font-medium">No sub-categories found.</p>
                    </div>
                `;
                return;
            }

            list.innerHTML = items.map(sub => {
                const searchUrl = `/search?category=${encodeURIComponent(currentCategoryName)}&subcategory=${encodeURIComponent(sub.name)}&location=${encodeURIComponent(locationParam)}`;
                
                return `
                    <a href="${searchUrl}" class="flex flex-col items-center justify-center p-4 rounded-2xl hover:bg-green-50/50 transition-all border border-transparent hover:border-green-100 group">
                        <div class="w-14 h-14 mb-3 flex items-center justify-center">
                            <img src="/${sub.icon}" 
                                 alt="${sub.name}" 
                                 class="max-w-full max-h-full object-contain group-hover:scale-110 transition-transform duration-300 drop-shadow-sm"
                                 onerror="this.parentElement.innerHTML='<i class=\\'fa-solid fa-layer-group text-2xl text-gray-300 group-hover:text-green-500/50 transition-colors\\'></i>'">
                        </div>
                        <span class="text-xs font-bold text-center text-gray-600 group-hover:text-green-600 line-clamp-2 leading-tight px-2">
                            ${sub.name}
                        </span>
                    </a>
                `;
            }).join('');
        }

        // Close on backdrop click
        document.getElementById('category-modal').addEventListener('click', function(e) {
            if (e.target === this) closeCategoryModal();
        });
        
        // Close on Escape key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') closeCategoryModal();
        });

        // Sync location with home search form
        const originalSelectLocation = window.selectLocation;
        window.selectLocation = function(location) {
            // Update home search form hidden input
            const homeLocationInput = document.getElementById('home-location-input');
            if (homeLocationInput) {
                homeLocationInput.value = location === 'All Uganda' ? '' : location;
            }
            // Call original function
            if (typeof originalSelectLocation === 'function') {
                originalSelectLocation(location);
            } else {
                localStorage.setItem('yilick_location', location);
                updateLocationDisplay(location);
                closeLocationModal();
            }
        };
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/home.blade.php ENDPATH**/ ?>