<!DOCTYPE html>
<html>
<head>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .header {
            text-align: center;
            padding-bottom: 20px;
            border-bottom: 1px solid #eeeeee;
        }
        .content {
            padding: 20px 0;
            color: #333333;
            line-height: 1.6;
        }
        .message-box {
            background-color: #f9f9f9;
            border-left: 4px solid #4CAF50;
            padding: 15px;
            margin: 15px 0;
            font-style: italic;
        }
        .button-container {
            text-align: center;
            margin-top: 30px;
        }
        .button {
            background-color: #4CAF50;
            color: white;
            padding: 12px 24px;
            text-decoration: none;
            border-radius: 4px;
            font-weight: bold;
            display: inline-block;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            color: #888888;
            font-size: 12px;
            border-top: 1px solid #eeeeee;
            padding-top: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>New Message on Yilick</h2>
        </div>
        
        <div class="content">
            <p>Hello <?php echo e($recipientName); ?>,</p>
            
            <p>You have received a new message from <strong><?php echo e($sender->full_name ?? $sender->username); ?></strong>.</p>
            
            <div class="message-box">
                <?php if($messageModel->type === 'image'): ?>
                    [Sent an image]
                <?php else: ?>
                    "<?php echo e($messageModel->message); ?>"
                <?php endif; ?>
            </div>
            
            <div class="button-container">
                <a href="yilick://chat-detail?conversationId=<?php echo e($messageModel->conversation_id); ?>" class="button">Reply in App</a>
            </div>
            
            <p style="text-align: center; margin-top: 20px;">
                <small>If the button doesn't work, open the Yilick app and go to your messages.</small>
            </p>
        </div>
        
        <div class="footer">
            <p>&copy; <?php echo e(date('Y')); ?> Yilick. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/yilickapp/website/resources/views/emails/new_message.blade.php ENDPATH**/ ?>