<?php $__env->startSection('title', 'Contact Us - Yilick'); ?>

<?php $__env->startSection('content'); ?>
<style>
    @keyframes slideIn {
        from { opacity: 0; transform: translateY(-1rem); }
        to { opacity: 1; transform: translateY(0); }
    }
    .animate-slide-in {
        animation: slideIn 0.5s ease-out forwards;
    }
</style>
<div class="bg-white min-h-screen">
    <!-- Light & Fresh Header -->
    <div class="bg-emerald-50/50 pt-24 pb-32 relative overflow-hidden border-b border-emerald-100/50">
        <!-- Decorative subtle elements -->
        <div class="absolute inset-0 pointer-events-none">
            <div class="absolute top-0 right-0 w-96 h-96 bg-primary/5 rounded-full blur-[100px] -mr-48 -mt-48 transition-all duration-1000"></div>
            <div class="absolute bottom-0 left-0 w-96 h-96 bg-primary/5 rounded-full blur-[100px] -ml-48 -mb-48"></div>
            <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-full h-full bg-[radial-gradient(theme(colors.primary)_1px,transparent_1px)] [background-size:40px_40px] opacity-[0.03]"></div>
        </div>

        <div class="container mx-auto px-4 relative z-10">
            <div class="max-w-4xl mx-auto text-center">
                <span class="inline-block px-4 py-1.5 rounded-full bg-primary/10 text-primary text-xs font-black uppercase tracking-widest mb-6 border border-primary/20">Contact Us</span>
                <h1 class="text-4xl md:text-6xl font-black text-gray-900 mb-6 tracking-tight">Let's build something <br/><span class="text-primary italic">great together</span></h1>
                <p class="text-cool-gray text-lg md:text-xl leading-relaxed max-w-2xl mx-auto font-medium">
                    Whether you're looking to scale your business or have a simple question, our dedicated team is here to support your journey on Yilick.
                </p>
            </div>
        </div>
    </div>

    <!-- Main Content Grid -->
    <div class="container mx-auto px-4 -mt-20 relative z-20 pb-24">
        <div class="max-w-6xl mx-auto">
            <div class="grid grid-cols-1 lg:grid-cols-12 gap-8 items-start">
                
                <!-- Left Sidebar: Contact Info -->
                <div class="lg:col-span-5 space-y-6">
                    <!-- Session Feedback -->
                    <?php if(session('success')): ?>
                        <div class="bg-primary text-white p-6 rounded-3xl shadow-xl shadow-primary/20 flex items-center gap-4 animate-slide-in">
                            <i class="fa-solid fa-circle-check text-2xl"></i>
                            <p class="font-bold text-sm"><?php echo e(session('success')); ?></p>
                        </div>
                    <?php endif; ?>

                    <?php if(session('error')): ?>
                        <div class="bg-red-500 text-white p-6 rounded-3xl shadow-xl shadow-red-500/20 flex items-center gap-4 animate-slide-in">
                            <i class="fa-solid fa-circle-exclamation text-2xl"></i>
                            <p class="font-bold text-sm"><?php echo e(session('error')); ?></p>
                        </div>
                    <?php endif; ?>

                    <!-- Connect Card -->
                    <div class="bg-white p-8 md:p-10 rounded-[40px] shadow-2xl shadow-gray-200/40 border border-emerald-100/50 overflow-hidden relative group">
                        <div class="absolute top-0 right-0 w-32 h-32 bg-emerald-50 rounded-full -mr-16 -mt-16 transition-transform duration-500 group-hover:scale-110"></div>
                        
                        <h3 class="text-2xl font-black text-gray-900 mb-10 relative">Get in touch</h3>
                        
                        <div class="space-y-8 relative">
                            <!-- Location -->
                            <div class="flex items-start gap-5 group/item">
                                <div class="w-14 h-14 rounded-2xl bg-primary/5 text-primary flex items-center justify-center flex-shrink-0 group-hover/item:bg-primary group-hover/item:text-white transition-all duration-300">
                                    <i class="fa-solid fa-location-dot text-xl"></i>
                                </div>
                                <div>
                                    <h4 class="text-xs font-black text-gray-400 uppercase tracking-widest mb-1">Our Office</h4>
                                    <p class="text-gray-900 font-bold leading-relaxed">Ntinda, Kampala Uganda</p>
                                    <p class="text-cool-gray text-sm">P.O.BOX 170683 Kampala GPO</p>
                                </div>
                            </div>

                            <!-- Email -->
                            <div class="flex items-start gap-5 group/item">
                                <div class="w-14 h-14 rounded-2xl bg-emerald-50 text-emerald-600 flex items-center justify-center flex-shrink-0 group-hover/item:bg-emerald-600 group-hover/item:text-white transition-all duration-300">
                                    <i class="fa-solid fa-envelope text-xl"></i>
                                </div>
                                <div>
                                    <h4 class="text-xs font-black text-gray-400 uppercase tracking-widest mb-1">Email Us</h4>
                                    <a href="mailto:support@yilick.ug" class="text-gray-900 font-bold block hover:text-primary transition-colors">support@yilick.ug</a>
                                    <a href="mailto:business@yilick.ug" class="text-gray-900 font-bold block hover:text-primary transition-colors">business@yilick.ug</a>
                                </div>
                            </div>

                            <!-- Phone -->
                            <div class="flex items-start gap-5 group/item">
                                <div class="w-14 h-14 rounded-2xl bg-orange-50 text-orange-600 flex items-center justify-center flex-shrink-0 group-hover/item:bg-orange-600 group-hover/item:text-white transition-all duration-300">
                                    <i class="fa-solid fa-phone text-xl"></i>
                                </div>
                                <div>
                                    <h4 class="text-xs font-black text-gray-400 uppercase tracking-widest mb-1">Call Us</h4>
                                    <a href="tel:+256200957522" class="text-gray-900 font-bold block hover:text-primary transition-colors">+256-200-957-522</a>
                                    <p class="text-cool-gray text-sm">Mon - Fri, 8:00 AM - 6:00 PM</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Social Card - Light Version -->
                    <div class="bg-white p-8 md:p-10 rounded-[40px] shadow-2xl shadow-gray-200/40 border border-emerald-100/50 relative overflow-hidden group">
                        <div class="absolute bottom-0 right-0 w-32 h-32 bg-primary/5 rounded-full -mr-16 -mb-16 blur-2xl"></div>
                        
                        <h4 class="font-black text-lg text-gray-900 mb-8 relative">Join the community</h4>
                        <div class="grid grid-cols-3 gap-4 relative">
                            <a href="https://www.facebook.com/yilickapp" target="_blank" class="w-full aspect-square rounded-2xl bg-gray-50 flex items-center justify-center hover:bg-blue-600 hover:text-white text-gray-400 transition-all duration-300 group/social">
                                <i class="fa-brands fa-facebook-f text-xl transition-transform group-hover/social:scale-110"></i>
                            </a>
                            <a href="https://twitter.com/yilickapp" target="_blank" class="w-full aspect-square rounded-2xl bg-gray-50 flex items-center justify-center hover:bg-sky-500 hover:text-white text-gray-400 transition-all duration-300 group/social">
                                <i class="fa-brands fa-twitter text-xl transition-transform group-hover/social:scale-110"></i>
                            </a>
                            <a href="https://www.instagram.com/yilickapp" target="_blank" class="w-full aspect-square rounded-2xl bg-gray-50 flex items-center justify-center hover:bg-pink-600 hover:text-white text-gray-400 transition-all duration-300 group/social">
                                <i class="fa-brands fa-instagram text-xl transition-transform group-hover/social:scale-110"></i>
                            </a>
                            <a href="https://www.linkedin.com/company/yilickapp" target="_blank" class="w-full aspect-square rounded-2xl bg-gray-50 flex items-center justify-center hover:bg-blue-700 hover:text-white text-gray-400 transition-all duration-300 group/social">
                                <i class="fa-brands fa-linkedin-in text-xl transition-transform group-hover/social:scale-110"></i>
                            </a>
                            <a href="https://www.youtube.com/@yilick" target="_blank" class="w-full aspect-square rounded-2xl bg-gray-50 flex items-center justify-center hover:bg-red-600 hover:text-white text-gray-400 transition-all duration-300 group/social">
                                <i class="fa-brands fa-youtube text-xl transition-transform group-hover/social:scale-110"></i>
                            </a>
                            <a href="https://www.tiktok.com/@yilick.ug" target="_blank" class="w-full aspect-square rounded-2xl bg-gray-50 flex items-center justify-center hover:bg-black hover:text-white text-gray-400 transition-all duration-300 group/social">
                                <i class="fa-brands fa-tiktok text-xl transition-transform group-hover/social:scale-110"></i>
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Right Content: Form -->
                <div class="lg:col-span-7">
                    <div class="bg-white p-8 md:p-12 rounded-[48px] shadow-2xl shadow-gray-200/50 border border-gray-100 h-full">
                        <div class="mb-10">
                            <h3 class="text-3xl font-black text-gray-900 mb-2">Send a Message</h3>
                            <p class="text-cool-gray">We'll get back to you as soon as possible, usually within 24 hours.</p>
                        </div>
                        
                        <form action="<?php echo e(route('web.support.send')); ?>" method="POST" class="space-y-8">
                            <?php echo csrf_field(); ?>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                                <!-- Name Input -->
                                <div class="space-y-2 group">
                                    <label class="text-[10px] font-black text-gray-400 uppercase tracking-[0.2em] pl-1 group-focus-within:text-primary transition-colors">Your Name</label>
                                    <div class="relative">
                                        <input type="text" name="name" placeholder="John Doe" required 
                                            class="w-full px-6 py-5 rounded-3xl bg-gray-50 border-2 border-transparent focus:bg-white focus:border-primary/20 focus:ring-4 focus:ring-primary/5 outline-none transition-all placeholder:text-gray-300 font-medium text-gray-900">
                                    </div>
                                </div>

                                <!-- Email Input -->
                                <div class="space-y-2 group">
                                    <label class="text-[10px] font-black text-gray-400 uppercase tracking-[0.2em] pl-1 group-focus-within:text-primary transition-colors">Email Address</label>
                                    <div class="relative">
                                        <input type="email" name="email" placeholder="john@example.com" required 
                                            class="w-full px-6 py-5 rounded-3xl bg-gray-50 border-2 border-transparent focus:bg-white focus:border-primary/20 focus:ring-4 focus:ring-primary/5 outline-none transition-all placeholder:text-gray-300 font-medium text-gray-900">
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Subject Input -->
                            <div class="space-y-2 group">
                                <label class="text-[10px] font-black text-gray-400 uppercase tracking-[0.2em] pl-1 group-focus-within:text-primary transition-colors">Subject</label>
                                <div class="relative">
                                    <input type="text" name="subject" placeholder="How can we help?" required 
                                        class="w-full px-6 py-5 rounded-3xl bg-gray-50 border-2 border-transparent focus:bg-white focus:border-primary/20 focus:ring-4 focus:ring-primary/5 outline-none transition-all placeholder:text-gray-300 font-medium text-gray-900">
                                </div>
                            </div>

                            <!-- Message Input -->
                            <div class="space-y-2 group">
                                <label class="text-[10px] font-black text-gray-400 uppercase tracking-[0.2em] pl-1 group-focus-within:text-primary transition-colors">Your Message</label>
                                <div class="relative">
                                    <textarea name="message" rows="6" placeholder="Tell us more about your inquiry..." required 
                                        class="w-full px-6 py-5 rounded-3xl bg-gray-50 border-2 border-transparent focus:bg-white focus:border-primary/20 focus:ring-4 focus:ring-primary/5 outline-none transition-all placeholder:text-gray-300 font-medium text-gray-900 resize-none"></textarea>
                                </div>
                            </div>

                            <button type="submit" class="w-full py-6 bg-primary hover:bg-emerald-700 text-white font-black rounded-[2rem] shadow-2xl shadow-primary/30 transition-all hover:-translate-y-1 active:scale-[0.98] flex items-center justify-center gap-3 group">
                                <span>Send Message</span>
                                <i class="fa-solid fa-paper-plane text-sm transition-transform group-hover:translate-x-1 group-hover:-translate-y-1"></i>
                            </button>
                        </form>
                    </div>
                </div>

            </div>

            <!-- FAQ Redirection -->
            <div class="mt-20 p-12 bg-gray-50 rounded-[48px] border border-gray-100 flex flex-col md:flex-row items-center justify-between gap-8">
                <div class="text-center md:text-left">
                    <h3 class="text-2xl font-black text-gray-900 mb-2">Check our Help Center first</h3>
                    <p class="text-cool-gray">Browse common questions and guides to find instant answers.</p>
                </div>
                <div class="flex gap-4">
                    <a href="<?php echo e(route('web.help-center')); ?>" class="px-8 py-4 bg-white text-gray-900 font-bold rounded-2xl border border-gray-200 hover:bg-gray-100 transition-all">
                        Help Center
                    </a>
                    <a href="<?php echo e(route('web.faqs')); ?>" class="px-8 py-4 bg-primary text-white font-bold rounded-2xl hover:bg-emerald-700 transition-all shadow-lg shadow-primary/20">
                        View FAQs
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/contact.blade.php ENDPATH**/ ?>