<?php $__env->startSection('title', 'Business Members'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50 pb-20 font-sans selection:bg-primary/20">
    <div class="container mx-auto px-4 py-6 max-w-4xl">
        <!-- Header -->
        <div class="flex items-center mb-6">
            <a href="<?php echo e(route('web.settings')); ?>" class="mr-4 w-10 h-10 bg-white rounded-xl shadow-sm border border-gray-100 flex items-center justify-center text-gray-600 hover:text-primary hover:border-primary/20 transition-all">
                <i class="fa-solid fa-arrow-left"></i>
            </a>
            <h1 class="text-2xl font-bold text-gray-900">Manage Members</h1>
        </div>

        <!-- Success Message -->
        <?php if(session('success')): ?>
        <div class="mb-6 bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded-xl flex items-center gap-3">
            <i class="fa-solid fa-check-circle"></i>
            <?php echo e(session('success')); ?>

        </div>
        <?php endif; ?>

        <!-- Error Message -->
        <?php if($errors->any()): ?>
        <div class="mb-6 bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded-xl">
             <ul class="list-disc list-inside">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <?php endif; ?>

        <!-- Navigation Tabs -->
        <div class="flex gap-2 overflow-x-auto pb-4 mb-2 no-scrollbar">
            <a href="<?php echo e(route('web.business.edit')); ?>" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all border border-transparent text-gray-500 hover:bg-white hover:shadow-sm">
                Details
            </a>
            <a href="<?php echo e(route('web.business.links')); ?>" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all border border-transparent text-gray-500 hover:bg-white hover:shadow-sm">
                 Links
            </a>
            <a href="<?php echo e(route('web.business.branding')); ?>" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all border border-transparent text-gray-500 hover:bg-white hover:shadow-sm">
                 Branding
            </a>
            <a href="<?php echo e(route('web.business.number.edit', ['type' => 'phone'])); ?>" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all border border-transparent text-gray-500 hover:bg-white hover:shadow-sm">
                 Phone
            </a>
             <a href="<?php echo e(route('web.business.members')); ?>" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all bg-primary text-white shadow-lg shadow-primary/30">
                 Members
            </a>
        </div>


        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Main Content: Members List -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Invite Section (Owner Only) -->
                <?php if($business->owner_user_id == auth()->id()): ?>
                <div class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100">
                    <h2 class="text-lg font-bold text-gray-900 mb-4">Invite New Member</h2>
                    <form action="<?php echo e(route('web.business.members.invite')); ?>" method="POST" class="flex flex-col sm:flex-row gap-3">
                        <?php echo csrf_field(); ?>
                        <div class="flex-1">
                            <input type="email" name="email" placeholder="Enter email address" required
                                class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all text-sm">
                        </div>
                        <input type="hidden" name="role" value="manager">
                        <button type="submit" class="w-full sm:w-auto px-6 py-3 bg-primary text-white font-bold rounded-xl hover:bg-primary-dark transition-all shadow-lg shadow-primary/20 flex-shrink-0">
                            Invite
                        </button>
                    </form>
                </div>
                <?php endif; ?>

                <!-- Active Members -->
                <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                    <div class="p-6 border-b border-gray-100 flex justify-between items-center">
                        <h2 class="text-lg font-bold text-gray-900">Active Members</h2>
                        <span class="bg-gray-100 text-gray-600 px-2.5 py-1 rounded-lg text-xs font-bold"><?php echo e($members->count()); ?></span>
                    </div>
                    <div class="divide-y divide-gray-100">
                        <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="p-6 flex flex-col sm:flex-row sm:items-center justify-between gap-4">
                            <div class="flex items-center gap-4">
                                <div class="w-12 h-12 rounded-full bg-gradient-to-br from-gray-100 to-gray-200 flex items-center justify-center text-gray-600 font-bold text-lg shadow-inner">
                                    <?php echo e(substr($member->name ?? $member->email, 0, 1)); ?>

                                </div>
                                <div>
                                    <div class="font-bold text-gray-900"><?php echo e($member->name ?? 'User'); ?></div>
                                    <div class="text-xs text-gray-500"><?php echo e($member->email); ?></div>
                                    <div class="text-[10px] text-gray-400 mt-0.5">Joined <?php echo e($member->joined_at ? $member->joined_at->format('M d, Y') : 'N/A'); ?></div>
                                </div>
                            </div>
                            <div class="flex items-center gap-3 self-end sm:self-auto">
                                <span class="px-3 py-1 rounded-full text-xs font-bold capitalize border
                                    <?php echo e($member->role === 'owner' ? 'bg-purple-50 text-purple-700 border-purple-100' : 'bg-blue-50 text-blue-700 border-blue-100'); ?>">
                                    <?php echo e($member->role); ?>

                                </span>
                                
                                <?php if($business->owner_user_id == auth()->id() && $member->role !== 'owner' && $member->id !== auth()->id()): ?>
                                <div class="flex items-center gap-1">
                                    <form action="<?php echo e(route('web.business.members.remove', $member->id)); ?>" method="POST" onsubmit="return confirm('Revoke access for this member?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="px-3 py-1.5 text-xs font-bold text-red-600 bg-red-50 hover:bg-red-100 rounded-lg transition-colors">
                                            Revoke
                                        </button>
                                    </form>
                                </div>
                                <?php endif; ?>

                                <?php if($member->id === auth()->id() && $business->owner_user_id != auth()->id()): ?>
                                <form action="<?php echo e(route('web.business.members.remove', $member->id)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to leave this business?');">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="px-3 py-1.5 text-xs font-bold text-red-600 bg-red-50 hover:bg-red-100 rounded-lg transition-colors">
                                        Leave Business
                                    </button>
                                </form>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <!-- Pending Invitations -->
                <?php if($invitations->count() > 0): ?>
                <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                    <div class="p-6 border-b border-gray-100 flex justify-between items-center">
                        <h2 class="text-lg font-bold text-gray-900">Pending Invitations</h2>
                        <span class="bg-orange-100 text-orange-600 px-2.5 py-1 rounded-lg text-xs font-bold"><?php echo e($invitations->count()); ?></span>
                    </div>
                    <div class="divide-y divide-gray-100">
                        <?php $__currentLoopData = $invitations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invite): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="p-6 flex flex-col sm:flex-row sm:items-center justify-between gap-4">
                            <div class="flex items-center gap-4">
                                <div class="w-10 h-10 rounded-full bg-orange-50 flex items-center justify-center text-orange-500 font-bold">
                                    <i class="fa-regular fa-envelope"></i>
                                </div>
                                <div>
                                    <div class="font-bold text-gray-900"><?php echo e($invite->email); ?></div>
                                    <div class="flex items-center gap-2 mt-1">
                                        <span class="text-xs font-medium text-gray-500 bg-gray-100 px-2 py-0.5 rounded capitalize"><?php echo e($invite->role); ?></span>
                                        <span class="text-[10px] text-gray-400">• Expires <?php echo e($invite->expires_at->diffForHumans()); ?></span>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="flex items-center gap-3">
                                <span class="px-3 py-1 rounded-full text-xs font-bold bg-yellow-50 text-yellow-600 border border-yellow-100">
                                    <i class="fa-solid fa-clock mr-1"></i> Pending
                                </span>
                                
                                <?php if($business->owner_user_id == auth()->id()): ?>
                                <form action="<?php echo e(route('web.business.invitations.revoke', $invite->id)); ?>" method="POST" onsubmit="return confirm('Revoke this invitation?');">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="px-3 py-1.5 text-xs font-bold text-red-600 bg-red-50 hover:bg-red-100 rounded-lg transition-colors">
                                        Revoke
                                    </button>
                                </form>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>

            <!-- Sidebar: Ownership -->
            <?php if((int)$business->owner_user_id === (int)Auth::id()): ?>
            <div class="space-y-6">
                <div class="bg-red-50 rounded-2xl p-6 border border-red-100">
                    <h3 class="font-bold text-red-900 mb-2">Danger Zone</h3>
                    <p class="text-xs text-red-700 mb-4 leading-relaxed">
                        Transferring ownership is irreversible appropriately. You will lose owner privileges and become a manager.
                    </p>
                    
                    <form action="<?php echo e(route('web.business.transfer-ownership')); ?>" method="POST" onsubmit="return confirm('WARNING: You are about to transfer ownership of this business. This action cannot be undone. Are you sure?');">
                        <?php echo csrf_field(); ?>
                        <label class="block text-xs font-bold text-red-800 mb-2">New Owner Email</label>
                        <input type="email" name="new_owner_email" required
                            class="w-full px-3 py-2 bg-white border border-red-200 rounded-lg focus:ring-2 focus:ring-red-500/20 focus:border-red-500 transition-all text-sm mb-3">
                        <button type="submit" class="w-full py-2.5 bg-red-600 hover:bg-red-700 text-white rounded-lg font-bold text-sm shadow-md shadow-red-500/20 transition-all">
                            Transfer Ownership
                        </button>
                    </form>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/business/members.blade.php ENDPATH**/ ?>