<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Notice</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background-color: #f3f4f6;
            color: #111827;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: #ffffff;
        }
        .header {
            background: #10b981;
            padding: 28px 24px;
            color: #ffffff;
            text-align: left;
        }
        .header h1 {
            margin: 0;
            font-size: 20px;
            font-weight: 700;
        }
        .content {
            padding: 24px;
        }
        .card {
            background: #f9fafb;
            border: 1px solid #e5e7eb;
            border-radius: 12px;
            padding: 16px;
        }
        .row {
            display: flex;
            gap: 12px;
            padding: 10px 0;
            border-bottom: 1px solid #e5e7eb;
        }
        .row:last-child {
            border-bottom: none;
        }
        .label {
            width: 140px;
            font-size: 13px;
            color: #6b7280;
            font-weight: 600;
            flex-shrink: 0;
        }
        .value {
            font-size: 14px;
            color: #111827;
            word-break: break-word;
        }
        .hint {
            margin-top: 16px;
            font-size: 14px;
            color: #374151;
            line-height: 1.6;
        }
        .btn {
            display: inline-block;
            margin-top: 18px;
            background: #10b981;
            color: #ffffff !important;
            padding: 12px 16px;
            border-radius: 10px;
            text-decoration: none;
            font-weight: 600;
            font-size: 14px;
        }
        .btn:hover {
            background: #059669;
        }
        .footer {
            padding: 18px 24px;
            font-size: 12px;
            color: #6b7280;
        }
        .mono {
            font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, 'Liberation Mono', 'Courier New', monospace;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>New login to <?php echo e(config('app.name')); ?></h1>
        </div>

        <div class="content">
            <p style="margin: 0 0 14px 0; font-size: 14px; color: #374151; line-height: 1.6;">
                Hi <?php echo e($user->full_name); ?>,
                we noticed a successful login to your account.
            </p>

            <div class="card">
                <div class="row">
                    <div class="label">Account</div>
                    <div class="value"><?php echo e($user->email); ?></div>
                </div>
                <div class="row">
                    <div class="label">Time</div>
                    <div class="value"><?php echo e(optional($session->logged_in_at)->toDayDateTimeString()); ?></div>
                </div>
                <div class="row">
                    <div class="label">IP Address</div>
                    <div class="value mono"><?php echo e($session->ip_address); ?></div>
                </div>
                <div class="row">
                    <div class="label">Device</div>
                    <div class="value"><?php echo e($session->user_agent); ?></div>
                </div>
            </div>

            <p class="hint">
                If this was you, no action is required.
                If you don’t recognize this login, we recommend changing your password immediately.
            </p>

            <a class="btn" href="<?php echo e(rtrim(config('app.url'), '/')); ?>/account/security">Review Account Security</a>
        </div>

        <div class="footer">
            This message was sent to <span class="mono"><?php echo e($user->email); ?></span>.
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/yilickapp/website/resources/views/emails/login-notice.blade.php ENDPATH**/ ?>