<?php $__env->startSection('title', 'Terms of Use & EULA - Yilick'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-gray-50 min-h-screen pt-20 pb-20">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto">
            <!-- Header -->
            <div class="text-center mb-12">
                <h1 class="text-4xl font-black text-charcoal-gray mb-4">Terms of Use & End User License Agreement (EULA)</h1>
                <p class="text-cool-gray font-bold uppercase tracking-widest text-sm">Last Updated: 7th January 2026</p>
                <div class="w-20 h-1.5 bg-primary rounded-full mx-auto mt-6"></div>
            </div>

            <!-- Content Card -->
            <div class="bg-white rounded-[32px] shadow-sm border border-gray-100 p-8 md:p-12 prose prose-emerald max-w-none">
                <p class="lead text-lg text-cool-gray font-medium">Welcome to Yilick. These Terms of Use and End User License Agreement (“Terms”, “Agreement”) govern your access to and use of the Yilick mobile application, website, and related services (collectively, the “Platform”).</p>
                
                <p>By creating an account, accessing, or using Yilick, you agree to be bound by these Terms. If you do not agree, you must not use the Platform.</p>

                <div class="space-y-12 mt-12">
                    <section>
                        <h3 class="text-2xl font-black text-charcoal-gray mb-4 flex items-center gap-3">
                            <span class="w-8 h-8 rounded-lg bg-primary/10 text-primary flex items-center justify-center text-sm">01</span>
                            About Yilick
                        </h3>
                        <div class="pl-11 text-gray-600">
                            <p>Yilick is an AI-powered classified marketplace and business-management platform that enables users to:</p>
                            <ul class="list-disc pl-5 space-y-2 mt-4">
                                <li>Post and browse classified listings</li>
                                <li>Buy and sell goods and services</li>
                                <li>Manage business operations such as inventory, POS, and analytics</li>
                            </ul>
                            <p class="mt-4 font-medium text-gray-800">Yilick acts as a technology platform only and is not a party to transactions between users.</p>
                        </div>
                    </section>

                    <section>
                        <h3 class="text-2xl font-black text-charcoal-gray mb-4 flex items-center gap-3">
                            <span class="w-8 h-8 rounded-lg bg-primary/10 text-primary flex items-center justify-center text-sm">02</span>
                            Eligibility
                        </h3>
                        <div class="pl-11 text-gray-600">
                            <p>You must:</p>
                            <ul class="list-disc pl-5 space-y-2 mt-4">
                                <li>Be at least 18 years old, or the legal age of majority in your country</li>
                                <li>Provide accurate and truthful information when creating an account</li>
                                <li>Use the Platform in compliance with applicable laws and regulations</li>
                            </ul>
                            <p class="mt-4 text-red-600 font-medium">We reserve the right to suspend or terminate accounts that do not meet these requirements.</p>
                        </div>
                    </section>

                    <section>
                        <h3 class="text-2xl font-black text-charcoal-gray mb-4 flex items-center gap-3">
                            <span class="w-8 h-8 rounded-lg bg-primary/10 text-primary flex items-center justify-center text-sm">03</span>
                            Account Registration & Security
                        </h3>
                        <div class="pl-11 text-gray-600">
                            <ul class="list-disc pl-5 space-y-2">
                                <li>You are responsible for maintaining the confidentiality of your account credentials</li>
                                <li>You are responsible for all activities performed under your account</li>
                                <li>You must notify us immediately of any unauthorized access or security breach</li>
                            </ul>
                        </div>
                    </section>

                    <section>
                        <h3 class="text-2xl font-black text-charcoal-gray mb-4 flex items-center gap-3">
                            <span class="w-8 h-8 rounded-lg bg-primary/10 text-primary flex items-center justify-center text-sm">04</span>
                            User-Generated Content
                        </h3>
                        <div class="pl-11 text-gray-600">
                            <p>Yilick allows users to post content, including listings, images, descriptions, messages, and other materials (“User Content”).</p>
                            <p class="mt-4">You agree that you will <strong>NOT</strong> post, upload, share, or distribute any content that:</p>
                            <ul class="list-disc pl-5 space-y-2 mt-4">
                                <li>Is illegal, fraudulent, or misleading</li>
                                <li>Promotes scams, financial fraud, or pyramid schemes</li>
                                <li>Contains hate speech, harassment, or abusive language</li>
                                <li>Is sexually explicit, pornographic, or exploitative</li>
                                <li>Promotes violence, self-harm, or criminal activity</li>
                                <li>Infringes intellectual property rights</li>
                                <li>Violates any applicable law or regulation</li>
                            </ul>
                            <div class="bg-red-50 border-l-4 border-red-500 p-4 mt-6 rounded-r-lg">
                                <p class="text-red-700 font-bold flex items-center gap-2">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"></path></svg>
                                    Zero tolerance applies to objectionable or abusive content.
                                </p>
                            </div>
                        </div>
                    </section>

                    <section>
                        <h3 class="text-2xl font-black text-charcoal-gray mb-4 flex items-center gap-3">
                            <span class="w-8 h-8 rounded-lg bg-primary/10 text-primary flex items-center justify-center text-sm">05</span>
                            Content Moderation & Enforcement
                        </h3>
                        <div class="pl-11 text-gray-600 space-y-6">
                            <p>To maintain a safe platform, Yilick implements the following safeguards:</p>
                            
                            <div>
                                <h4 class="font-bold text-gray-900 mb-2">a) Content Filtering</h4>
                                <p>We apply automated and manual measures to detect and restrict objectionable content, including keyword filtering and review systems.</p>
                            </div>

                            <div>
                                <h4 class="font-bold text-gray-900 mb-2">b) Reporting Mechanism</h4>
                                <p>Users may report content or users they believe violate these Terms. All reports are reviewed by our moderation team.</p>
                            </div>

                            <div>
                                <h4 class="font-bold text-gray-900 mb-2">c) Blocking Users</h4>
                                <p>Users may block other users at any time. Blocking:</p>
                                <ul class="list-disc pl-5 space-y-1 mt-2">
                                    <li>Immediately removes the blocked user’s content from the user’s view</li>
                                    <li>Prevents further interaction</li>
                                    <li>Notifies our moderation team for review</li>
                                </ul>
                            </div>

                            <div>
                                <h4 class="font-bold text-gray-900 mb-2">d) Enforcement Actions</h4>
                                <p>We may, at our sole discretion:</p>
                                <ul class="list-disc pl-5 space-y-1 mt-2">
                                    <li>Remove content</li>
                                    <li>Suspend or terminate accounts</li>
                                    <li>Restrict access to platform features</li>
                                </ul>
                            </div>

                            <p class="flex items-center gap-2 text-sm text-gray-500 italic bg-gray-50 p-2 rounded">
                                <span>⏱️</span> Reported content is reviewed and acted upon within 24 hours.
                            </p>
                        </div>
                    </section>

                    <section>
                        <h3 class="text-2xl font-black text-charcoal-gray mb-4 flex items-center gap-3">
                            <span class="w-8 h-8 rounded-lg bg-primary/10 text-primary flex items-center justify-center text-sm">06</span>
                            Listings, Transactions & Responsibility
                        </h3>
                        <div class="pl-11 text-gray-600">
                            <ul class="list-disc pl-5 space-y-2">
                                <li>Yilick does not own, inspect, or guarantee listed items</li>
                                <li>Buyers and sellers are solely responsible for transactions</li>
                                <li>Yilick does not guarantee payment, delivery, or quality of goods/services</li>
                                <li>Users must resolve disputes directly between themselves</li>
                            </ul>
                        </div>
                    </section>

                    <section>
                        <h3 class="text-2xl font-black text-charcoal-gray mb-4 flex items-center gap-3">
                            <span class="w-8 h-8 rounded-lg bg-primary/10 text-primary flex items-center justify-center text-sm">07</span>
                            Fees & Payments
                        </h3>
                        <div class="pl-11 text-gray-600">
                            <p>Some features (such as POS or premium tools) may involve fees.</p>
                            <p>All applicable fees will be disclosed before use.</p>
                            <p class="mt-2 text-gray-800 font-medium">Yilick does not process payments for classified listings unless explicitly stated.</p>
                        </div>
                    </section>

                    <section>
                        <h3 class="text-2xl font-black text-charcoal-gray mb-4 flex items-center gap-3">
                            <span class="w-8 h-8 rounded-lg bg-primary/10 text-primary flex items-center justify-center text-sm">08</span>
                            Prohibited Activities
                        </h3>
                        <div class="pl-11 text-gray-600">
                            <p>You agree not to:</p>
                            <ul class="list-disc pl-5 space-y-2 mt-4">
                                <li>Use the Platform for unlawful purposes</li>
                                <li>Attempt to bypass security or moderation systems</li>
                                <li>Scrape, copy, or reverse-engineer the Platform</li>
                                <li>Impersonate another person or entity</li>
                                <li>Use the Platform to distribute malware or spam</li>
                            </ul>
                        </div>
                    </section>

                    <section>
                        <h3 class="text-2xl font-black text-charcoal-gray mb-4 flex items-center gap-3">
                            <span class="w-8 h-8 rounded-lg bg-primary/10 text-primary flex items-center justify-center text-sm">09</span>
                            Intellectual Property
                        </h3>
                        <div class="pl-11 text-gray-600">
                            <p>Yilick and all related trademarks, logos, software, and content are owned by Yilick or its licensors</p>
                            <p class="mt-2">You may not copy, modify, or distribute any part of the Platform without permission</p>
                        </div>
                    </section>

                    <section>
                        <h3 class="text-2xl font-black text-charcoal-gray mb-4 flex items-center gap-3">
                            <span class="w-8 h-8 rounded-lg bg-primary/10 text-primary flex items-center justify-center text-sm">10</span>
                            Privacy
                        </h3>
                        <div class="pl-11 text-gray-600">
                            <p>Your use of Yilick is also governed by our Privacy Policy, which explains how we collect, use, and protect your data.</p>
                        </div>
                    </section>

                    <section>
                        <h3 class="text-2xl font-black text-charcoal-gray mb-4 flex items-center gap-3">
                            <span class="w-8 h-8 rounded-lg bg-primary/10 text-primary flex items-center justify-center text-sm">11</span>
                            Termination
                        </h3>
                        <div class="pl-11 text-gray-600">
                            <p>We may suspend or terminate your account at any time if you:</p>
                            <ul class="list-disc pl-5 space-y-2 mt-2">
                                <li>Violate these Terms</li>
                                <li>Engage in abusive or illegal behavior</li>
                                <li>Post objectionable content</li>
                            </ul>
                            <p class="mt-4">You may stop using the Platform at any time.</p>
                        </div>
                    </section>

                    <section>
                        <h3 class="text-2xl font-black text-charcoal-gray mb-4 flex items-center gap-3">
                            <span class="w-8 h-8 rounded-lg bg-primary/10 text-primary flex items-center justify-center text-sm">12</span>
                            Disclaimer & Limitation of Liability
                        </h3>
                        <div class="pl-11 text-gray-600">
                            <p>Yilick is provided “as is” and “as available.”</p>
                            <p class="mt-4 font-medium">To the maximum extent permitted by law:</p>
                            <ul class="list-disc pl-5 space-y-2 mt-2">
                                <li>We disclaim all warranties</li>
                                <li>We are not liable for indirect, incidental, or consequential damages</li>
                                <li>We are not responsible for user conduct or transactions</li>
                            </ul>
                        </div>
                    </section>

                    <section>
                        <h3 class="text-2xl font-black text-charcoal-gray mb-4 flex items-center gap-3">
                            <span class="w-8 h-8 rounded-lg bg-primary/10 text-primary flex items-center justify-center text-sm">13</span>
                            Changes to These Terms
                        </h3>
                        <div class="pl-11 text-gray-600">
                            <p>We may update these Terms from time to time.</p>
                            <p>Continued use of Yilick after changes means you accept the updated Terms.</p>
                        </div>
                    </section>

                    <section>
                        <h3 class="text-2xl font-black text-charcoal-gray mb-4 flex items-center gap-3">
                            <span class="w-8 h-8 rounded-lg bg-primary/10 text-primary flex items-center justify-center text-sm">14</span>
                            Contact Information
                        </h3>
                        <div class="pl-11 text-gray-600">
                            <p>If you have questions or concerns, contact us at:</p>
                            <div class="mt-4 bg-gray-50 p-6 rounded-2xl border border-gray-100 inline-block">
                                <p class="mb-2"><strong>Email:</strong> <a href="mailto:support@yilick.ug" class="text-primary hover:underline">support@yilick.ug</a></p>
                                <p class="mb-1"><strong>Company:</strong> Yilick</p>
                                <p><strong>Country:</strong> Uganda</p>
                            </div>
                        </div>
                    </section>
                </div>
            </div>

            <!-- Footer Note -->
            <div class="mt-12 text-center text-cool-gray text-sm">
                <p>&copy; <?php echo e(date('Y')); ?> Yilick. All rights reserved.</p>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/terms.blade.php ENDPATH**/ ?>