<?php $__env->startSection('title', 'How to Buy - Yilick'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-gray-50 min-h-screen pb-20">
    <!-- Header -->
    <div class="bg-white border-b border-gray-100 pt-8 pb-8 sticky top-0 md:static z-30">
        <div class="container mx-auto px-4">
            <div class="max-w-4xl mx-auto flex items-center gap-4">
                <a href="<?php echo e(route('web.help-center')); ?>" class="w-10 h-10 rounded-xl bg-gray-50 flex items-center justify-center text-cool-gray hover:text-primary transition-colors">
                    <i class="fa-solid fa-chevron-left"></i>
                </a>
                <h1 class="text-xl font-black text-charcoal-gray tracking-tight">How to Buy on Yilick</h1>
            </div>
        </div>
    </div>

    <div class="container mx-auto px-4 mt-12">
        <div class="max-w-3xl mx-auto">
            <!-- Hero Card -->
            <div class="bg-emerald-600 rounded-[32px] p-8 md:p-12 text-white mb-12 relative overflow-hidden shadow-2xl shadow-emerald-200">
                <div class="absolute top-0 right-0 w-64 h-64 bg-white/10 rounded-full -mr-20 -mt-20 blur-3xl"></div>
                <div class="relative z-10">
                    <div class="w-16 h-16 rounded-2xl bg-white/20 backdrop-blur-md flex items-center justify-center mb-8">
                        <i class="fa-solid fa-cart-shopping text-3xl"></i>
                    </div>
                    <h2 class="text-3xl md:text-4xl font-black mb-4">Finding your perfect match</h2>
                    <p class="text-white/80 text-lg leading-relaxed">Follow these simple steps to ensure a smooth and safe buying experience on Uganda's favorite marketplace.</p>
                </div>
            </div>

            <!-- Steps -->
            <div class="space-y-8 relative">
                <!-- Vertical Line -->
                <div class="absolute left-6 top-4 bottom-4 w-0.5 bg-gray-100 hidden md:block"></div>

                <?php
                    $steps = [
                        ['step' => 1, 'title' => 'Search and Discover', 'desc' => 'Use the search bar or browse categories to find what you need. filter by location and price to narrow your results.', 'icon' => 'fa-magnifying-glass', 'color' => 'emerald'],
                        ['step' => 2, 'title' => 'Check the Details', 'desc' => 'Read the description carefully and look at all photos. Check the seller\'s profile and ratings for gathered trust.', 'icon' => 'fa-eye', 'color' => 'emerald'],
                        ['step' => 3, 'title' => 'Contact the Seller', 'desc' => 'Use the build-in chat or call the seller directly to ask questions or verify item availability.', 'icon' => 'fa-comment-dots', 'color' => 'emerald'],
                        ['step' => 4, 'title' => 'Negotiate Fairly', 'desc' => 'Most sellers are open to reasonable offers. Discuss the price and agree on a meeting spot.', 'icon' => 'fa-handshake', 'color' => 'emerald'],
                        ['step' => 5, 'title' => 'Meet in Public', 'desc' => 'Always arrange meetings in safe, public places during daylight hours. Never go alone if possible.', 'icon' => 'fa-location-dot', 'color' => 'emerald'],
                        ['step' => 6, 'title' => 'Inspect the Item', 'desc' => 'Carefully check the item to ensure it matches the description and functions as expected before paying.', 'icon' => 'fa-clipboard-check', 'color' => 'emerald'],
                        ['step' => 7, 'title' => 'Complete the Transaction', 'desc' => 'Once satisfied, pay the agreed amount. We recommend mobile money or cash for physical meetups.', 'icon' => 'fa-circle-check', 'color' => 'emerald'],
                    ];
                ?>

                <?php $__currentLoopData = $steps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $step): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="relative flex flex-col md:flex-row gap-6 p-6 bg-white rounded-3xl border border-gray-100 shadow-sm hover:shadow-md transition-shadow">
                        <div class="flex-shrink-0 w-12 h-12 rounded-2xl bg-emerald-50 text-emerald-600 flex items-center justify-center font-black text-lg relative z-10 md:mt-2">
                            <?php echo e($step['step']); ?>

                        </div>
                        <div class="flex-1">
                            <div class="flex items-center gap-3 mb-2">
                                <i class="fa-solid <?php echo e($step['icon']); ?> text-emerald-400"></i>
                                <h3 class="font-bold text-xl text-charcoal-gray"><?php echo e($step['title']); ?></h3>
                            </div>
                            <p class="text-cool-gray leading-relaxed"><?php echo e($step['desc']); ?></p>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Safety Banner -->
            <div class="mt-16 bg-orange-50 border border-orange-100 rounded-3xl p-8 flex flex-col md:flex-row gap-6 items-center">
                <div class="w-16 h-16 rounded-full bg-orange-100 text-orange-600 flex items-center justify-center flex-shrink-0">
                    <i class="fa-solid fa-shield-heart text-3xl"></i>
                </div>
                <div>
                    <h3 class="text-xl font-black text-charcoal-gray mb-2">Safety First!</h3>
                    <p class="text-charcoal-gray/70 leading-relaxed">Never send money before seeing the item. If a deal sounds too good to be true, it probably is. Stay vigilant!</p>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/guides/how-to-buy.blade.php ENDPATH**/ ?>