<?php $__env->startSection('title', 'Business Branding'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50 pb-20 font-sans selection:bg-primary/20">
    <div class="container mx-auto px-4 py-6 max-w-2xl">
        <!-- Header -->
        <div class="flex items-center mb-6">
            <a href="<?php echo e(route('web.settings')); ?>" class="mr-4 w-10 h-10 bg-white rounded-xl shadow-sm border border-gray-100 flex items-center justify-center text-gray-600 hover:text-primary hover:border-primary/20 transition-all">
                <i class="fa-solid fa-arrow-left"></i>
            </a>
            <h1 class="text-2xl font-bold text-gray-900">Business Branding</h1>
        </div>

        <!-- Success Message -->
        <?php if(session('success')): ?>
        <div class="mb-6 bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded-xl flex items-center gap-3">
            <i class="fa-solid fa-check-circle"></i>
            <?php echo e(session('success')); ?>

        </div>
        <?php endif; ?>

        <!-- Error Message -->
        <?php if($errors->any()): ?>
        <div class="mb-6 bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded-xl">
             <ul class="list-disc list-inside">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <?php endif; ?>

        <!-- Navigation Tabs -->
        <div class="flex gap-2 overflow-x-auto pb-4 mb-2 no-scrollbar">
            <a href="<?php echo e(route('web.business.edit')); ?>" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all <?php echo e(Route::is('web.business.edit') ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'border border-transparent text-gray-500 hover:bg-white hover:shadow-sm'); ?>">
                Details
            </a>
            <a href="<?php echo e(route('web.business.links')); ?>" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all <?php echo e(Route::is('web.business.links') ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'border border-transparent text-gray-500 hover:bg-white hover:shadow-sm'); ?>">
                 Links
            </a>
            <a href="<?php echo e(route('web.business.branding')); ?>" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all <?php echo e(Route::is('web.business.branding') ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'border border-transparent text-gray-500 hover:bg-white hover:shadow-sm'); ?>">
                 Branding
            </a>
            <a href="<?php echo e(route('web.business.number.edit', ['type' => 'phone'])); ?>" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all <?php echo e(request()->route('type') == 'phone' ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'border border-transparent text-gray-500 hover:bg-white hover:shadow-sm'); ?>">
                 Phone
            </a>
             <a href="<?php echo e(route('web.business.members')); ?>" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all <?php echo e(Route::is('web.business.members') ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'border border-transparent text-gray-500 hover:bg-white hover:shadow-sm'); ?>">
                 Members
            </a>
        </div>

        <form action="<?php echo e(route('web.business.branding.update')); ?>" method="POST" enctype="multipart/form-data" class="space-y-6">
            <?php echo csrf_field(); ?>
            
            <!-- Info Box -->
            <div class="bg-primary/5 rounded-2xl p-4 border border-primary/10 flex gap-4 shadow-sm shadow-primary/5">
                <div class="w-10 h-10 rounded-full bg-primary flex-shrink-0 flex items-center justify-center text-white shadow-sm">
                    <i class="fa-solid fa-palette text-sm"></i>
                </div>
                <div class="text-xs font-medium text-gray-600 leading-relaxed">
                    Customize your business appearance with a logo, banner, and brand colors.
                </div>
            </div>

            <!-- Logo Upload -->
            <div class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100">
                <div class="flex items-center gap-3 mb-4">
                    <i class="fa-solid fa-image text-primary text-lg"></i>
                    <h2 class="text-base font-bold text-gray-900">Business Logo</h2>
                </div>

                <div class="flex flex-col items-center">
                    <div class="relative group cursor-pointer" onclick="document.getElementById('logo-input').click()">
                        <div class="w-32 h-32 rounded-2xl bg-gray-100 border-4 border-white shadow-lg overflow-hidden relative">
                            <?php if($business->logo): ?>
                                <img src="<?php echo e(asset('storage/' . $business->logo)); ?>" class="w-full h-full object-cover" id="logo-preview">
                            <?php else: ?>
                                <div class="w-full h-full flex items-center justify-center" id="logo-placeholder">
                                    <i class="fa-solid fa-image text-4xl text-gray-400"></i>
                                </div>
                            <?php endif; ?>
                            <div class="absolute inset-0 bg-black/40 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity">
                                <i class="fa-solid fa-camera text-white text-2xl"></i>
                            </div>
                        </div>
                        <div class="absolute bottom-0 right-0 w-10 h-10 bg-primary rounded-xl border-4 border-white shadow-md flex items-center justify-center text-white">
                            <i class="fa-solid fa-pen text-sm"></i>
                        </div>
                    </div>
                    <button type="button" onclick="document.getElementById('logo-input').click()" class="mt-4 text-sm font-bold text-primary hover:text-primary-dark transition-colors">
                        Change logo
                    </button>
                    <p class="mt-2 text-xs text-gray-500">Max size: 2MB</p>
                    <input type="file" id="logo-input" name="logo" class="hidden" accept="image/*" onchange="previewImage(this, 'logo-preview', 'logo-placeholder')">
                </div>
                <?php $__errorArgs = ['logo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-3 text-xs text-red-500 font-bold"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Banner Upload -->
            <div class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100">
                <div class="flex items-center gap-3 mb-4">
                    <i class="fa-solid fa-panorama text-primary text-lg"></i>
                    <h2 class="text-base font-bold text-gray-900">Business Banner</h2>
                </div>

                <div class="flex flex-col items-center">
                    <div class="relative group cursor-pointer w-full" onclick="document.getElementById('banner-input').click()">
                        <div class="w-full h-40 rounded-2xl bg-gray-100 border-4 border-white shadow-lg overflow-hidden relative">
                            <?php if($business->cover): ?>
                                <img src="<?php echo e(asset('storage/' . $business->cover)); ?>" class="w-full h-full object-cover" id="banner-preview">
                            <?php else: ?>
                                <div class="w-full h-full flex items-center justify-center" id="banner-placeholder">
                                    <i class="fa-solid fa-panorama text-4xl text-gray-400"></i>
                                </div>
                            <?php endif; ?>
                            <div class="absolute inset-0 bg-black/40 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity">
                                <i class="fa-solid fa-camera text-white text-2xl"></i>
                            </div>
                        </div>
                    </div>
                    <button type="button" onclick="document.getElementById('banner-input').click()" class="mt-4 text-sm font-bold text-primary hover:text-primary-dark transition-colors">
                        Change banner
                    </button>
                    <p class="mt-2 text-xs text-gray-500">Max size: 5MB • Recommended: 1200x400px</p>
                    <input type="file" id="banner-input" name="cover" class="hidden" accept="image/*" onchange="previewImage(this, 'banner-preview', 'banner-placeholder')">
                </div>
                <?php $__errorArgs = ['cover'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-3 text-xs text-red-500 font-bold"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Colors -->
            <div class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100 space-y-6">
                <!-- Primary Color -->
                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2">Primary Color</label>
                    <div class="flex items-center gap-3">
                        <input type="color" name="primary_color" value="<?php echo e(old('primary_color', $business->primary_color ?? '#10B981')); ?>"
                            class="w-16 h-16 rounded-xl border-2 border-gray-200 cursor-pointer">
                        <div class="flex-1">
                            <p class="text-sm text-gray-600">Main brand color used across your business profile</p>
                        </div>
                    </div>
                    <?php $__errorArgs = ['primary_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-xs text-red-500 font-bold"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Secondary Color -->
                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2">Secondary Color</label>
                    <div class="flex items-center gap-3">
                        <input type="color" name="secondary_color" value="<?php echo e(old('secondary_color', $business->secondary_color ?? '#F97316')); ?>"
                            class="w-16 h-16 rounded-xl border-2 border-gray-200 cursor-pointer">
                        <div class="flex-1">
                            <p class="text-sm text-gray-600">Accent color for highlights and accents</p>
                        </div>
                    </div>
                    <?php $__errorArgs = ['secondary_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-xs text-red-500 font-bold"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>


            <!-- Marketing Kit Preview Card -->
            <div class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100 overflow-hidden relative group">
                <div class="flex items-center justify-between mb-4">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 rounded-xl bg-primary/10 flex items-center justify-center text-primary font-bold">
                            <i class="fa-solid fa-magic"></i>
                        </div>
                        <h2 class="text-base font-bold text-gray-900">Shop Marketing Kit</h2>
                    </div>
                    <span class="text-[9px] font-black bg-emerald-50 text-emerald-600 px-2 py-0.5 rounded-full uppercase tracking-widest">New</span>
                </div>
                
                <p class="text-xs text-gray-500 mb-6 leading-relaxed">
                    Generate a professional "I sell on Yilick" poster to display in your physical shop and attract more customers.
                </p>

                <div class="grid grid-cols-2 gap-3">
                    <button type="button" 
                            onclick="openPosterModal()"
                            class="flex items-center justify-center gap-2 py-3 bg-gray-900 text-white rounded-xl font-bold text-xs hover:bg-black transition-all active:scale-95 shadow-md">
                        <i class="fa-solid fa-eye"></i>
                        Preview & Print
                    </button>
                    <button type="button" 
                            onclick="copyShopLink('<?php echo e(route('business.show', $business->slug)); ?>')"
                            class="flex items-center justify-center gap-2 py-3 bg-white text-gray-700 border border-gray-200 rounded-xl font-bold text-xs hover:border-primary hover:text-primary transition-all active:scale-95">
                        <i class="fa-solid fa-link"></i>
                        Store Link
                    </button>
                </div>
            </div>

            <!-- Submit Button -->

            <!-- Submit Button -->
            <button type="submit" class="w-full py-4 bg-primary hover:bg-primary-dark text-white rounded-xl font-bold text-base shadow-lg shadow-primary/20 transition-all transform active:scale-[0.98]">
                Update Business Branding
            </button>
        </form>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<!-- Poster Modal -->
<div id="poster-modal" class="fixed inset-0 z-[200] hidden">
    <div class="absolute inset-0 bg-black/80 backdrop-blur-sm" onclick="closePosterModal()"></div>
    <div class="absolute inset-0 flex items-center justify-center p-4 pointer-events-none">
        <div class="w-full max-w-lg pointer-events-auto animate-in zoom-in-95 duration-300">
            <!-- Modal Header (Close button only) -->
            <div class="flex justify-end mb-4">
                <button onclick="closePosterModal()" class="w-12 h-12 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center text-white transition-all shadow-lg">
                    <i class="fa-solid fa-xmark text-xl"></i>
                </button>
            </div>

            <!-- The Poster -->
            <div id="shop-poster-printable" class="aspect-[3/4] bg-gradient-to-br from-emerald-600 to-emerald-900 rounded-[2.5rem] p-10 text-white relative overflow-hidden shadow-2xl">
                <!-- Decorative background -->
                <div class="absolute -top-20 -right-20 w-80 h-80 bg-white/5 rounded-full blur-3xl"></div>
                <div class="absolute -bottom-20 -left-20 w-64 h-64 bg-white/5 rounded-full blur-2xl"></div>
                
                <div class="relative h-full flex flex-col items-center">
                    <!-- Yilick Badge -->
                    <div class="bg-white/10 backdrop-blur-md px-6 py-2 rounded-full border border-white/20 mb-10">
                        <span class="text-[11px] font-black uppercase tracking-[0.3em]">Official Seller</span>
                    </div>

                    <!-- Business Identity -->
                    <div class="flex flex-col items-center mb-10">
                        <div class="w-24 h-24 bg-white rounded-[2rem] p-1.5 shadow-2xl mb-6">
                            <div class="w-full h-full rounded-[1.6rem] overflow-hidden bg-white flex items-center justify-center">
                                <?php if($business->logo): ?>
                                    <img src="<?php echo e(asset('storage/' . $business->logo)); ?>" class="w-full h-full object-cover">
                                <?php else: ?>
                                    <span class="text-3xl font-black text-primary"><?php echo e(strtoupper(substr($business->name, 0, 1))); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <h3 class="text-3xl font-black tracking-tight text-center leading-tight mb-2"><?php echo e($business->name); ?></h3>
                        <div class="text-white/60 text-sm italic font-medium">Verified storefront on Yilick</div>
                    </div>

                    <!-- Message -->
                    <div class="text-center mb-10">
                        <p class="text-white font-black text-xl tracking-wide opacity-90 leading-tight">
                            I sell on <span class="text-emerald-300">Yilick</span><br>
                            <span class="text-sm font-bold opacity-60">Scan to browse our shop</span>
                        </p>
                    </div>

                    <!-- QR Code -->
                    <div class="mt-auto relative">
                        <div class="bg-white p-5 rounded-[2.5rem] shadow-2xl">
                            <img src="https://api.qrserver.com/v1/create-qr-code/?size=400x400&data=<?php echo e(urlencode(route('business.show', $business->slug))); ?>&color=065f46" 
                                 alt="QR Code" 
                                 class="w-32 h-32 object-contain">
                        </div>
                        <!-- Centered Icon in QR -->
                        <div class="absolute inset-0 flex items-center justify-center pointer-events-none">
                            <div class="w-6 h-6 bg-white rounded-lg flex items-center justify-center shadow-lg border-2 border-emerald-50">
                                <img src="/assets/icons/favicon.png" class="w-4 h-4 object-contain">
                            </div>
                        </div>
                    </div>

                    <!-- Footer -->
                    <div class="mt-12 flex items-center gap-3">
                        <img src="/assets/icons/logo.png" alt="Yilick" class="h-6 brightness-0 invert opacity-60">
                        <div class="h-4 w-[1px] bg-white/20"></div>
                        <span class="text-[10px] font-black text-white/40 tracking-widest uppercase">yilick.ug</span>
                    </div>
                </div>
            </div>

            <!-- Modal Footer (Actions) -->
            <div class="mt-8 grid grid-cols-2 gap-4">
                <button onclick="printPoster()" class="flex items-center justify-center gap-3 py-4 bg-white text-gray-900 rounded-2xl font-black text-sm hover:scale-105 transition-all shadow-xl active:scale-95">
                    <i class="fa-solid fa-print"></i>
                    Print Now
                </button>
                <a href="https://api.qrserver.com/v1/create-qr-code/?size=1000x1000&data=<?php echo e(urlencode(route('business.show', $business->slug))); ?>&color=065f46" 
                   target="_blank"
                   class="flex items-center justify-center gap-3 py-4 bg-primary text-white rounded-2xl font-black text-sm hover:scale-105 transition-all shadow-xl active:scale-95">
                    <i class="fa-solid fa-download"></i>
                    Download HD
                </a>
            </div>
        </div>
    </div>
</div>

<style>
    @media print {
        header, main, footer, nav, .fixed, .absolute, #app-launcher-modal { display: none !important; }
        #poster-modal { display: block !important; position: static !important; background: white !important; }
        #poster-modal > div:first-child { display: none !important; }
        #poster-modal > div:last-child { position: static !important; display: block !important; p: 0 !important; }
        #poster-modal .flex.justify-end { display: none !important; }
        #poster-modal .grid { display: none !important; }
        #shop-poster-printable { 
            position: fixed !important; 
            top: 0 !important; 
            left: 0 !important; 
            width: 100% !important; 
            height: 100% !important; 
            border-radius: 0 !important;
            margin: 0 !important;
            display: block !important;
            box-shadow: none !important;
            -webkit-print-color-adjust: exact !important; 
            print-color-adjust: exact !important;
        }
    }
</style>

<script>
    function openPosterModal() {
        document.getElementById('poster-modal').classList.remove('hidden');
        document.body.style.overflow = 'hidden';
    }

    function closePosterModal() {
        document.getElementById('poster-modal').classList.add('hidden');
        document.body.style.overflow = '';
    }

    function printPoster() {
        window.print();
    }

    function previewImage(input, previewId, placeholderId) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                const preview = document.getElementById(previewId);
                const placeholder = document.getElementById(placeholderId);
                
                if (preview) {
                    preview.src = e.target.result;
                } else if (placeholder) {
                    placeholder.innerHTML = `<img src="${e.target.result}" class="w-full h-full object-cover" id="${previewId}">`;
                }
            }
            reader.readAsDataURL(input.files[0]);
        }
    }

    function copyShopLink(link) {
        navigator.clipboard.writeText(link).then(() => {
            if (typeof showToast === 'function') {
                showToast('Shop link copied to clipboard!');
            } else {
                alert('Shop link copied to clipboard!');
            }
        });
    }
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/business/branding.blade.php ENDPATH**/ ?>