<?php $__env->startSection('title', $blogPost->title . ' - Yilick Journal'); ?>
<?php $__env->startSection('meta_description', $blogPost->excerpt); ?>
<?php $__env->startSection('meta_keywords', $blogPost->category . ', yilick journal, digital commerce uganda, ' . implode(', ', explode(' ', strtolower($blogPost->title)))); ?>

<?php $__env->startSection('header_meta'); ?>
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "Article",
    "headline": "<?php echo e($blogPost->title); ?>",
    "description": "<?php echo e($blogPost->excerpt); ?>",
    "author": {
        "@type": "Person",
        "name": "<?php echo e($blogPost->author); ?>"
    },
    "publisher": {
        "@type": "Organization",
        "name": "Yilick",
        "logo": {
            "@type": "ImageObject",
            "url": "<?php echo e(asset('assets/icons/logo.png')); ?>"
        }
    },
    "datePublished": "<?php echo e($blogPost->published_at->toIso8601String()); ?>",
    "dateModified": "<?php echo e($blogPost->updated_at->toIso8601String()); ?>",
    "mainEntityOfPage": {
        "@type": "WebPage",
        "@id": "<?php echo e(url()->current()); ?>"
    }
}
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white min-h-screen">
    <!-- Article Header -->
    <div class="relative pt-32 pb-20 overflow-hidden">
        <div class="absolute inset-0 bg-gray-50/50 -z-10"></div>
        <div class="container mx-auto px-4">
            <div class="max-w-4xl mx-auto">
                <nav class="flex items-center gap-2 text-sm font-bold text-cool-gray mb-8">
                    <a href="<?php echo e(route('web.blog')); ?>" class="hover:text-primary transition-colors">Blog</a>
                    <i class="fa-solid fa-chevron-right text-[10px]"></i>
                    <span class="text-gray-400 capitalize"><?php echo e($blogPost->category); ?></span>
                </nav>

                <h1 class="text-4xl md:text-6xl font-black text-gray-900 mb-8 leading-[1.1] tracking-tight">
                    <?php echo e($blogPost->title); ?>

                </h1>

                <div class="flex flex-wrap items-center gap-6 text-sm text-cool-gray font-bold">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 rounded-full bg-primary/10 flex items-center justify-center text-primary">
                            <i class="fa-solid fa-user-nib"></i>
                        </div>
                        <span class="text-gray-900"><?php echo e($blogPost->author); ?></span>
                    </div>
                    <div class="flex items-center gap-2">
                        <i class="fa-regular fa-calendar"></i>
                        <span><?php echo e($blogPost->published_at->format('M d, Y')); ?></span>
                    </div>
                    <div class="flex items-center gap-2">
                        <i class="fa-regular fa-clock"></i>
                        <span><?php echo e($blogPost->read_time); ?> min read</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Featured Image -->
    <div class="container mx-auto px-4 -mt-10">
        <div class="max-w-5xl mx-auto">
            <div class="aspect-[21/9] rounded-[48px] overflow-hidden shadow-2xl shadow-gray-200/50 border border-gray-100 bg-gray-50 relative group">
                <?php if($blogPost->featured_image): ?>
                    <img src="<?php echo e($blogPost->featured_image); ?>" class="w-full h-full object-cover" alt="<?php echo e($blogPost->title); ?>">
                <?php else: ?>
                    <div class="absolute inset-0 bg-primary/5 flex items-center justify-center">
                        <i class="fa-solid fa-newspaper text-7xl text-primary/10"></i>
                    </div>
                <?php endif; ?>
                <div class="absolute inset-0 bg-gradient-to-t from-black/20 to-transparent"></div>
            </div>
        </div>
    </div>

    <!-- Article Content -->
    <div class="container mx-auto px-4 py-20">
        <div class="max-w-3xl mx-auto">
            <div class="prose prose-lg prose-primary max-w-none">
                <p class="text-xl md:text-2xl text-cool-gray font-medium leading-relaxed mb-12 italic border-l-4 border-primary pl-8">
                    <?php echo e($blogPost->excerpt); ?>

                </p>
                
                <div class="text-gray-800 leading-[1.8] text-lg space-y-8 font-medium">
                    <?php echo nl2br(e($blogPost->content)); ?>

                </div>
            </div>

            <!-- Share & Navigation -->
            <div class="mt-20 pt-10 border-t border-gray-100 flex flex-col md:flex-row items-center justify-between gap-8">
                <div class="flex items-center gap-4">
                    <span class="text-sm font-black text-gray-400 uppercase tracking-widest">Share this</span>
                    <div class="flex gap-2">
                        <?php
                            $shareUrl = urlencode(request()->fullUrl());
                            $shareTitle = urlencode($blogPost->title);
                        ?>
                        <a href="https://twitter.com/intent/tweet?url=<?php echo e($shareUrl); ?>&text=<?php echo e($shareTitle); ?>" 
                           target="_blank"
                           class="w-10 h-10 rounded-full bg-blue-50 text-blue-600 flex items-center justify-center hover:bg-blue-600 hover:text-white transition-all">
                            <i class="fa-brands fa-twitter"></i>
                        </a>
                        <a href="https://www.linkedin.com/sharing/share-offsite/?url=<?php echo e($shareUrl); ?>" 
                           target="_blank"
                           class="w-10 h-10 rounded-full bg-indigo-50 text-indigo-600 flex items-center justify-center hover:bg-indigo-600 hover:text-white transition-all">
                            <i class="fa-brands fa-linkedin"></i>
                        </a>
                        <a href="https://api.whatsapp.com/send?text=<?php echo e($shareTitle); ?>%20<?php echo e($shareUrl); ?>" 
                           target="_blank"
                           class="w-10 h-10 rounded-full bg-green-50 text-green-600 flex items-center justify-center hover:bg-green-600 hover:text-white transition-all">
                            <i class="fa-brands fa-whatsapp"></i>
                        </a>
                    </div>
                </div>
                <a href="<?php echo e(route('web.blog')); ?>" class="flex items-center gap-3 px-8 py-4 rounded-full bg-gray-50 text-gray-900 font-black hover:bg-gray-100 transition-all border border-gray-100">
                    <i class="fa-solid fa-arrow-left"></i>
                    Back to Blog
                </a>
            </div>
        </div>
    </div>

    <!-- Related Posts -->
    <?php if($relatedPosts->count() > 0): ?>
    <div class="bg-gray-50 py-24">
        <div class="container mx-auto px-4">
            <div class="max-w-5xl mx-auto">
                <div class="flex items-center justify-between mb-12">
                    <h2 class="text-3xl font-black text-gray-900">Recommended <span class="text-primary italic">Reading</span></h2>
                    <a href="<?php echo e(route('web.blog', ['category' => $blogPost->category])); ?>" class="text-sm font-black text-primary hover:text-emerald-700 transition-colors uppercase tracking-widest flex items-center gap-2">
                        View more in <?php echo e($blogPost->category); ?>

                        <i class="fa-solid fa-arrow-right"></i>
                    </a>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                    <?php $__currentLoopData = $relatedPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('web.blog.show', $post->slug)); ?>" class="group">
                        <div class="aspect-video bg-white rounded-3xl mb-6 overflow-hidden border border-gray-100 relative shadow-sm group-hover:shadow-xl group-hover:shadow-gray-200/50 transition-all duration-500">
                            <?php if($post->featured_image): ?>
                                <img src="<?php echo e($post->featured_image); ?>" class="absolute inset-0 w-full h-full object-cover group-hover:scale-110 transition-transform duration-700" alt="<?php echo e($post->title); ?>">
                            <?php else: ?>
                                <div class="absolute inset-0 bg-primary/5 flex items-center justify-center">
                                    <i class="fa-solid fa-newspaper text-2xl text-primary/20"></i>
                                </div>
                            <?php endif; ?>
                        </div>
                        <h3 class="text-xl font-black text-gray-900 mb-3 leading-snug group-hover:text-primary transition-colors line-clamp-2"><?php echo e($post->title); ?></h3>
                        <p class="text-cool-gray text-sm font-bold"><?php echo e($post->published_at->format('M d, Y')); ?></p>
                    </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/blog-details.blade.php ENDPATH**/ ?>