<?php $__env->startSection('title', 'Cookie Policy - Yilick'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-gray-50 min-h-screen pt-20 pb-20">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto">
            <!-- Header -->
            <div class="text-center mb-12">
                <h1 class="text-4xl font-black text-charcoal-gray mb-4">Cookie Policy</h1>
                <p class="text-cool-gray">Last Updated: January 1, 2026</p>
                <div class="w-20 h-1.5 bg-primary rounded-full mx-auto mt-6"></div>
            </div>

            <!-- Content Card -->
            <div class="bg-white rounded-[32px] shadow-sm border border-gray-100 p-8 md:p-12 prose prose-emerald max-w-none">
                <p class="lead text-lg text-cool-gray">This Cookie Policy explains how Yilick uses cookies and similar technologies to recognize you when you visit our website. It explains what these technologies are and why we use them, as well as your rights to control our use of them.</p>

                <h3 class="text-2xl font-bold text-charcoal-gray mt-10 mb-4">1. What are Cookies?</h3>
                <p>Cookies are small data files that are placed on your computer or mobile device when you visit a website. Cookies are widely used by website owners in order to make their websites work, or to work more efficiently, as well as to provide reporting information.</p>

                <h3 class="text-2xl font-bold text-charcoal-gray mt-10 mb-4">2. Why do we use Cookies?</h3>
                <p>We use first-party and third-party cookies for several reasons. Some cookies are required for technical reasons in order for our Services to operate, and we refer to these as "essential" or "strictly necessary" cookies. Other cookies also enable us to track and target the interests of our users to enhance the experience on our Online Properties.</p>

                <h3 class="text-2xl font-bold text-charcoal-gray mt-10 mb-4">3. Types of Cookies we use</h3>
                <ul>
                    <li><strong>Essential Website Cookies:</strong> These cookies are strictly necessary to provide you with services available through our Website and to use some of its features.</li>
                    <li><strong>Performance and Functionality Cookies:</strong> These cookies are used to enhance the performance and functionality of our Website but are non-essential to their use.</li>
                    <li><strong>Analytics and Customization Cookies:</strong> These cookies collect information that is used either in aggregate form to help us understand how our Website is being used or how effective our marketing campaigns are.</li>
                </ul>

                <h3 class="text-2xl font-bold text-charcoal-gray mt-10 mb-4">4. How can I control Cookies?</h3>
                <p>You have the right to decide whether to accept or reject cookies. You can set or amend your web browser controls to accept or refuse cookies. If you choose to reject cookies, you may still use our website though your access to some functionality and areas of our website may be restricted.</p>

                <h3 class="text-2xl font-bold text-charcoal-gray mt-10 mb-4">5. Contact Us</h3>
                <p>If you have any questions about our use of cookies or other technologies, please contact us through the <a href="<?php echo e(route('web.help-center')); ?>" class="text-primary font-bold hover:underline">Help Center</a>.</p>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/cookie.blade.php ENDPATH**/ ?>