<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Welcome to <?php echo e(config('app.name')); ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: #1f2937;
            background-color: #f9fafb;
        }
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
        }
        .header {
            background: #10b981;
            padding: 40px 30px;
            text-align: center;
        }
        .header h1 {
            color: #ffffff;
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 10px;
        }
        .header p {
            color: #f0f0f0;
            font-size: 16px;
        }
        .content {
            padding: 40px 30px;
        }
        .greeting {
            font-size: 24px;
            font-weight: 600;
            color: #333333;
            margin-bottom: 20px;
        }
        .message {
            font-size: 16px;
            color: #555555;
            margin-bottom: 20px;
            line-height: 1.8;
        }
        .highlight-box {
            background-color: #ecfdf5;
            border-left: 4px solid #10b981;
            padding: 20px;
            margin: 30px 0;
            border-radius: 8px;
        }
        .highlight-box p {
            margin: 0;
            color: #555555;
            font-size: 15px;
        }
        .button-container {
            text-align: center;
            margin: 35px 0;
        }
        .verify-button {
            display: inline-block;
            padding: 16px 40px;
            background: #10b981;
            color: #ffffff !important;
            text-decoration: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            box-shadow: 0 2px 8px rgba(16, 185, 129, 0.3);
            transition: all 0.3s ease;
        }
        .verify-button:hover {
            background: #059669;
            box-shadow: 0 4px 12px rgba(16, 185, 129, 0.4);
            transform: translateY(-1px);
        }
        .features {
            margin: 30px 0;
        }
        .feature-item {
            display: flex;
            align-items: flex-start;
            margin-bottom: 20px;
        }
        .feature-icon {
            width: 40px;
            height: 40px;
            background: #10b981;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
            flex-shrink: 0;
        }
        .feature-icon::before {
            content: "✓";
            color: #ffffff;
            font-size: 20px;
            font-weight: bold;
        }
        .feature-text h3 {
            font-size: 16px;
            font-weight: 600;
            color: #333333;
            margin-bottom: 5px;
        }
        .feature-text p {
            font-size: 14px;
            color: #666666;
            margin: 0;
        }
        .divider {
            height: 1px;
            background-color: #e0e0e0;
            margin: 30px 0;
        }
        .footer {
            background-color: #f8f9fa;
            padding: 30px;
            text-align: center;
        }
        .footer p {
            font-size: 14px;
            color: #666666;
            margin-bottom: 10px;
        }
        .footer-links {
            margin-top: 20px;
        }
        .footer-links a {
            color: #10b981;
            text-decoration: none;
            margin: 0 10px;
            font-size: 14px;
        }
        .security-notice {
            background-color: #fff3cd;
            border: 1px solid #ffc107;
            border-radius: 4px;
            padding: 15px;
            margin: 20px 0;
        }
        .security-notice p {
            font-size: 14px;
            color: #856404;
            margin: 0;
        }
        @media only screen and (max-width: 600px) {
            .content {
                padding: 30px 20px;
            }
            .header {
                padding: 30px 20px;
            }
            .greeting {
                font-size: 20px;
            }
            .verify-button {
                padding: 14px 30px;
                font-size: 15px;
            }
        }
    </style>
</head>
<body>
    <div class="email-container">
        <!-- Header -->
        <div class="header">
            <h1>🎉 Welcome to <?php echo e(config('app.name')); ?>!</h1>
            <p>Your journey starts here</p>
        </div>

        <!-- Content -->
        <div class="content">
            <div class="greeting">
                Hello <?php echo e($user->full_name); ?>,
            </div>

            <p class="message">
                We're thrilled to have you join our community! Thank you for choosing <?php echo e(config('app.name')); ?> as your trusted platform for classified listings.
            </p>

            <p class="message">
                To ensure the security of your account and unlock all features, please verify your email address by clicking the button below:
            </p>

            <!-- Verify Button -->
            <div class="button-container">
                <a href="<?php echo e($verificationUrl); ?>" class="verify-button">
                    Verify Email Address
                </a>
            </div>

            <div class="highlight-box">
                <p><strong>⏰ Important:</strong> This verification link will expire in 60 minutes for security purposes.</p>
            </div>

            <!-- Features Section -->
            <div class="features">
                <h2 style="font-size: 20px; color: #333333; margin-bottom: 20px;">What you can do with <?php echo e(config('app.name')); ?>:</h2>
                
                <div class="feature-item">
                    <div class="feature-icon"></div>
                    <div class="feature-text">
                        <h3>Post Unlimited Listings</h3>
                        <p>Create and manage your classified ads with ease</p>
                    </div>
                </div>

                <div class="feature-item">
                    <div class="feature-icon"></div>
                    <div class="feature-text">
                        <h3>Connect with Buyers & Sellers</h3>
                        <p>Build your network and grow your business</p>
                    </div>
                </div>

                <div class="feature-item">
                    <div class="feature-icon"></div>
                    <div class="feature-text">
                        <h3>Secure Transactions</h3>
                        <p>Trade with confidence using our verified platform</p>
                    </div>
                </div>

                <div class="feature-item">
                    <div class="feature-icon"></div>
                    <div class="feature-text">
                        <h3>24/7 Support</h3>
                        <p>Our team is always here to help you succeed</p>
                    </div>
                </div>
            </div>

            <div class="divider"></div>

            <!-- Security Notice -->
            <div class="security-notice">
                <p><strong>🔒 Security Notice:</strong> If you did not create an account with <?php echo e(config('app.name')); ?>, please ignore this email. Your email address will not be used without verification.</p>
            </div>

            <p class="message" style="margin-top: 30px;">
                If the button above doesn't work, copy and paste this link into your browser:
            </p>
            <p style="font-size: 13px; color: #059669; word-break: break-all; background-color: #ecfdf5; padding: 12px; border-radius: 8px; border: 1px solid #d1fae5;">
                <?php echo e($verificationUrl); ?>

            </p>
        </div>

        <!-- Footer -->
        <div class="footer">
            <p style="font-weight: 600; color: #333333;">Need help getting started?</p>
            <p>Our support team is here to assist you every step of the way.</p>
            
            <div class="footer-links">
                <a href="<?php echo e(config('app.url')); ?>">Visit Website</a>
                <a href="<?php echo e(config('app.url')); ?>/help">Help Center</a>
                <a href="<?php echo e(config('app.url')); ?>/contact">Contact Us</a>
            </div>

            <div class="divider" style="margin: 20px 0;"></div>

            <p style="font-size: 12px; color: #999999;">
                © <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. All rights reserved.
            </p>
            <p style="font-size: 12px; color: #999999;">
                You're receiving this email because you registered for an account.
            </p>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/yilickapp/website/resources/views/emails/welcome.blade.php ENDPATH**/ ?>