<?php $__env->startSection('title', 'Edit Ad - Yilick'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-gray-50 min-h-screen py-8">
    <div class="container mx-auto px-4 max-w-3xl">
        
        <!-- Header -->
        <div class="mb-8 flex flex-col sm:flex-row sm:items-center justify-between gap-4">
            <div>
                <h1 class="text-3xl font-extrabold text-gray-900 tracking-tight">Edit Your Ad</h1>
                <p class="text-gray-500 text-sm mt-1 flex items-center gap-2">
                    <span class="w-2 h-2 rounded-full bg-emerald-500"></span>
                    Update your listing details to attract more buyers.
                </p>
            </div>
            <a href="<?php echo e(route('web.my-ads')); ?>" class="inline-flex items-center justify-center gap-2 px-6 py-2.5 rounded-xl border border-gray-200 bg-white text-gray-600 font-semibold text-sm hover:bg-gray-50 hover:border-gray-300 hover:text-gray-900 transition-all shadow-sm">
                <i class="fa-solid fa-arrow-left text-xs"></i>
                Back to My Ads
            </a>
        </div>

        <form action="<?php echo e(route('listing.update', $listing->id)); ?>" method="POST" enctype="multipart/form-data" id="editAdForm" class="space-y-6">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            
            <!-- SECTION 1: Category & Photos -->
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                <div class="p-6 space-y-6">
                    <h2 class="text-lg font-bold text-gray-900 flex items-center gap-2">
                        <span class="flex items-center justify-center w-6 h-6 rounded-full bg-emerald-100 text-emerald-600 text-xs shadow-sm">1</span>
                        Category & Images
                    </h2>

                    <!-- Security Info Banner -->
                    <div class="bg-amber-50 border border-amber-200 rounded-xl p-4 flex items-start gap-3">
                        <div class="w-8 h-8 rounded-full bg-amber-100 flex items-center justify-center text-amber-600 shrink-0">
                            <i class="fa-solid fa-shield-halved text-sm"></i>
                        </div>
                        <div>
                            <p class="text-sm font-bold text-amber-800">Limited Editing</p>
                            <p class="text-xs text-amber-700">For security reasons, you can only edit the fields below. Category cannot be changed after posting.</p>
                        </div>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                        <div class="space-y-2">
                            <label class="text-sm font-bold text-gray-700 ml-1">Category</label>
                            <div class="relative group">
                                <i class="fa-solid fa-folder absolute left-4 top-1/2 -translate-y-1/2 text-gray-400"></i>
                                <input type="text" value="<?php echo e($listing->category); ?>" class="w-full rounded-2xl border-gray-200 bg-gray-100/50 text-gray-500 font-bold text-sm py-3.5 pl-11 pr-4 cursor-not-allowed border-dashed" readonly>
                            </div>
                        </div>

                        <?php if($listing->sub_category): ?>
                        <div class="space-y-2">
                            <label class="text-sm font-bold text-gray-700 ml-1">Sub Category</label>
                            <div class="relative group">
                                <i class="fa-solid fa-folder-tree absolute left-4 top-1/2 -translate-y-1/2 text-gray-400"></i>
                                <input type="text" value="<?php echo e($listing->sub_category); ?>" class="w-full rounded-2xl border-gray-200 bg-gray-100/50 text-gray-500 font-bold text-sm py-3.5 pl-11 pr-4 cursor-not-allowed border-dashed" readonly>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>

                    <!-- Hidden inputs to submit category values -->
                    <input type="hidden" name="category" value="<?php echo e($listing->category); ?>">
                    <input type="hidden" name="sub_category" value="<?php echo e($listing->sub_category); ?>">

                    <hr class="border-gray-100">

                    <!-- Photos -->
                    <div class="space-y-2">
                        <div class="flex items-center justify-between">
                            <label class="text-sm font-semibold text-gray-700">Photos *</label>
                            <span class="text-xs text-emerald-600 bg-emerald-50 px-2 py-0.5 rounded-full font-medium">First photo is cover</span>
                        </div>
                        
                        <div class="grid grid-cols-2 sm:grid-cols-4 gap-4" id="photo-grid">
                            <!-- Existing Photos -->
                            <?php $__currentLoopData = $listing->media; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div id="media-<?php echo e($media->id); ?>" class="photo-preview relative aspect-square rounded-2xl overflow-hidden group shadow-sm border border-gray-100 bg-gray-50">
                                    <img src="<?php echo e(Storage::disk('public')->url($media->path)); ?>" class="w-full h-full object-cover transition-opacity duration-300">
                                    <div class="absolute inset-0 bg-black/40 opacity-0 group-hover:opacity-100 transition-opacity flex items-center justify-center gap-2">
                                        <button type="button" onclick="deleteExistingMedia(<?php echo e($media->id); ?>)" class="w-8 h-8 rounded-full bg-white text-red-500 flex items-center justify-center hover:bg-red-50 hover:text-red-600 transition-colors shadow-lg">
                                            <i class="fa-solid fa-trash-can"></i>
                                        </button>
                                    </div>
                                    <?php if($media->is_primary): ?>
                                        <div class="cover-badge absolute top-2 left-2 px-2 py-0.5 rounded-md bg-primary text-white text-[10px] font-bold shadow-sm z-10">COVER</div>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <label id="add-photo-label" class="relative aspect-square rounded-2xl border-2 border-dashed border-gray-200 hover:border-primary hover:bg-primary/5 transition-all cursor-pointer group flex flex-col items-center justify-center gap-2">
                                <input type="file" multiple accept="image/*" class="absolute inset-0 opacity-0 cursor-pointer" onchange="handleFileSelect(this)">
                                <div class="w-12 h-12 rounded-full bg-gray-50 group-hover:bg-primary/10 flex items-center justify-center transition-colors">
                                    <i class="fa-solid fa-plus text-gray-400 group-hover:text-primary"></i>
                                </div>
                                <span class="text-xs font-bold text-gray-500 group-hover:text-primary">Add Photo</span>
                            </label>
                        </div>
                        <p class="text-xs text-gray-400">Supported formats: JPG, PNG, WEBP. Max size: 5MB per image.</p>
                    </div>
                </div>
            </div>

            <!-- SECTION 2: Item Details -->
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                <div class="p-6 space-y-6">
                    <h2 class="text-lg font-bold text-gray-900 flex items-center gap-2">
                        <span class="flex items-center justify-center w-6 h-6 rounded-full bg-emerald-100 text-emerald-600 text-xs shadow-sm">2</span>
                        Item Details
                    </h2>

                    <div class="space-y-5">
                        <div class="space-y-2">
                            <label class="text-sm font-bold text-gray-700 ml-1">Title *</label>
                            <div class="relative group">
                                <i class="fa-solid fa-tag absolute left-4 top-1/2 -translate-y-1/2 text-gray-400 group-focus-within:text-emerald-500 transition-colors"></i>
                                <input type="text" name="title" value="<?php echo e($listing->title); ?>" class="w-full rounded-2xl border-gray-200 bg-gray-50/50 focus:bg-white focus:border-emerald-500 focus:ring-4 focus:ring-emerald-500/10 transition-all py-3.5 pl-11 pr-4 text-sm font-medium placeholder:text-gray-400 outline-none" placeholder="e.g. Brand New iPhone 14 Pro Max 256GB" required minlength="5" maxlength="100">
                            </div>
                        </div>


                        <div class="space-y-2">
                            <label class="text-sm font-bold text-gray-700 ml-1">Description *</label>
                            <textarea name="description" rows="6" class="w-full rounded-2xl border-gray-200 bg-gray-50/50 focus:bg-white focus:border-emerald-500 focus:ring-4 focus:ring-emerald-500/10 transition-all py-3.5 px-4 text-sm font-medium placeholder:text-gray-400 outline-none resize-none" placeholder="Describe the condition, features, and reason for selling..." required minlength="20"><?php echo e($listing->description); ?></textarea>
                        </div>

                        <div class="space-y-2">
                            <label class="text-sm font-bold text-gray-700 ml-1">Location *</label>
                            <div class="relative group">
                                <i class="fa-solid fa-location-dot absolute left-4 top-1/2 -translate-y-1/2 text-gray-400 group-focus-within:text-emerald-500 transition-colors"></i>
                                <select id="location" name="location" class="w-full rounded-2xl border-gray-200 bg-gray-50/50 focus:bg-white focus:border-emerald-500 focus:ring-4 focus:ring-emerald-500/10 transition-all py-3.5 pl-11 pr-4 text-sm font-medium appearance-none outline-none" required>
                                    <option value="">Select District</option>
                                </select>
                                <i class="fa-solid fa-chevron-down absolute right-4 top-1/2 -translate-y-1/2 text-gray-400 pointer-events-none text-xs"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- SECTION 3: Price & Inventory -->
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                <div class="p-6 space-y-6">
                    <h2 class="text-lg font-bold text-gray-900 flex items-center gap-2">
                        <span class="flex items-center justify-center w-6 h-6 rounded-full bg-emerald-100 text-emerald-600 text-xs shadow-sm">3</span>
                        Pricing & Stock
                    </h2>

                    <div class="space-y-2">
                        <label class="text-sm font-bold text-gray-700 ml-1">Selling Price *</label>
                        <div class="relative group">
                            <span class="absolute left-5 top-1/2 -translate-y-1/2 text-gray-900 font-extrabold text-sm tracking-wide">UGX</span>
                            <input type="text" name="price" value="<?php echo e(number_format($listing->price_amount)); ?>" class="w-full rounded-2xl border-gray-200 bg-gray-50/50 focus:bg-white focus:border-emerald-500 focus:ring-4 focus:ring-emerald-500/10 transition-all py-4 pl-16 pr-4 font-extrabold text-2xl text-gray-900 price-input placeholder:text-gray-300 outline-none shadow-inner" required placeholder="0">
                        </div>
                    </div>

                    <div class="bg-gray-50 rounded-xl p-4 border border-gray-100 space-y-4">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center gap-2">
                                <div class="bg-blue-100 text-blue-600 p-2 rounded-lg">
                                    <i class="fa-solid fa-cash-register text-sm"></i>
                                </div>
                                <div title="Calculates profit automatically">
                                    <span class="text-sm font-bold text-gray-900 block">Stock Management</span>
                                    <span class="text-xs text-gray-500 font-bold">Track stock and calculate profit (Private)</span>
                                </div>
                            </div>
                            <label class="relative inline-flex items-center cursor-pointer">
                                <input type="checkbox" name="allow_pos" id="allowPosToggle" class="sr-only peer" onchange="toggleStockFields()" <?php echo e($listing->allow_pos ? 'checked' : ''); ?>>
                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-emerald-300 rounded-full peer peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-emerald-600"></div>
                            </label>
                        </div>

                        <div id="stockFields" class="<?php echo e($listing->allow_pos ? 'block' : 'hidden'); ?> pt-3 border-t border-gray-100 mt-3 animate-fade-in">
                            <div class="bg-emerald-50/50 border border-emerald-100 rounded-xl p-4 flex items-start gap-4 shadow-sm">
                                <div class="w-10 h-10 rounded-full bg-emerald-100/50 flex items-center justify-center text-emerald-600 shrink-0">
                                    <i class="fa-solid fa-mobile-screen-button"></i>
                                </div>
                                <div class="space-y-1">
                                    <p class="text-sm font-bold text-gray-900">App-Managed Inventory</p>
                                    <p class="text-xs text-gray-600 leading-relaxed">
                                        You can manage stock quantities, and record restocks via the <strong>Point of Sale (POS)</strong> tool within the <strong>Business Tools</strong> section of the Yilick app.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

             <!-- SECTION 4: Contact Info -->
             <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                <div class="p-4 bg-gray-50 border-b border-gray-100 flex items-center justify-between">
                    <h2 class="text-sm font-bold text-gray-700">Contact Information</h2>
                    <span class="text-xs text-gray-400"><i class="fa-solid fa-lock mr-1"></i>Secure</span>
                </div>
                <div class="p-6 grid grid-cols-1 md:grid-cols-2 gap-4">
                     <div class="space-y-2">
                         <label class="text-xs font-bold text-gray-400 uppercase tracking-widest ml-1">Contact Name</label>
                         <div class="relative group">
                            <i class="fa-regular fa-user absolute left-4 top-1/2 -translate-y-1/2 text-gray-400 group-focus-within:text-emerald-500 transition-colors"></i>
                            <input type="text" value="<?php echo e($business->name ?? auth()->user()->full_name); ?>" class="w-full rounded-2xl border-gray-200 bg-gray-100/50 text-gray-500 font-bold text-sm py-3.5 pl-11 pr-4 cursor-not-allowed border-dashed" readonly>
                         </div>
                    </div>
                     <div class="space-y-2">
                         <label class="text-xs font-bold text-gray-400 uppercase tracking-widest ml-1">Contact Phone</label>
                         <div class="relative group">
                            <i class="fa-solid fa-phone absolute left-4 top-1/2 -translate-y-1/2 text-gray-400 group-focus-within:text-emerald-500 transition-colors"></i>
                            <input type="text" value="<?php echo e($business->primary_phone ?? auth()->user()->phone); ?>" class="w-full rounded-2xl border-gray-200 bg-gray-100/50 text-gray-500 font-bold text-sm py-3.5 pl-11 pr-4 cursor-not-allowed border-dashed" readonly>
                         </div>
                    </div>
                </div>
            </div>

            <!-- Submit -->
            <div class="pt-8 pb-16">
                <button type="submit" class="w-full md:w-auto md:min-w-[400px] block mx-auto py-5 px-10 bg-emerald-600 text-white font-black rounded-2xl shadow-xl shadow-emerald-200 hover:bg-emerald-700 hover:shadow-emerald-300 hover:-translate-y-1 transition-all transform active:scale-95 text-xl flex items-center justify-center gap-3 group">
                    <span>Update Ad</span>
                    <i class="fa-solid fa-check-double group-hover:scale-110 transition-transform"></i>
                </button>
                <div class="flex flex-col items-center gap-2 mt-6">
                    <p class="text-center text-xs text-gray-400 max-w-sm">
                        Updating your ad will put it back in review status to ensure continued quality compliance.
                    </p>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Submission Overlay -->
<div id="submissionOverlay" class="fixed inset-0 z-[200] hidden opacity-0 transition-opacity duration-500 bg-white/80 backdrop-blur-md flex flex-col items-center justify-center">
    <div class="relative">
        <!-- Pulse Rings -->
        <div class="absolute inset-0 scale-[3] animate-ping opacity-20 bg-emerald-400 rounded-full"></div>
        <div class="absolute inset-0 scale-[2] animate-ping opacity-30 bg-emerald-300 rounded-full" style="animation-delay: 0.5s"></div>
        
        <div class="relative bg-white p-8 rounded-3xl shadow-2xl flex flex-col items-center gap-6 border border-emerald-50">
            <div class="w-20 h-20 rounded-2xl bg-emerald-50 text-emerald-600 flex items-center justify-center overflow-hidden">
                <i class="fa-solid fa-cloud-arrow-up text-4xl animate-bounce"></i>
            </div>
            <div class="text-center space-y-2">
                <h3 class="text-2xl font-black text-gray-900 tracking-tight" id="submissionOverlayTitle">Updating your ad...</h3>
                <p class="text-gray-500 text-sm font-medium">Please wait while we save your changes</p>
            </div>
            
            <!-- Progress Bar -->
            <div class="w-64 h-2 bg-gray-100 rounded-full overflow-hidden relative">
                <div class="absolute inset-0 bg-emerald-500 w-1/3 animate-[progress_2s_infinite_linear]"></div>
            </div>
        </div>
    </div>
</div>

<style>
@keyframes progress {
    0% { left: -100%; width: 50%; }
    50% { left: 50%; width: 80%; }
    100% { left: 100%; width: 50%; }
}
</style>

<?php $__env->startPush('scripts'); ?>
<script>
    // Initial Data from Server
    const initialLocation = <?php echo json_encode($listing->location_district, 15, 512) ?>;

    // Load districts on page load
    document.addEventListener('DOMContentLoaded', async () => {
        await fetchDistricts();
    });

    async function fetchDistricts() {
        try {
            const response = await fetch('/assets/districts.json');
            const data = await response.json();
            const select = document.getElementById('location');
            data.forEach(d => {
                const opt = document.createElement('option');
                opt.value = d.name;
                opt.textContent = d.name;
                if (initialLocation && d.name.toLowerCase() === initialLocation.toLowerCase()) {
                    opt.selected = true;
                }
                select.appendChild(opt);
            });
        } catch (e) { console.error('Failed to load districts', e); }
    }

    // Formatted number input
    document.querySelectorAll('.price-input').forEach(input => {
        input.addEventListener('input', function(e) {
            let value = this.value.replace(/\D/g, '');
            if (value === '') return;
            this.value = parseInt(value).toLocaleString();
        });
    });

    let uploadQueue = 0;
    
    function handleFileSelect(input) {
        const files = Array.from(input.files);
        const grid = document.getElementById('photo-grid');
        const existingCount = grid.querySelectorAll('.photo-preview').length;
        files.slice(0, 8 - existingCount).forEach(file => uploadFile(file));
        input.value = '';
    }

    function uploadFile(file) {
        const grid = document.getElementById('photo-grid');
        const label = document.getElementById('add-photo-label');
        const tempId = 'temp-' + Date.now();
        const div = document.createElement('div');
        div.id = tempId;
        div.className = 'photo-preview relative aspect-square rounded-2xl overflow-hidden group shadow-sm border border-gray-100 bg-gray-50';
        div.innerHTML = `
            <div class="absolute inset-0 flex items-center justify-center bg-gray-50"><div class="text-primary animate-spin"><i class="fa-solid fa-circle-notch fa-2xl"></i></div></div>
            <img class="w-full h-full object-cover opacity-0 transition-opacity duration-300">
            <div class="absolute inset-0 bg-black/40 opacity-0 group-hover:opacity-100 transition-opacity flex items-center justify-center gap-2">
                <button type="button" onclick="removePhoto('${tempId}')" class="w-8 h-8 rounded-full bg-white text-red-500 flex items-center justify-center hover:bg-red-50 hover:text-red-600 transition-colors shadow-lg"><i class="fa-solid fa-trash-can"></i></button>
            </div>
            <div class="upload-progress absolute bottom-0 left-0 h-1 bg-primary transition-all duration-300" style="width: 0%"></div>
            <input type="hidden" name="media_ids[]" value="">
        `;
        grid.insertBefore(div, label);
        
        const reader = new FileReader();
        reader.onload = (e) => {
            const img = div.querySelector('img');
            img.src = e.target.result;
            img.classList.remove('opacity-0');
            div.querySelector('.absolute.inset-0.flex').classList.add('hidden');
        };
        reader.readAsDataURL(file);

        const formData = new FormData();
        formData.append('media[]', file);
        formData.append('_token', '<?php echo e(csrf_token()); ?>');
        
        uploadQueue++;
        checkSubmitStatus();

        const xhr = new XMLHttpRequest();
        xhr.open('POST', '<?php echo e(route('listing.media.upload')); ?>', true);
        xhr.upload.onprogress = (e) => { if (e.lengthComputable) div.querySelector('.upload-progress').style.width = (e.loaded / e.total * 100) + '%'; };
        xhr.onload = function() {
            uploadQueue--;
            checkSubmitStatus();
            if (xhr.status === 200) {
                const response = JSON.parse(xhr.responseText);
                if (response.success) {
                    div.querySelector('input[name="media_ids[]"]').value = response.media[0].id;
                    div.querySelector('.upload-progress').classList.add('bg-emerald-500');
                    setTimeout(() => div.querySelector('.upload-progress').style.opacity = '0', 1000);
                    updateCoverBadge();
                }
            }
        };
        xhr.send(formData);
    }

    function removePhoto(id) { document.getElementById(id).remove(); updateCoverBadge(); }

    async function deleteExistingMedia(mediaId) {
        if (!confirm('Are you sure you want to remove this photo?')) return;
        
        try {
            const response = await fetch(`/listing/media/${mediaId}`, {
                method: 'DELETE',
                headers: { 'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>' }
            });
            const result = await response.json();
            if (result.success) {
                document.getElementById(`media-${mediaId}`).remove();
                updateCoverBadge();
            } else {
                alert(result.message || 'Failed to delete photo.');
            }
        } catch (e) { alert('An error occurred.'); }
    }

    function updateCoverBadge() {
        const grid = document.getElementById('photo-grid');
        grid.querySelectorAll('.cover-badge').forEach(b => b.remove());
        const first = grid.querySelector('.photo-preview');
        if (first) {
            const b = document.createElement('div');
            b.className = 'cover-badge absolute top-2 left-2 px-2 py-0.5 rounded-md bg-primary text-white text-[10px] font-bold shadow-sm z-10';
            b.textContent = 'COVER';
            first.appendChild(b);
        }
    }

    function checkSubmitStatus() {
        const btn = document.querySelector('button[type="submit"]');
        if (uploadQueue > 0) {
            btn.disabled = true;
            btn.classList.add('opacity-75', 'cursor-not-allowed');
            btn.innerHTML = '<i class="fa-solid fa-circle-notch fa-spin mr-2"></i>Uploading Photos...';
        } else {
            btn.disabled = false;
            btn.classList.remove('opacity-75', 'cursor-not-allowed');
            btn.innerHTML = 'Update Ad';
        }
    }

    function toggleStockFields() {
        const checked = document.getElementById('allowPosToggle').checked;
        const container = document.getElementById('stockFields');
        if (checked) {
            container.classList.remove('hidden');
            container.classList.add('block');
        } else {
            container.classList.add('hidden');
            container.classList.remove('block');
        }
    }

    // Form submission handler
    document.getElementById('editAdForm').addEventListener('submit', function(e) {
        if (uploadQueue > 0) {
            e.preventDefault();
            alert('Please wait for photos to finish uploading before updating.');
            return;
        }

        // Show Overlay
        const overlay = document.getElementById('submissionOverlay');
        overlay.classList.remove('hidden');
        setTimeout(() => overlay.classList.remove('opacity-0'), 10);
        
        // Disable button further
        const submitBtn = this.querySelector('button[type="submit"]');
        submitBtn.disabled = true;

        document.querySelectorAll('.price-input').forEach(i => i.value = i.value.replace(/,/g, ''));
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/edit-ad.blade.php ENDPATH**/ ?>