<?php $__env->startSection('title', 'Listing Details'); ?>
<?php $__env->startSection('header_title', 'Review Ad: ' . $listing->title); ?>

<?php $__env->startSection('content'); ?>
<div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
    <!-- Main Info -->
    <div class="lg:col-span-2 space-y-8">
        <!-- Media Gallery -->
        <div class="bg-white rounded-[2rem] border border-gray-100 shadow-sm p-6">
            <h3 class="font-black text-gray-900 uppercase tracking-tighter text-lg mb-6 flex items-center gap-3">
                <i class="fa-solid fa-images text-primary"></i>
                Ad Gallery
            </h3>
            
            <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
                <?php $__empty_1 = true; $__currentLoopData = $listing->media; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="aspect-square rounded-2xl overflow-hidden border border-gray-100 bg-gray-50 group relative">
                        <img src="<?php echo e($item->url); ?>" class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                        <div class="absolute inset-0 bg-black/40 opacity-0 group-hover:opacity-100 transition-opacity flex items-center justify-center">
                            <a href="<?php echo e($item->url); ?>" target="_blank" class="w-10 h-10 rounded-full bg-white text-gray-900 flex items-center justify-center">
                                <i class="fa-solid fa-expand"></i>
                            </a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="col-span-full py-12 flex flex-col items-center justify-center text-gray-300">
                        <i class="fa-solid fa-image text-5xl mb-4 opacity-20"></i>
                        <p class="text-sm font-bold uppercase">No photos uploaded</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Ad Details -->
        <div class="bg-white rounded-[2rem] border border-gray-100 shadow-sm p-8 space-y-8">
            <div class="flex items-start justify-between gap-4">
                <div>
                    <h2 class="text-2xl font-black text-gray-900 leading-tight"><?php echo e($listing->title); ?></h2>
                    <div class="mt-2 flex items-center gap-3">
                        <span class="px-3 py-1 bg-gray-100 rounded-full text-[10px] font-black uppercase text-gray-500"><?php echo e($listing->category); ?></span>
                        <span class="text-[10px] font-bold text-gray-400 capitalize"><?php echo e($listing->created_at->format('M d, Y')); ?></span>
                    </div>
                </div>
                <div class="text-right">
                    <div class="text-2xl font-black text-primary"><?php echo e(number_format($listing->price_amount)); ?> UGX</div>
                    <?php if(isset($listing->attributes['is_negotiable']) && $listing->attributes['is_negotiable']): ?>
                        <div class="text-[10px] font-black uppercase text-emerald-500 mt-1">Negotiable</div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="border-t border-gray-50 pt-8">
                <h3 class="text-xs font-black uppercase text-gray-400 mb-4 tracking-widest">Description</h3>
                <p class="text-gray-700 leading-relaxed text-sm whitespace-pre-line"><?php echo e($listing->description); ?></p>
            </div>

            <?php if($listing->custom_fields && count($listing->custom_fields) > 0): ?>
                <div class="border-t border-gray-50 pt-8">
                    <h3 class="text-xs font-black uppercase text-gray-400 mb-4 tracking-widest">Additional Details</h3>
                    <div class="grid grid-cols-2 lg:grid-cols-3 gap-6">
                        <?php $__currentLoopData = $listing->custom_fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="bg-gray-50 p-4 rounded-2xl border border-gray-100">
                                <div class="text-[10px] font-black uppercase text-gray-400"><?php echo e(str_replace('_', ' ', $key)); ?></div>
                                <div class="text-sm font-bold text-gray-800 mt-1"><?php echo e(is_array($value) ? implode(', ', $value) : $value); ?></div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Actions & Sidebar -->
    <div class="lg:col-span-1 space-y-6">
        <!-- Moderation Controls -->
        <div class="bg-white rounded-[2rem] border border-gray-100 shadow-sm p-6 space-y-6 sticky top-24">
            <h3 class="font-black text-gray-900 uppercase tracking-tighter text-lg flex items-center gap-3">
                <i class="fa-solid fa-gavel text-primary"></i>
                Moderation
            </h3>

            <form action="<?php echo e(route('admin.listings.update-status', $listing)); ?>" method="POST" class="space-y-4">
                <?php echo csrf_field(); ?>
                <div class="space-y-2">
                    <label class="text-[10px] font-black uppercase text-gray-400 ml-1">Update Status</label>
                    <div class="grid grid-cols-2 gap-2">
                        <button type="submit" name="status" value="published" 
                                class="py-2.5 rounded-xl text-xs font-bold transition-all <?php echo e($listing->status === 'published' ? 'bg-emerald-500 text-white shadow-lg shadow-emerald-500/20' : 'bg-gray-50 text-gray-500 hover:bg-emerald-50 hover:text-emerald-600'); ?>">
                            Publish
                        </button>
                        <button type="submit" name="status" value="review" 
                                class="py-2.5 rounded-xl text-xs font-bold transition-all <?php echo e($listing->status === 'review' ? 'bg-orange-500 text-white shadow-lg shadow-orange-500/20' : 'bg-gray-50 text-gray-500 hover:bg-orange-50 hover:text-orange-600'); ?>">
                            Send to Review
                        </button>
                        <button type="submit" name="status" value="draft" 
                                class="py-2.5 rounded-xl text-xs font-bold transition-all <?php echo e($listing->status === 'draft' ? 'bg-gray-800 text-white shadow-lg shadow-gray-800/20' : 'bg-gray-50 text-gray-500 hover:bg-gray-100'); ?>">
                            Unpublish (Draft)
                        </button>
                        <button type="button" onclick="document.getElementById('decline-form').classList.toggle('hidden')" 
                                class="py-2.5 rounded-xl text-xs font-bold transition-all <?php echo e($listing->status === 'rejected' ? 'bg-red-500 text-white shadow-lg shadow-red-500/20' : 'bg-gray-50 text-gray-500 hover:bg-red-50 hover:text-red-600'); ?>">
                            Reject Ad
                        </button>
                    </div>
                </div>

                <!-- Decline Form (Inner) -->
                <div id="decline-form" class="<?php echo e($listing->status !== 'rejected' ? 'hidden' : ''); ?> space-y-3 pt-4 border-t border-gray-50">
                    <label class="text-[10px] font-black uppercase text-red-400 ml-1">Rejection Reason</label>
                    <select name="reason" class="w-full px-4 py-3 rounded-2xl bg-red-50/50 border border-red-100 text-sm focus:bg-white focus:border-red-500 outline-none transition-all">
                        <option value="">Select a reason...</option>
                        <?php $__currentLoopData = \App\Models\Listing::REJECTION_REASONS; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>" <?php echo e($listing->decline_reason === $key ? 'selected' : ''); ?>>
                                <?php echo e($label); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <p class="text-[10px] text-gray-400 italic px-1">Selecting a reason will automatically generate a detailed notification for the user.</p>
                    <button type="submit" name="status" value="rejected" class="w-full py-3 bg-red-500 text-white font-bold rounded-2xl shadow-lg shadow-red-500/20 hover:bg-red-600 transition-all text-xs">
                        Confirm Rejection
                    </button>
                </div>
            </form>

            <div class="border-t border-gray-50 my-6"></div>

            <!-- Delete Action -->
            <form action="<?php echo e(route('admin.listings.destroy', $listing)); ?>" method="POST" onsubmit="return confirm('WARNING: This action cannot be undone. Are you sure you want to PERMANENTLY delete this listing?');">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="w-full py-2.5 bg-white border-2 border-red-50 text-red-500 font-bold rounded-xl hover:bg-red-50 transition-all text-xs flex items-center justify-center gap-2">
                    <i class="fa-solid fa-trash-can"></i>
                    Permanent Delete
                </button>
            </form>
        </div>

        <!-- Seller Overview -->
        <div class="bg-white rounded-[2rem] border border-gray-100 shadow-sm p-6">
            <h3 class="text-xs font-black uppercase text-gray-400 mb-6 tracking-widest">Seller Details</h3>
            
            <div class="flex items-center gap-4 mb-6">
                <div class="w-16 h-16 rounded-2xl bg-gray-50 border border-gray-100 flex items-center justify-center text-gray-400 font-black text-2xl overflow-hidden shrink-0">
                    <?php if($listing->createdBy->profile_photo): ?>
                        <img src="<?php echo e($listing->createdBy->profile_photo_url); ?>" class="w-full h-full object-cover">
                    <?php else: ?>
                        <?php echo e(substr($listing->createdBy->full_name, 0, 1)); ?>

                    <?php endif; ?>
                </div>
                <div>
                    <a href="<?php echo e(route('admin.users.show', $listing->createdBy)); ?>" class="text-lg font-black text-gray-900 hover:text-primary transition-colors leading-tight block"><?php echo e($listing->createdBy->full_name); ?></a>
                    <div class="flex items-center gap-2 mt-1">
                        <span class="text-[10px] font-black uppercase text-gray-400"><?php echo e($listing->createdBy->role); ?></span>
                        <span class="w-1 h-1 rounded-full bg-gray-200"></span>
                        <span class="text-[10px] font-bold text-emerald-500"><?php echo e($listing->createdBy->createdListings->count()); ?> Ads</span>
                    </div>
                </div>
            </div>

            <?php if($listing->business): ?>
                <a href="<?php echo e(route('admin.businesses.show', $listing->business)); ?>" class="flex items-center justify-between p-4 bg-gray-50 rounded-2xl border border-gray-100 group">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 rounded-xl bg-white flex items-center justify-center text-primary font-bold shadow-sm">
                            <?php echo e(substr($listing->business->name, 0, 1)); ?>

                        </div>
                        <div>
                            <div class="text-[10px] font-black uppercase text-gray-400 leading-none mb-1">Posted Via</div>
                            <div class="text-sm font-bold text-gray-800"><?php echo e($listing->business->name); ?></div>
                        </div>
                    </div>
                    <i class="fa-solid fa-chevron-right text-gray-300 group-hover:text-primary transition-colors"></i>
                </a>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/admin/listings/show.blade.php ENDPATH**/ ?>