<?php $__env->startSection('title', 'Business Profile'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50 pb-20 font-sans selection:bg-primary/20">
    <div class="container mx-auto px-4 py-6 max-w-2xl">
        <!-- Header -->
        <div class="flex items-center mb-6">
            <a href="<?php echo e(route('web.settings')); ?>" class="mr-4 w-10 h-10 bg-white rounded-xl shadow-sm border border-gray-100 flex items-center justify-center text-gray-600 hover:text-primary hover:border-primary/20 transition-all">
                <i class="fa-solid fa-arrow-left"></i>
            </a>
            <h1 class="text-2xl font-bold text-gray-900">Business Profile</h1>
        </div>

        <!-- Success Message -->
        <?php if(session('success')): ?>
        <div class="mb-6 bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded-xl flex items-center gap-3">
            <i class="fa-solid fa-check-circle"></i>
            <?php echo e(session('success')); ?>

        </div>
        <?php endif; ?>

        <!-- Error Message -->
        <?php if($errors->any()): ?>
        <div class="mb-6 bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded-xl">
             <ul class="list-disc list-inside">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <?php endif; ?>

        <!-- Navigation Tabs -->
        <div class="flex gap-2 overflow-x-auto pb-4 mb-2 no-scrollbar">
            <a href="<?php echo e(route('web.business.edit')); ?>" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all <?php echo e(Route::is('web.business.edit') ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'border border-transparent text-gray-500 hover:bg-white hover:shadow-sm'); ?>">
                Details
            </a>
            <a href="<?php echo e(route('web.business.links')); ?>" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all <?php echo e(Route::is('web.business.links') ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'border border-transparent text-gray-500 hover:bg-white hover:shadow-sm'); ?>">
                 Links
            </a>
            <a href="<?php echo e(route('web.business.branding')); ?>" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all <?php echo e(Route::is('web.business.branding') ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'border border-transparent text-gray-500 hover:bg-white hover:shadow-sm'); ?>">
                 Branding
            </a>
            <a href="<?php echo e(route('web.business.number.edit', ['type' => 'phone'])); ?>" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all <?php echo e(request()->route('type') == 'phone' ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'border border-transparent text-gray-500 hover:bg-white hover:shadow-sm'); ?>">
                 Phone
            </a>
             <a href="<?php echo e(route('web.business.members')); ?>" class="px-5 py-2.5 rounded-full font-bold text-sm whitespace-nowrap transition-all <?php echo e(Route::is('web.business.members') ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'border border-transparent text-gray-500 hover:bg-white hover:shadow-sm'); ?>">
                 Members
            </a>
        </div>

        <form action="<?php echo e(route('web.business.update')); ?>" method="POST" class="space-y-6">
            <?php echo csrf_field(); ?>
            
            <!-- Info Box -->
            <div class="bg-primary/5 rounded-2xl p-4 border border-primary/10 flex gap-4 shadow-sm shadow-primary/5">
                <div class="w-10 h-10 rounded-full bg-primary flex-shrink-0 flex items-center justify-center text-white shadow-sm">
                    <i class="fa-solid fa-shop text-sm"></i>
                </div>
                <div class="text-xs font-medium text-gray-600 leading-relaxed">
                    Update your business information to help customers find and learn about your services.
                </div>
            </div>

            <!-- Form Fields -->
            <div class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100 space-y-6">
                <!-- Business Name -->
                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2">Business Name</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                            <i class="fa-solid fa-building text-gray-400"></i>
                        </div>
                        <input type="text" name="name" value="<?php echo e(old('name', $business->name)); ?>" required
                            class="w-full pl-11 pr-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-gray-900 placeholder:text-gray-400"
                            placeholder="Enter business name">
                    </div>
                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-xs text-red-500 font-bold"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Business Description -->
                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2">Business Description</label>
                    <div class="relative">
                        <textarea name="description" rows="3" required
                            class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-gray-900 placeholder:text-gray-400"
                            placeholder="Describe your business"><?php echo e(old('description', $business->description)); ?></textarea>
                    </div>
                    <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-xs text-red-500 font-bold"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Business Type -->
                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2">Business Type</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none z-10">
                            <i class="fa-solid fa-tag text-gray-400"></i>
                        </div>
                        <select name="business_type" required
                            class="w-full pl-11 pr-10 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-gray-900 appearance-none">
                            <option value="">Select Business Type</option>
                            <option value="individual" <?php echo e(old('business_type', $business->business_type) == 'individual' ? 'selected' : ''); ?>>Individual</option>
                            <option value="retail" <?php echo e(old('business_type', $business->business_type) == 'retail' ? 'selected' : ''); ?>>Retail</option>
                            <option value="wholesale" <?php echo e(old('business_type', $business->business_type) == 'wholesale' ? 'selected' : ''); ?>>Wholesale</option>
                            <option value="serviceProvider" <?php echo e(old('business_type', $business->business_type) == 'serviceProvider' ? 'selected' : ''); ?>>Service Provider</option>
                        </select>
                        <div class="absolute inset-y-0 right-0 pr-4 flex items-center pointer-events-none">
                            <i class="fa-solid fa-chevron-down text-gray-400 text-xs"></i>
                        </div>
                    </div>
                    <?php $__errorArgs = ['business_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-xs text-red-500 font-bold"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Business Category -->
                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2">Business Category</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none z-10">
                            <i class="fa-solid fa-folder text-gray-400"></i>
                        </div>
                        <select name="business_category"
                            class="w-full pl-11 pr-10 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-gray-900 appearance-none">
                            <option value="">Select Category</option>
                            <option value="Retail" <?php echo e(old('business_category', $business->business_category) == 'Retail' ? 'selected' : ''); ?>>Retail</option>
                            <option value="Food & Beverage" <?php echo e(old('business_category', $business->business_category) == 'Food & Beverage' ? 'selected' : ''); ?>>Food & Beverage</option>
                            <option value="Services" <?php echo e(old('business_category', $business->business_category) == 'Services' ? 'selected' : ''); ?>>Services</option>
                            <option value="Healthcare" <?php echo e(old('business_category', $business->business_category) == 'Healthcare' ? 'selected' : ''); ?>>Healthcare</option>
                            <option value="Education" <?php echo e(old('business_category', $business->business_category) == 'Education' ? 'selected' : ''); ?>>Education</option>
                            <option value="Technology" <?php echo e(old('business_category', $business->business_category) == 'Technology' ? 'selected' : ''); ?>>Technology</option>
                            <option value="Construction" <?php echo e(old('business_category', $business->business_category) == 'Construction' ? 'selected' : ''); ?>>Construction</option>
                            <option value="Transportation" <?php echo e(old('business_category', $business->business_category) == 'Transportation' ? 'selected' : ''); ?>>Transportation</option>
                            <option value="Manufacturing" <?php echo e(old('business_category', $business->business_category) == 'Manufacturing' ? 'selected' : ''); ?>>Manufacturing</option>
                            <option value="Finance" <?php echo e(old('business_category', $business->business_category) == 'Finance' ? 'selected' : ''); ?>>Finance</option>
                            <option value="Hospitality" <?php echo e(old('business_category', $business->business_category) == 'Hospitality' ? 'selected' : ''); ?>>Hospitality</option>
                            <option value="Real Estate" <?php echo e(old('business_category', $business->business_category) == 'Real Estate' ? 'selected' : ''); ?>>Real Estate</option>
                            <option value="Automotive" <?php echo e(old('business_category', $business->business_category) == 'Automotive' ? 'selected' : ''); ?>>Automotive</option>
                            <option value="Agriculture" <?php echo e(old('business_category', $business->business_category) == 'Agriculture' ? 'selected' : ''); ?>>Agriculture</option>
                            <option value="Consulting" <?php echo e(old('business_category', $business->business_category) == 'Consulting' ? 'selected' : ''); ?>>Consulting</option>
                            <option value="Other" <?php echo e(old('business_category', $business->business_category) == 'Other' ? 'selected' : ''); ?>>Other</option>
                        </select>
                        <div class="absolute inset-y-0 right-0 pr-4 flex items-center pointer-events-none">
                            <i class="fa-solid fa-chevron-down text-gray-400 text-xs"></i>
                        </div>
                    </div>
                    <?php $__errorArgs = ['business_category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-xs text-red-500 font-bold"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Business Address -->
                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2">Business Address</label>
                    <div class="relative">
                        <textarea name="address" rows="2" required
                            class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-gray-900 placeholder:text-gray-400"
                            placeholder="Enter business address"><?php echo e(old('address', $business->address)); ?></textarea>
                    </div>
                    <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-xs text-red-500 font-bold"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- District -->
                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2">District</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                            <i class="fa-solid fa-location-dot text-gray-400"></i>
                        </div>
                        <input type="text" name="district" value="<?php echo e(old('district', $business->district)); ?>" required
                            class="w-full pl-11 pr-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-2 focus:ring-primary/20 focus:border-primary transition-all font-medium text-gray-900 placeholder:text-gray-400"
                            placeholder="Enter district">
                    </div>
                    <?php $__errorArgs = ['district'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-xs text-red-500 font-bold"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <!-- Submit Button -->
            <button type="submit" class="w-full py-4 bg-primary hover:bg-primary-dark text-white rounded-xl font-bold text-base shadow-lg shadow-primary/20 transition-all transform active:scale-[0.98]">
                Update Business Profile
            </button>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/business/edit.blade.php ENDPATH**/ ?>