<?php
    $categoryName = $filters['category'] ?? null;
    $subCategoryName = $filters['subcategory'] ?? null;
    $locationName = $filters['location'] && $filters['location'] !== 'All Uganda' ? $filters['location'] : null;
    $queryText = $filters['q'] ?? null;
    
    // Construct dynamic title
    $seoTitle = '';
    
    // Check for prominent custom filters (Brand, Model, etc.)
    $customInfo = '';
    if(isset($filters['custom']) && is_array($filters['custom'])) {
        foreach(['Brand', 'Model', 'Type', 'Make'] as $importantKey) {
            if(!empty($filters['custom'][$importantKey])) {
                $customInfo .= $filters['custom'][$importantKey] . ' ';
                break; // Just use one prominent one for the title
            }
        }
    }

    if($queryText) $seoTitle .= 'Buy ' . $queryText . ' ';
    elseif($customInfo) $seoTitle .= 'Buy ' . $customInfo;
    
    if($subCategoryName) $seoTitle .= $subCategoryName . ' ';
    elseif($categoryName) $seoTitle .= $categoryName . ' ';
    
    if(!$queryText && !$categoryName && !$customInfo) $seoTitle .= 'Online Marketplace ';
    
    if($locationName) $seoTitle .= 'in ' . $locationName . ' ';
    else $seoTitle .= 'in Uganda ';
    
    $seoTitle .= '| Yilick';
    
    // Construct dynamic description
    $seoDesc = 'Discover the best deals for ';
    if($queryText) $seoDesc .= '"' . $queryText . '" ';
    if($subCategoryName) $seoDesc .= 'in ' . $subCategoryName . ' ';
    elseif($categoryName) $seoDesc .= 'in ' . $categoryName . ' ';
    
    if($locationName) $seoDesc .= 'anywhere in ' . $locationName . '. ';
    else $seoDesc .= 'nationwide in Uganda. ';
    
    $seoDesc .= 'Verified sellers, safe transactions, and AI-powered insights for ' . ($categoryName ?? 'every niche') . '.';
?>

<?php $__env->startSection('title', $seoTitle); ?>
<?php $__env->startSection('meta_description', $seoDesc); ?>
<?php $__env->startSection('meta_keywords', ($queryText ? $queryText . ', ' : '') . ($categoryName ? $categoryName . ', ' : '') . ($subCategoryName ? $subCategoryName . ', ' : '') . ($locationName ? 'shops in ' . $locationName . ', ' : '') . 'online shopping uganda, classifieds africa, buy and sell safely'); ?>

<?php $__env->startSection('header_meta'); ?>
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "BreadcrumbList",
    "itemListElement": [{
        "@type": "ListItem",
        "position": 1,
        "name": "Home",
        "item": "<?php echo e(route('web.home')); ?>"
    },
    <?php if($categoryName): ?>
    {
        "@type": "ListItem",
        "position": 2,
        "name": "<?php echo e($categoryName); ?>",
        "item": "<?php echo e(route('listing.search', ['category' => $categoryName])); ?>"
    },
    <?php endif; ?>
    <?php if($subCategoryName): ?>
    {
        "@type": "ListItem",
        "position": <?php echo e($categoryName ? 3 : 2); ?>,
        "name": "<?php echo e($subCategoryName); ?>",
        "item": "<?php echo e(route('listing.search', ['category' => $categoryName, 'subcategory' => $subCategoryName])); ?>"
    },
    <?php endif; ?>
    {
        "@type": "ListItem",
        "position": <?php echo e(($categoryName ? 1 : 0) + ($subCategoryName ? 1 : 0) + 2); ?>,
        "name": "<?php echo e(!empty($queryText) ? $queryText : 'Search Results'); ?>",
        "item": "<?php echo e(url()->full()); ?>"
    }]
}
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-gray-50 min-h-screen">
    <!-- Search Header (Top Bar) - Premium Design -->
    <div class="bg-gradient-to-r from-primary via-primary to-emerald-600 sticky top-[52px] md:top-[60px] z-40 shadow-lg shadow-primary/20">
        <!-- Decorative Elements -->
        <div class="absolute inset-0 overflow-hidden pointer-events-none">
            <div class="absolute -top-24 -right-24 w-48 h-48 bg-white/5 rounded-full blur-2xl"></div>
            <div class="absolute -bottom-12 -left-12 w-32 h-32 bg-white/5 rounded-full blur-xl"></div>
        </div>
        
        <div class="max-w-[1440px] mx-auto px-4 sm:px-6 lg:px-8 py-4 relative">
            <form action="<?php echo e(route('listing.search')); ?>" method="GET" id="search-form-top" class="flex items-center gap-3">
                <!-- Enhanced Search Input Container -->
                <div class="flex-1 min-w-0 flex items-center bg-white/95 backdrop-blur-sm rounded-2xl overflow-hidden shadow-xl shadow-black/10 border-2 border-white/50 focus-within:border-white focus-within:shadow-2xl focus-within:shadow-black/15 transition-all duration-300 group">
                    <!-- Search Icon with Animation -->
                    <div class="flex-1 flex items-center px-5 py-3.5 min-w-0 relative">
                        <div class="relative mr-4 flex-shrink-0">
                            <i class="fa-solid fa-magnifying-glass text-primary text-lg group-focus-within:scale-110 transition-transform duration-200"></i>
                            <div class="absolute inset-0 bg-primary/20 rounded-full blur-md opacity-0 group-focus-within:opacity-100 transition-opacity"></div>
                        </div>
                        <input 
                            type="text" 
                            name="q" 
                            id="main-search-input"
                            value="<?php echo e($filters['q'] ?? ''); ?>"
                            placeholder="What are you looking for?" 
                            class="w-full bg-transparent border-0 focus:ring-0 focus:outline-none outline-none text-gray-900 placeholder-gray-400 text-base font-medium truncate"
                            autocomplete="off"
                        >
                        <!-- Clear Button -->
                        <button type="button" onclick="clearSearchInput()" class="hidden absolute right-2 top-1/2 -translate-y-1/2 w-6 h-6 rounded-full bg-gray-100 hover:bg-gray-200 flex items-center justify-center text-gray-400 hover:text-gray-600 transition-all" id="clear-search-btn">
                            <i class="fa-solid fa-xmark text-xs"></i>
                        </button>
                    </div>
                    
                    <!-- Divider -->
                    <div class="hidden md:flex items-center h-10 w-px bg-gradient-to-b from-transparent via-gray-200 to-transparent"></div>
                    
                    <!-- Location Picker (Desktop) -->
                    <button type="button" onclick="openLocationModal()" class="hidden md:flex items-center gap-3 px-6 py-3.5 hover:bg-gray-50/80 transition-all text-gray-700 text-sm font-semibold whitespace-nowrap group/loc">
                        <div class="relative">
                            <i class="fa-solid fa-location-dot text-primary text-base group-hover/loc:scale-110 transition-transform"></i>
                            <div class="absolute -inset-1 bg-primary/10 rounded-full opacity-0 group-hover/loc:opacity-100 transition-opacity"></div>
                        </div>
                        <span id="search-location-text-top" class="max-w-[120px] truncate"><?php echo e($filters['location'] ?? 'All Uganda'); ?></span>
                        <i class="fa-solid fa-chevron-down text-[10px] text-gray-400 group-hover/loc:text-primary transition-colors"></i>
                    </button>
                    <input type="hidden" name="location" id="location-input" value="<?php echo e($filters['location'] ?? ''); ?>">
                </div>

                <!-- Save to Favorites Button -->
                <?php if(Auth::guard('web')->user()): ?>
                <button type="button" 
                        id="save-search-btn"
                        onclick="saveCurrentSearch()" 
                        class="flex items-center gap-2 px-4 md:px-5 py-3 md:py-3.5 bg-white/15 hover:bg-white/25 backdrop-blur-sm rounded-xl md:rounded-2xl border border-white/30 text-white text-sm font-bold transition-all duration-300 hover:scale-105 active:scale-95 group"
                        title="Save this search to favorites">
                    <i class="fa-regular fa-heart text-lg group-hover:scale-110 transition-transform" id="save-search-icon"></i>
                    <span class="hidden md:inline" id="save-search-text">Save</span>
                </button>
                <?php endif; ?>

                <!-- Mobile Filter Trigger -->
                <button type="button" onclick="toggleMobileFilters()" class="lg:hidden flex items-center gap-2 px-4 py-3.5 bg-white/15 hover:bg-white/25 backdrop-blur-sm rounded-2xl border border-white/30 text-white text-sm font-bold transition-all duration-300 active:scale-95">
                    <i class="fa-solid fa-sliders"></i>
                    <span>Filters</span>
                </button>

                <!-- Search Button (Desktop) - Enhanced -->
                <button type="submit" class="hidden md:flex items-center gap-2 bg-white hover:bg-gray-50 text-primary font-black px-8 py-3.5 rounded-2xl transition-all duration-300 shadow-lg shadow-black/10 hover:shadow-xl hover:shadow-black/15 hover:scale-105 active:scale-95 group">
                    <i class="fa-solid fa-arrow-right text-sm group-hover:translate-x-0.5 transition-transform"></i>
                    <span>Search</span>
                </button>
            </form>
            
            <!-- Quick Search Suggestions (appears when input focused) -->
            <?php if(!($filters['q'] ?? '') && !empty($popularSearches)): ?>
            <div id="quick-suggestions" class="hidden mt-4 flex flex-wrap gap-2 animate-fade-in">
                <?php $__currentLoopData = $popularSearches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $term): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <button type="button" 
                        onclick="applyQuickSearch('<?php echo e($term); ?>')" 
                        class="px-4 py-2 bg-white/15 hover:bg-white/25 backdrop-blur-sm rounded-full text-white/90 text-xs font-bold transition-all duration-200 hover:scale-105 active:scale-95 border border-white/20">
                    <?php echo e(ucfirst($term)); ?>

                </button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Toast Notification Container -->
    <div id="toast-container" class="fixed top-20 right-4 z-[200] flex flex-col gap-3 pointer-events-none"></div>

    <!-- Main Content Layout -->
    <div class="max-w-[1440px] mx-auto px-4 sm:px-6 lg:px-8 py-6">
        <div class="flex flex-col lg:flex-row gap-8">
            
            <!-- Sidebar (Desktop Friendly) -->
            <aside id="filters-sidebar" class="hidden lg:block w-72 flex-shrink-0 space-y-6">
                <!-- Sidebar Form -->
                <form action="<?php echo e(route('listing.search')); ?>" method="GET" id="search-form-sidebar">
                    <!-- Preserve search and location -->
                    <input type="hidden" name="q" value="<?php echo e($filters['q'] ?? ''); ?>">
                    <input type="hidden" name="location" value="<?php echo e($filters['location'] ?? ''); ?>">
                    <input type="hidden" name="subcategory" value="<?php echo e($filters['subcategory'] ?? ''); ?>">

                    <!-- Primary Filters Container -->
                    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                        <div class="px-5 py-4 border-b border-gray-50 flex items-center justify-between">
                            <h3 class="font-bold text-gray-900 text-sm italic">Basic Search</h3>
                            <div class="flex items-center gap-3">
                                <?php if(Auth::guard('web')->user()): ?>
                                <button type="button" 
                                        id="sidebar-save-btn"
                                        onclick="saveCurrentSearchSidebar()" 
                                        class="flex items-center gap-1.5 px-3 py-1.5 bg-primary/5 hover:bg-primary/10 rounded-lg text-xs text-primary font-bold transition-all duration-200 hover:scale-105 active:scale-95 group" 
                                        title="Save this search to favorites">
                                    <i class="fa-regular fa-heart group-hover:scale-110 transition-transform" id="sidebar-save-icon"></i>
                                    <span id="sidebar-save-text">Save</span>
                                </button>
                                <?php endif; ?>
                                <?php if(($filters['q'] ?? '') || ($filters['location'] ?? '') || ($filters['category'] ?? '') || ($filters['min_price'] ?? '') || ($filters['max_price'] ?? '') || ($filters['sort'] ?? 'relevance') !== 'relevance'): ?>
                                    <a href="<?php echo e(route('listing.search')); ?>" class="text-xs text-gray-400 hover:text-red-500 font-bold hover:underline transition-colors">Reset</a>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="p-5 space-y-6">
                            <!-- Category Dropdown -->
                            <div class="space-y-2">
                                <label class="block text-[10px] font-black text-gray-400 uppercase tracking-widest">Select Category</label>
                                <div class="relative">
                                    <select name="category" onchange="const sub = this.form.querySelector('input[name=subcategory]'); if(sub) sub.value='';" class="w-full appearance-none px-4 py-3 rounded-xl bg-gray-50 border border-gray-100 text-gray-700 text-sm focus:ring-2 focus:ring-primary/20 outline-none cursor-pointer font-medium transition-all">
                                        <option value="">All Categories</option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($cat['Category']); ?>" <?php echo e(($filters['category'] ?? '') == $cat['Category'] ? 'selected' : ''); ?>>
                                                <?php echo e($cat['Category']); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <i class="fa-solid fa-chevron-down absolute right-4 top-1/2 -translate-y-1/2 text-gray-400 text-[10px] pointer-events-none"></i>
                                </div>
                            </div>

                            <!-- Sort Dropdown -->
                            <div class="space-y-2">
                                <label class="block text-[10px] font-black text-gray-400 uppercase tracking-widest">Sort By</label>
                                <div class="relative">
                                    <select name="sort" class="w-full appearance-none px-4 py-3 rounded-xl bg-gray-50 border border-gray-100 text-gray-700 text-sm focus:ring-2 focus:ring-primary/20 outline-none cursor-pointer font-medium transition-all">
                                        <?php $__currentLoopData = [
                                            'relevance' => 'Relevance',
                                            'newest' => 'Newest First',
                                            'price_asc' => 'Price: Low to High',
                                            'price_desc' => 'Price: High to Low'
                                        ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key); ?>" <?php echo e(($filters['sort'] ?? 'relevance') == $key ? 'selected' : ''); ?>><?php echo e($label); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <i class="fa-solid fa-chevron-down absolute right-4 top-1/2 -translate-y-1/2 text-gray-400 text-[10px] pointer-events-none"></i>
                                </div>
                            </div>

                            <!-- Price Range Area -->
                            <div class="space-y-3 pt-2">
                                <label class="block text-[10px] font-black text-gray-400 uppercase tracking-widest">Price Range (UGX)</label>
                                <div class="grid grid-cols-2 gap-3">
                                    <div class="space-y-1">
                                        <input type="number" name="min_price" value="<?php echo e($filters['min_price'] ?? ''); ?>" placeholder="Min" class="w-full px-4 py-2.5 rounded-xl bg-gray-50 border border-gray-100 text-sm focus:ring-2 focus:ring-primary/20 outline-none transition-all placeholder:text-gray-300">
                                    </div>
                                    <div class="space-y-1">
                                        <input type="number" name="max_price" value="<?php echo e($filters['max_price'] ?? ''); ?>" placeholder="Max" class="w-full px-4 py-2.5 rounded-xl bg-gray-50 border border-gray-100 text-sm focus:ring-2 focus:ring-primary/20 outline-none transition-all placeholder:text-gray-300">
                                    </div>
                                </div>
                            </div>

                            <!-- Specifications (Wrapped within Basic Search) -->
                            <?php if(!empty($customFields)): ?>
                                <div class="pt-4 border-t border-gray-50 space-y-5">
                                    <div class="flex items-center gap-2 mb-1">
                                        <i class="fa-solid fa-list-check text-primary text-[10px]"></i>
                                        <h4 class="font-bold text-gray-900 text-xs italic">Specifications</h4>
                                    </div>
                                    <?php $__currentLoopData = $customFields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(isset($field['options']) && !empty($field['options'])): ?>
                                            <div class="space-y-2">
                                                <label class="block text-[10px] font-black text-gray-400 uppercase tracking-widest"><?php echo e($field['name']); ?></label>
                                                
                                                <?php if(($field['type'] ?? '') === 'checkbox'): ?>
                                                    <!-- Multi-select Toggle -->
                                                    <?php
                                                        $selectedValues = array_filter(explode(',', $filters['custom'][$field['name']] ?? ''));
                                                        $count = count($selectedValues);
                                                    ?>
                                                    <button type="button" 
                                                            onclick="openCheckboxModal('<?php echo e($field['name']); ?>', <?php echo e(json_encode($field['options'])); ?>)"
                                                            class="w-full flex items-center justify-between px-4 py-2.5 rounded-xl bg-gray-50 border border-gray-100 text-gray-700 text-sm focus:ring-2 focus:ring-primary/20 outline-none hover:bg-white transition-all text-left">
                                                        <span class="flex-1 truncate <?php echo e($count > 0 ? 'text-primary font-bold' : ''); ?>">
                                                            <?php echo e($count > 0 ? $count . ' selected' : 'Multi-select...'); ?>

                                                        </span>
                                                        <div class="flex items-center gap-2">
                                                            <?php if($count > 0): ?>
                                                                <i class="fa-solid fa-circle-check text-primary text-[10px]"></i>
                                                            <?php endif; ?>
                                                            <i class="fa-solid fa-plus-circle text-gray-400 text-[10px]"></i>
                                                        </div>
                                                    </button>
                                                    <input type="hidden" name="custom[<?php echo e($field['name']); ?>]" id="custom-hidden-<?php echo e(Str::slug($field['name'])); ?>" value="<?php echo e($filters['custom'][$field['name']] ?? ''); ?>">
                                                <?php else: ?>
                                                    <!-- Standard Dropdown -->
                                                    <div class="relative">
                                                        <select name="custom[<?php echo e($field['name']); ?>]" class="w-full appearance-none px-4 py-2.5 rounded-xl bg-gray-50 border border-gray-100 text-gray-700 text-sm focus:ring-2 focus:ring-primary/20 outline-none cursor-pointer hover:bg-white transition-all">
                                                            <option value="">All <?php echo e($field['name']); ?></option>
                                                            <?php $__currentLoopData = $field['options']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($option); ?>" <?php echo e(($filters['custom'][$field['name']] ?? '') == $option ? 'selected' : ''); ?>>
                                                                    <?php echo e($option); ?>

                                                                </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                        <i class="fa-solid fa-chevron-down absolute right-4 top-1/2 -translate-y-1/2 text-gray-400 text-[10px] pointer-events-none"></i>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>

                            <div class="pt-4">
                                <button type="button" 
                                        onclick="submitSearchForm(this.form)"
                                        class="w-full py-3.5 bg-gray-900 text-white font-black rounded-xl text-xs hover:bg-black hover:shadow-xl hover:shadow-gray-200 transition-all active:scale-95 flex items-center justify-center gap-2">
                                    <i class="fa-solid fa-sliders text-[10px]"></i>
                                    Apply All Filters
                                </button>
                            </div>
                        </div>
                    </div>


            </aside>

            <!-- Multi-select Checkbox Modal -->
            <div id="checkbox-modal" class="fixed inset-0 z-[70] hidden items-center justify-center p-4">
                <div class="absolute inset-0 bg-black/60 backdrop-blur-sm" onclick="closeCheckboxModal()"></div>
                <div class="bg-white rounded-[2.5rem] w-full max-w-lg max-h-[80vh] flex flex-col relative shadow-2xl overflow-hidden animate-fade-in-up">
                    <div class="p-6 border-b border-gray-100 flex items-center justify-between">
                        <div>
                            <h3 id="modal-field-title" class="font-black text-xl text-gray-900 tracking-tight italic">Options</h3>
                            <p class="text-xs text-gray-400 font-bold uppercase tracking-widest mt-1">Select multiple items</p>
                        </div>
                        <button onclick="closeCheckboxModal()" class="w-10 h-10 rounded-full bg-gray-50 flex items-center justify-center text-gray-400 hover:text-red-500 transition-all">
                            <i class="fa-solid fa-xmark"></i>
                        </button>
                    </div>
                    <div id="modal-options-list" class="flex-1 overflow-y-auto p-6 grid grid-cols-1 sm:grid-cols-2 gap-3 custom-scrollbar">
                        <!-- Checkboxes will be injected here -->
                    </div>
                    <div class="p-6 border-t border-gray-100 bg-gray-50 flex items-center justify-between gap-4">
                        <button type="button" onclick="clearModalCheckboxes()" class="text-xs font-bold text-gray-400 hover:text-red-500 transition-colors uppercase tracking-widest">Clear All</button>
                        <button type="button" onclick="saveCheckboxSelection()" class="px-8 py-3 bg-primary text-white font-black rounded-2xl text-sm shadow-xl shadow-primary/20 hover:scale-105 active:scale-95 transition-all">
                            Done Selection
                        </button>
                    </div>
                </div>
            </div>

            <!-- Main Results Area -->
            <main class="flex-1 min-w-0">
                <!-- Subcategory Horizontal Scroll (Desktop/Tablet) -->
                <?php if(!empty($subcategories)): ?>
                <div class="mb-6 w-full max-w-full overflow-hidden">
                    <div class="flex items-center gap-2 overflow-x-auto pb-4 custom-scrollbar whitespace-nowrap px-1">
                        <button type="button" 
                                onclick="applySubcategory('')"
                                class="px-5 py-2.5 rounded-full text-sm font-bold transition-all shadow-sm border <?php echo e(($filters['subcategory'] ?? '') === '' ? 'bg-primary text-white border-primary shadow-primary/20' : 'bg-white text-gray-600 border-gray-100 hover:border-primary/30'); ?>">
                            All
                        </button>
                        <?php $__currentLoopData = $subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <button type="button" 
                                    onclick="applySubcategory('<?php echo e($sub['Category']); ?>')"
                                    class="px-5 py-2.5 rounded-full text-sm font-bold transition-all shadow-sm border <?php echo e(($filters['subcategory'] ?? '') == $sub['Category'] ? 'bg-primary text-white border-primary shadow-primary/20' : 'bg-white text-gray-600 border-gray-100 hover:border-primary/30'); ?>">
                                <?php echo e($sub['Category']); ?>

                            </button>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <!-- Search Suggestions (Did you mean?) -->
                <?php if(isset($suggestion) && $suggestion): ?>
                <div class="mb-8 bg-white border border-primary/20 rounded-[1.5rem] p-5 flex items-center gap-5 shadow-xl shadow-primary/5 group hover:border-primary/40 transition-all animate-fade-in relative overflow-hidden">
                    <!-- Decorative background element -->
                    <div class="absolute -right-8 -top-8 w-24 h-24 bg-primary/5 rounded-full blur-2xl group-hover:bg-primary/10 transition-colors"></div>
                    
                    <div class="w-12 h-12 rounded-2xl bg-primary flex items-center justify-center text-white shadow-lg shadow-primary/20 flex-shrink-0 group-hover:scale-110 transition-transform duration-300">
                        <i class="fa-solid fa-wand-magic-sparkles text-lg"></i>
                    </div>
                    <div class="flex-1 min-w-0">
                        <h4 class="text-[10px] font-black text-primary uppercase tracking-[0.2em] mb-1">Smart Suggestion</h4>
                        <p class="text-sm md:text-base text-gray-600 font-medium">
                            Showing results for <span class="font-bold text-gray-900 italic">"<?php echo e($filters['q']); ?>"</span>. 
                            Did you mean <a href="<?php echo e(route('listing.search', array_merge($filters, ['q' => $suggestion]))); ?>" class="text-primary font-black hover:text-emerald-600 transition-all decoration-2 underline-offset-4 decoration-primary/20 hover:decoration-primary group-hover:underline">"<?php echo e($suggestion); ?>"</a>?
                        </p>
                    </div>
                    <div class="hidden md:flex items-center gap-3">
                        <a href="<?php echo e(route('listing.search', array_merge($filters, ['q' => $suggestion]))); ?>" class="px-5 py-2.5 bg-gray-50 hover:bg-white border border-gray-100 rounded-xl text-xs font-black text-gray-900 transition-all shadow-sm hover:shadow-md active:scale-95">
                            Use Correction
                        </a>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Section Header -->
                <div class="flex items-center justify-between mb-8">
                    <div>
                        <h1 class="text-1xl font-black text-gray-900 tracking-tight">
                            <?php if($filters['q'] ?? ''): ?>
                                <span class="text-gray-400 font-medium">Search for</span> "<?php echo e($filters['q']); ?>"
                            <?php elseif($filters['category'] ?? ''): ?>
                                <?php echo e($filters['category']); ?>

                            <?php else: ?>
                                <span class="italic text-primary">All Listings</span>
                            <?php endif; ?>
                        </h1>
                    </div>

                    <!-- Sort Dropdown (Visible on mobile instead of sidebar) -->
                    <div class="lg:hidden">
                        <!-- We'll keep the mobile sorting in the drawer for a cleaner UI -->
                    </div>
                </div>

                <!-- Active Filter Pills (Enhanced) -->
                <div class="flex items-center gap-3 flex-wrap mb-8">
                    <?php if(($filters['location'] ?? '') && $filters['location'] !== 'All Uganda'): ?>
                        <div class="group flex items-center bg-white border border-gray-100 rounded-xl px-4 py-2 shadow-sm hover:border-primary/30 transition-all">
                            <i class="fa-solid fa-location-dot text-primary text-xs mr-2"></i>
                            <span class="text-xs font-bold text-gray-700 mr-2"><?php echo e($filters['location']); ?></span>
                            <a href="<?php echo e(route('listing.search', array_diff_key($filters, ['location' => '']))); ?>" class="text-gray-400 hover:text-red-500 transition-colors">
                                <i class="fa-solid fa-xmark"></i>
                            </a>
                        </div>
                    <?php endif; ?>
                    
                    <?php if($filters['category'] ?? ''): ?>
                        <div class="group flex items-center bg-white border border-gray-100 rounded-xl px-4 py-2 shadow-sm hover:border-primary/30 transition-all">
                            <i class="fa-solid fa-layer-group text-primary text-xs mr-2"></i>
                            <span class="text-xs font-bold text-gray-700 mr-2"><?php echo e($filters['category']); ?></span>
                            <a href="<?php echo e(route('listing.search', array_diff_key($filters, ['category' => '', 'subcategory' => '']))); ?>" class="text-gray-400 hover:text-red-500 transition-colors">
                                <i class="fa-solid fa-xmark"></i>
                            </a>
                        </div>
                    <?php endif; ?>

                    <?php if($filters['subcategory'] ?? ''): ?>
                        <div class="group flex items-center bg-white border border-gray-100 rounded-xl px-4 py-2 shadow-sm hover:border-primary/30 transition-all">
                            <i class="fa-solid fa-tags text-primary text-xs mr-2"></i>
                            <span class="text-xs font-bold text-gray-700 mr-2"><?php echo e($filters['subcategory']); ?></span>
                            <a href="<?php echo e(route('listing.search', array_diff_key($filters, ['subcategory' => '']))); ?>" class="text-gray-400 hover:text-red-500 transition-colors">
                                <i class="fa-solid fa-xmark"></i>
                            </a>
                        </div>
                    <?php endif; ?>

                    <?php if(!empty($filters['custom'] ?? [])): ?>
                        <?php $__currentLoopData = $filters['custom']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(!empty($val)): ?>
                                <div class="group flex items-center bg-orange-50 border border-orange-100 rounded-xl px-4 py-2 shadow-sm hover:border-orange-200 transition-all">
                                    <span class="text-[10px] uppercase font-black text-orange-400 mr-2"><?php echo e($key); ?>:</span>
                                    <span class="text-xs font-bold text-gray-700 mr-2"><?php echo e($val); ?></span>
                                    <a href="<?php echo e(route('listing.search', array_merge($filters, ['custom' => array_diff_key($filters['custom'], [$key => ''])]))); ?>" class="text-orange-400 hover:text-red-500 transition-colors">
                                        <i class="fa-solid fa-xmark"></i>
                                    </a>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    
                    <?php if(count($filters) > 3 || !empty($filters['custom'] ?? [])): ?>
                         <a href="<?php echo e(route('listing.search')); ?>" class="text-xs font-bold text-red-500 hover:underline px-3 py-2">Clear All</a>
                    <?php endif; ?>
                </div>

                <!-- Results Grid -->
                <?php if($listings->count() > 0): ?>
                    <div class="grid grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4 md:gap-6">
                        <?php $__currentLoopData = $listings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $listing): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if (isset($component)) { $__componentOriginal31ec1dc5dadb4835ef50de3d88e519ce = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal31ec1dc5dadb4835ef50de3d88e519ce = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.listing-card','data' => ['listing' => $listing]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('listing-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['listing' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($listing)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal31ec1dc5dadb4835ef50de3d88e519ce)): ?>
<?php $attributes = $__attributesOriginal31ec1dc5dadb4835ef50de3d88e519ce; ?>
<?php unset($__attributesOriginal31ec1dc5dadb4835ef50de3d88e519ce); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal31ec1dc5dadb4835ef50de3d88e519ce)): ?>
<?php $component = $__componentOriginal31ec1dc5dadb4835ef50de3d88e519ce; ?>
<?php unset($__componentOriginal31ec1dc5dadb4835ef50de3d88e519ce); ?>
<?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    
                    <!-- Pagination -->
                    <div class="mt-12 flex justify-center">
                        <?php echo e($listings->links('vendor.pagination.yilick')); ?>

                    </div>
                <?php else: ?>
                    <!-- No Results (Enhanced) -->
                    <div class="bg-white rounded-[2rem] border border-gray-100 p-12 text-center shadow-sm">
                        <div class="w-24 h-24 bg-primary/5 rounded-full flex items-center justify-center mx-auto mb-8 shadow-inner">
                            <i class="fa-solid fa-cloud-moon text-primary/30 text-4xl"></i>
                        </div>
                        <h2 class="text-2xl font-black text-gray-900 mb-3 tracking-tight">Oops! No listings found</h2>
                        <p class="text-gray-400 font-medium max-w-sm mx-auto mb-10 leading-relaxed">
                            We searched far and wide but couldn't find any matches. Try adjusting your filters or search terms.
                        </p>
                        
                        <div class="max-w-md mx-auto grid grid-cols-1 md:grid-cols-2 gap-4 text-left">
                            <div class="p-4 bg-gray-50 rounded-2xl border border-gray-100">
                                <h4 class="font-bold text-gray-900 text-sm mb-2">Search Tips</h4>
                                <ul class="space-y-1.5 text-xs text-gray-500 font-medium">
                                    <li class="flex items-center gap-2"><div class="w-1 h-1 bg-primary rounded-full"></div>Check spelling</li>
                                    <li class="flex items-center gap-2"><div class="w-1 h-1 bg-primary rounded-full"></div>Generic terms</li>
                                    <li class="flex items-center gap-2"><div class="w-1 h-1 bg-primary rounded-full"></div>Fewer keywords</li>
                                </ul>
                            </div>
                            <div class="p-4 bg-gray-50 rounded-2xl border border-gray-100">
                                <h4 class="font-bold text-gray-900 text-sm mb-2">Try Instead</h4>
                                <ul class="space-y-1.5 text-xs text-gray-500 font-medium">
                                    <li class="flex items-center gap-2"><div class="w-1 h-1 bg-primary rounded-full"></div>Change location</li>
                                    <li class="flex items-center gap-2"><div class="w-1 h-1 bg-primary rounded-full"></div>Reset filters</li>
                                    <li class="flex items-center gap-2"><div class="w-1 h-1 bg-primary rounded-full"></div>Browse categories</li>
                                </ul>
                            </div>
                        </div>
                        
                        <a href="<?php echo e(route('listing.search')); ?>" class="inline-flex items-center gap-2 mt-10 px-8 py-3.5 bg-primary text-white font-bold rounded-2xl hover:bg-primary/90 transition-all shadow-xl shadow-primary/20 hover:-translate-y-1 active:scale-95">
                            <i class="fa-solid fa-rotate-left"></i>
                            Reset Everything
                        </a>
                    </div>
                <?php endif; ?>
            </main>
        </div>
    </div>

    <!-- Mobile Filters Drawer (Off-canvas) -->
    <div id="mobile-filters-drawer" class="fixed inset-0 z-[100] hidden transition-all duration-300">
        <!-- Backdrop -->
        <div id="drawer-backdrop" class="absolute inset-0 bg-black/60 opacity-0 transition-opacity duration-300" onclick="window.toggleMobileFilters()"></div>
        
        <!-- Drawer Panel -->
        <div id="drawer-panel" class="absolute inset-y-0 left-0 w-[85%] max-w-sm bg-gray-50 shadow-2xl -translate-x-full transition-transform duration-300 ease-out flex flex-col will-change-transform">
            <!-- Header -->
            <div class="p-5 bg-white border-b border-gray-100 flex items-center justify-between flex-shrink-0">
                <div class="flex items-center gap-3">
                    <i class="fa-solid fa-sliders text-primary"></i>
                    <h3 class="font-black text-gray-900 italic tracking-tighter">Filter Listings</h3>
                </div>
                <button type="button" onclick="window.toggleMobileFilters()" class="w-10 h-10 rounded-full bg-gray-50 flex items-center justify-center text-gray-400 transition-colors hover:text-red-500 active:scale-90">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>

            <!-- Body (Scrollable) -->
            <div class="flex-1 overflow-y-auto overflow-x-hidden p-5 space-y-8 pb-32 overscroll-contain custom-scrollbar">
                <!-- We inject the same filter content here using JavaScript or by duplicating HTML for simplicity -->
                <!-- For now, let's just clone the sidebar content conceptually or use a JS-based approach -->
                <div id="mobile-drawer-content">
                    <!-- This will be populated with a copy of the sidebar form on initial load or just built separately here -->
                </div>
            </div>

            <!-- Footer Actions -->
            <div class="absolute bottom-0 inset-x-0 p-5 bg-white border-t border-gray-100 flex gap-3 shadow-[0_-10px_30px_rgba(0,0,0,0.05)]">
                <a href="<?php echo e(route('listing.search')); ?>" class="flex-1 py-3.5 text-center text-gray-400 font-bold text-sm bg-gray-50 rounded-2xl hover:bg-gray-100 transition-colors">
                    Reset
                </a>
                <button type="button" onclick="submitSearchForm('mobile-drawer-form')" class="flex-[2] py-3.5 bg-primary text-white font-bold rounded-2xl text-sm shadow-xl shadow-primary/20 hover:bg-primary/90 active:scale-95 transition-all">
                    Show Results
                </button>
            </div>
        </div>
    </div>
</div>

<style>
    .custom-scrollbar::-webkit-scrollbar { width: 4px; }
    .custom-scrollbar::-webkit-scrollbar-track { background: transparent; }
    .custom-scrollbar::-webkit-scrollbar-thumb { background: #E5E7EB; border-radius: 10px; }
    .custom-scrollbar::-webkit-scrollbar-thumb:hover { background: #D1D5DB; }
    
    /* Toast Animations */
    @keyframes toast-slide-in {
        from { transform: translateX(100%); opacity: 0; }
        to { transform: translateX(0); opacity: 1; }
    }
    @keyframes toast-slide-out {
        from { transform: translateX(0); opacity: 1; }
        to { transform: translateX(100%); opacity: 0; }
    }
    .toast-enter { animation: toast-slide-in 0.3s ease-out forwards; }
    .toast-exit { animation: toast-slide-out 0.3s ease-in forwards; }
    
    /* Fade In Animation */
    @keyframes fade-in {
        from { opacity: 0; transform: translateY(-10px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .animate-fade-in { animation: fade-in 0.3s ease-out forwards; }
    
    /* Heart Pulse Animation */
    @keyframes heart-pulse {
        0%, 100% { transform: scale(1); }
        50% { transform: scale(1.3); }
    }
    .heart-saved { animation: heart-pulse 0.4s ease-in-out; }
</style>

<?php $__env->startPush('scripts'); ?>
<script>
    window.submitSearchForm = function(formOrId) {
        let form;
        if (typeof formOrId === 'string') {
            form = document.getElementById(formOrId);
        } else {
            form = formOrId;
        }

        if (!form) return;

        // Close drawer first for visual polish if open
        const drawer = document.getElementById('mobile-filters-drawer');
        if (drawer && !drawer.classList.contains('hidden')) {
            window.toggleMobileFilters();
            // Small delay to let the animation start before page unload
            setTimeout(() => {
                form.submit();
            }, 150);
        } else {
            form.submit();
        }
    };

    window.toggleMobileFilters = function() {
        const drawer = document.getElementById('mobile-filters-drawer');
        const backdrop = document.getElementById('drawer-backdrop');
        const panel = document.getElementById('drawer-panel');
        
        if (!drawer || !backdrop || !panel) return;

        if (drawer.classList.contains('hidden')) {
            // Open
            drawer.classList.remove('hidden');
            drawer.classList.add('flex');
            
            // Force reflow for transitions
            void drawer.offsetWidth;
            
            backdrop.classList.replace('opacity-0', 'opacity-100');
            panel.classList.replace('-translate-x-full', 'translate-x-0');
            document.body.style.overflow = 'hidden';
        } else {
            // Close
            backdrop.classList.replace('opacity-100', 'opacity-0');
            panel.classList.replace('translate-x-0', '-translate-x-full');
            document.body.style.overflow = '';
            
            // Wait for transition then hide
            setTimeout(() => {
                drawer.classList.add('hidden');
                drawer.classList.remove('flex');
            }, 300);
        }
    };

    function applySubcategory(sub) {
        // Find all subcategory inputs and update them
        const inputs = document.querySelectorAll('input[name="subcategory"]');
        inputs.forEach(input => input.value = sub);
        
        // Submit the main form
        document.getElementById('search-form-sidebar').submit();
    }

    // Clone sidebar into mobile drawer on load
    document.addEventListener('DOMContentLoaded', function() {
        const sidebarForm = document.getElementById('search-form-sidebar');
        const mobileContainer = document.getElementById('mobile-drawer-content');
        
        if (sidebarForm && mobileContainer) {
            const clone = sidebarForm.cloneNode(true);
            clone.id = 'mobile-drawer-form';
            // Show hidden parts if any
            clone.querySelectorAll('.hidden').forEach(el => {
                if(!el.tagName.toLowerCase() === 'select') el.classList.remove('hidden');
            });
            mobileContainer.appendChild(clone);
            
            // Re-bind events for the cloned form if necessary
            // In modern browsers, most things work, but let's ensure location picker still works
        }
        
        // Location display sync and initial input sync
        const saved = localStorage.getItem('yilick_location');
        const urlLocation = "<?php echo e($filters['location'] ?? ''); ?>";
        const location = urlLocation || saved || 'All Uganda';
        
        updateSearchLocationDisplay(location);
        
        // Initial sync of location inputs
        document.querySelectorAll('input[name="location"]').forEach(input => {
            input.value = location === 'All Uganda' ? '' : location;
        });
        
        // Enhanced search input interactions
        const mainSearchInput = document.getElementById('main-search-input');
        const clearBtn = document.getElementById('clear-search-btn');
        const quickSuggestions = document.getElementById('quick-suggestions');
        
        if (mainSearchInput) {
            // Show/hide clear button based on input value
            const toggleClearBtn = () => {
                if (clearBtn) {
                    if (mainSearchInput.value.length > 0) {
                        clearBtn.classList.remove('hidden');
                        clearBtn.classList.add('flex');
                    } else {
                        clearBtn.classList.add('hidden');
                        clearBtn.classList.remove('flex');
                    }
                }
            };
            
            mainSearchInput.addEventListener('input', toggleClearBtn);
            toggleClearBtn(); // Initial check
            
            // Show quick suggestions on focus (when empty)
            mainSearchInput.addEventListener('focus', () => {
                if (quickSuggestions && mainSearchInput.value.length === 0) {
                    quickSuggestions.classList.remove('hidden');
                    quickSuggestions.classList.add('flex');
                }
            });
            
            // Hide quick suggestions on blur (with delay to allow click)
            mainSearchInput.addEventListener('blur', () => {
                setTimeout(() => {
                    if (quickSuggestions) {
                        quickSuggestions.classList.add('hidden');
                        quickSuggestions.classList.remove('flex');
                    }
                }, 200);
            });
        }
    });

    // Sync search input across all forms
    document.querySelectorAll('input[name="q"]').forEach(input => {
        input.addEventListener('input', function() {
            const val = this.value;
            document.querySelectorAll('input[name="q"]').forEach(other => {
                if (other !== this) other.value = val;
            });
        });
    });

    function updateSearchLocationDisplay(location) {
        const textTop = document.getElementById('search-location-text-top');
        if (textTop) textTop.textContent = location;
    }

    // Checkbox Modal Logic
    let currentFieldName = '';
    
    window.openCheckboxModal = function(fieldName, options) {
        currentFieldName = fieldName;
        const modal = document.getElementById('checkbox-modal');
        const title = document.getElementById('modal-field-title');
        const list = document.getElementById('modal-options-list');
        const hiddenInput = document.getElementById('custom-hidden-' + fieldName.toLowerCase().replace(/\s+/g, '-'));
        const selected = (hiddenInput?.value || '').split(',').filter(v => v);

        title.textContent = fieldName;
        list.innerHTML = '';

        options.forEach(opt => {
            const isChecked = selected.includes(opt);
            const id = 'opt-' + Math.random().toString(36).substr(2, 9);
            list.innerHTML += `
                <label for="${id}" class="flex items-center gap-3 p-3 rounded-2xl border ${isChecked ? 'border-primary bg-primary/5' : 'border-gray-100 bg-white shadow-sm'} cursor-pointer hover:border-primary/50 transition-all group">
                    <div class="relative flex items-center justify-center">
                        <input type="checkbox" id="${id}" value="${opt}" ${isChecked ? 'checked' : ''} 
                               class="peer appearance-none w-5 h-5 rounded-lg border-2 border-gray-200 checked:border-primary checked:bg-primary transition-all">
                        <i class="fa-solid fa-check text-[10px] text-white absolute opacity-0 peer-checked:opacity-100 transition-opacity"></i>
                    </div>
                    <span class="text-sm font-bold ${isChecked ? 'text-primary' : 'text-gray-600 group-hover:text-gray-900'} transition-colors">${opt}</span>
                </label>
            `;
        });

        modal.classList.remove('hidden');
        modal.classList.add('flex');
        document.body.style.overflow = 'hidden';
    };

    window.closeCheckboxModal = function() {
        const modal = document.getElementById('checkbox-modal');
        modal.classList.add('hidden');
        modal.classList.remove('flex');
        document.body.style.overflow = '';
    };

    window.clearModalCheckboxes = function() {
        document.querySelectorAll('#modal-options-list input[type="checkbox"]').forEach(cb => cb.checked = false);
    };

    window.saveCheckboxSelection = function() {
        const selected = Array.from(document.querySelectorAll('#modal-options-list input[type="checkbox"]:checked')).map(cb => cb.value);
        const fieldSlug = currentFieldName.toLowerCase().replace(/\s+/g, '-');
        const hiddenInput = document.getElementById('custom-hidden-' + fieldSlug);
        
        if (hiddenInput) {
            hiddenInput.value = selected.join(',');
        }
        
        closeCheckboxModal();
        
        // Find the button to update its text
        const buttons = document.querySelectorAll('button[onclick*="openCheckboxModal"]');
        buttons.forEach(btn => {
            if (btn.getAttribute('onclick').includes(currentFieldName)) {
                const span = btn.querySelector('span');
                const checkIcon = btn.querySelector('.fa-circle-check');
                if (selected.length > 0) {
                    span.textContent = selected.length + ' selected';
                    span.classList.add('text-primary', 'font-bold');
                    if (!checkIcon) {
                        const iconContainer = btn.querySelector('.flex');
                        const newIcon = document.createElement('i');
                        newIcon.className = 'fa-solid fa-circle-check text-primary text-[10px]';
                        iconContainer.insertBefore(newIcon, iconContainer.firstChild);
                    }
                } else {
                    span.textContent = 'Multi-select...';
                    span.classList.remove('text-primary', 'font-bold');
                    if (checkIcon) checkIcon.remove();
                }
            }
        });
    };

    // Location selection wiring
    const originalSelectLocation = window.selectLocation;
    window.selectLocation = function(location) {
        const normalizedLocation = location === 'All Uganda' ? '' : location;
        
        // Update all location inputs
        document.querySelectorAll('input[name="location"]').forEach(input => {
            input.value = normalizedLocation;
        });
        
        updateSearchLocationDisplay(location);
        
        // Call original to update storage and header
        if (typeof originalSelectLocation === 'function') {
            originalSelectLocation(location);
        } else {
            localStorage.setItem('yilick_location', location);
            const headerText = document.getElementById('desktop-location-text') || document.getElementById('mobile-location-text');
            if (headerText) headerText.textContent = location;
            closeLocationModal();
        }
        
        // Auto-submit the primary form
        if (sidebarForm) {
            sidebarForm.submit();
        } else {
            document.getElementById('search-form-top').submit();
        }
    };

    // Toast Notification System
    window.showToast = function(message, type = 'success', duration = 4000) {
        const container = document.getElementById('toast-container');
        if (!container) return;
        
        const toast = document.createElement('div');
        toast.className = 'toast-enter pointer-events-auto flex items-center gap-3 px-5 py-4 rounded-2xl shadow-2xl backdrop-blur-md max-w-sm';
        
        // Style based on type
        const styles = {
            success: 'bg-emerald-500/95 text-white',
            error: 'bg-red-500/95 text-white',
            info: 'bg-primary/95 text-white',
            warning: 'bg-amber-500/95 text-white'
        };
        
        const icons = {
            success: 'fa-circle-check',
            error: 'fa-circle-xmark',
            info: 'fa-circle-info',
            warning: 'fa-triangle-exclamation'
        };
        
        toast.classList.add(...(styles[type] || styles.info).split(' '));
        
        toast.innerHTML = `
            <div class="w-8 h-8 rounded-full bg-white/20 flex items-center justify-center flex-shrink-0">
                <i class="fa-solid ${icons[type] || icons.info}"></i>
            </div>
            <p class="text-sm font-semibold flex-1">${message}</p>
            <button onclick="this.parentElement.remove()" class="w-6 h-6 rounded-full hover:bg-white/20 flex items-center justify-center transition-colors">
                <i class="fa-solid fa-xmark text-xs"></i>
            </button>
        `;
        
        container.appendChild(toast);
        
        // Auto remove
        setTimeout(() => {
            toast.classList.remove('toast-enter');
            toast.classList.add('toast-exit');
            setTimeout(() => toast.remove(), 300);
        }, duration);
    };
    
    // Enhanced Save Current Search with toast and button states
    window.saveCurrentSearch = function() {
        const btn = document.getElementById('save-search-btn');
        const icon = document.getElementById('save-search-icon');
        const text = document.getElementById('save-search-text');
        
        // Disable button and show loading state
        if (btn) {
            btn.disabled = true;
            btn.classList.add('opacity-70', 'cursor-wait');
        }
        if (icon) {
            icon.classList.remove('fa-regular', 'fa-heart');
            icon.classList.add('fa-solid', 'fa-spinner', 'fa-spin');
        }
        if (text) text.textContent = 'Saving...';
        
        const params = new URLSearchParams(window.location.search);
        const data = Object.fromEntries(params.entries());

        fetch('<?php echo e(route('web.favorites.save-search')); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify(data)
        })
        .then(res => res.json())
        .then(response => {
            // Reset button state
            if (btn) {
                btn.disabled = false;
                btn.classList.remove('opacity-70', 'cursor-wait');
            }
            
            if (response.status === 'success') {
                // Show filled heart with animation
                if (icon) {
                    icon.classList.remove('fa-spinner', 'fa-spin');
                    icon.classList.add('fa-heart', 'heart-saved');
                    // Already solid from loading state
                }
                if (text) text.textContent = 'Saved!';
                showToast(response.message || 'Search saved to favorites!', 'success');
                
                // Reset to normal state after delay
                setTimeout(() => {
                    if (icon) {
                        icon.classList.remove('heart-saved', 'fa-solid');
                        icon.classList.add('fa-regular');
                    }
                    if (text) text.textContent = 'Save';
                }, 3000);
            } else if (response.status === 'info') {
                // Already saved
                if (icon) {
                    icon.classList.remove('fa-spinner', 'fa-spin');
                    icon.classList.add('fa-heart');
                }
                if (text) text.textContent = 'Already Saved';
                showToast(response.message || 'Search already in favorites', 'info');
                
                setTimeout(() => {
                    if (icon) {
                        icon.classList.remove('fa-solid');
                        icon.classList.add('fa-regular');
                    }
                    if (text) text.textContent = 'Save';
                }, 2000);
            } else {
                // Error state
                if (icon) {
                    icon.classList.remove('fa-spinner', 'fa-spin', 'fa-solid');
                    icon.classList.add('fa-regular', 'fa-heart');
                }
                if (text) text.textContent = 'Save';
                showToast(response.message || 'Something went wrong', 'error');
            }
        })
        .catch(err => {
            console.error(err);
            // Reset button state
            if (btn) {
                btn.disabled = false;
                btn.classList.remove('opacity-70', 'cursor-wait');
            }
            if (icon) {
                icon.classList.remove('fa-spinner', 'fa-spin', 'fa-solid');
                icon.classList.add('fa-regular', 'fa-heart');
            }
            if (text) text.textContent = 'Save';
            showToast('Failed to save search. Please try again.', 'error');
        });
    };
    
    // Quick Search Helper
    window.applyQuickSearch = function(term) {
        const input = document.getElementById('main-search-input');
        if (input) {
            input.value = term;
            document.getElementById('search-form-top').submit();
        }
    };
    
    // Clear Search Input
    window.clearSearchInput = function() {
        const input = document.getElementById('main-search-input');
        const clearBtn = document.getElementById('clear-search-btn');
        if (input) {
            input.value = '';
            input.focus();
        }
        if (clearBtn) {
            clearBtn.classList.add('hidden');
            clearBtn.classList.remove('flex');
        }
    };
    
    // Sidebar Save Search (same functionality, different button)
    window.saveCurrentSearchSidebar = function() {
        const btn = document.getElementById('sidebar-save-btn');
        const icon = document.getElementById('sidebar-save-icon');
        const text = document.getElementById('sidebar-save-text');
        
        // Disable button and show loading state
        if (btn) {
            btn.disabled = true;
            btn.classList.add('opacity-70');
        }
        if (icon) {
            icon.classList.remove('fa-regular', 'fa-heart');
            icon.classList.add('fa-solid', 'fa-spinner', 'fa-spin');
        }
        if (text) text.textContent = 'Saving...';
        
        const params = new URLSearchParams(window.location.search);
        const data = Object.fromEntries(params.entries());

        fetch('<?php echo e(route('web.favorites.save-search')); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify(data)
        })
        .then(res => res.json())
        .then(response => {
            if (btn) {
                btn.disabled = false;
                btn.classList.remove('opacity-70');
            }
            
            if (response.status === 'success') {
                if (icon) {
                    icon.classList.remove('fa-spinner', 'fa-spin');
                    icon.classList.add('fa-heart', 'heart-saved');
                }
                if (text) text.textContent = 'Saved!';
                showToast(response.message || 'Search saved to favorites!', 'success');
                
                setTimeout(() => {
                    if (icon) {
                        icon.classList.remove('heart-saved', 'fa-solid');
                        icon.classList.add('fa-regular');
                    }
                    if (text) text.textContent = 'Save';
                }, 3000);
            } else if (response.status === 'info') {
                if (icon) {
                    icon.classList.remove('fa-spinner', 'fa-spin');
                    icon.classList.add('fa-heart');
                }
                if (text) text.textContent = 'Saved';
                showToast(response.message || 'Search already in favorites', 'info');
                
                setTimeout(() => {
                    if (icon) {
                        icon.classList.remove('fa-solid');
                        icon.classList.add('fa-regular');
                    }
                    if (text) text.textContent = 'Save';
                }, 2000);
            } else {
                if (icon) {
                    icon.classList.remove('fa-spinner', 'fa-spin', 'fa-solid');
                    icon.classList.add('fa-regular', 'fa-heart');
                }
                if (text) text.textContent = 'Save';
                showToast(response.message || 'Something went wrong', 'error');
            }
        })
        .catch(err => {
            console.error(err);
            if (btn) {
                btn.disabled = false;
                btn.classList.remove('opacity-70');
            }
            if (icon) {
                icon.classList.remove('fa-spinner', 'fa-spin', 'fa-solid');
                icon.classList.add('fa-regular', 'fa-heart');
            }
            if (text) text.textContent = 'Save';
            showToast('Failed to save search. Please try again.', 'error');
        });
    };
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/web/search.blade.php ENDPATH**/ ?>