<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>404 - Page Not Found | Yilick</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Outfit', sans-serif;
        }
        .animate-float {
            animation: float 6s ease-in-out infinite;
        }
        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-20px); }
        }
    </style>
</head>
<body class="bg-emerald-50/30 min-h-screen flex items-center justify-center p-6">
    <div class="max-w-xl w-full text-center space-y-8">
        <!-- Visual Element -->
        <div class="relative inline-block">
            <div class="text-[120px] sm:text-[180px] font-black text-emerald-100 leading-none select-none">404</div>
            <div class="absolute inset-0 flex items-center justify-center">
                <div class="bg-white rounded-3xl shadow-2xl shadow-emerald-200/50 p-6 sm:p-8 animate-float">
                    <i class="fa-solid fa-compass-slash text-5xl sm:text-6xl text-emerald-600"></i>
                </div>
            </div>
        </div>

        <!-- Text Content -->
        <div class="space-y-4">
            <h1 class="text-3xl sm:text-4xl font-extrabold text-gray-900 tracking-tight">Oops! We're Lost.</h1>
            <p class="text-gray-600 text-lg max-w-md mx-auto leading-relaxed">
                The page you're looking for seems to have vanished or moved to a new destination.
            </p>
        </div>

        <!-- Main Actions -->
        <div class="flex flex-col sm:flex-row items-center justify-center gap-4">
            <a href="<?php echo e(url('/')); ?>" class="w-full sm:w-auto px-10 py-4 bg-emerald-600 text-white font-bold rounded-2xl shadow-xl shadow-emerald-200 hover:bg-emerald-700 hover:shadow-emerald-300 transition-all transform hover:-translate-y-1 active:scale-95 flex items-center justify-center gap-2">
                <i class="fa-solid fa-house text-sm"></i>
                Back to Home
            </a>
            <button onclick="history.back()" class="w-full sm:w-auto px-10 py-4 bg-white text-emerald-700 font-bold rounded-2xl border-2 border-emerald-100 shadow-sm hover:border-emerald-200 hover:bg-emerald-50 transition-all flex items-center justify-center gap-2">
                <i class="fa-solid fa-arrow-left text-sm"></i>
                Go Back
            </button>
        </div>

        <!-- Secondary Help Links -->
        <div class="pt-8 border-t border-emerald-100/50">
            <p class="text-sm font-bold text-gray-400 uppercase tracking-widest mb-4">Try these instead</p>
            <div class="flex flex-wrap justify-center gap-x-6 gap-y-3">
                <a href="<?php echo e(route('listing.search')); ?>" class="text-emerald-600 font-semibold hover:text-emerald-700 transition-colors flex items-center gap-1.5">
                    <i class="fa-solid fa-magnifying-glass text-xs"></i>
                    Search Ads
                </a>
                <a href="<?php echo e(route('web.help-center')); ?>" class="text-emerald-600 font-semibold hover:text-emerald-700 transition-colors flex items-center gap-1.5">
                    <i class="fa-solid fa-circle-question text-xs"></i>
                    Help Center
                </a>
                <a href="<?php echo e(route('web.home')); ?>#trending" class="text-emerald-600 font-semibold hover:text-emerald-700 transition-colors flex items-center gap-1.5">
                    <i class="fa-solid fa-fire text-xs"></i>
                    Popular Deals
                </a>
            </div>
        </div>

        <!-- Branding -->
        <div class="pt-8">
            <span class="text-gray-400 text-sm font-medium">&copy; <?php echo e(date('Y')); ?> Yilick. All rights reserved.</span>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/yilickapp/website/resources/views/errors/404.blade.php ENDPATH**/ ?>