<?php $__env->startSection('title', 'Business Registry'); ?>
<?php $__env->startSection('header_title', 'Business Registry'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Filters & Search -->
    <div class="bg-white p-6 rounded-3xl border border-gray-100 shadow-sm">
        <form action="<?php echo e(route('admin.businesses.index')); ?>" method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div class="md:col-span-2">
                <div class="relative">
                    <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="Search by business name, email, or phone..." 
                           class="w-full pl-10 pr-4 py-2.5 rounded-xl border border-gray-200 focus:border-primary focus:ring-2 focus:ring-primary/10 outline-none text-sm transition-all">
                    <i class="fa-solid fa-search absolute left-3.5 top-1/2 -translate-y-1/2 text-gray-400"></i>
                </div>
            </div>
            
            <div>
                <select name="status" class="w-full px-4 py-2.5 rounded-xl border border-gray-200 focus:border-primary outline-none text-sm bg-white">
                    <option value="">All Verification Status</option>
                    <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                    <option value="verified" <?php echo e(request('status') == 'verified' ? 'selected' : ''); ?>>Verified</option>
                    <option value="rejected" <?php echo e(request('status') == 'rejected' ? 'selected' : ''); ?>>Rejected</option>
                    <option value="unverified" <?php echo e(request('status') == 'unverified' ? 'selected' : ''); ?>>Unverified</option>
                </select>
            </div>
            
            <div class="flex gap-2">
                <button type="submit" class="flex-1 bg-primary text-white py-2.5 rounded-xl font-bold text-sm hover:bg-emerald-600 transition-all flex items-center justify-center gap-2">
                    <i class="fa-solid fa-filter"></i>
                    Filter
                </button>
                <a href="<?php echo e(route('admin.businesses.index')); ?>" class="px-4 py-2.5 bg-gray-100 text-gray-600 rounded-xl font-bold text-sm hover:bg-gray-200 transition-all flex items-center justify-center">
                    <i class="fa-solid fa-rotate-left"></i>
                </a>
            </div>
        </form>
    </div>

    <!-- Businesses Table -->
    <div class="bg-white rounded-3xl border border-gray-100 shadow-sm overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full text-left text-sm">
                <thead class="bg-gray-50 text-[10px] font-black uppercase text-gray-400">
                    <tr>
                        <th class="px-6 py-4">Business</th>
                        <th class="px-6 py-4">Owner</th>
                        <th class="px-6 py-4">Category</th>
                        <th class="px-6 py-4">Status</th>
                        <th class="px-6 py-4 text-right">Action</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-50">
                    <?php $__empty_1 = true; $__currentLoopData = $businesses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $business): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50 transition-all">
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 rounded-xl bg-emerald-50 text-emerald-600 flex items-center justify-center font-bold">
                                        <?php echo e(substr($business->name, 0, 1)); ?>

                                    </div>
                                    <div>
                                        <div class="font-bold text-gray-800"><?php echo e($business->name); ?></div>
                                        <div class="text-[10px] font-medium text-gray-400 uppercase"><?php echo e($business->phone); ?></div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <a href="<?php echo e(route('admin.users.show', $business->owner)); ?>" class="font-medium text-gray-700 hover:text-primary hover:underline">
                                    <?php echo e($business->owner->full_name); ?>

                                </a>
                            </td>
                            <td class="px-6 py-4 text-gray-500 font-medium">
                                <?php echo e($business->business_category); ?>

                            </td>
                            <td class="px-6 py-4">
                                <span class="px-3 py-1 rounded-full text-[10px] font-black uppercase tracking-wider <?php echo e($business->verification_status === 'verified' ? 'bg-emerald-50 text-emerald-600' : ($business->verification_status === 'pending' ? 'bg-orange-50 text-orange-600' : 'bg-gray-50 text-gray-500')); ?>">
                                    <?php echo e($business->verification_status); ?>

                                </span>
                            </td>
                            <td class="px-6 py-4 text-right">
                                <a href="<?php echo e(route('admin.businesses.show', $business)); ?>" class="p-2 text-gray-400 hover:text-primary hover:bg-primary/5 rounded-lg transition-all" title="View Details">
                                    <i class="fa-solid fa-eye"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="px-6 py-12 text-center text-gray-400">
                                <i class="fa-solid fa-store text-4xl mb-4 opacity-20"></i>
                                <p class="text-sm font-medium">No businesses found.</p>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        <?php if($businesses->hasPages()): ?>
            <div class="px-6 py-4 bg-gray-50 border-t border-gray-100">
                <?php echo e($businesses->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/admin/businesses/index.blade.php ENDPATH**/ ?>