<?php $__env->startSection('title', 'User Details'); ?>
<?php $__env->startSection('header_title', 'User Profile: ' . $user->full_name); ?>

<?php $__env->startSection('content'); ?>
<div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
    <!-- Profile Info -->
    <div class="lg:col-span-1 space-y-6">
        <div class="bg-white rounded-3xl border border-gray-100 shadow-sm p-8 text-center">
            <div class="w-32 h-32 rounded-3xl bg-gray-100 mx-auto mb-6 flex items-center justify-center text-gray-400 text-4xl font-bold overflow-hidden ring-4 ring-gray-50">
                <?php if($user->profile_photo): ?>
                    <img src="<?php echo e($user->profile_photo_url); ?>" class="w-full h-full object-cover">
                <?php else: ?>
                    <?php echo e(substr($user->full_name, 0, 1)); ?>

                <?php endif; ?>
            </div>
            <h2 class="text-xl font-black text-gray-800"><?php echo e($user->full_name); ?></h2>
            <p class="text-sm text-gray-400 font-medium uppercase tracking-widest mt-1"><?php echo e($user->role); ?></p>
            
            <div class="mt-6 flex items-center justify-center gap-2">
                <span class="px-3 py-1 rounded-full text-xs font-black uppercase <?php echo e($user->status === 'active' ? 'bg-emerald-50 text-emerald-600' : 'bg-red-50 text-red-600'); ?>">
                    <?php echo e($user->status); ?>

                </span>
                <?php if($user->email_verified_at): ?>
                    <span class="px-3 py-1 rounded-full bg-blue-50 text-blue-600 text-xs font-black uppercase" title="Email Verified">
                        <i class="fa-solid fa-envelope-circle-check"></i>
                    </span>
                <?php endif; ?>
            </div>
        </div>

        <!-- Management Actions -->
        <div class="bg-white rounded-3xl border border-gray-100 shadow-sm p-6 space-y-6">
            <h3 class="font-bold text-gray-800 flex items-center gap-2">
                <i class="fa-solid fa-user-gear text-primary"></i>
                Account Management
            </h3>

            <!-- Status Form -->
            <form action="<?php echo e(route('admin.users.update-status', $user)); ?>" method="POST" class="space-y-3">
                <?php echo csrf_field(); ?>
                <label class="text-[10px] font-black uppercase text-gray-400">Change Account Status</label>
                <div class="flex gap-2">
                    <select name="status" class="flex-1 bg-gray-50 border border-gray-100 rounded-xl px-4 py-2 text-sm font-semibold outline-none focus:ring-2 focus:ring-primary/10">
                        <option value="active" <?php echo e($user->status === 'active' ? 'selected' : ''); ?>>Activate Account</option>
                        <option value="suspended" <?php echo e($user->status === 'suspended' ? 'selected' : ''); ?>>Suspend Account</option>
                    </select>
                    <button type="submit" class="bg-gray-800 text-white px-4 rounded-xl hover:bg-gray-900 transition-all">
                        <i class="fa-solid fa-check"></i>
                    </button>
                </div>
            </form>

            <div class="border-t border-gray-50 my-6"></div>

            <!-- Role Form -->
            <form action="<?php echo e(route('admin.users.update-role', $user)); ?>" method="POST" class="space-y-3">
                <?php echo csrf_field(); ?>
                <label class="text-[10px] font-black uppercase text-gray-400">Update User Role</label>
                <div class="flex gap-2">
                    <select name="role" class="flex-1 bg-gray-50 border border-gray-100 rounded-xl px-4 py-2 text-sm font-semibold outline-none focus:ring-2 focus:ring-primary/10">
                        <option value="user" <?php echo e($user->role === 'user' ? 'selected' : ''); ?>>Standard User</option>
                        <option value="seller" <?php echo e($user->role === 'seller' ? 'selected' : ''); ?>>Professional Seller</option>
                        <option value="admin" <?php echo e($user->role === 'admin' ? 'selected' : ''); ?>>Administrator</option>
                    </select>
                    <button type="submit" class="bg-gray-800 text-white px-4 rounded-xl hover:bg-gray-900 transition-all">
                        <i class="fa-solid fa-check"></i>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Details Content -->
    <div class="lg:col-span-2 space-y-8">
        <!-- Contact & Security -->
        <div class="bg-white rounded-3xl border border-gray-100 shadow-sm p-8 grid grid-cols-1 md:grid-cols-2 gap-8">
            <div>
                <h3 class="font-bold text-gray-800 mb-4">Contact Information</h3>
                <div class="space-y-4">
                    <div class="flex items-center gap-4">
                        <div class="w-10 h-10 rounded-xl bg-gray-50 flex items-center justify-center text-gray-400">
                            <i class="fa-solid fa-envelope"></i>
                        </div>
                        <div>
                            <div class="text-[10px] font-black uppercase text-gray-400">Email Address</div>
                            <div class="text-sm font-bold text-gray-700"><?php echo e($user->email); ?></div>
                        </div>
                    </div>
                    <div class="flex items-center gap-4">
                        <div class="w-10 h-10 rounded-xl bg-gray-50 flex items-center justify-center text-gray-400">
                            <i class="fa-solid fa-phone"></i>
                        </div>
                        <div>
                            <div class="text-[10px] font-black uppercase text-gray-400">Phone Number</div>
                            <div class="text-sm font-bold text-gray-700"><?php echo e($user->phone ?? 'Not provided'); ?></div>
                        </div>
                    </div>
                </div>
            </div>

            <div>
                <h3 class="font-bold text-gray-800 mb-4">System Metadata</h3>
                <div class="space-y-4">
                    <div class="flex items-center gap-4">
                        <div class="w-10 h-10 rounded-xl bg-gray-50 flex items-center justify-center text-gray-400">
                            <i class="fa-solid fa-calendar"></i>
                        </div>
                        <div>
                            <div class="text-[10px] font-black uppercase text-gray-400">Registered On</div>
                            <div class="text-sm font-bold text-gray-700"><?php echo e($user->created_at->format('M d, Y @ H:i')); ?></div>
                        </div>
                    </div>
                    <div class="flex items-center gap-4">
                        <div class="w-10 h-10 rounded-xl bg-gray-50 flex items-center justify-center text-gray-400">
                            <i class="fa-solid fa-hashtag"></i>
                        </div>
                        <div>
                            <div class="text-[10px] font-black uppercase text-gray-400">System ID</div>
                            <div class="text-sm font-bold text-gray-700">#<?php echo e($user->id); ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Linked Businesses -->
        <div class="bg-white rounded-3xl border border-gray-100 shadow-sm overflow-hidden">
            <div class="px-8 py-5 border-b border-gray-50 flex items-center justify-between">
                <h3 class="font-bold text-gray-800">Owned Businesses</h3>
                <span class="bg-gray-100 text-gray-600 px-3 py-1 rounded-full text-[10px] font-black"><?php echo e($user->ownedBusinesses->count()); ?></span>
            </div>
            <?php if($user->ownedBusinesses->isNotEmpty()): ?>
                <div class="divide-y divide-gray-50">
                    <?php $__currentLoopData = $user->ownedBusinesses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $business): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="px-8 py-4 flex items-center justify-between">
                            <div class="flex items-center gap-4">
                                <a href="<?php echo e(route('admin.businesses.show', $business)); ?>" class="flex items-center gap-4 group hover:opacity-75 transition-opacity">
                                    <div class="w-10 h-10 rounded-xl bg-emerald-50 text-emerald-600 flex items-center justify-center font-bold group-hover:bg-emerald-100 transition-colors">
                                        <?php echo e(substr($business->name, 0, 1)); ?>

                                    </div>
                                    <div>
                                        <div class="font-bold text-gray-800 group-hover:text-primary transition-colors"><?php echo e($business->name); ?></div>
                                        <div class="text-[10px] font-medium text-gray-400 uppercase"><?php echo e($business->business_category); ?></div>
                                    </div>
                                </a>
                            </div>
                            <div class="flex items-center gap-3">
                                <span class="px-2 py-0.5 rounded text-[9px] font-black uppercase tracking-wider <?php echo e($business->verification_status === 'verified' ? 'bg-emerald-50 text-emerald-600' : 'bg-orange-50 text-orange-600'); ?>">
                                    <?php echo e($business->verification_status); ?>

                                </span>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="px-8 py-10 text-center text-gray-400">
                    <p class="text-sm font-medium">This user does not own any businesses.</p>
                </div>
            <?php endif; ?>
        </div>

        <!-- Active Listings -->
        <div class="bg-white rounded-3xl border border-gray-100 shadow-sm overflow-hidden">
            <div class="px-8 py-5 border-b border-gray-50 flex items-center justify-between">
                <h3 class="font-bold text-gray-800">Recent Ads</h3>
                <span class="bg-gray-100 text-gray-600 px-3 py-1 rounded-full text-[10px] font-black tracking-widest"><?php echo e($user->createdListings->count()); ?> TOTAL</span>
            </div>
            <?php if($user->createdListings->isNotEmpty()): ?>
                <div class="divide-y divide-gray-50">
                    <?php $__currentLoopData = $user->createdListings->take(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $listing): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="px-8 py-4 flex items-center justify-between">
                            <div class="flex items-center gap-4">
                                <div class="w-12 h-12 rounded-xl bg-gray-50 overflow-hidden border border-gray-100">
                                    <?php if($listing->thumbnail_url): ?>
                                        <img src="<?php echo e($listing->thumbnail_url); ?>" class="w-full h-full object-cover">
                                    <?php else: ?>
                                        <div class="w-full h-full flex items-center justify-center text-gray-300">
                                            <i class="fa-solid fa-image"></i>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div>
                                    <div class="font-bold text-gray-800 text-sm truncate max-w-[200px]"><?php echo e($listing->title); ?></div>
                                    <div class="text-[10px] font-bold text-primary"><?php echo e(number_format($listing->price_amount)); ?> UGX</div>
                                </div>
                            </div>
                            <div class="text-right">
                                <div class="text-[10px] font-black uppercase px-2 py-0.5 rounded <?php echo e($listing->status === 'published' ? 'bg-emerald-50 text-emerald-600' : 'bg-gray-50 text-gray-400'); ?>">
                                    <?php echo e($listing->status); ?>

                                </div>
                                <div class="text-[10px] text-gray-400 mt-1"><?php echo e($listing->created_at->format('M d, Y')); ?></div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="px-8 py-10 text-center text-gray-400">
                    <p class="text-sm font-medium">This user has not posted any ads yet.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/yilickapp/website/resources/views/admin/users/show.blade.php ENDPATH**/ ?>