<?= '<?xml version="1.0" encoding="UTF-8"?>' ?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
    <!-- Static Pages -->
    <url>
        <loc>{{ route('web.home') }}</loc>
        <lastmod>{{ now()->format('Y-m-d') }}</lastmod>
        <changefreq>daily</changefreq>
        <priority>1.0</priority>
    </url>
    <url>
        <loc>{{ route('web.about') }}</loc>
        <changefreq>monthly</changefreq>
        <priority>0.8</priority>
    </url>
    <url>
        <loc>{{ route('listing.hot-deals') }}</loc>
        <changefreq>hourly</changefreq>
        <priority>0.9</priority>
    </url>
    <url>
        <loc>{{ route('web.download') }}</loc>
        <changefreq>monthly</changefreq>
        <priority>0.7</priority>
    </url>
    <url>
        <loc>{{ route('web.blog') }}</loc>
        <changefreq>daily</changefreq>
        <priority>0.9</priority>
    </url>

    <!-- Blog Posts -->
    @foreach ($blogPosts as $post)
    <url>
        <loc>{{ route('web.blog.show', $post->slug) }}</loc>
        <lastmod>{{ $post->published_at->format('Y-m-d') }}</lastmod>
        <changefreq>monthly</changefreq>
        <priority>0.8</priority>
    </url>
    @endforeach

    <!-- Category Hubs -->
    @foreach ($categories as $cat)
    <url>
        <loc>{{ route('listing.search', ['category' => $cat['Category']]) }}</loc>
        <changefreq>daily</changefreq>
        <priority>0.9</priority>
    </url>
    @endforeach

    <!-- Subcategory Hubs -->
    @foreach ($subcategories as $sub)
    @php
        // Find parent category name
        $parent = collect($categories)->firstWhere('id', $sub['parent']);
        $parentName = $parent ? $parent['Category'] : '';
    @endphp
    <url>
        <loc>{{ route('listing.search', ['category' => $parentName, 'subcategory' => $sub['Category']]) }}</loc>
        <changefreq>daily</changefreq>
        <priority>0.8</priority>
    </url>
    @endforeach

    <!-- Shops / Businesses -->
    @foreach ($businesses as $business)
    <url>
        <loc>{{ route('business.show', $business->slug) }}</loc>
        <lastmod>{{ $business->updated_at->format('Y-m-d') }}</lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.8</priority>
    </url>
    @endforeach

    <!-- Products / Listings -->
    @foreach ($listings as $listing)
    <url>
        <loc>{{ route('listing.show', $listing->slug) }}</loc>
        <lastmod>{{ $listing->updated_at->format('Y-m-d') }}</lastmod>
        <changefreq>daily</changefreq>
        <priority>0.9</priority>
    </url>
    @endforeach
</urlset>
