@php
    $type = $type ?? 'all';
    $icon = 'fa-envelope-open';
    $title = 'No notifications';
    $message = 'You don\'t have any notifications at the moment.';

    if ($type === 'unread') {
        $icon = 'fa-envelope';
        $title = 'All caught up!';
        $message = 'You have no unread notifications.';
    } elseif ($type === 'read') {
        $icon = 'fa-inbox';
        $title = 'No read notifications';
        $message = 'Notifications you\'ve read will appear here.';
    }
@endphp

<div class="flex flex-col items-center justify-center py-20 text-center animate-in fade-in zoom-in duration-700">
    <div class="w-24 h-24 rounded-3xl bg-white shadow-xl shadow-gray-200/50 flex items-center justify-center text-cool-gray/30 mb-8 border border-gray-50">
        <i class="fa-solid {{ $icon }} text-4xl"></i>
    </div>
    <h3 class="text-xl font-black text-charcoal-gray mb-2">{{ $title }}</h3>
    <p class="text-sm text-cool-gray max-w-sm mx-auto leading-relaxed">
        {{ $message }}
    </p>
    
    <button onclick="location.reload()" class="mt-8 flex items-center gap-2 text-primary font-bold text-xs uppercase tracking-widest hover:underline active:scale-95 transition-all">
        <i class="fa-solid fa-rotate-right text-[10px]"></i>
        <span>Refresh</span>
    </button>
</div>
