@php
    $isRead = $notification->read_at !== null;
    $data = $notification->data;
    $type = $notification->type;
    
    $icon = 'fa-bell';
    $color = 'text-cool-gray';
    $bgColor = 'bg-gray-50';

    if (str_contains($type, 'ad_approved')) {
        $icon = 'fa-circle-check';
        $color = 'text-emerald-500';
        $bgColor = 'bg-emerald-50';
    } elseif (str_contains($type, 'Message') || str_contains($type, 'Chat')) {
        $icon = 'fa-comment-dots';
        $color = 'text-primary';
        $bgColor = 'bg-primary/5';
    }
@endphp

<div onclick="openNotification({{ json_encode([
    'id' => $notification->id,
    'title' => $data['title'] ?? 'Notification',
    'body' => $data['body'] ?? '',
    'time' => $notification->created_at->diffForHumans(),
    'icon' => $icon,
    'color' => $color,
    'bgColor' => $bgColor,
    'unread' => !$isRead
]) }})" class="bg-white rounded-2xl p-4 shadow-sm border border-gray-100 flex items-start gap-4 transition-all hover:bg-gray-50 cursor-pointer relative overflow-hidden group notification-item" data-id="{{ $notification->id }}">
    @if(!$isRead)
        <div class="absolute top-0 right-0 w-2 h-2 bg-primary rounded-bl-xl"></div>
    @endif

    <div class="w-12 h-12 rounded-xl {{ $bgColor }} flex items-center justify-center {{ $color }} flex-shrink-0 group-hover:scale-110 transition-transform">
        <i class="fa-solid {{ $icon }} text-xl"></i>
    </div>

    <div class="flex-1 min-w-0">
        <div class="flex items-center justify-between mb-1">
            <h3 class="font-bold text-sm {{ $isRead ? 'text-cool-gray' : 'text-charcoal-gray' }} truncate">
                {{ $data['title'] ?? 'Notification' }}
            </h3>
            <span class="text-[10px] font-medium text-cool-gray/60 whitespace-nowrap">
                {{ $notification->created_at->diffForHumans() }}
            </span>
        </div>
        <p class="text-xs text-cool-gray leading-relaxed {{ $isRead ? 'opacity-60' : '' }}">
            {{ $data['body'] ?? '' }}
        </p>
    </div>
</div>
