@extends('layouts.app')

@section('title', 'Notifications - Yilick')

@section('content')
<div class="bg-gray-50 min-h-screen pb-12">
    <!-- Header -->
    <div class="bg-white border-b border-gray-100 pt-8 pb-4 sticky top-0 md:static z-30">
        <div class="container mx-auto px-4">
            <div class="max-w-4xl mx-auto flex items-center justify-between">
                <div class="flex items-center gap-4">
                    <a href="{{ route('web.profile') }}" class="w-10 h-10 rounded-xl bg-gray-50 flex items-center justify-center text-cool-gray hover:text-primary transition-colors">
                        <i class="fa-solid fa-chevron-left"></i>
                    </a>
                    <h1 class="text-xl font-black text-charcoal-gray tracking-tight">Notifications</h1>
                </div>

                @if($unreadNotifications->count() > 0)
                    <form action="{{ route('web.notifications.read-all') }}" method="POST">
                        @csrf
                        <button type="submit" class="flex items-center gap-2 px-4 py-2 bg-primary/5 text-primary text-xs font-bold rounded-xl hover:bg-primary hover:text-white transition-all">
                            <i class="fa-solid fa-check-double"></i>
                            <span class="hidden sm:inline">Mark all as read</span>
                        </button>
                    </form>
                @endif
            </div>

            <!-- Tabs (Flutter Style) -->
            <div class="max-w-4xl mx-auto mt-6 flex border-b border-gray-100">
                <button onclick="switchTab('all')" id="tab-all" class="flex-1 py-4 text-sm font-bold transition-all border-b-2 border-primary text-primary">
                    All
                </button>
                <button onclick="switchTab('unread')" id="tab-unread" class="flex-1 py-4 text-sm font-bold transition-all border-b-2 border-transparent text-cool-gray hover:text-charcoal-gray">
                    Unread ({{ $unreadNotifications->count() }})
                </button>
                <button onclick="switchTab('read')" id="tab-read" class="flex-1 py-4 text-sm font-bold transition-all border-b-2 border-transparent text-cool-gray hover:text-charcoal-gray">
                    Read
                </button>
            </div>
        </div>
    </div>

    <div class="container mx-auto px-4 mt-6">
        <div class="max-w-4xl mx-auto">
            <!-- All Notifications -->
            <div id="content-all" class="space-y-3">
                @forelse($allNotifications as $notification)
                    @include('web.partials.notification-card', ['notification' => $notification])
                @empty
                    @include('web.partials.notification-empty')
                @endforelse
                
                <div class="mt-8">
                    {{ $allNotifications->links() }}
                </div>
            </div>

            <!-- Unread Notifications -->
            <div id="content-unread" class="hidden space-y-3">
                @forelse($unreadNotifications as $notification)
                    @include('web.partials.notification-card', ['notification' => $notification])
                @empty
                    @include('web.partials.notification-empty', ['type' => 'unread'])
                @endforelse
            </div>

            <!-- Read Notifications -->
            <div id="content-read" class="hidden space-y-3">
                @forelse($readNotifications as $notification)
                    @include('web.partials.notification-card', ['notification' => $notification])
                @empty
                    @include('web.partials.notification-empty', ['type' => 'read'])
                @endforelse
            </div>
        </div>
    </div>
</div>

<script>
    function switchTab(tab) {
        // Content switching
        document.getElementById('content-all').classList.add('hidden');
        document.getElementById('content-unread').classList.add('hidden');
        document.getElementById('content-read').classList.add('hidden');
        document.getElementById('content-' + tab).classList.remove('hidden');

        // Tab styling
        const tabs = ['all', 'unread', 'read'];
        tabs.forEach(t => {
            const el = document.getElementById('tab-' + t);
            if (t === tab) {
                el.classList.add('border-primary', 'text-primary');
                el.classList.remove('border-transparent', 'text-cool-gray');
            } else {
                el.classList.remove('border-primary', 'text-primary');
                el.classList.add('border-transparent', 'text-cool-gray');
            }
        });
    }

    function openNotification(notification) {
        const modal = document.getElementById('notification-modal');
        const content = document.getElementById('modal-content');
        
        // Populate Modal
        document.getElementById('modal-icon-container').className = `w-16 h-16 rounded-2xl ${notification.bgColor} flex items-center justify-center ${notification.color} mb-6`;
        document.getElementById('modal-icon').className = `fa-solid ${notification.icon} text-3xl`;
        document.getElementById('modal-title').innerText = notification.title;
        document.getElementById('modal-time').innerText = notification.time;
        document.getElementById('modal-body').innerText = notification.body;

        // Show Modal
        modal.classList.remove('hidden');
        setTimeout(() => {
            content.classList.remove('translate-y-full', 'scale-95', 'opacity-0');
            modal.querySelector('.bg-black\\/50').classList.remove('opacity-0');
        }, 10);

        // Mark as Read if unread
        if (notification.unread) {
            markRead(notification.id);
        }
    }

    function closeModal() {
        const modal = document.getElementById('notification-modal');
        const content = document.getElementById('modal-content');
        
        content.classList.add('translate-y-full', 'scale-95', 'opacity-0');
        modal.querySelector('.bg-black\\/50').classList.add('opacity-0');
        
        setTimeout(() => {
            modal.classList.add('hidden');
        }, 300);
    }

    function markRead(id) {
        fetch(`/notifications/${id}/read`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Accept': 'application/json'
            }
        }).then(response => {
            if (response.ok) {
                // Update UI dynamically
                const items = document.querySelectorAll(`.notification-item[data-id="${id}"]`);
                items.forEach(item => {
                    // Remove unread dot
                    const dot = item.querySelector('.bg-primary');
                    if (dot) dot.remove();
                    
                    // Gray out text
                    item.querySelector('h3').classList.remove('text-charcoal-gray');
                    item.querySelector('h3').classList.add('text-cool-gray');
                    item.querySelector('p').classList.add('opacity-60');
                });
            }
        });
    }
</script>

<!-- Notification Modal -->
<div id="notification-modal" class="fixed inset-0 z-[100] hidden">
    <!-- Backdrop -->
    <div onclick="closeModal()" class="absolute inset-0 bg-black/50 backdrop-blur-sm opacity-0 transition-opacity duration-300"></div>
    
    <!-- Modal Content -->
    <div class="absolute inset-x-0 bottom-0 md:inset-0 md:flex md:items-center md:justify-center p-4">
        <div id="modal-content" class="bg-white w-full max-w-lg rounded-t-[32px] md:rounded-[32px] p-8 shadow-2xl transform translate-y-full scale-95 opacity-0 md:translate-y-0 transition-all duration-300">
            <!-- Pull Handle for Mobile -->
            <div class="md:hidden w-12 h-1 bg-gray-200 rounded-full mx-auto -mt-4 mb-8"></div>
            
            <div class="flex flex-col items-center text-center">
                <div id="modal-icon-container">
                    <i id="modal-icon"></i>
                </div>
                
                <h2 id="modal-title" class="text-xl font-black text-charcoal-gray mb-1"></h2>
                <p id="modal-time" class="text-[10px] font-bold text-cool-gray/50 uppercase tracking-widest mb-6"></p>
                
                <div class="w-full bg-gray-50 rounded-2xl p-6 mb-8">
                    <p id="modal-body" class="text-sm text-cool-gray leading-relaxed text-left"></p>
                </div>
                
                <button onclick="closeModal()" class="w-full py-4 bg-charcoal-gray text-white font-bold rounded-2xl hover:bg-black transition-all active:scale-95 shadow-lg">
                    Got it, thanks!
                </button>
            </div>
        </div>
    </div>
</div>
@endsection
