@extends('layouts.app')

@section('title', 'My Ads - Yilick')

@section('content')
<div class="bg-gray-50 min-h-screen pb-20">
    <!-- Premium Hero Header -->
    <div class="relative bg-gradient-to-br from-[#064e3b] via-[#059669] to-[#0d9488] overflow-hidden pt-24 pb-28 md:pt-32 md:pb-40">
        <!-- Abstract Background Decorative Elements -->
        <div class="absolute inset-0 overflow-hidden pointer-events-none">
            <div class="absolute top-0 right-0 w-[500px] h-[500px] bg-white/10 rounded-full blur-[120px] -mr-48 -mt-48"></div>
            <div class="absolute bottom-0 left-0 w-[400px] h-[400px] bg-white/10 rounded-full blur-[100px] -ml-32 -mb-32"></div>
            <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-full h-full opacity-[0.05]" style="background-image: url('data:image/svg+xml,%3Csvg width=\"60\" height=\"60\" viewBox=\"0 0 60 60\" xmlns=\"http://www.w3.org/2000/svg\"%3E%3Cpath d=\"M54.627 0l.83.83L1.457 55.457 0 54.001l54.627-54.627zM5.373 0L4.543.83 58.543 54.83 60 53.373 5.373 0z\" fill=\"%23ffffff\" fill-opacity=\"1\" fill-rule=\"evenodd\"/%3E%3C/svg%3E');"></div>
        </div>
        
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            <div class="flex flex-col lg:flex-row lg:items-end justify-between gap-12">
                <div class="flex-1">
                    <div class="inline-flex items-center gap-2 px-3 py-1 rounded-full bg-white/10 border border-white/20 text-white text-[10px] font-black uppercase tracking-widest mb-6 backdrop-blur-sm">
                        <i class="fa-solid fa-chart-line"></i>
                        <span>Seller Dashboard</span>
                    </div>
                    <h1 class="text-4xl md:text-5xl lg:text-6xl font-black text-white tracking-tight mb-4 italic">
                        My <span class="text-emerald-300">Listings.</span>
                    </h1>
                    <p class="text-white/80 text-base md:text-lg max-w-xl font-medium leading-relaxed">
                        Track performance, update prices, and manage your inventory with professional-grade tools.
                    </p>
                </div>
                
                <!-- Quick Stats Row -->
                <div class="flex flex-wrap items-center gap-4 md:gap-8 lg:mb-2">
                    <div class="px-6 py-4 bg-white/10 border border-white/20 backdrop-blur-md rounded-2xl">
                        <div class="text-[10px] font-black text-emerald-200 uppercase tracking-widest mb-1">Total Active</div>
                        <div class="text-3xl font-black text-white">{{ $publishedCount }}</div>
                    </div>
                    <div class="px-6 py-4 bg-white/10 border border-white/20 backdrop-blur-md rounded-2xl">
                        <div class="text-[10px] font-black text-blue-200 uppercase tracking-widest mb-1">In Review</div>
                        <div class="text-3xl font-black text-white">{{ $reviewCount }}</div>
                    </div>
                    <a href="{{ route('listing.create') }}" class="group relative flex items-center justify-center gap-3 px-8 py-5 bg-[#28a745] text-white font-black rounded-2xl shadow-2xl shadow-black/10 hover:bg-[#218838] transition-all transform hover:-translate-y-1 active:scale-95">
                        <i class="fa-solid fa-plus text-lg"></i>
                        <span class="text-sm uppercase tracking-wider">Post New Listing</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Modern Navigation Bar -->
    <div class="relative -mt-12 z-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="bg-white rounded-3xl shadow-xl shadow-black/5 border border-gray-100 p-2 md:p-3 overflow-hidden">
                <div class="flex items-center gap-2 md:gap-4 overflow-x-auto no-scrollbar scroll-smooth">
                    @php
                        $tabs = [
                            'published' => ['label' => 'Published', 'icon' => 'fa-circle-check', 'count' => $publishedCount, 'color' => 'emerald'],
                            'review' => ['label' => 'Under Review', 'icon' => 'fa-clock', 'count' => $reviewCount, 'color' => 'blue'],
                            'declined' => ['label' => 'Declined', 'icon' => 'fa-circle-xmark', 'count' => $declinedCount, 'color' => 'red'],
                            'closed' => ['label' => 'Closed', 'icon' => 'fa-box-archive', 'count' => $closedCount, 'color' => 'gray'],
                        ];
                    @endphp

                    @foreach($tabs as $key => $t)
                        <a href="{{ route('web.my-ads', ['tab' => $key]) }}" 
                           class="flex items-center gap-3 px-6 py-3.5 rounded-2xl font-black text-xs uppercase tracking-widest transition-all duration-300 group whitespace-nowrap
                           {{ $tab === $key 
                              ? 'bg-gray-900 text-white shadow-lg shadow-gray-200' 
                              : 'text-gray-400 hover:bg-gray-50 hover:text-gray-600' }}">
                            <i class="fa-solid {{ $t['icon'] }} {{ $tab === $key ? 'text-emerald-400' : 'text-gray-300' }} text-base group-hover:scale-110 transition-transform"></i>
                            <span>{{ $t['label'] }}</span>
                            <span class="ml-1 px-2 py-0.5 rounded-full text-[10px] {{ $tab === $key ? 'bg-white/10 text-emerald-400' : 'bg-gray-100 text-gray-500' }}">
                                {{ $t['count'] }}
                            </span>
                        </a>
                    @endforeach

                    <!-- Desktop Bulk Select Toggle -->
                    <div class="hidden md:flex flex-1 items-center justify-end px-4 border-l border-gray-100 ml-4">
                        <label class="flex items-center gap-3 text-[11px] font-black text-gray-400 uppercase tracking-widest cursor-pointer select-none hover:text-primary transition-all group">
                            <div class="relative w-5 h-5 rounded-lg border-2 border-gray-100 bg-gray-50 flex items-center justify-center transition-all group-hover:border-primary/30 group-hover:bg-white">
                                <input type="checkbox" id="selectAll" class="sr-only peer">
                                <i class="fa-solid fa-check text-[10px] text-primary opacity-0 peer-checked:opacity-100 transition-opacity"></i>
                            </div>
                            <span>Quick Select All</span>
                        </label>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Content Area -->
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        
        @if($listings->isEmpty())
            @include('web.partials.my-ads-empty', ['type' => $tab])
        @else
            <div id="listings-grid" class="grid grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4 md:gap-6">
                @foreach($listings as $listing)
                    <div id="listing-card-{{ $listing->id }}" class="relative group">
                        <div class="bg-white rounded-2xl overflow-hidden hover:shadow-2xl hover:shadow-gray-200/60 transition-all duration-500 cursor-pointer h-full flex flex-col relative group/card border border-gray-100/80 hover:border-primary/20 hover:-translate-y-1">
                            <!-- Image Section -->
                            <a href="{{ route('listing.show', $listing->slug) }}" class="relative aspect-[4/3] bg-gradient-to-br from-gray-100 to-gray-50 overflow-hidden block">
                                @if($listing->thumbnail_url)
                                    <img src="{{ $listing->thumbnail_url }}" 
                                         onerror="this.onerror=null; this.src='/assets/icons/listing_placeholder.svg'"
                                         class="w-full h-full object-cover group-hover/card:scale-105 transition-transform duration-500 {{ $listing->status !== 'published' ? 'opacity-70 grayscale-[0.4]' : '' }}">
                                @else
                                    <div class="w-full h-full flex items-center justify-center text-gray-300">
                                        <i class="fa-regular fa-image text-4xl"></i>
                                    </div>
                                @endif

                                <!-- Gradient Overlay -->
                                <div class="absolute inset-0 bg-gradient-to-t from-black/40 via-transparent to-transparent opacity-0 group-hover/card:opacity-100 transition-opacity duration-300"></div>

                                <!-- Status Badge Overlay -->
                                <div class="absolute top-3 left-3 flex flex-col gap-1.5 z-10">
                                    @php
                                        $statusConfig = [
                                            'published' => ['label' => 'Live', 'class' => 'bg-emerald-500 text-white', 'icon' => 'fa-circle-check'],
                                            'review' => ['label' => 'In Review', 'class' => 'bg-blue-500 text-white', 'icon' => 'fa-clock'],
                                            'rejected' => ['label' => 'Declined', 'class' => 'bg-red-500 text-white', 'icon' => 'fa-circle-xmark'],
                                            'draft' => ['label' => 'Closed', 'class' => 'bg-gray-600 text-white', 'icon' => 'fa-box-archive'],
                                        ][$listing->status] ?? ['label' => 'Unknown', 'class' => 'bg-gray-400 text-white', 'icon' => 'fa-question'];
                                    @endphp
                                    <span class="{{ $statusConfig['class'] }} text-[10px] font-bold uppercase tracking-wider px-2.5 py-1 rounded-full shadow-lg backdrop-blur-sm flex items-center gap-1.5">
                                        <i class="fa-solid {{ $statusConfig['icon'] }} text-[8px]"></i>
                                        {{ $statusConfig['label'] }}
                                    </span>
                                </div>

                                <!-- Views Badge -->
                                <div class="absolute bottom-3 left-3 z-10">
                                    <span class="bg-black/60 backdrop-blur-md text-white text-[10px] font-bold px-2.5 py-1 rounded-full flex items-center gap-1.5">
                                        <i class="fa-regular fa-eye text-[9px]"></i>
                                        {{ number_format($listing->views_count ?? 0) }}
                                    </span>
                                </div>

                                @if($listing->status === 'review')
                                    <div class="absolute inset-0 flex items-center justify-center pointer-events-none bg-blue-900/20 backdrop-blur-[2px]">
                                        <div class="w-12 h-12 rounded-full bg-white shadow-xl flex items-center justify-center text-blue-500">
                                            <i class="fa-solid fa-hourglass-half text-lg animate-pulse"></i>
                                        </div>
                                    </div>
                                @endif
                            </a>

                            <!-- Selection Checkbox -->
                            <div class="absolute top-3 right-3 z-20">
                                <label class="relative flex items-center justify-center w-8 h-8 rounded-full bg-white/95 backdrop-blur-sm cursor-pointer hover:bg-white transition-all shadow-lg hover:scale-110">
                                    <input type="checkbox" name="selected_ids[]" value="{{ $listing->id }}" class="item-checkbox sr-only peer">
                                    <div class="hidden peer-checked:flex items-center justify-center w-full h-full bg-primary rounded-full text-white text-xs">
                                        <i class="fa-solid fa-check"></i>
                                    </div>
                                    <div class="peer-checked:hidden text-gray-400 text-sm">
                                        <i class="fa-regular fa-circle"></i>
                                    </div>
                                </label>
                            </div>

                            <!-- Content Details -->
                            <div class="p-4 flex flex-col flex-grow">
                                <a href="{{ route('listing.show', $listing->slug) }}" class="block mb-3">
                                    <h3 class="text-sm font-bold text-gray-900 line-clamp-2 leading-snug group-hover/card:text-primary transition-colors">
                                        {{ $listing->title }}
                                    </h3>
                                </a>

                                <div class="flex items-end justify-between mt-auto">
                                    <div>
                                        <span class="text-lg font-black text-primary tracking-tight">
                                            {{ $listing->price_formatted }}
                                        </span>
                                        @if($listing->quantity > 1)
                                            <span class="text-[10px] text-gray-400 ml-1">× {{ $listing->quantity }}</span>
                                        @endif
                                    </div>
                                    <span class="text-[10px] text-gray-400 font-medium bg-gray-50 px-2 py-0.5 rounded-full">
                                        {{ $listing->created_at->diffForHumans(null, true, true) }}
                                    </span>
                                </div>
                            </div>

                            <!-- Management Quick Actions -->
                            <div class="p-3 bg-gradient-to-b from-gray-50/50 to-gray-100/50 border-t border-gray-100 space-y-2">
                                @if($listing->status === 'draft')
                                    {{-- CLOSED/DRAFT: Repost + Delete --}}
                                    <form action="{{ route('listing.repost', $listing->id) }}" method="POST" onsubmit="return confirmFormSubmit(event, this, 'Repost Ad', 'This will make the ad active for another 30 days.', 'emerald', 'fa-arrows-rotate')">
                                        @csrf
                                        <button type="submit" class="w-full py-2.5 bg-gradient-to-r from-emerald-500 to-emerald-600 text-white text-xs font-bold rounded-xl hover:from-emerald-600 hover:to-emerald-700 transition-all flex items-center justify-center gap-2 shadow-lg shadow-emerald-200/50 hover:shadow-xl hover:shadow-emerald-300/50 hover:-translate-y-0.5">
                                            <i class="fa-solid fa-rocket"></i> Reactivate
                                        </button>
                                    </form>
                                    <div class="grid grid-cols-2 gap-2">
                                        <a href="{{ route('listing.edit', $listing->slug) }}" class="py-2 bg-white text-gray-600 text-[11px] font-bold rounded-xl hover:bg-gray-50 transition-all flex items-center justify-center gap-1.5 border border-gray-200 hover:border-primary hover:text-primary">
                                            <i class="fa-regular fa-pen-to-square"></i> Edit
                                        </a>
                                        <form action="{{ route('listing.destroy', $listing->id) }}" method="POST" onsubmit="return confirmFormSubmit(event, this, 'Delete Permanently', 'Are you sure? This cannot be undone.', 'red', 'fa-trash-can')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="w-full py-2 bg-white text-gray-400 text-[11px] font-bold rounded-xl hover:bg-red-50 hover:text-red-500 hover:border-red-200 transition-all flex items-center justify-center gap-1.5 border border-gray-200">
                                                <i class="fa-regular fa-trash-can"></i> Delete
                                            </button>
                                        </form>
                                    </div>
                                @elseif($listing->status === 'rejected')
                                    {{-- REJECTED: Decline Reason + Fix + Delete --}}
                                    @if($listing->decline_reason)
                                        <div class="px-3 py-2 bg-red-50 border border-red-100 rounded-xl">
                                            <p class="text-[10px] text-red-600 font-medium line-clamp-2 flex items-start gap-1.5">
                                                <i class="fa-solid fa-triangle-exclamation mt-0.5 flex-shrink-0"></i>
                                                <span>{{ $listing->decline_reason }}</span>
                                            </p>
                                        </div>
                                    @endif
                                    <div class="grid grid-cols-2 gap-2">
                                        <a href="{{ route('listing.edit', $listing->slug) }}" class="py-2.5 bg-gradient-to-r from-orange-500 to-red-500 text-white text-[11px] font-bold rounded-xl hover:from-orange-600 hover:to-red-600 transition-all flex items-center justify-center gap-1.5 shadow-lg shadow-orange-200/50">
                                            <i class="fa-solid fa-wrench"></i> Fix Issues
                                        </a>
                                        <form action="{{ route('listing.destroy', $listing->id) }}" method="POST" onsubmit="return confirmFormSubmit(event, this, 'Delete Permanently', 'Are you sure? This cannot be undone.', 'red', 'fa-trash-can')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="w-full py-2.5 bg-white text-gray-400 text-[11px] font-bold rounded-xl hover:bg-red-50 hover:text-red-500 hover:border-red-200 transition-all flex items-center justify-center gap-1.5 border border-gray-200">
                                                <i class="fa-regular fa-trash-can"></i> Delete
                                            </button>
                                        </form>
                                    </div>
                                @elseif($listing->status === 'review')
                                    {{-- REVIEW: Edit + Delete --}}
                                    <div class="px-3 py-2 bg-blue-50 border border-blue-100 rounded-xl">
                                        <p class="text-[10px] text-blue-600 font-medium flex items-center gap-1.5">
                                            <i class="fa-solid fa-clock animate-pulse"></i>
                                            <span>Under review by our team. Usually takes 1-24 hours.</span>
                                        </p>
                                    </div>
                                    <div class="grid grid-cols-2 gap-2">
                                        <a href="{{ route('listing.edit', $listing->slug) }}" class="py-2 bg-white text-gray-600 text-[11px] font-bold rounded-xl hover:bg-gray-50 transition-all flex items-center justify-center gap-1.5 border border-gray-200 hover:border-primary hover:text-primary">
                                            <i class="fa-regular fa-pen-to-square"></i> Edit
                                        </a>
                                        <form action="{{ route('listing.destroy', $listing->id) }}" method="POST" onsubmit="return confirmFormSubmit(event, this, 'Delete Permanently', 'Are you sure? This cannot be undone.', 'red', 'fa-trash-can')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="w-full py-2 bg-white text-gray-400 text-[11px] font-bold rounded-xl hover:bg-red-50 hover:text-red-500 hover:border-red-200 transition-all flex items-center justify-center gap-1.5 border border-gray-200">
                                                <i class="fa-regular fa-trash-can"></i> Delete
                                            </button>
                                        </form>
                                    </div>
                                @elseif($listing->status === 'published')
                                    {{-- PUBLISHED: Edit + Close --}}
                                    <div class="grid grid-cols-2 gap-2">
                                        <a href="{{ route('listing.edit', $listing->slug) }}" class="py-2.5 bg-white text-gray-700 text-[11px] font-bold rounded-xl hover:bg-primary hover:text-white transition-all flex items-center justify-center gap-1.5 border border-gray-200 hover:border-primary shadow-sm">
                                            <i class="fa-regular fa-pen-to-square"></i> Edit
                                        </a>
                                        <form action="{{ route('listing.close', $listing->id) }}" method="POST" onsubmit="return confirmFormSubmit(event, this, 'Close Ad', 'This will archive the ad. It will no longer be visible.', 'orange', 'fa-box-archive')">
                                            @csrf
                                            <button type="submit" class="w-full py-2.5 bg-white text-gray-500 text-[11px] font-bold rounded-xl hover:bg-orange-50 hover:text-orange-600 hover:border-orange-300 transition-all flex items-center justify-center gap-1.5 border border-gray-200">
                                                <i class="fa-solid fa-box-archive"></i> Close
                                            </button>
                                        </form>
                                    </div>
                                @else
                                    {{-- OTHER: Edit + Delete --}}
                                    <div class="grid grid-cols-2 gap-2">
                                        <a href="{{ route('listing.edit', $listing->slug) }}" class="py-2 bg-white text-gray-600 text-[11px] font-bold rounded-xl hover:bg-gray-50 transition-all flex items-center justify-center gap-1.5 border border-gray-200 hover:border-primary hover:text-primary">
                                            <i class="fa-regular fa-pen-to-square"></i> Edit
                                        </a>
                                        <form action="{{ route('listing.destroy', $listing->id) }}" method="POST" onsubmit="return confirmFormSubmit(event, this, 'Delete Permanently', 'Are you sure? This cannot be undone.', 'red', 'fa-trash-can')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="w-full py-2 bg-white text-gray-400 text-[11px] font-bold rounded-xl hover:bg-red-50 hover:text-red-500 hover:border-red-200 transition-all flex items-center justify-center gap-1.5 border border-gray-200">
                                                <i class="fa-regular fa-trash-can"></i> Delete
                                            </button>
                                        </form>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <!-- Pagination -->
            <div class="mt-8">
                {{ $listings->appends(['tab' => $tab])->links('vendor.pagination.yilick') }}
            </div>
        @endif
    </div>

    <!-- Floating Action Bar -->
     <div id="bulkActionsBar" class="fixed bottom-6 left-1/2 -translate-x-1/2 bg-white rounded-full shadow-2xl border border-gray-200 px-6 py-3 flex items-center gap-4 z-40 translate-y-24 transition-transform duration-300">
        <span class="text-sm font-bold text-gray-700 whitespace-nowrap">
            <span id="selectedCount">0</span> Selected
        </span>
        <div class="h-6 w-px bg-gray-200"></div>
        <div class="flex items-center gap-2">
            @if($tab === 'closed')
                <button onclick="submitBulkAction('repost')" class="flex items-center gap-2 px-4 py-2 bg-emerald-600 text-white rounded-full text-xs font-bold hover:bg-emerald-700 transition-colors shadow-lg shadow-emerald-200">
                    <i class="fa-solid fa-arrows-rotate"></i> Repost Selected
                </button>
            @endif
             <button onclick="submitBulkAction('destroy')" class="flex items-center gap-2 px-4 py-2 bg-red-600 text-white rounded-full text-xs font-bold hover:bg-red-700 transition-colors shadow-lg shadow-red-200">
                <i class="fa-solid fa-trash"></i> Delete Selected
            </button>
        </div>
    </div>

    <!-- Hidden Bulk Forms -->
    <form id="bulkRepostForm" action="{{ route('listing.bulk-repost') }}" method="POST" class="hidden">
        @csrf
    </form>
    <form id="bulkDestroyForm" action="{{ route('listing.bulk-destroy') }}" method="POST" class="hidden">
        @csrf
    </form>
</div>

@push('scripts')
<style>
    .no-scrollbar::-webkit-scrollbar { display: none; }
    .no-scrollbar { -ms-overflow-style: none; scrollbar-width: none; }
    .line-clamp-1 { display: -webkit-box; -webkit-line-clamp: 1; -webkit-box-orient: vertical; overflow: hidden; }
    .line-clamp-2 { display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden; }
    .animate-spin-slow { animation: spin 3s linear infinite; }
    @keyframes spin { from { transform: rotate(0deg); } to { transform: rotate(360deg); } }
</style>
<script>
    // Handle Image Error
    document.querySelectorAll('img').forEach(img => {
        img.addEventListener('error', function() {
            this.style.display = 'none';
            this.nextElementSibling.style.display = 'flex'; // Show placeholder
        });
    });

    // Bulk Selection Logic
    const selectAllCheckbox = document.getElementById('selectAll');
    const itemCheckboxes = document.querySelectorAll('.item-checkbox');
    const bulkActionsBar = document.getElementById('bulkActionsBar');
    const selectedCountSpan = document.getElementById('selectedCount');

    function updateBulkBar() {
        const checkedCount = document.querySelectorAll('.item-checkbox:checked').length;
        selectedCountSpan.textContent = checkedCount;
        
        if (checkedCount > 0) {
            bulkActionsBar.classList.remove('translate-y-24');
        } else {
            bulkActionsBar.classList.add('translate-y-24');
        }
    }

    if(selectAllCheckbox) {
        selectAllCheckbox.addEventListener('change', function() {
            itemCheckboxes.forEach(cb => cb.checked = this.checked);
            updateBulkBar();
        });
    }

    itemCheckboxes.forEach(cb => {
        cb.addEventListener('change', updateBulkBar);
    });

    function submitBulkAction(action) {
        let title, message, color, icon, btnText;
        const selectedIds = Array.from(document.querySelectorAll('.item-checkbox:checked')).map(cb => cb.value);

        if (action === 'repost') {
            title = 'Repost Selected Ads?';
            message = `This will activate ${selectedIds.length} selected ads for 30 days.`;
            color = 'emerald';
            icon = 'fa-arrows-rotate';
            btnText = 'Repost All';
        } else {
            title = 'Delete Selected Ads?';
            message = `Are you sure you want to delete ${selectedIds.length} selected ads? This cannot be undone.`;
            color = 'red';
            icon = 'fa-trash-can';
            btnText = 'Delete All';
        }

        showConfirmation({
            title: title,
            message: message,
            confirmText: btnText,
            confirmColor: color,
            iconClass: icon,
            onConfirm: async () => {
                const url = action === 'repost' ? "{{ route('listing.bulk-repost') }}" : "{{ route('listing.bulk-destroy') }}";
                
                showLoading();
                try {
                    const response = await fetch(url, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}',
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        body: JSON.stringify({ ids: selectedIds })
                    });

                    const data = await response.json();
                    if (data.success) {
                        showToast(data.message);
                        selectedIds.forEach(id => {
                            const card = document.getElementById(`listing-card-${id}`);
                            if (card) {
                                card.classList.add('scale-95', 'opacity-0');
                                setTimeout(() => {
                                    card.remove();
                                    updateTabCounts(-1);
                                    checkEmptyState();
                                }, 300);
                            }
                        });
                        clearSelection();
                    } else {
                        showToast(data.message || 'Action failed', 'error');
                    }
                } catch (e) {
                    showToast('An error occurred', 'error');
                } finally {
                    hideLoading();
                }
            }
        });
    }

    function confirmFormSubmit(event, form, title, message, color = 'red', icon = 'fa-triangle-exclamation') {
        event.preventDefault();
        showConfirmation({
            title: title,
            message: message,
            confirmColor: color,
            iconClass: icon,
            onConfirm: async () => {
                showLoading();
                try {
                    const formData = new FormData(form);
                    const response = await fetch(form.action, {
                        method: 'POST',
                        body: formData,
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        }
                    });

                    const data = await response.json();
                    if (data.success) {
                        showToast(data.message);
                        const card = form.closest('[id^="listing-card-"]');
                        if (card) {
                            card.style.transition = 'all 0.3s ease';
                            card.classList.add('scale-95', 'opacity-0');
                            setTimeout(() => {
                                card.remove();
                                updateTabCounts(-1);
                                checkEmptyState();
                            }, 300);
                        }
                    } else {
                        showToast(data.message || 'Action failed', 'error');
                    }
                } catch (e) {
                    showToast('An error occurred', 'error');
                } finally {
                    hideLoading();
                }
            }
        });
        return false;
    }

    function updateTabCounts(change) {
        const countSpan = document.querySelector(`.tab-btn.active span[class*="rounded-full"]`);
        if (countSpan) {
            let currentCount = parseInt(countSpan.textContent);
            countSpan.textContent = Math.max(0, currentCount + change);
        }
    }

    function checkEmptyState() {
        const grid = document.getElementById('listings-grid');
        if (grid && grid.querySelectorAll('[id^="listing-card-"]').length === 0) {
            location.reload(); 
        }
    }

    function clearSelection() {
        document.getElementById('selectAll').checked = false;
        document.querySelectorAll('.item-checkbox').forEach(cb => cb.checked = false);
        updateBulkActionsBar();
    }
</script>
@include('web.partials.confirmation-modal')
@endpush
@endsection
