@extends('layouts.app')

@section('title', 'My Favorites - Yilick')

@section('content')
<div class="bg-gray-50 min-h-screen">
    <!-- Hero Header with Gradient Background -->
    <div class="relative bg-gradient-to-br from-primary via-emerald-500 to-teal-600 overflow-hidden">
        <!-- Decorative Elements -->
        <div class="absolute inset-0 overflow-hidden pointer-events-none">
            <div class="absolute -top-32 -right-32 w-96 h-96 bg-white/10 rounded-full blur-3xl"></div>
            <div class="absolute -bottom-24 -left-24 w-64 h-64 bg-white/5 rounded-full blur-2xl"></div>
            <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[600px] h-[600px] bg-gradient-to-br from-white/5 to-transparent rounded-full"></div>
            <!-- Floating hearts decoration -->
            <div class="absolute top-20 right-20 text-white/10 text-6xl animate-pulse hidden lg:block">
                <i class="fa-regular fa-heart"></i>
            </div>
            <div class="absolute bottom-10 left-32 text-white/10 text-4xl animate-pulse delay-500 hidden lg:block">
                <i class="fa-regular fa-heart"></i>
            </div>
        </div>
        
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 pt-24 md:pt-28 pb-20 relative">
            <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-6">
                <div class="max-w-2xl">
                    <div class="inline-flex items-center gap-2 px-4 py-2 bg-white/15 backdrop-blur-sm rounded-full text-white/90 text-sm font-medium mb-4">
                        <i class="fa-solid fa-heart text-red-300"></i>
                        <span>Your Collection</span>
                    </div>
                    <h1 class="text-3xl md:text-4xl lg:text-5xl font-black text-white tracking-tight mb-4">
                        My Favorites
                    </h1>
                    <p class="text-white/80 text-base md:text-lg leading-relaxed">
                        All your saved ads, favorite shops, and search alerts organized in one beautiful place.
                    </p>
                </div>
                
                <!-- Stats Cards -->
                <div class="flex gap-3 md:gap-4">
                    <div class="bg-white/15 backdrop-blur-md rounded-2xl p-4 md:p-5 text-center border border-white/20 min-w-[100px]">
                        <div class="text-2xl md:text-3xl font-black text-white mb-1">{{ $favoriteListings->count() }}</div>
                        <div class="text-white/70 text-xs font-medium uppercase tracking-wide">Ads</div>
                    </div>
                    <div class="bg-white/15 backdrop-blur-md rounded-2xl p-4 md:p-5 text-center border border-white/20 min-w-[100px]">
                        <div class="text-2xl md:text-3xl font-black text-white mb-1">{{ $favoriteBusinesses->count() }}</div>
                        <div class="text-white/70 text-xs font-medium uppercase tracking-wide">Shops</div>
                    </div>
                    <div class="bg-white/15 backdrop-blur-md rounded-2xl p-4 md:p-5 text-center border border-white/20 min-w-[100px]">
                        <div class="text-2xl md:text-3xl font-black text-white mb-1">{{ $favoriteSearches->count() }}</div>
                        <div class="text-white/70 text-xs font-medium uppercase tracking-wide">Searches</div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Wave Divider -->
        <div class="absolute bottom-0 left-0 right-0">
            <svg viewBox="0 0 1440 120" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-full h-auto">
                <path d="M0 120L60 110C120 100 240 80 360 70C480 60 600 60 720 65C840 70 960 80 1080 85C1200 90 1320 90 1380 90L1440 90V120H1380C1320 120 1200 120 1080 120C960 120 840 120 720 120C600 120 480 120 360 120C240 120 120 120 60 120H0Z" fill="#F9FAFB"/>
            </svg>
        </div>
    </div>

    <!-- Navigation Tabs - Sticky -->
    <div class="bg-white sticky top-[52px] md:top-[60px] z-40 shadow-sm border-b border-gray-100">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <nav class="flex gap-1 md:gap-2 overflow-x-auto no-scrollbar py-3" aria-label="Tabs">
                <button data-tab-target="#tab-ads" 
                        class="tab-btn active flex items-center gap-2 px-4 md:px-6 py-3 rounded-xl text-sm font-bold transition-all duration-300">
                    <i class="fa-solid fa-layer-group"></i>
                    <span>Ads</span>
                    <span class="tab-count ml-1 px-2 py-0.5 rounded-full text-xs">{{ $favoriteListings->count() }}</span>
                </button>

                <button data-tab-target="#tab-sellers" 
                        class="tab-btn flex items-center gap-2 px-4 md:px-6 py-3 rounded-xl text-sm font-bold transition-all duration-300">
                    <i class="fa-solid fa-store"></i>
                    <span>Shops</span>
                    <span class="tab-count ml-1 px-2 py-0.5 rounded-full text-xs">{{ $favoriteBusinesses->count() }}</span>
                </button>

                <button data-tab-target="#tab-searches" 
                        class="tab-btn flex items-center gap-2 px-4 md:px-6 py-3 rounded-xl text-sm font-bold transition-all duration-300">
                    <i class="fa-solid fa-magnifying-glass"></i>
                    <span>Searches</span>
                    <span class="tab-count ml-1 px-2 py-0.5 rounded-full text-xs">{{ $favoriteSearches->count() }}</span>
                </button>
            </nav>
        </div>
    </div>

    <!-- Main Content -->
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8 md:py-12">
        
        <!-- ADS TAB -->
        <div id="tab-ads" data-tab-content class="tab-content">
            @if($favoriteListings->isEmpty())
                @include('web.partials.favorites-empty', ['type' => 'ads'])
            @else
                <div class="mb-6 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                    <h2 class="text-xl md:text-2xl font-black text-gray-900">Saved Ads</h2>
                    <p class="text-sm text-gray-500">{{ $favoriteListings->count() }} {{ Str::plural('item', $favoriteListings->count()) }} saved</p>
                </div>
                <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-5 gap-3 md:gap-5">
                    @foreach($favoriteListings as $listing)
                        <div id="fav-listing-{{ $listing->id }}" class="relative group animate-fade-in">
                            <div class="h-full transform transition-all duration-300 hover:-translate-y-1">
                                <x-listing-card :listing="$listing" />
                            </div>
                            <!-- Remove Button -->
                            <button onclick="toggleFavorite('listing', {{ $listing->id }})" 
                                    class="absolute top-3 right-3 w-10 h-10 rounded-xl bg-white/95 backdrop-blur-sm text-red-500 shadow-lg border border-white/50 flex items-center justify-center z-10 hover:bg-red-50 hover:scale-110 active:scale-95 transition-all duration-300 group/btn"
                                    title="Remove from favorites">
                                <i class="fa-solid fa-heart text-lg group-hover/btn:animate-pulse"></i>
                            </button>
                        </div>
                    @endforeach
                </div>
            @endif
        </div>

        <!-- SHOPS TAB -->
        <div id="tab-sellers" class="hidden tab-content" data-tab-content>
            @if($favoriteBusinesses->isEmpty())
                @include('web.partials.favorites-empty', ['type' => 'sellers'])
            @else
                <div class="mb-6 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                    <h2 class="text-xl md:text-2xl font-black text-gray-900">Followed Shops</h2>
                    <p class="text-sm text-gray-500">{{ $favoriteBusinesses->count() }} {{ Str::plural('shop', $favoriteBusinesses->count()) }} followed</p>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 md:gap-6">
                    @foreach($favoriteBusinesses as $business)
                        <div id="fav-business-{{ $business->id }}" class="bg-white rounded-2xl border border-gray-100 overflow-hidden shadow-sm hover:shadow-xl hover:border-primary/20 transition-all duration-500 group relative animate-fade-in">
                            <!-- Cover/Banner -->
                            <div class="h-20 md:h-24 bg-gradient-to-r from-primary/10 via-emerald-50 to-teal-50 relative">
                                <div class="absolute inset-0 bg-[url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHZpZXdCb3g9IjAgMCA0MCA0MCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSJub25lIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPjxjaXJjbGUgY3g9IjIwIiBjeT0iMjAiIHI9IjEiIGZpbGw9InJnYmEoMCwwLDAsMC4wNSkiLz48L2c+PC9zdmc+')] opacity-50"></div>
                                
                                <!-- Unfollow Button -->
                                <button onclick="toggleFavorite('business', {{ $business->id }})" 
                                        class="absolute top-3 right-3 w-9 h-9 rounded-xl bg-white/90 backdrop-blur-sm text-red-500 shadow-md border border-white/50 flex items-center justify-center hover:bg-red-50 hover:scale-110 active:scale-95 transition-all duration-300"
                                        title="Unfollow shop">
                                    <i class="fa-regular fa-heart"></i>
                                </button>
                            </div>
                            
                            <!-- Content -->
                            <div class="px-5 pb-5 -mt-8 relative">
                                <!-- Logo -->
                                <div class="w-16 h-16 md:w-20 md:h-20 rounded-2xl bg-white border-4 border-white shadow-lg flex items-center justify-center overflow-hidden mb-4 group-hover:scale-105 transition-transform duration-300">
                                    @if($business->logo_url)
                                        <img src="{{ $business->logo_url }}" class="w-full h-full object-cover" alt="{{ $business->name }}">
                                    @else
                                        <div class="w-full h-full bg-gradient-to-br from-gray-50 to-gray-100 flex items-center justify-center">
                                            <i class="fa-solid fa-store text-gray-300 text-2xl"></i>
                                        </div>
                                    @endif
                                </div>
                                
                                <!-- Info -->
                                <h3 class="font-bold text-gray-900 text-lg mb-2 group-hover:text-primary transition-colors line-clamp-1">
                                    {{ $business->name }}
                                </h3>
                                
                                <div class="flex flex-wrap gap-3 text-sm text-gray-500 mb-4">
                                    @if($business->district)
                                    <span class="flex items-center gap-1.5">
                                        <i class="fa-solid fa-location-dot text-primary text-xs"></i>
                                        {{ $business->district }}
                                    </span>
                                    @endif
                                    <span class="flex items-center gap-1.5">
                                        <i class="fa-solid fa-layer-group text-primary text-xs"></i>
                                        {{ $business->listings_count ?? 0 }} {{ Str::plural('Ad', $business->listings_count ?? 0) }}
                                    </span>
                                </div>
                                
                                <a href="{{ route('business.show', $business->slug) }}" 
                                   class="inline-flex items-center justify-center w-full px-5 py-3 bg-gray-50 hover:bg-primary hover:text-white text-gray-700 text-sm font-bold rounded-xl transition-all duration-300 group/link">
                                    Visit Store 
                                    <i class="fa-solid fa-arrow-right ml-2 group-hover/link:translate-x-1 transition-transform"></i>
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>
            @endif
        </div>

        <!-- SEARCHES TAB -->
        <div id="tab-searches" class="hidden tab-content" data-tab-content>
            @if($favoriteSearches->isEmpty())
                @include('web.partials.favorites-empty', ['type' => 'searches'])
            @else
                <div class="mb-6 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                    <h2 class="text-xl md:text-2xl font-black text-gray-900">Saved Searches</h2>
                    <p class="text-sm text-gray-500">{{ $favoriteSearches->count() }} {{ Str::plural('search', $favoriteSearches->count()) }} saved</p>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 md:gap-6">
                    @foreach($favoriteSearches as $search)
                        <div id="fav-search-{{ $search->id }}" class="bg-white rounded-2xl border border-gray-100 p-5 md:p-6 shadow-sm hover:shadow-xl hover:border-orange-200 transition-all duration-500 group flex flex-col h-full relative animate-fade-in">
                            <!-- Delete Button -->
                            <button onclick="removeSavedSearch({{ $search->id }})" 
                                    class="absolute top-4 right-4 w-9 h-9 rounded-xl bg-gray-50 hover:bg-red-50 text-gray-300 hover:text-red-500 flex items-center justify-center transition-all duration-300 hover:scale-110 active:scale-95"
                                    title="Delete saved search">
                                <i class="fa-solid fa-trash-can text-sm"></i>
                            </button>

                            <!-- Icon -->
                            <div class="w-14 h-14 rounded-2xl bg-gradient-to-br from-orange-100 to-amber-50 flex items-center justify-center text-orange-500 mb-5 group-hover:scale-110 group-hover:rotate-3 transition-all duration-300">
                                <i class="fa-solid fa-magnifying-glass text-xl"></i>
                            </div>

                            <a href="{{ route('listing.search', ['q' => $search->query] + ($search->filters ?? [])) }}" class="flex-1 flex flex-col">
                                <h3 class="font-bold text-gray-900 text-lg md:text-xl mb-3 group-hover:text-primary transition-colors capitalize line-clamp-2">
                                    {{ $search->name ?: ($search->query ?: 'Custom Search') }}
                                </h3>
                                
                                <!-- Filter Tags -->
                                <div class="flex flex-wrap gap-2 mb-5">
                                    @if($search->query)
                                        <span class="inline-flex items-center px-3 py-1.5 rounded-lg bg-orange-50 text-orange-700 text-xs font-semibold border border-orange-100">
                                            <i class="fa-solid fa-quote-left mr-1.5 text-[10px] opacity-50"></i>
                                            {{ Str::limit($search->query, 20) }}
                                        </span>
                                    @endif
                                    @if(isset($search->filters['category']))
                                        <span class="inline-flex items-center px-3 py-1.5 rounded-lg bg-gray-50 text-gray-600 text-xs font-semibold border border-gray-100">
                                            <i class="fa-solid fa-tag mr-1.5 text-[10px] opacity-50"></i>
                                            {{ Str::limit($search->filters['category'], 15) }}
                                        </span>
                                    @endif
                                    @if(isset($search->filters['location']))
                                        <span class="inline-flex items-center px-3 py-1.5 rounded-lg bg-gray-50 text-gray-600 text-xs font-semibold border border-gray-100">
                                            <i class="fa-solid fa-location-dot mr-1.5 text-[10px] opacity-50"></i>
                                            {{ Str::limit($search->filters['location'], 15) }}
                                        </span>
                                    @endif
                                </div>
                                
                                <div class="mt-auto flex items-center justify-between">
                                    <p class="text-xs text-gray-400">
                                        <i class="fa-regular fa-clock mr-1"></i>
                                        {{ $search->created_at->diffForHumans() }}
                                    </p>
                                    <span class="text-primary text-sm font-bold group-hover:underline">
                                        Run Search <i class="fa-solid fa-arrow-right ml-1"></i>
                                    </span>
                                </div>
                            </a>
                        </div>
                    @endforeach
                </div>
            @endif
        </div>

    </div>
</div>

<!-- Toast Container -->
<div id="toast-container" class="fixed top-20 right-4 z-[200] flex flex-col gap-3 pointer-events-none"></div>

@push('scripts')
<script>
    // Tab Switching Logic
    document.addEventListener('DOMContentLoaded', function() {
        const tabs = document.querySelectorAll('[data-tab-target]');
        const contents = document.querySelectorAll('[data-tab-content]');

        tabs.forEach(tab => {
            tab.addEventListener('click', () => {
                // Reset all tabs
                tabs.forEach(t => t.classList.remove('active'));
                
                // Hide all contents
                contents.forEach(c => c.classList.add('hidden'));

                // Activate clicked tab
                tab.classList.add('active');
                
                // Show target content
                const target = document.querySelector(tab.dataset.tabTarget);
                target.classList.remove('hidden');
            });
        });
    });

    // Toast Notification
    function showToast(message, type = 'success') {
        const container = document.getElementById('toast-container');
        if (!container) return;
        
        const toast = document.createElement('div');
        toast.className = 'toast-enter pointer-events-auto flex items-center gap-3 px-5 py-4 rounded-2xl shadow-2xl backdrop-blur-md max-w-sm';
        
        const styles = {
            success: 'bg-emerald-500/95 text-white',
            error: 'bg-red-500/95 text-white',
            info: 'bg-primary/95 text-white'
        };
        
        const icons = {
            success: 'fa-circle-check',
            error: 'fa-circle-xmark',
            info: 'fa-circle-info'
        };
        
        toast.classList.add(...(styles[type] || styles.success).split(' '));
        
        toast.innerHTML = `
            <div class="w-8 h-8 rounded-full bg-white/20 flex items-center justify-center flex-shrink-0">
                <i class="fa-solid ${icons[type] || icons.success}"></i>
            </div>
            <p class="text-sm font-semibold flex-1">${message}</p>
            <button onclick="this.parentElement.remove()" class="w-6 h-6 rounded-full hover:bg-white/20 flex items-center justify-center transition-colors">
                <i class="fa-solid fa-xmark text-xs"></i>
            </button>
        `;
        
        container.appendChild(toast);
        
        setTimeout(() => {
            toast.classList.remove('toast-enter');
            toast.classList.add('toast-exit');
            setTimeout(() => toast.remove(), 300);
        }, 4000);
    }

    // Favorite Actions
    async function toggleFavorite(type, id) {
        const url = type === 'listing' 
            ? "{{ route('web.favorites.toggle-listing') }}" 
            : "{{ route('web.favorites.toggle-business') }}";
        
        const body = type === 'listing' ? { listing_id: id } : { business_id: id };

        try {
            const response = await fetch(url, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify(body)
            });

            const data = await response.json();

            if (data.status === 'success') {
                if (data.action === 'removed') {
                    const el = document.getElementById(`fav-${type}-${id}`);
                    el.style.transition = 'all 0.3s ease-out';
                    el.style.opacity = '0';
                    el.style.transform = 'scale(0.9) translateY(-10px)';
                    
                    setTimeout(() => {
                        el.remove();
                        // Check if empty
                        const container = document.getElementById(type === 'listing' ? 'tab-ads' : 'tab-sellers');
                        const remaining = container.querySelectorAll(`[id^="fav-${type}-"]`).length;
                        if (remaining === 0) location.reload();
                        
                        // Update count in tab
                        updateTabCount(type === 'listing' ? '#tab-ads' : '#tab-sellers');
                    }, 300);
                }
                showToast(data.message, 'success');
            }
        } catch (error) {
            console.error('Error:', error);
            showToast('Something went wrong', 'error');
        }
    }

    async function removeSavedSearch(id) {
        if (!confirm('Remove this saved search?')) return;

        try {
            const response = await fetch(`/favorites/search/${id}`, {
                method: 'DELETE',
                headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' }
            });

            const data = await response.json();

            if (data.status === 'success') {
                const el = document.getElementById(`fav-search-${id}`);
                el.style.transition = 'all 0.3s ease-out';
                el.style.opacity = '0';
                el.style.transform = 'scale(0.9) translateY(-10px)';
                
                setTimeout(() => {
                    el.remove();
                    const container = document.getElementById('tab-searches');
                    if (container.querySelectorAll('[id^="fav-search-"]').length === 0) location.reload();
                    updateTabCount('#tab-searches');
                }, 300);
                showToast(data.message, 'success');
            }
        } catch (error) {
            console.error('Error:', error);
            showToast('Failed to remove search', 'error');
        }
    }
    
    function updateTabCount(tabSelector) {
        // This will update the count visually after removing items
        const tabBtn = document.querySelector(`[data-tab-target="${tabSelector}"]`);
        if (tabBtn) {
            const countEl = tabBtn.querySelector('.tab-count');
            if (countEl) {
                const currentCount = parseInt(countEl.textContent) || 0;
                countEl.textContent = Math.max(0, currentCount - 1);
            }
        }
    }
</script>

<style>
    /* Tab Styles */
    .tab-btn {
        color: #6B7280;
        background: transparent;
    }
    .tab-btn .tab-count {
        background: #F3F4F6;
        color: #6B7280;
    }
    .tab-btn.active {
        color: white;
        background: linear-gradient(135deg, var(--color-primary) 0%, #10B981 100%);
        box-shadow: 0 4px 15px rgba(16, 185, 129, 0.3);
    }
    .tab-btn.active .tab-count {
        background: rgba(255,255,255,0.25);
        color: white;
    }
    .tab-btn:not(.active):hover {
        background: #F3F4F6;
        color: #374151;
    }
    
    /* Animations */
    @keyframes fade-in {
        from { opacity: 0; transform: translateY(10px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .animate-fade-in {
        animation: fade-in 0.4s ease-out forwards;
    }
    
    @keyframes toast-slide-in {
        from { transform: translateX(100%); opacity: 0; }
        to { transform: translateX(0); opacity: 1; }
    }
    @keyframes toast-slide-out {
        from { transform: translateX(0); opacity: 1; }
        to { transform: translateX(100%); opacity: 0; }
    }
    .toast-enter { animation: toast-slide-in 0.3s ease-out forwards; }
    .toast-exit { animation: toast-slide-out 0.3s ease-in forwards; }
    
    /* Scrollbar Hide */
    .no-scrollbar::-webkit-scrollbar { display: none; }
    .no-scrollbar { -ms-overflow-style: none; scrollbar-width: none; }
    
    /* Line Clamp */
    .line-clamp-1 {
        display: -webkit-box;
        -webkit-line-clamp: 1;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }
    .line-clamp-2 {
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }
</style>
@endpush
@endsection
