@extends('layouts.app')

@section('title', 'Careers - Join the Yilick Team')

@section('content')
<div class="bg-white min-h-screen">
    <!-- Light & Inspiring Hero -->
    <section class="relative pt-32 pb-24 overflow-hidden bg-emerald-50/50 border-b border-emerald-100/50">
        <!-- Decorative subtle elements -->
        <div class="absolute inset-0 pointer-events-none">
            <div class="absolute top-0 right-0 w-[500px] h-[500px] bg-primary/5 rounded-full blur-[120px] -mr-64 -mt-64"></div>
            <div class="absolute bottom-0 left-0 w-[500px] h-[500px] bg-emerald-500/5 rounded-full blur-[120px] -ml-64 -mb-64"></div>
            <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-full h-full bg-[radial-gradient(theme(colors.primary)_1px,transparent_1px)] [background-size:48px_48px] opacity-[0.04]"></div>
        </div>
        
        <div class="container mx-auto px-4 relative z-10 text-center">
            <span class="inline-block px-5 py-2 rounded-full bg-primary/10 text-primary text-[10px] font-black uppercase tracking-[0.2em] mb-8 border border-primary/20">Join the Revolution</span>
            <h1 class="text-5xl md:text-7xl font-black text-gray-900 mb-8 tracking-tighter leading-[0.95]">Shape the Future of <br/><span class="text-primary italic">African Commerce</span></h1>
            <p class="text-cool-gray text-lg md:text-xl max-w-2xl mx-auto leading-relaxed mb-12 font-medium">
                We are building the tools that empower millions of Ugandan businesses to thrive in the digital age. Come build with us.
            </p>
            <div class="flex flex-col sm:flex-row items-center justify-center gap-4">
                <a href="#openings" class="w-full sm:w-auto inline-flex items-center justify-center gap-3 bg-primary text-white px-10 py-5 rounded-[2rem] font-black hover:bg-emerald-700 transition-all shadow-2xl shadow-primary/30 hover:-translate-y-1 active:scale-95">
                    View Openings
                    <i class="fa-solid fa-arrow-down text-sm"></i>
                </a>
                <a href="mailto:careers@xperbyte.xyz" class="w-full sm:w-auto inline-flex items-center justify-center gap-3 bg-white text-gray-900 px-10 py-5 rounded-[2rem] font-black border border-gray-200 hover:bg-gray-50 transition-all">
                    Direct Application
                    <i class="fa-solid fa-envelope text-sm opacity-40"></i>
                </a>
            </div>
        </div>
    </section>

    <!-- Core Values -->
    <section class="py-32">
        <div class="container mx-auto px-4">
            <div class="max-w-4xl mx-auto text-center mb-20">
                <h2 class="text-3xl md:text-5xl font-black text-gray-900 mb-6 tracking-tight">Our Core Values</h2>
                <p class="text-cool-gray text-lg font-medium">The principles that guide every line of code we write and every decision we make.</p>
                <div class="w-20 h-1.5 bg-primary rounded-full mx-auto mt-8"></div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Innovation -->
                <div class="group bg-white p-12 rounded-[48px] shadow-2xl shadow-gray-200/50 border border-gray-50 hover:border-primary/20 transition-all duration-500 hover:-translate-y-2">
                    <div class="w-16 h-16 rounded-3xl bg-blue-50 text-blue-600 flex items-center justify-center text-3xl mb-8 group-hover:bg-blue-600 group-hover:text-white transition-all duration-300">
                        <i class="fa-solid fa-lightbulb"></i>
                    </div>
                    <h3 class="text-2xl font-black text-gray-900 mb-4">Innovation First</h3>
                    <p class="text-cool-gray leading-relaxed font-medium">We don't just follow trends; we set them. We're building AI tools that redefine how local businesses operate.</p>
                </div>

                <!-- Empowerment -->
                <div class="group bg-white p-12 rounded-[48px] shadow-2xl shadow-gray-200/50 border border-gray-50 hover:border-primary/20 transition-all duration-500 hover:-translate-y-2">
                    <div class="w-16 h-16 rounded-3xl bg-purple-50 text-purple-600 flex items-center justify-center text-3xl mb-8 group-hover:bg-purple-600 group-hover:text-white transition-all duration-300">
                        <i class="fa-solid fa-users-gear"></i>
                    </div>
                    <h3 class="text-2xl font-black text-gray-900 mb-4">True Empowerment</h3>
                    <p class="text-cool-gray leading-relaxed font-medium">Our mission is to give every seller in Uganda the same digital power as a global retail giant.</p>
                </div>

                <!-- Growth -->
                <div class="group bg-white p-12 rounded-[48px] shadow-2xl shadow-gray-200/50 border border-gray-50 hover:border-primary/20 transition-all duration-500 hover:-translate-y-2">
                    <div class="w-16 h-16 rounded-3xl bg-emerald-50 text-emerald-600 flex items-center justify-center text-3xl mb-8 group-hover:bg-emerald-600 group-hover:text-white transition-all duration-300">
                        <i class="fa-solid fa-rocket"></i>
                    </div>
                    <h3 class="text-2xl font-black text-gray-900 mb-4">Fast Growth</h3>
                    <p class="text-cool-gray leading-relaxed font-medium">At Yilick (and Xperbyte), we move fast. You'll work on impactful projects that launch in weeks, not years.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Why Work With Us -->
    <section class="py-32 bg-gray-50 relative overflow-hidden">
        <div class="container mx-auto px-4 relative z-10">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-20 items-center">
                <div>
                    <h2 class="text-4xl md:text-5xl font-black text-gray-900 mb-8 leading-tight">Why you'll love <br/>working at <span class="text-primary">Yilick</span></h2>
                    <p class="text-cool-gray text-lg mb-12 font-medium">We believe in creating an environment where talent meets opportunity, and hard work meets high reward.</p>
                    
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-6">
                        <div class="flex items-center gap-4">
                            <div class="w-10 h-10 rounded-full bg-primary/10 text-primary flex items-center justify-center">
                                <i class="fa-solid fa-check font-bold"></i>
                            </div>
                            <span class="font-bold text-gray-700">Remote Flexibility</span>
                        </div>
                        <div class="flex items-center gap-4">
                            <div class="w-10 h-10 rounded-full bg-primary/10 text-primary flex items-center justify-center">
                                <i class="fa-solid fa-check font-bold"></i>
                            </div>
                            <span class="font-bold text-gray-700">Health Coverage</span>
                        </div>
                        <div class="flex items-center gap-4">
                            <div class="w-10 h-10 rounded-full bg-primary/10 text-primary flex items-center justify-center">
                                <i class="fa-solid fa-check font-bold"></i>
                            </div>
                            <span class="font-bold text-gray-700">Modern Tech Stack</span>
                        </div>
                        <div class="flex items-center gap-4">
                            <div class="w-10 h-10 rounded-full bg-primary/10 text-primary flex items-center justify-center">
                                <i class="fa-solid fa-check font-bold"></i>
                            </div>
                            <span class="font-bold text-gray-700">Equity Options</span>
                        </div>
                    </div>
                </div>
                
                <div class="relative">
                    <div class="aspect-square bg-white rounded-[60px] shadow-2xl flex items-center justify-center p-12 relative z-10">
                        <div class="text-center">
                            <div class="text-6xl font-black text-primary mb-4 italic">Xperbyte</div>
                            <div class="text-cool-gray font-black uppercase tracking-widest text-sm">Our Parent Company</div>
                        </div>
                    </div>
                    <!-- Decorative back elements -->
                    <div class="absolute -top-10 -right-10 w-full h-full bg-primary/5 rounded-[60px] -z-10 translate-x-4 translate-y-4 border border-primary/10"></div>
                </div>
            </div>
        </div>
    </section>

    <!-- Openings -->
    <section id="openings" class="py-32">
        <div class="container mx-auto px-4 max-w-5xl">
            <div class="text-center mb-20">
                <h2 class="text-3xl md:text-5xl font-black text-gray-900 mb-6 tracking-tight">Open Opportunities</h2>
                <div class="w-24 h-1.5 bg-primary rounded-full mx-auto"></div>
            </div>

            <!-- Enhanced Empty State -->
            <div class="bg-white rounded-[60px] border-2 border-dashed border-gray-200 p-16 md:p-24 text-center shadow-xl shadow-gray-50">
                <div class="w-24 h-24 bg-emerald-50 rounded-full flex items-center justify-center mx-auto mb-10 text-primary">
                    <i class="fa-solid fa-briefcase text-4xl"></i>
                </div>
                <h3 class="text-3xl font-black text-gray-900 mb-4">No active roles today</h3>
                <p class="text-cool-gray text-lg mb-12 max-w-lg mx-auto font-medium">We're always looking for talented creators, engineers, and visionaries. Tell us why you belong here.</p>
                <a href="mailto:careers@xperbyte.xyz" class="inline-flex items-center gap-3 bg-gray-900 text-white px-12 py-6 rounded-[2rem] font-black hover:bg-primary transition-all shadow-xl hover:-translate-y-1">
                    Send Open Pitch
                    <i class="fa-solid fa-paper-plane text-sm"></i>
                </a>
                <div class="mt-12 text-sm text-cool-gray">
                    Or follow us on <a href="https://www.linkedin.com/company/yilickapp" target="_blank" class="text-primary font-black hover:underline">LinkedIn</a> for updates.
                </div>
            </div>
        </div>
    </section>
</div>
@endsection
