@extends('layouts.app')

@section('title', 'Congratulations! Your Shop is Live - Yilick')

@section('content')
<div class="min-h-[80vh] flex items-center justify-center py-12 px-4 relative overflow-hidden">
    <!-- Background Sparkles (CSS) -->
    <div class="absolute inset-0 pointer-events-none">
        <div class="sparkle-1 absolute top-20 left-[10%] w-2 h-2 bg-primary rounded-full opacity-20 animate-ping"></div>
        <div class="sparkle-2 absolute top-40 right-[15%] w-3 h-3 bg-vibrant-orange rounded-full opacity-20 animate-bounce"></div>
        <div class="sparkle-3 absolute bottom-20 left-[20%] w-2 h-2 bg-primary-dark rounded-full opacity-20 animate-pulse"></div>
    </div>

    <div class="max-w-4xl w-full">
        <div class="bg-white rounded-[3rem] shadow-2xl shadow-gray-200/50 border border-gray-100 overflow-hidden text-center p-8 md:p-16 relative">
            
            <!-- Success Animation / Icon -->
            <div class="mb-10 flex justify-center">
                <div class="relative">
                    <div class="w-24 h-24 md:w-32 md:h-32 bg-primary/10 rounded-full flex items-center justify-center text-primary text-4xl md:text-6xl animate-in zoom-in-50 duration-700">
                        <i class="fa-solid fa-check"></i>
                    </div>
                    <!-- Decorative Rings -->
                    <div class="absolute inset-0 border-4 border-primary/20 rounded-full animate-ping delay-100"></div>
                    <div class="absolute inset-[-10px] border-2 border-primary/10 rounded-full animate-pulse delay-300"></div>
                </div>
            </div>

            <!-- Content Header -->
            <div class="animate-in fade-in slide-in-from-bottom-6 duration-700 delay-200">
                <h1 class="text-4xl md:text-6xl font-black text-charcoal-gray tracking-tight mb-4">
                    Congratulations, <span class="text-primary italic">{{ explode(' ', auth()->user()->full_name)[0] }}!</span>
                </h1>
                <p class="text-xl md:text-2xl font-bold text-cool-gray mb-8">
                    Your shop <span class="text-charcoal-gray">"{{ $business->name }}"</span> is now live on Yilick!
                </p>
            </div>

            <!-- Next Steps Section -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-12 text-left animate-in fade-in slide-in-from-bottom-10 duration-1000 delay-500">
                <!-- Step 1 -->
                <div class="bg-gray-50 p-6 rounded-[2rem] border border-gray-100 hover:border-primary/30 transition-all group">
                    <div class="w-12 h-12 bg-primary text-white rounded-2xl flex items-center justify-center mb-4 shadow-lg shadow-primary/20 transition-transform group-hover:scale-110 group-hover:rotate-6">
                        <i class="fa-solid fa-rocket"></i>
                    </div>
                    <h3 class="font-black text-charcoal-gray mb-2 uppercase tracking-wider text-xs">Launch Fast</h3>
                    <p class="text-cool-gray text-sm leading-relaxed">Add your first products and reach thousands of buyers instantly.</p>
                </div>

                <!-- Step 2 -->
                <div class="bg-gray-50 p-6 rounded-[2rem] border border-gray-100 hover:border-vibrant-orange/30 transition-all group">
                    <div class="w-12 h-12 bg-vibrant-orange text-white rounded-2xl flex items-center justify-center mb-4 shadow-lg shadow-vibrant-orange/20 transition-transform group-hover:scale-110 group-hover:rotate-6">
                        <i class="fa-solid fa-chart-line"></i>
                    </div>
                    <h3 class="font-black text-charcoal-gray mb-2 uppercase tracking-wider text-xs">Track Growth</h3>
                    <p class="text-cool-gray text-sm leading-relaxed">Use your dashboard to monitor visits, clicks, and sales in real-time.</p>
                </div>

                <!-- Step 3 -->
                <div class="bg-gray-50 p-6 rounded-[2rem] border border-gray-100 hover:border-primary/30 transition-all group">
                    <div class="w-12 h-12 bg-primary-dark text-white rounded-2xl flex items-center justify-center mb-4 shadow-lg shadow-black/10 transition-transform group-hover:scale-110 group-hover:rotate-6">
                        <i class="fa-solid fa-crown"></i>
                    </div>
                    <h3 class="font-black text-charcoal-gray mb-2 uppercase tracking-wider text-xs">GO PREMIUM</h3>
                    <p class="text-cool-gray text-sm leading-relaxed">Upgrade to showcase your shop at the top of search results.</p>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="flex flex-col md:flex-row items-center justify-center gap-4 animate-in fade-in slide-in-from-bottom-12 duration-1000 delay-700">
                <a href="{{ route('listing.create') }}" class="w-full md:w-auto px-12 py-5 bg-primary text-white rounded-2xl font-black shadow-xl shadow-primary/20 hover:bg-primary-dark hover:scale-105 active:scale-95 transition-all flex items-center justify-center gap-3 uppercase tracking-widest text-xs">
                    <span>Post First Ad</span>
                    <i class="fa-solid fa-plus-circle"></i>
                </a>
                
                <a href="{{ route('web.profile') }}" class="w-full md:w-auto px-12 py-5 bg-white border border-gray-100 rounded-2xl text-charcoal-gray font-black hover:bg-gray-50 hover:border-primary/30 transition-all uppercase tracking-widest text-xs flex items-center justify-center gap-3">
                    <i class="fa-solid fa-user-gear"></i>
                    <span>Manage Shop</span>
                </a>

                <a href="{{ route('web.home') }}" class="w-full md:w-auto px-8 py-5 text-cool-gray font-bold hover:text-primary transition-colors text-xs uppercase tracking-widest">
                    Back to Home
                </a>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.9.2/dist/confetti.browser.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Trigger professional confetti
        const duration = 3 * 1000;
        const animationEnd = Date.now() + duration;
        const defaults = { startVelocity: 30, spread: 360, ticks: 60, zIndex: 0 };

        function randomInRange(min, max) {
            return Math.random() * (max - min) + min;
        }

        const interval = setInterval(function() {
            const timeLeft = animationEnd - Date.now();

            if (timeLeft <= 0) {
                return clearInterval(interval);
            }

            const particleCount = 50 * (timeLeft / duration);
            // since particles fall down, start a bit higher than random
            confetti(Object.assign({}, defaults, { 
                particleCount, 
                origin: { x: randomInRange(0.1, 0.3), y: Math.random() - 0.2 },
                colors: ['#00cc50', '#2AB188', '#E96F2B', '#F2D16B']
            }));
            confetti(Object.assign({}, defaults, { 
                particleCount, 
                origin: { x: randomInRange(0.7, 0.9), y: Math.random() - 0.2 },
                colors: ['#00cc50', '#2AB188', '#E96F2B', '#F2D16B']
            }));
        }, 250);
    });
</script>
@endpush

<style>
    @keyframes sparkle {
        0%, 100% { transform: scale(1); opacity: 0.2; }
        50% { transform: scale(1.5); opacity: 0.5; }
    }
    .sparkle-1 { animation: sparkle 3s infinite; }
    .sparkle-2 { animation: sparkle 4s infinite 1s; }
    .sparkle-3 { animation: sparkle 5s infinite 2s; }
</style>
@endsection
