@extends('layouts.app')

@section('title', 'Sign In - Yilick')

@section('content')
<div class="min-h-[80vh] flex flex-col items-center justify-center py-12 px-4 sm:px-6 lg:px-8 bg-gray-50/50 relative overflow-hidden">
    <!-- Decorative background elements -->
    <div class="absolute top-0 right-0 -translate-y-1/2 translate-x-1/2 w-96 h-96 bg-primary/5 rounded-full blur-3xl pointer-events-none"></div>
    <div class="absolute bottom-0 left-0 translate-y-1/2 -translate-x-1/2 w-80 h-80 bg-primary/5 rounded-full blur-3xl pointer-events-none"></div>

    <div class="w-full max-w-md relative">

        <!-- Main Card -->
        <div class="bg-white rounded-[2.5rem] shadow-xl shadow-gray-200/40 border border-gray-100 p-8 md:p-10 relative z-10">
            <!-- Logo & Header -->
            <div class="text-center mb-10">
                <div class="w-24 h-24 bg-primary/10 rounded-full flex items-center justify-center mx-auto mb-6 ring-4 ring-primary/5">
                    <img src="{{ asset('assets/icons/logo.png') }}" alt="Yilick" class="w-16 h-16 object-contain" onerror="this.outerHTML='<i class=\'fa-solid fa-store text-primary text-3xl\'></i>'">
                </div>
                <h1 class="text-3xl font-black text-gray-900 tracking-tight mb-2">Sign In</h1>
                <p class="text-gray-500 font-medium">Sign in to continue to Yilick</p>
            </div>

            <!-- Login Form -->
            <form action="{{ route('login') }}" method="POST" class="space-y-6">
                @csrf
                
                <!-- Login (Email/Phone) -->
                <div class="space-y-2">
                    <label for="login" class="block text-xs font-black text-gray-400 uppercase tracking-widest ml-1">Email or Phone Number</label>
                    <div class="relative group">
                        <div class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400 group-focus-within:text-primary transition-colors">
                            <i class="fa-regular fa-envelope text-lg"></i>
                        </div>
                        <input type="text" 
                               name="login" 
                               id="login" 
                               value="{{ old('login') }}"
                               placeholder="Enter your email or phone" 
                               required
                               class="w-full pl-12 pr-4 py-4 rounded-2xl bg-gray-50 border border-gray-100 focus:bg-white focus:border-primary focus:ring-4 focus:ring-primary/10 outline-none transition-all font-medium text-gray-700 placeholder:text-gray-400">
                    </div>
                    @error('login')
                        <p class="text-red-500 text-xs font-bold mt-1 ml-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Password -->
                <div class="space-y-2">
                    <div class="flex items-center justify-between ml-1">
                        <label for="password" class="block text-xs font-black text-gray-400 uppercase tracking-widest">Password</label>
                        <a href="{{ route('password.request') }}" class="text-xs font-bold text-primary hover:underline">Forgot Password?</a>
                    </div>
                    <div class="relative group" id="password-group">
                        <div class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400 group-focus-within:text-primary transition-colors">
                            <i class="fa-solid fa-lock text-base"></i>
                        </div>
                        <input type="password" 
                               name="password" 
                               id="password" 
                               placeholder="••••••••" 
                               required
                               class="w-full pl-12 pr-12 py-4 rounded-2xl bg-gray-50 border border-gray-100 focus:bg-white focus:border-primary focus:ring-4 focus:ring-primary/10 outline-none transition-all font-medium text-gray-700 placeholder:text-gray-400">
                        <button type="button" 
                                onclick="togglePasswordVisibility()"
                                class="absolute right-4 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-600 transition-colors">
                            <i class="fa-regular fa-eye-slash" id="password-toggle-icon"></i>
                        </button>
                    </div>
                    @error('password')
                        <p class="text-red-500 text-xs font-bold mt-1 ml-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Remember Me -->
                <div class="flex items-center gap-2 ml-1">
                    <div class="relative flex items-center">
                        <input type="checkbox" name="remember" id="remember" class="peer h-5 w-5 cursor-pointer appearance-none rounded-md border border-gray-300 transition-all checked:bg-primary checked:border-primary">
                        <i class="fa-solid fa-check absolute left-1 top-1 text-[10px] text-white opacity-0 peer-checked:opacity-100 pointer-events-none"></i>
                    </div>
                    <label for="remember" class="text-sm font-semibold text-gray-600 cursor-pointer select-none">Remember me</label>
                </div>

                <!-- Submit Button -->
                <button type="submit" 
                        class="w-full py-4 bg-primary hover:bg-emerald-600 text-white font-bold rounded-2xl shadow-lg shadow-primary/20 hover:shadow-primary/30 transform hover:-translate-y-0.5 active:scale-[0.98] transition-all flex items-center justify-center gap-3">
                    <span>Sign In</span>
                    <i class="fa-solid fa-arrow-right text-sm"></i>
                </button>
            </form>

            <!-- Divider -->
            <div class="relative my-8">
                <div class="absolute inset-0 flex items-center">
                    <div class="w-full border-t border-gray-100"></div>
                </div>
                <div class="relative flex justify-center text-sm">
                    <span class="px-4 bg-white text-gray-400 font-bold uppercase tracking-widest text-[10px]">Or</span>
                </div>
            </div>

            <!-- Create Account -->
            <div class="text-center">
                <a href="{{ route('register') }}" class="inline-flex items-center gap-2 text-gray-600 hover:text-primary transition-all font-bold px-8 py-4 rounded-2xl border border-gray-200 hover:border-primary hover:bg-primary/5 w-full justify-center group">
                    <i class="fa-regular fa-user group-hover:scale-110 transition-transform"></i>
                    <span>Create New Account</span>
                </a>
            </div>

        </div>
        
        <!-- Footer Links -->
        <p class="text-center mt-10 text-gray-400 text-sm font-medium">
            By signing in, you agree to our <br class="sm:hidden">
            <a href="{{ route('web.terms') }}" class="text-gray-500 hover:text-primary hover:underline">Terms of Service</a> and 
            <a href="{{ route('web.privacy') }}" class="text-gray-500 hover:text-primary hover:underline">Privacy Policy</a>
        </p>
    </div>
</div>

<script>
    function togglePasswordVisibility() {
        const passwordInput = document.getElementById('password');
        const toggleIcon = document.getElementById('password-toggle-icon');
        
        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            toggleIcon.className = 'fa-regular fa-eye';
        } else {
            passwordInput.type = 'password';
            toggleIcon.className = 'fa-regular fa-eye-slash';
        }
    }
</script>
@endsection
