@extends('layouts.app')

@section('title', 'Forgot Password - Yilick')

@section('content')
<div class="min-h-[80vh] flex flex-col items-center justify-center py-12 px-4 sm:px-6 lg:px-8 bg-gray-50/50 relative overflow-hidden">
    <!-- Decorative background elements -->
    <div class="absolute top-0 right-0 -translate-y-1/2 translate-x-1/2 w-96 h-96 bg-primary/5 rounded-full blur-3xl pointer-events-none"></div>
    <div class="absolute bottom-0 left-0 translate-y-1/2 -translate-x-1/2 w-80 h-80 bg-primary/5 rounded-full blur-3xl pointer-events-none"></div>

    <div class="w-full max-w-md relative">
        <!-- Main Card -->
        <div class="bg-white rounded-[2.5rem] shadow-xl shadow-gray-200/40 border border-gray-100 p-8 md:p-10 relative z-10">
            <!-- Logo & Header -->
            <div class="text-center mb-8">
                <div class="w-20 h-20 bg-primary/10 rounded-full flex items-center justify-center mx-auto mb-6 ring-4 ring-primary/5">
                    <img src="{{ asset('assets/icons/logo.png') }}" alt="Yilick" class="w-12 h-12 object-contain" onerror="this.outerHTML='<i class=\'fa-solid fa-store text-primary text-2xl\'></i>'">
                </div>
                <h1 class="text-3xl font-black text-gray-900 tracking-tight mb-2">Forgot Password?</h1>
                <p class="text-gray-500 font-medium text-sm leading-relaxed">Enter your email address and we'll send you a link to reset your password.</p>
            </div>

            <!-- Forgot Password Form -->
            <form action="{{ route('password.email') }}" method="POST" class="space-y-6">
                @csrf
                
                <div class="space-y-1.5">
                    <label for="email" class="block text-[10px] font-black text-gray-400 uppercase tracking-widest ml-1">Email Address</label>
                    <div class="relative group">
                        <div class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400 group-focus-within:text-primary transition-colors">
                            <i class="fa-regular fa-envelope text-lg"></i>
                        </div>
                        <input type="email" name="email" id="email" value="{{ old('email') }}" placeholder="your@email.com" required
                               class="w-full pl-12 pr-4 py-4 rounded-2xl bg-gray-50 border border-gray-100 focus:bg-white focus:border-primary focus:ring-4 focus:ring-primary/10 outline-none transition-all font-medium text-gray-700">
                    </div>
                    @error('email') <p class="text-red-500 text-[10px] font-bold mt-1 ml-1">{{ $message }}</p> @enderror
                </div>

                <!-- Submit Button -->
                <button type="submit" 
                        class="w-full py-4 bg-primary hover:bg-emerald-600 text-white font-bold rounded-2xl shadow-lg shadow-primary/20 hover:shadow-primary/30 transform hover:-translate-y-0.5 active:scale-[0.98] transition-all flex items-center justify-center gap-3">
                    <span>Send Reset Link</span>
                    <i class="fa-solid fa-paper-plane text-sm"></i>
                </button>
            </form>

            <!-- Divider -->
            <div class="relative my-10">
                <div class="absolute inset-0 flex items-center">
                    <div class="w-full border-t border-gray-100"></div>
                </div>
                <div class="relative flex justify-center text-sm">
                    <span class="px-4 bg-white text-gray-400 font-bold uppercase tracking-widest text-[10px]">Or</span>
                </div>
            </div>

            <!-- Back to Login -->
            <div class="text-center">
                <a href="{{ route('login') }}" class="inline-flex items-center gap-2 text-gray-600 hover:text-primary transition-all font-bold px-8 py-4 rounded-2xl border border-gray-200 hover:border-primary hover:bg-primary/5 w-full justify-center group">
                    <i class="fa-solid fa-arrow-left group-hover:-translate-x-1 transition-transform"></i>
                    <span>Back to Sign In</span>
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
