@extends('layouts.app')

@section('title', 'About Yilick - Transforming Digital Commerce in Uganda & Africa')
@section('meta_description', 'Learn how Yilick is revolutionizing African commerce. Uganda\'s first AI-powered marketplace with integrated POS, inventory management, and data-driven insights for businesses.')
@section('meta_keywords', 'about yilick, digital commerce uganda, business growth africa, ai marketplace, ecommerce mission kampala, secure shopping uganda')

@section('header_meta')
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "AboutPage",
    "mainEntity": {
        "@id": "{{ route('web.home') }}#organization"
    },
    "description": "Yilick is Africa's leading business management and marketplace platform, combining classified listings with integrated AI tools."
}
</script>
@endsection

@section('content')
<div class="min-h-screen bg-white">
    <!-- Light & Professional Hero Section -->
    <div class="relative min-h-[90vh] flex items-center overflow-hidden bg-white pt-20">
        <!-- Subtle Background Elements -->
        <div class="absolute top-0 right-0 w-[600px] h-[600px] bg-primary/5 rounded-full blur-[100px] -translate-y-1/2 translate-x-1/2"></div>
        <div class="absolute bottom-0 left-0 w-[400px] h-[400px] bg-emerald-500/5 rounded-full blur-[80px] translate-y-1/4 -translate-x-1/4"></div>
        
        <!-- Dot Pattern -->
        <div class="absolute inset-0 z-0 opacity-[0.03]" style="background-image: radial-gradient(#10b981 0.5px, transparent 0.5px); background-size: 24px 24px;"></div>

        <div class="container mx-auto px-4 relative z-10">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <div class="text-left">
                    <div class="inline-flex items-center gap-3 px-4 py-2 rounded-full bg-primary/10 border border-primary/20 text-primary text-[10px] font-black uppercase tracking-[0.2em] mb-8 reveal-up">
                        <span class="w-2 h-2 rounded-full bg-primary animate-pulse"></span>
                        Our Mission & Vision
                    </div>
                    <h1 class="text-5xl md:text-7xl font-black text-gray-900 leading-[1.05] mb-8 reveal-up">
                        Empowering <span class="text-primary italic">Africa's</span><br>
                        Digital <span class="relative">
                            <span class="relative z-10">Frontier</span>
                            <span class="absolute bottom-2 left-0 w-full h-4 bg-primary/10 -z-10 rotate-1"></span>
                        </span>
                    </h1>
                    <p class="text-lg md:text-xl text-gray-600 leading-relaxed font-medium mb-10 max-w-xl reveal-up">
                        Yilick is more than a marketplace. We're building the complete AI-powered operating system for businesses across Uganda, making commerce simpler, smarter, and faster for everyone.
                    </p>
                    <div class="flex flex-wrap gap-5 reveal-up">
                        <a href="{{ route('register') }}" class="px-8 py-4 bg-primary text-white rounded-2xl font-black hover:bg-emerald-600 transition-all hover:scale-105 shadow-xl shadow-primary/20 group">
                            Build Your Shop
                            <i class="fa-solid fa-arrow-right ml-2 group-hover:translate-x-1 transition-transform"></i>
                        </a>
                        <button type="button" onclick="openSupportModal()" class="px-8 py-4 bg-gray-50 text-gray-900 border border-gray-100 rounded-2xl font-black hover:bg-gray-100 transition-all">
                            Talk to Our Team
                        </button>
                    </div>
                    
                    <!-- Trusted By Label -->
                    <div class="mt-12 flex items-center gap-4 reveal-up">
                        <div class="flex -space-x-3">
                            <div class="w-10 h-10 rounded-full border-2 border-white bg-gray-200 overflow-hidden"><img src="https://i.pravatar.cc/100?u=1" alt=""></div>
                            <div class="w-10 h-10 rounded-full border-2 border-white bg-gray-200 overflow-hidden"><img src="https://i.pravatar.cc/100?u=2" alt=""></div>
                            <div class="w-10 h-10 rounded-full border-2 border-white bg-gray-200 overflow-hidden"><img src="https://i.pravatar.cc/100?u=3" alt=""></div>
                        </div>
                        <div class="text-xs font-bold text-gray-400 uppercase tracking-widest">Trusted by 10,000+ Sellers</div>
                    </div>
                </div>
                
                <div class="relative hidden lg:block reveal-right">
                    <div class="relative z-10 rounded-[3rem] overflow-hidden shadow-[0_40px_80px_rgba(0,0,0,0.1)]">
                        <img src="https://images.unsplash.com/photo-1522202176988-66273c2fd55f?auto=format&fit=crop&q=80&w=1200" class="w-full h-[600px] object-cover" alt="Team working">
                        <div class="absolute inset-0 bg-gradient-to-tr from-primary/20 via-transparent to-transparent"></div>
                    </div>
                    
                    <!-- Floating Badge -->
                    <div class="absolute -bottom-10 -left-10 bg-white p-8 rounded-[2.5rem] shadow-2xl border border-gray-50 flex items-center gap-5 animate-bounce-slow">
                        <div class="w-14 h-14 rounded-2xl bg-primary flex items-center justify-center text-white text-2xl shadow-lg shadow-primary/30">
                            <i class="fa-solid fa-bolt"></i>
                        </div>
                        <div>
                            <div class="text-2xl font-black text-gray-900">AI-First</div>
                            <div class="text-xs font-bold text-gray-400 uppercase tracking-widest">Platform Design</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Subtle Scroll Indicator -->
        <div class="absolute bottom-10 left-1/2 -translate-x-1/2 hidden md:block opacity-30">
            <div class="w-6 h-10 border-2 border-gray-400 rounded-full flex justify-center p-1">
                <div class="w-1.5 h-1.5 bg-gray-400 rounded-full animate-bounce"></div>
            </div>
        </div>
    </div>

    <!-- The "Why" Section - Visionary Stats -->
    <div class="py-32 relative overflow-hidden">
        <div class="container mx-auto px-4">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-24 items-center">
                <div class="reveal-left">
                    <h2 class="text-4xl md:text-5xl font-black text-gray-900 leading-tight mb-8">
                        More Than a Marketplace.<br>
                        <span class="text-primary">A Growth Engine.</span>
                    </h2>
                    <p class="text-lg text-gray-600 leading-relaxed mb-10 font-medium">
                        Our platform aims to become Africa's leading business management and marketplace, combining classified listings with integrated business tools powered by AI-driven insights. We believe every business, from street vendors to enterprise firms, deserves elite digital tools.
                    </p>
                    
                    <div class="grid grid-cols-2 gap-8">
                        <div class="p-8 rounded-[2rem] bg-gray-50 border border-gray-100 group hover:border-primary/30 transition-all">
                            <div class="text-3xl font-black text-gray-900 group-hover:text-primary transition-colors">Nationwide</div>
                            <div class="text-[10px] font-black text-gray-400 uppercase tracking-widest mt-2">Coverage in Uganda</div>
                        </div>
                        <div class="p-8 rounded-[2rem] bg-gray-50 border border-gray-100 group hover:border-primary/30 transition-all">
                            <div class="text-3xl font-black text-gray-900 group-hover:text-primary transition-colors">AI-First</div>
                            <div class="text-[10px] font-black text-gray-400 uppercase tracking-widest mt-2">Built-in Intelligence</div>
                        </div>
                    </div>
                </div>
                
                <div class="relative reveal-right">
                    <div class="aspect-square bg-gradient-to-br from-gray-900 to-gray-800 rounded-[3.5rem] p-1 shadow-2xl overflow-hidden group">
                        <div class="w-full h-full rounded-[3.4rem] overflow-hidden relative">
                             <img src="https://images.unsplash.com/photo-1551288049-bebda4e38f71?auto=format&fit=crop&q=80&w=1000" class="w-full h-full object-cover opacity-60 group-hover:scale-110 transition-transform duration-700" alt="Data Analytics">
                             <div class="absolute inset-0 bg-primary/20 mix-blend-overlay"></div>
                             
                             <!-- Floating UI Elements -->
                             <div class="absolute top-12 right-12 bg-white/10 backdrop-blur-xl p-6 rounded-3xl border border-white/20 animate-bounce-slow">
                                 <div class="flex items-center gap-3">
                                     <div class="w-10 h-10 rounded-xl bg-primary flex items-center justify-center text-white">
                                         <i class="fa-solid fa-chart-simple"></i>
                                     </div>
                                     <div>
                                         <div class="text-white font-black text-lg">+124%</div>
                                         <div class="text-white/60 text-[8px] font-black uppercase tracking-widest">Revenue Growth</div>
                                     </div>
                                 </div>
                             </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Core Pillars - Bento Grid Style -->
    <div class="py-32 bg-gray-50">
        <div class="container mx-auto px-4">
            <div class="text-center max-w-3xl mx-auto mb-20 reveal-up">
                <h2 class="text-4xl font-black text-gray-900 mb-6">Our Fundamental Pillars</h2>
                <p class="text-gray-500 font-bold uppercase tracking-[0.2em] text-xs">How We're Changing the Game</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Pillar 1 -->
                <div class="md:col-span-2 group reveal-up">
                    <div class="relative h-full bg-white p-12 rounded-[3rem] border border-gray-100 shadow-sm hover:shadow-2xl transition-all duration-500 overflow-hidden">
                        <div class="absolute top-0 right-0 p-12 opacity-5 group-hover:scale-110 transition-transform">
                            <i class="fa-solid fa-robot text-9xl"></i>
                        </div>
                        <div class="w-16 h-16 rounded-2xl bg-primary/10 flex items-center justify-center text-primary text-2xl mb-10 group-hover:bg-primary group-hover:text-white transition-all">
                            <i class="fa-solid fa-brain"></i>
                        </div>
                        <h3 class="text-3xl font-black text-gray-900 mb-6">Innovative AI Ecosystem</h3>
                        <p class="text-lg text-gray-600 leading-relaxed max-w-xl">
                            We're pioneering AI-driven solutions that transform how businesses operate. From automated inventory tracking to smart customer insights, we put a personal AI assistant in the pocket of every shop owner in Uganda.
                        </p>
                    </div>
                </div>

                <!-- Pillar 2 -->
                <div class="group reveal-up" style="transition-delay: 100ms">
                    <div class="relative h-full bg-primary p-12 rounded-[3rem] text-white shadow-xl shadow-primary/20 hover:scale-[1.02] transition-all duration-500">
                        <div class="w-16 h-16 rounded-2xl bg-white/20 flex items-center justify-center text-white text-2xl mb-10">
                            <i class="fa-solid fa-shield-halved"></i>
                        </div>
                        <h3 class="text-3xl font-black mb-6">Unshakeable Trust</h3>
                        <p class="text-white/80 leading-relaxed">
                            Marketplaces only work when there's trust. We use bank-grade security and verified profiles to ensure every transaction on Yilick is safe.
                        </p>
                    </div>
                </div>

                <!-- Pillar 3 -->
                <div class="group reveal-up" style="transition-delay: 200ms">
                    <div class="relative h-full bg-gray-900 p-12 rounded-[3rem] text-white hover:bg-black transition-all duration-500 overflow-hidden">
                        <div class="absolute -bottom-10 -right-10 opacity-10">
                             <i class="fa-solid fa-users text-[200px]"></i>
                        </div>
                        <div class="w-16 h-16 rounded-2xl bg-white/10 flex items-center justify-center text-white text-2xl mb-10">
                            <i class="fa-solid fa-handshake-angle"></i>
                        </div>
                        <h3 class="text-2xl font-black mb-6">Community First</h3>
                        <p class="text-white/60 leading-relaxed">
                            Building a thriving ecosystem that supports local business growth and economic development for all Ugandans.
                        </p>
                    </div>
                </div>

                <!-- Pillar 4 -->
                <div class="md:col-span-2 group reveal-up" style="transition-delay: 300ms">
                    <div class="relative h-full bg-white p-12 rounded-[3rem] border border-gray-100 shadow-sm hover:shadow-2xl transition-all duration-500 overflow-hidden">
                         <div class="grid grid-cols-1 md:grid-cols-2 gap-10 items-center">
                            <div>
                                <div class="w-16 h-16 rounded-2xl bg-amber-500/10 flex items-center justify-center text-amber-600 text-2xl mb-10 group-hover:bg-amber-500 group-hover:text-white transition-all">
                                    <i class="fa-solid fa-bolt-lightning"></i>
                                </div>
                                <h3 class="text-3xl font-black text-gray-900 mb-6">Scale at Speed</h3>
                                <p class="text-lg text-gray-600 leading-relaxed">
                                    Get high-performance tools that were previously only available to big retail chains. From POS to Advanced Analytics, Yilick gives you the power to scale.
                                </p>
                            </div>
                            <div class="bg-gray-50 rounded-[2rem] p-4 p-8">
                                <div class="flex flex-col gap-4">
                                    <div class="flex items-center gap-4 bg-white p-4 rounded-xl shadow-sm border border-gray-100">
                                        <div class="w-8 h-8 rounded-lg bg-emerald-500 flex items-center justify-center text-white text-xs"><i class="fa-solid fa-check"></i></div>
                                        <div class="text-xs font-black text-gray-900 uppercase">Inventory Management</div>
                                    </div>
                                    <div class="flex items-center gap-4 bg-white p-4 rounded-xl shadow-sm border border-gray-100">
                                        <div class="w-8 h-8 rounded-lg bg-primary flex items-center justify-center text-white text-xs"><i class="fa-solid fa-check"></i></div>
                                        <div class="text-xs font-black text-gray-900 uppercase">Interactive POS</div>
                                    </div>
                                    <div class="flex items-center gap-4 bg-white p-4 rounded-xl shadow-sm border border-gray-100 opacity-50">
                                         <div class="w-8 h-8 rounded-lg bg-gray-200 flex items-center justify-center text-gray-500 text-xs"><i class="fa-solid fa-lock"></i></div>
                                         <div class="text-xs font-black text-gray-400 uppercase tracking-widest italic">Predictive AI</div>
                                    </div>
                                </div>
                            </div>
                         </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Our Journey - Modern Timeline -->
    <div class="py-32 bg-white overflow-hidden">
        <div class="container mx-auto px-4">
            <div class="flex flex-col md:flex-row gap-20">
                <div class="md:w-1/3">
                    <div class="sticky top-32">
                        <div class="text-primary font-black uppercase tracking-[0.3em] text-[10px] mb-4">Our Trajectory</div>
                        <h2 class="text-5xl font-black text-gray-900 leading-tight mb-8">The Journey<br>to Africa's OS</h2>
                        <p class="text-lg text-gray-600 font-medium leading-relaxed">
                            From a simple classifieds project to an all-encompassing business ecosystem. We're just getting started.
                        </p>
                    </div>
                </div>
                
                <div class="md:w-2/3 space-y-20">
                    <!-- Step 1 -->
                    <div class="relative pl-12 reveal-up">
                        <div class="absolute left-0 top-0 bottom-0 w-[2px] bg-gray-100"></div>
                        <div class="absolute left-[-9px] top-0 w-5 h-5 rounded-full bg-primary border-4 border-white shadow-xl"></div>
                        <div class="text-sm font-black text-primary mb-2 uppercase tracking-widest">The Beginning</div>
                        <h4 class="text-2xl font-black text-gray-900 mb-4">Redefining Classifieds</h4>
                        <p class="text-gray-600 max-w-xl">
                            We started by asking why buying and selling in Uganda had to be so complicated. We built the first version of Yilick to make person-to-person commerce safer and faster.
                        </p>
                    </div>

                    <!-- Step 2 -->
                    <div class="relative pl-12 reveal-up" style="transition-delay: 100ms">
                         <div class="absolute left-0 top-0 bottom-0 w-[2px] bg-gray-100"></div>
                         <div class="absolute left-[-9px] top-0 w-5 h-5 rounded-full bg-amber-500 border-4 border-white shadow-xl"></div>
                         <div class="text-sm font-black text-amber-500 mb-2 uppercase tracking-widest">Expansion</div>
                         <h4 class="text-2xl font-black text-gray-900 mb-4">Business Tools Integration</h4>
                         <p class="text-gray-600 max-w-xl">
                             Realizing that sellers needed more than just eyes on their ads, we integrated a full suite of management tools, allowing vendors to run their entire operation from Yilick.
                         </p>
                    </div>

                    <!-- Step 3 -->
                    <div class="relative pl-12 reveal-up" style="transition-delay: 200ms">
                         <div class="absolute left-0 top-0 w-[2px] h-full bg-gray-100 border-dashed"></div>
                         <div class="absolute left-[-9px] top-0 w-5 h-5 rounded-full bg-black border-4 border-white shadow-xl"></div>
                         <div class="text-sm font-black text-gray-900 mb-2 uppercase tracking-widest">The Future</div>
                         <h4 class="text-2xl font-black text-gray-900 mb-4">AI-Driven Revolution</h4>
                         <p class="text-gray-600 max-w-xl">
                             Our roadmap is paved with AI. We are training models specifically for the African marketplace to predict trends, automate pricing, and personalize the shopping experience like never before.
                         </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Final CTA - High Impact -->
    <div class="py-32 container mx-auto px-4">
        <div class="relative bg-primary rounded-[4rem] p-12 md:p-24 text-center overflow-hidden shadow-[0_40px_100px_rgba(16,185,129,0.25)]">
            <!-- Decorative circle -->
            <div class="absolute top-0 right-0 w-[500px] h-[500px] bg-white/10 rounded-full blur-[80px] -translate-y-1/2 translate-x-1/2"></div>
            
            <div class="relative z-10 max-w-3xl mx-auto">
                <h2 class="text-4xl md:text-6xl font-black text-white mb-10 leading-tight">
                    Join the digital commerce revolution.
                </h2>
                <p class="text-white/80 text-xl font-medium mb-12">
                    Whether you're a buyer looking for quality or a seller aiming for the sky, your journey starts here.
                </p>
                <div class="flex flex-wrap justify-center gap-6">
                    <a href="{{ route('register') }}" class="px-12 py-6 bg-white text-primary rounded-2xl font-black text-xl hover:scale-105 transition-all shadow-2xl active:scale-95">
                        Build Your Shop
                    </a>
                    <a href="{{ route('web.home') }}" class="px-12 py-6 bg-white/10 backdrop-blur-md text-white border border-white/20 rounded-2xl font-black text-xl hover:bg-white/20 transition-all">
                        Start Shopping
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

@include('web.partials.support-modal')

<style>
    .reveal-up { @apply opacity-0 translate-y-10 transition-all duration-700 ease-out; }
    .reveal-left { @apply opacity-0 -translate-x-10 transition-all duration-700 ease-out; }
    .reveal-right { @apply opacity-0 translate-x-10 transition-all duration-700 ease-out; }
    
    .reveal-visible { @apply opacity-100 translate-y-0 translate-x-0; }

    .animate-bounce-slow {
        animation: bounce-slow 4s infinite;
    }
    @keyframes bounce-slow {
        0%, 100% { transform: translateY(-5%); animation-timing-function: cubic-bezier(0.8,0,1,1); }
        50% { transform: none; animation-timing-function: cubic-bezier(0,0,0.2,1); }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const observerOptions = {
            threshold: 0.1
        };

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.classList.add('reveal-visible');
                }
            });
        }, observerOptions);

        document.querySelectorAll('.reveal-up, .reveal-left, .reveal-right').forEach(el => {
            observer.observe(el);
        });
    });
</script>
@endsection
