@if ($paginator->hasPages())
    <nav role="navigation" aria-label="{{ __('Pagination Navigation') }}" class="flex items-center justify-between">
        {{-- Mobile View --}}
        <div class="flex justify-between flex-1 sm:hidden">
            @if ($paginator->onFirstPage())
                <span class="relative inline-flex items-center px-6 py-3 text-xs font-black text-gray-300 bg-white border border-gray-100 cursor-default leading-5 rounded-2xl uppercase tracking-widest italic">
                    {!! __('pagination.previous') !!}
                </span>
            @else
                <a href="{{ $paginator->previousPageUrl() }}" class="relative inline-flex items-center px-6 py-3 text-xs font-black text-primary bg-white border border-primary/20 leading-5 rounded-2xl hover:bg-primary hover:text-white transition-all duration-300 shadow-sm active:scale-95 uppercase tracking-widest italic">
                    {!! __('pagination.previous') !!}
                </a>
            @endif

            @if ($paginator->hasMorePages())
                <a href="{{ $paginator->nextPageUrl() }}" class="relative inline-flex items-center px-6 py-3 ml-3 text-xs font-black text-primary bg-white border border-primary/20 leading-5 rounded-2xl hover:bg-primary hover:text-white transition-all duration-300 shadow-sm active:scale-95 uppercase tracking-widest italic">
                    {!! __('pagination.next') !!}
                </a>
            @else
                <span class="relative inline-flex items-center px-6 py-3 ml-3 text-xs font-black text-gray-300 bg-white border border-gray-100 cursor-default leading-5 rounded-2xl uppercase tracking-widest italic">
                    {!! __('pagination.next') !!}
                </span>
            @endif
        </div>

        {{-- Desktop View --}}
        <div class="hidden sm:flex-1 sm:flex sm:items-center sm:justify-between">
            <div>
                <p class="text-xs text-gray-400 font-bold uppercase tracking-widest">
                    Showing <span class="text-gray-900">{{ $paginator->firstItem() ?? 0 }}</span> to <span class="text-gray-900">{{ $paginator->lastItem() ?? 0 }}</span> of <span class="text-primary">{{ $paginator->total() }}</span> results
                </p>
            </div>

            <div>
                <span class="relative z-0 inline-flex items-center gap-2">
                    {{-- Previous Page Link --}}
                    @if ($paginator->onFirstPage())
                        <span aria-disabled="true" class="w-10 h-10 rounded-xl bg-gray-50 flex items-center justify-center text-gray-300 border border-gray-100 cursor-not-allowed">
                            <i class="fa-solid fa-chevron-left text-xs"></i>
                        </span>
                    @else
                        <a href="{{ $paginator->previousPageUrl() }}" rel="prev" class="w-10 h-10 rounded-xl bg-white flex items-center justify-center text-primary border border-primary/20 hover:bg-primary hover:text-white hover:border-primary transition-all duration-300 shadow-sm hover:shadow-primary/20 active:scale-90" aria-label="{{ __('pagination.previous') }}">
                            <i class="fa-solid fa-chevron-left text-xs"></i>
                        </a>
                    @endif

                    {{-- Pagination Elements --}}
                    @foreach ($elements as $element)
                        {{-- "Three Dots" Separator --}}
                        @if (is_string($element))
                            <span aria-disabled="true" class="w-10 h-10 flex items-center justify-center text-gray-400 font-bold">
                                {{ $element }}
                            </span>
                        @endif

                        {{-- Array Of Links --}}
                        @if (is_array($element))
                            @foreach ($element as $page => $url)
                                @if ($page == $paginator->currentPage())
                                    <span aria-current="page" class="w-10 h-10 rounded-xl bg-primary flex items-center justify-center text-white font-black text-sm shadow-lg shadow-primary/30 z-10">
                                        {{ $page }}
                                    </span>
                                @else
                                    <a href="{{ $url }}" class="w-10 h-10 rounded-xl bg-white flex items-center justify-center text-gray-600 font-bold text-sm border border-gray-100 hover:border-primary/50 hover:text-primary transition-all duration-300 shadow-sm active:scale-90" aria-label="{{ __('Go to page :page', ['page' => $page]) }}">
                                        {{ $page }}
                                    </a>
                                @endif
                            @endforeach
                        @endif
                    @endforeach

                    {{-- Next Page Link --}}
                    @if ($paginator->hasMorePages())
                        <a href="{{ $paginator->nextPageUrl() }}" rel="next" class="w-10 h-10 rounded-xl bg-white flex items-center justify-center text-primary border border-primary/20 hover:bg-primary hover:text-white hover:border-primary transition-all duration-300 shadow-sm hover:shadow-primary/20 active:scale-90" aria-label="{{ __('pagination.next') }}">
                            <i class="fa-solid fa-chevron-right text-xs"></i>
                        </a>
                    @else
                        <span aria-disabled="true" class="w-10 h-10 rounded-xl bg-gray-50 flex items-center justify-center text-gray-300 border border-gray-100 cursor-not-allowed">
                            <i class="fa-solid fa-chevron-right text-xs"></i>
                        </span>
                    @endif
                </span>
            </div>
        </div>
    </nav>
@endif
