@extends('layouts.mobile')

@section('content')
<!-- Header Section -->
<div class="relative bg-white pt-12 pb-20 px-6 overflow-hidden">
    <div class="relative z-10 fade-up">
        <h1 class="text-3xl font-[900] text-gray-900 leading-tight">Elevate Your<br><span class="text-emerald-600">Business</span></h1>
        <p class="text-gray-500 mt-3 text-base font-medium leading-relaxed max-w-[80%]">
            Scale faster with professional tools and premium visibility.
        </p>
    </div>
</div>

<div class="px-5 -mt-10 pb-12 space-y-8 relative z-20">
    @if($activeSubscription)
        <div class="fade-up delay-1 bg-white/80 backdrop-blur-md p-5 rounded-[2rem] border border-emerald-100 shadow-xl shadow-emerald-900/5 flex items-center gap-5">
            <div class="w-14 h-14 rounded-2xl bg-emerald-600 flex items-center justify-center flex-shrink-0 shadow-lg shadow-emerald-200">
                <i class="fa-solid fa-crown text-white text-xl"></i>
            </div>
            <div>
                <div class="text-[10px] font-extrabold text-emerald-600 uppercase tracking-[0.1em] mb-0.5">Active Subscription</div>
                <div class="text-lg font-black text-gray-900 leading-tight">{{ $activeSubscription->package->name }}</div>
                <div class="mt-1 flex flex-col gap-1">
                    <div class="text-[10px] text-gray-500 font-semibold flex items-center gap-1.5">
                        <i class="fa-regular fa-clock text-emerald-500 text-[10px]"></i>
                        Expires {{ $activeSubscription->expires_at->format('M d, Y') }}
                    </div>
                    <div class="text-[10px] text-gray-400 font-bold flex items-center gap-1.5">
                        <i class="fa-solid fa-layer-group text-emerald-500/50 text-[10px]"></i>
                        {{ $activeSubscription->listings_used }} / {{ $activeSubscription->package->max_listings }} Listings Used
                    </div>
                </div>
            </div>
        </div>
    @endif

    <div class="space-y-10">
        @foreach($packages as $package)
            @php
                $isCurrent = $activeSubscription && $activeSubscription->package_id === $package->id;
                $isPopular = !$activeSubscription && $loop->iteration === 2;
                $delayClass = "delay-" . ($loop->index + 1);
            @endphp
            
            <div class="fade-up {{ $delayClass }} bg-white rounded-[2.5rem] shadow-2xl shadow-gray-200/50 border border-gray-50 relative overflow-hidden active-scale transition-transform duration-200">
                @if($isPopular)
                <div class="absolute top-0 right-8 bg-emerald-600 text-white px-5 py-2 rounded-b-2xl text-[10px] font-black uppercase tracking-widest shadow-lg z-30">
                    Most Popular
                </div>
                @endif

                <div class="p-8">
                    <div class="flex justify-between items-start mb-6">
                        <div class="max-w-[65%]">
                            <h3 class="text-xl font-black text-gray-900 tracking-tight">{{ $package->name }}</h3>
                            <p class="text-xs text-gray-400 font-medium mt-1 leading-relaxed">{{ $package->description }}</p>
                        </div>
                        <div class="text-right">
                            <div class="text-[10px] font-extrabold text-gray-400 uppercase tracking-widest mb-1">{{ $package->currency }}</div>
                            <div class="text-2xl font-[900] text-gray-900 leading-none">
                                {{ number_format($package->price) }}
                            </div>
                            <div class="text-[10px] font-bold text-emerald-600 mt-2 bg-emerald-50 px-2 py-0.5 rounded-full inline-block">
                                {{ $package->duration_days }} Days
                            </div>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 gap-4 mb-8">
                        @foreach($package->features as $feature)
                        <div class="flex items-center gap-3">
                            <div class="w-2 h-2 rounded-full bg-emerald-500 flex-shrink-0 animate-pulse"></div>
                            <span class="text-[13px] text-gray-600 font-semibold leading-none">{{ $feature }}</span>
                        </div>
                        @endforeach
                    </div>

                    @if($isCurrent)
                        @if($package->slug === 'free')
                            <div class="block w-full text-center py-5 rounded-2xl bg-gray-100 text-gray-400 text-sm font-black uppercase tracking-widest border border-gray-200 cursor-not-allowed">
                                Active Plan
                            </div>
                        @else
                            <a href="{{ route('web.membership.checkout', ['id' => $package->id, 'mode' => 'mobile', 'business_id' => $businessId]) }}" 
                               class="block w-full text-center py-5 rounded-2xl bg-emerald-50 text-emerald-700 text-sm font-black uppercase tracking-widest border border-emerald-100/50">
                                Extend Plan
                            </a>
                        @endif
                    @else
                        <a href="{{ route('web.membership.checkout', ['id' => $package->id, 'mode' => 'mobile', 'business_id' => $businessId]) }}" 
                           class="block w-full text-center py-5 rounded-2xl bg-emerald-600 text-white text-sm font-black uppercase tracking-[0.2em] shadow-xl shadow-emerald-200 active-scale transition-all">
                            {{ $activeSubscription ? 'Change Plan' : 'Get Started' }}
                        </a>
                    @endif
                </div>
                
                <!-- Decorative background shape -->
                <div class="absolute -bottom-12 -right-12 w-32 h-32 bg-gray-50 rounded-full opacity-50 -z-0"></div>
            </div>
        @endforeach
    </div>

    <!-- Security & Trust -->
    <div class="fade-up delay-3 pt-6 pb-4">
        <div class="bg-emerald-50/50 rounded-3xl p-6 border border-emerald-100/50 text-center">
            <h4 class="text-xs font-black text-emerald-900 uppercase tracking-widest mb-1">Mobile Money</h4>
            <p class="text-[10px] text-emerald-600/70 font-bold">Secure payments via MTN & Airtel</p>
        </div>
    </div>
</div>
