@extends('layouts.mobile')

@push('styles')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@23.0.4/build/css/intlTelInput.css">
<style>
    .iti { width: 100%; }
    .iti__country-list { 
        border-radius: 1.5rem; 
        border: none; 
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
        padding: 0.75rem;
        margin-top: 0.5rem;
    }
    .iti__country { padding: 0.75rem 1rem; border-radius: 1rem; font-weight: 600; font-size: 0.875rem; }
    .iti__selected-flag { background: transparent !important; border-radius: 1.5rem 0 0 1.5rem; padding-left: 1.25rem; }
</style>
@endpush

@section('content')
<div class="bg-[#f9fafb] pb-28">
    <!-- Sophisticated App Bar -->
    <div class="bg-white/80 backdrop-blur-xl px-6 py-6 flex items-center gap-6 sticky top-0 z-50 border-b border-gray-50">
        <a href="{{ route('web.membership.index', ['mode' => 'mobile']) }}" class="w-11 h-11 rounded-2xl bg-gray-50 flex items-center justify-center active-scale transition-all text-gray-900 shadow-sm border border-gray-100">
            <i class="fa-solid fa-chevron-left text-sm"></i>
        </a>
        <h1 class="text-lg font-black text-gray-900 tracking-tight">Checkout</h1>
    </div>

    <div class="p-6 space-y-8">
        <!-- Selection Summary Card -->
        <div class="fade-up bg-white rounded-[2rem] p-8 border border-gray-100 shadow-sm relative overflow-hidden">
            <div class="relative z-10">
                <div class="flex justify-between items-start mb-6">
                    <div>
                        <div class="text-[10px] font-black text-emerald-600 uppercase tracking-[0.2em] mb-2">Selected Plan</div>
                        <h2 class="text-2xl font-[900] text-gray-900 tracking-tight">{{ $package->name }}</h2>
                    </div>
                    <div class="w-12 h-12 rounded-2xl bg-emerald-50 flex items-center justify-center">
                        <i class="fa-solid fa-crown text-emerald-600"></i>
                    </div>
                </div>
                
                <div class="flex items-baseline gap-2 mb-2">
                    @if($discount > 0)
                        <span class="text-3xl font-[900] text-gray-900">{{ number_format($finalPrice) }}</span>
                        <span class="text-sm font-bold text-gray-400 line-through">{{ number_format($package->price) }}</span>
                    @else
                        <span class="text-3xl font-[900] text-gray-900">{{ number_format($package->price) }}</span>
                    @endif
                    <span class="text-sm font-bold text-gray-400 uppercase tracking-widest">{{ $package->currency }}</span>
                </div>

                @if($discount > 0)
                <div class="flex items-center gap-2 text-[10px] font-bold text-emerald-600 mb-6 bg-emerald-50 px-3 py-1.5 rounded-xl w-fit border border-emerald-100/50">
                    <i class="fa-solid fa-tags"></i>
                    Upgrade Discount Applied: -{{ number_format($discount) }} UGX
                </div>
                @endif
                
                <div class="h-[1px] bg-gray-50 w-full mb-6"></div>
                
                <div class="flex flex-wrap gap-2">
                    <div class="flex items-center gap-2 text-[10px] font-black uppercase text-gray-400 bg-gray-50/80 px-4 py-2 rounded-xl border border-gray-100/50">
                        <i class="fa-solid fa-clock-rotate-left"></i>
                        {{ $package->duration_days }} Days Plan
                    </div>
                </div>
            </div>
        </div>

        <!-- Payment Method Selection -->
        <div class="fade-up delay-1">
            <h3 class="text-xs font-black text-gray-400 uppercase tracking-[0.2em] mb-4 px-2 text-center">Payment via Mobile Money</h3>
            
            <form action="{{ route('web.membership.process', $package->id) }}" method="POST" id="checkout-form">
                @csrf
                <input type="hidden" name="mode" value="mobile">
                <input type="hidden" name="full_phone" id="full_phone">
                <input type="hidden" name="business_id" value="{{ $businessId }}">
                
                <div class="space-y-6">
                    <!-- Phone Number Input Group -->
                    <div class="bg-white p-6 rounded-[2rem] border border-gray-100 shadow-sm">
                        <label for="phone" class="block text-[10px] font-black text-gray-400 uppercase tracking-widest mb-3 ml-1">MTN or Airtel Number</label>
                        <div class="relative">
                            <input type="tel" id="phone" name="phone_input" 
                                   class="w-full bg-gray-50 border-none rounded-2xl py-5 px-6 text-base font-bold text-gray-900 focus:ring-2 focus:ring-emerald-500 transition-all placeholder:text-gray-300"
                                   placeholder="7XX XXX XXX">
                        </div>
                        <div id="phone-error" class="hidden mt-3 text-[10px] font-bold text-red-500 flex items-center gap-1.5 ml-1">
                            <i class="fa-solid fa-circle-exclamation"></i>
                            <span>Please enter a valid Uganda number</span>
                        </div>
                        @error('full_phone')
                        <div class="mt-3 text-[10px] font-bold text-red-500 flex items-center gap-1.5 ml-1">
                            <i class="fa-solid fa-circle-exclamation"></i>
                            <span>{{ $message }}</span>
                        </div>
                        @enderror
                    </div>

                </div>
            </form>
        </div>

        <!-- Agreement -->
    <div class="fade-up delay-2 px-4">
        <p class="text-[10px] text-gray-400 font-bold text-center leading-relaxed italic">
            By clicking "Pay Now", you agree to our <a href="{{ route('web.terms') }}" class="text-emerald-600 underline">Terms of Use</a>.
        </p>
    </div>
    </div>

    <!-- Persistent Bottom Action -->
    <div class="fixed bottom-0 left-0 right-0 p-6 bg-white/80 backdrop-blur-xl border-t border-gray-50 pb-safe z-50">
        <button type="button" id="pay-button" 
                class="w-full bg-emerald-600 text-white rounded-[1.5rem] py-5 font-black text-sm uppercase tracking-[0.3em] shadow-xl shadow-emerald-200 active-scale transition-all flex items-center justify-center gap-3">
            <span id="button-text">Pay Now</span>
            <div id="button-loader" class="hidden">
                <i class="fa-solid fa-circle-notch fa-spin"></i>
            </div>
            <i id="button-icon" class="fa-solid fa-arrow-right text-[10px] animate-pulse"></i>
        </button>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@23.0.4/build/js/intlTelInput.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const phoneInput = document.querySelector("#phone");
        const form = document.querySelector("#checkout-form");
        const payButton = document.querySelector("#pay-button");
        const errorMsg = document.querySelector("#phone-error");
        const fullPhoneInput = document.querySelector("#full_phone");
        
        const loader = document.querySelector("#button-loader");
        const text = document.querySelector("#button-text");
        const icon = document.querySelector("#button-icon");

        const iti = window.intlTelInput(phoneInput, {
            initialCountry: "ug",
            onlyCountries: ["ug"],
            utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@23.0.4/build/js/utils.js",
            strictMode: true,
            containerClass: "w-full"
        });

        const reset = () => {
            phoneInput.classList.remove("ring-2", "ring-red-500");
            errorMsg.classList.add("hidden");
        };

        phoneInput.addEventListener('blur', () => {
            reset();
            if (phoneInput.value.trim()) {
                if (!iti.isValidNumber()) {
                    phoneInput.classList.add("ring-2", "ring-red-500");
                    errorMsg.classList.remove("hidden");
                }
            }
        });

        phoneInput.addEventListener('change', reset);
        phoneInput.addEventListener('keyup', reset);

        payButton.addEventListener('click', (e) => {
            e.preventDefault();
            reset();

            if (iti.isValidNumber()) {
                // Show loading state
                payButton.disabled = true;
                text.innerText = "Processing...";
                loader.classList.remove("hidden");
                icon.classList.add("hidden");
                
                fullPhoneInput.value = iti.getNumber();
                form.submit();
            } else {
                phoneInput.classList.add("ring-2", "ring-red-500");
                errorMsg.classList.remove("hidden");
                // Vibration feedback for mobile if available
                if (window.navigator && window.navigator.vibrate) {
                    window.navigator.vibrate(50);
                }
            }
        });
    });
</script>
@endpush
