<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verification Code</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background-color: #f3f4f6;
            color: #111827;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: #ffffff;
        }
        .header {
            background: #10b981;
            padding: 28px 24px;
            color: #ffffff;
        }
        .header h1 {
            margin: 0;
            font-size: 18px;
            font-weight: 700;
        }
        .content {
            padding: 24px;
        }
        .otp {
            margin: 18px 0;
            padding: 18px;
            border: 1px solid #e5e7eb;
            border-radius: 12px;
            background: #f9fafb;
            text-align: center;
        }
        .otp-code {
            font-size: 34px;
            letter-spacing: 6px;
            font-weight: 800;
            color: #111827;
            font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, 'Liberation Mono', 'Courier New', monospace;
        }
        .hint {
            font-size: 14px;
            color: #374151;
            line-height: 1.6;
            margin-top: 12px;
        }
        .small {
            font-size: 12px;
            color: #6b7280;
            line-height: 1.6;
            margin-top: 14px;
        }
        .footer {
            padding: 18px 24px;
            font-size: 12px;
            color: #6b7280;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>{{ config('app.name') }} Verification Code</h1>
        </div>

        <div class="content">
            <p style="margin: 0; font-size: 14px; color: #374151; line-height: 1.6;">
                Use the code below to complete verification.
            </p>

            <div class="otp">
                <div class="otp-code">{{ $otp }}</div>
            </div>

            <div class="hint">
                This code expires in <strong>{{ (int) ceil($expiresInSeconds / 60) }} minutes</strong>.
            </div>

            <div class="small">
                If you didn’t request this code, you can ignore this email.
            </div>
        </div>

        <div class="footer">
            © {{ date('Y') }} {{ config('app.name') }}
        </div>
    </div>
</body>
</html>
