<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Business Invitation Update</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: #1f2937;
            background-color: #f9fafb;
        }
        .email-container { max-width: 600px; margin: 0 auto; background-color: #ffffff; }
        .header {
            background: #111827;
            padding: 32px 24px;
            text-align: center;
        }
        .header h1 { color: #ffffff; font-size: 22px; font-weight: 700; margin-bottom: 8px; }
        .header p { color: #e5e7eb; font-size: 14px; }
        .content { padding: 28px 24px; }
        .greeting { font-size: 18px; font-weight: 600; margin-bottom: 16px; color: #111827; }
        .message { font-size: 15px; color: #374151; margin-bottom: 16px; line-height: 1.8; }
        .box {
            background: #f3f4f6;
            border: 1px solid #e5e7eb;
            border-radius: 10px;
            padding: 16px;
            margin: 18px 0;
        }
        .label { font-size: 12px; color: #6b7280; text-transform: uppercase; letter-spacing: .06em; margin-bottom: 6px; }
        .value { font-size: 15px; color: #111827; font-weight: 600; }
        .pill {
            display: inline-block;
            padding: 6px 10px;
            border-radius: 9999px;
            font-size: 12px;
            font-weight: 700;
            letter-spacing: .04em;
        }
        .pill-accepted { background: #dcfce7; color: #166534; }
        .pill-declined { background: #fee2e2; color: #991b1b; }
        .footer {
            padding: 18px 24px;
            border-top: 1px solid #e5e7eb;
            color: #6b7280;
            font-size: 12px;
        }
        .muted { color: #6b7280; font-size: 13px; }
    </style>
</head>
<body>
<div class="email-container">
    <div class="header">
        <h1>Business Invitation Update</h1>
        <p>{{ config('app.name') }}</p>
    </div>

    <div class="content">
        @php
            $status = $status ?? 'declined';
            $recipientType = $recipientType ?? 'invitee';
            $statusText = $status === 'accepted' ? 'Accepted' : 'Declined';
        @endphp

        @if($recipientType === 'inviter')
            <div class="greeting">Hi {{ $inviter->full_name ?? $inviter->email }},</div>
            <div class="message">
                Your invitation to <strong>{{ $invitee->full_name ?? $invitee->email }}</strong> to manage
                <strong>{{ $business->name }}</strong> has been updated.
            </div>
        @else
            <div class="greeting">Hi {{ $invitee->full_name ?? $invitee->email }},</div>
            <div class="message">
                Your invitation for <strong>{{ $business->name }}</strong> has been updated.
            </div>
        @endif

        <div class="box">
            <div class="label">Status</div>
            <div class="value">
                <span class="pill {{ $status === 'accepted' ? 'pill-accepted' : 'pill-declined' }}">{{ $statusText }}</span>
            </div>
        </div>

        <div class="box">
            <div class="label">Business</div>
            <div class="value">{{ $business->name }}</div>
        </div>

        <div class="box">
            <div class="label">Role</div>
            <div class="value">{{ $invite->role }}</div>
        </div>

        @if($recipientType === 'inviter')
            <div class="message">
                If you believe this was a mistake, you can send a new invitation anytime.
            </div>
        @else
            <div class="message">
                If you didn’t expect this invitation, you can safely ignore this email.
            </div>
        @endif

        <div class="muted">
            Date: {{ now()->toDayDateTimeString() }}
        </div>
    </div>

    <div class="footer">
        © {{ date('Y') }} {{ config('app.name') }}
    </div>
</div>
</body>
</html>
