<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invitation Revoked</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: #1f2937;
            background-color: #f9fafb;
        }
        .email-container { max-width: 600px; margin: 0 auto; background-color: #ffffff; }
        .header {
            background: #111827;
            padding: 32px 24px;
            text-align: center;
        }
        .header h1 { color: #ffffff; font-size: 22px; font-weight: 700; margin-bottom: 8px; }
        .header p { color: #e5e7eb; font-size: 14px; }
        .content { padding: 28px 24px; }
        .greeting { font-size: 18px; font-weight: 600; margin-bottom: 16px; color: #111827; }
        .message { font-size: 15px; color: #374151; margin-bottom: 16px; line-height: 1.8; }
        .box {
            background: #f3f4f6;
            border: 1px solid #e5e7eb;
            border-radius: 10px;
            padding: 16px;
            margin: 18px 0;
        }
        .label { font-size: 12px; color: #6b7280; text-transform: uppercase; letter-spacing: .06em; margin-bottom: 6px; }
        .value { font-size: 15px; color: #111827; font-weight: 600; }
        .footer {
            padding: 18px 24px;
            border-top: 1px solid #e5e7eb;
            color: #6b7280;
            font-size: 12px;
        }
        .muted { color: #6b7280; font-size: 13px; }
    </style>
</head>
<body>
<div class="email-container">
    <div class="header">
        <h1>Invitation Revoked</h1>
        <p>{{ config('app.name') }}</p>
    </div>

    <div class="content">
        <div class="greeting">Hi {{ $invite->email }},</div>

        <div class="message">
            The invitation to manage <strong>{{ $business->name }}</strong> has been revoked by the business owner.
        </div>

        <div class="box">
            <div class="label">Token was</div>
            <div class="value">{{ $invite->token }}</div>
        </div>

        <div class="message">
            The link previously sent is no longer valid. If you believe this is a mistake, please contact the business owner directly.
        </div>

        <div class="muted">
            You can safely ignore this email.
        </div>
    </div>

    <div class="footer">
        © {{ date('Y') }} {{ config('app.name') }}
    </div>
</div>
</body>
</html>
