<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; border: 1px solid #eee; border-radius: 5px; }
        .header { background: #f8f8f8; padding: 10px; border-bottom: 2px solid #e74c3c; margin-bottom: 20px; }
        .label { font-weight: bold; color: #555; }
        .value { margin-bottom: 10px; }
        .button { display: inline-block; padding: 10px 20px; background: #e74c3c; color: white; text-decoration: none; border-radius: 4px; }
        .footer { margin-top: 30px; font-size: 12px; color: #999; border-top: 1px solid #eee; padding-top: 10px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Ad Reported</h2>
            <p>A user has reported an advertisement on Yilick.</p>
        </div>

        <div class="value">
            <span class="label">Reason:</span><br>
            <strong>{{ $data['reason'] }}</strong>
        </div>

        <div class="value">
            <span class="label">Explanation:</span><br>
            {{ $data['explanation'] ?: 'No explanation provided.' }}
        </div>

        <hr style="border: 0; border-top: 1px solid #eee; margin: 20px 0;">

        <div class="value">
            <span class="label">Ad Title:</span><br>
            {{ $data['listing_title'] }}
        </div>

        <div class="value">
            <span class="label">Ad URL:</span><br>
            <a href="{{ $data['listing_url'] }}">{{ $data['listing_url'] }}</a>
        </div>

        <div class="value">
             <a href="{{ $data['listing_url'] }}" class="button">View Listing</a>
        </div>

        <hr style="border: 0; border-top: 1px solid #eee; margin: 20px 0;">

        <div class="value">
            <span class="label">Reporter Info:</span><br>
            IP: {{ $data['reporter_ip'] ?? 'Unknown' }}<br>
            Email: {{ $data['reporter_email'] ?? 'Anonymous' }}
        </div>

        <div class="footer">
            This is an automated message from the Yilick Reporting System.
        </div>
    </div>
</body>
</html>
