@props(['listing' => null, 'boosted' => false])

<div class="group relative bg-white border border-gray-100 rounded-none overflow-hidden hover:shadow-md transition-all duration-300 cursor-pointer h-full flex flex-col" style="box-shadow: rgba(0, 0, 0, 0.05) 0px 2px 4px 0px;">
    <!-- Image Container -->
    <div class="aspect-[4/3] bg-gray-50 relative overflow-hidden">
        @if($listing && $listing->media->isNotEmpty())
            <img src="{{ $listing->media->first()->url }}" 
                 alt="{{ $listing->title }} for sale in {{ $listing->location_district ?? 'Uganda' }} - Yilick" 
                 onerror="this.onerror=null; this.src='/assets/icons/listing_placeholder.svg'"
                 class="w-full h-full object-cover">
        @else
            <div class="w-full h-full flex items-center justify-center bg-gray-50 text-gray-300">
                <i class="fa-regular fa-image text-3xl"></i>
            </div>
        @endif

        @if($boosted)
            <div class="absolute top-2 left-2 z-10">
                <span class="inline-flex items-center px-1.5 py-0.5 bg-[#28a745] text-white text-[10px] font-bold uppercase rounded-sm shadow-sm">
                    Featured
                </span>
            </div>
        @endif

        <!-- Favorite Action -->
        @php
            $isFavorited = $listing ? $listing->isFavoritedBy(Auth::guard('web')->user()) : false;
        @endphp
        <button 
            type="button"
            onclick="event.stopPropagation(); event.preventDefault(); toggleFavoriteGlobal(this, 'listing', {{ $listing->id ?? 0 }})"
            class="absolute top-2 right-2 w-7 h-7 rounded-sm bg-white/90 backdrop-blur-sm hover:bg-white {{ $isFavorited ? 'text-red-500' : 'text-gray-400' }} hover:text-red-500 shadow-sm flex items-center justify-center transition-all z-10 favorite-btn"
            data-active="{{ $isFavorited ? 'true' : 'false' }}">
            <i class="{{ $isFavorited ? 'fa-solid' : 'fa-regular' }} fa-heart text-xs"></i>
        </button>
    </div>

    <!-- Content Details -->
    <div class="p-3 flex flex-col flex-grow">
        <!-- Title -->
        <h3 class="text-[14px] font-medium text-[#333333] line-clamp-2 leading-tight mb-2 h-[34px]">
            {{ $listing->title }}
        </h3>

        <!-- Price -->
        <div class="mb-2">
            <span class="text-[15.2px] font-semibold text-[#28a745]">
                {{ $listing?->price_amount ? number_format($listing->price_amount) : '0' }} UGX
            </span>
        </div>

        <!-- Location (Bottom) -->
        <div class="mt-auto pt-2 border-t border-gray-50 flex items-center gap-1 text-[#666666]">
            <i class="fa-solid fa-location-dot text-[10px] opacity-60"></i>
            <span class="text-[12px] font-normal truncate">{{ $listing->location_district ?? 'Kampala' }}</span>
        </div>
    </div>

    @if($listing)
        <a href="{{ route('listing.share', $listing->slug) }}" class="absolute inset-0 z-0" aria-label="View {{ $listing->title }}"></a>
    @endif
</div>
