<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Password - {{ config('app.name') }}</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background-color: #f3f4f6;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .container {
            background: white;
            max-width: 520px;
            width: 92%;
            margin: 20px;
            padding: 36px 28px;
            border-radius: 12px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }
        h1 {
            font-size: 22px;
            margin: 0 0 8px 0;
            color: #111827;
        }
        p {
            margin: 0 0 18px 0;
            color: #6b7280;
            line-height: 1.6;
            font-size: 14px;
        }
        label {
            display: block;
            font-size: 13px;
            font-weight: 600;
            color: #374151;
            margin: 14px 0 6px 0;
        }
        input {
            width: 100%;
            padding: 12px 12px;
            border: 1px solid #e5e7eb;
            border-radius: 10px;
            font-size: 14px;
            outline: none;
            box-sizing: border-box;
        }
        input:focus {
            border-color: #10b981;
            box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.15);
        }
        .btn {
            width: 100%;
            margin-top: 18px;
            padding: 12px 14px;
            border-radius: 10px;
            border: none;
            background: #10b981;
            color: #ffffff;
            font-weight: 700;
            font-size: 14px;
            cursor: pointer;
        }
        .btn:hover {
            background: #059669;
        }
        .error {
            background: #fef2f2;
            border: 1px solid #fecaca;
            color: #991b1b;
            padding: 10px 12px;
            border-radius: 10px;
            margin-bottom: 14px;
            font-size: 13px;
        }
        .success {
            background: #f0fdf4;
            border: 1px solid #bbf7d0;
            color: #14532d;
            padding: 10px 12px;
            border-radius: 10px;
            margin-bottom: 14px;
            font-size: 13px;
        }
        .hint {
            margin-top: 14px;
            font-size: 12px;
            color: #6b7280;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Reset your password</h1>
        <p>Enter a new password for your account.</p>

        @if ($errors->any())
            <div class="error">
                @foreach ($errors->all() as $error)
                    <div>{{ $error }}</div>
                @endforeach
            </div>
        @endif

        <form method="POST" action="{{ route('password.update') }}">
            @csrf
            <input type="hidden" name="token" value="{{ $token }}" />

            <label for="email">Email</label>
            <input id="email" name="email" type="email" value="{{ old('email', $email) }}" required />

            <label for="password">New password</label>
            <input id="password" name="password" type="password" required />

            <label for="password_confirmation">Confirm new password</label>
            <input id="password_confirmation" name="password_confirmation" type="password" required />

            <button class="btn" type="submit">Reset Password</button>
        </form>

        <div class="hint">If you didn’t request a password reset, you can ignore this page.</div>
    </div>
</body>
</html>
