<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Verified - {{ config('app.name') }}</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background-color: #f3f4f6;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .container {
            background: white;
            max-width: 500px;
            width: 90%;
            margin: 20px;
            padding: 48px 32px;
            border-radius: 12px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            text-align: center;
        }
        .icon {
            width: 80px;
            height: 80px;
            background-color: #10b981;
            border-radius: 50%;
            margin: 0 auto 24px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .checkmark {
            width: 40px;
            height: 40px;
            border: 4px solid white;
            border-top: none;
            border-left: none;
            transform: rotate(45deg);
            margin-top: -10px;
        }
        h1 {
            font-size: 28px;
            font-weight: 700;
            color: #111827;
            margin: 0 0 12px 0;
        }
        p {
            font-size: 16px;
            color: #6b7280;
            line-height: 1.6;
            margin: 0 0 24px 0;
        }
        .email {
            background-color: #f3f4f6;
            padding: 12px 16px;
            border-radius: 8px;
            font-size: 14px;
            color: #10b981;
            font-weight: 600;
            margin: 24px 0;
            word-break: break-all;
        }
        .buttons {
            margin-top: 32px;
        }
        .btn {
            display: inline-block;
            padding: 12px 24px;
            margin: 8px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            font-size: 15px;
            transition: all 0.2s;
        }
        .btn-primary {
            background-color: #10b981;
            color: white;
        }
        .btn-primary:hover {
            background-color: #059669;
        }
        .btn-secondary {
            background-color: white;
            color: #10b981;
            border: 2px solid #10b981;
        }
        .btn-secondary:hover {
            background-color: #f0fdf4;
        }
        .features {
            margin-top: 32px;
            padding-top: 32px;
            border-top: 1px solid #e5e7eb;
        }
        .features h3 {
            font-size: 16px;
            color: #111827;
            margin-bottom: 16px;
        }
        .feature-list {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px;
            text-align: left;
        }
        .feature-item {
            font-size: 14px;
            color: #6b7280;
            display: flex;
            align-items: center;
        }
        .feature-item:before {
            content: "✓";
            display: inline-block;
            width: 20px;
            height: 20px;
            background-color: #10b981;
            color: white;
            border-radius: 50%;
            text-align: center;
            line-height: 20px;
            margin-right: 8px;
            font-size: 12px;
            flex-shrink: 0;
        }
        @media (max-width: 600px) {
            .container {
                padding: 32px 24px;
            }
            .feature-list {
                grid-template-columns: 1fr;
            }
            .btn {
                display: block;
                margin: 8px 0;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="icon">
            <div class="checkmark"></div>
        </div>
        
        <h1>Email Verified!</h1>
        <p>Your email address has been successfully verified. You now have full access to {{ config('app.name') }}.</p>
        
        <div class="email">{{ $user->email }}</div>
        
        <div class="buttons">
            <a href="{{ config('app.url') }}" class="btn btn-primary">Go to Dashboard</a>
            <a href="{{ config('app.url') }}/profile" class="btn btn-secondary">View Profile</a>
        </div>
        
        <div class="features">
            <h3>What's Next?</h3>
            <div class="feature-list">
                <div class="feature-item">Post listings</div>
                <div class="feature-item">Browse marketplace</div>
                <div class="feature-item">Connect with sellers</div>
                <div class="feature-item">Manage account</div>
            </div>
        </div>
    </div>
</body>
</html>
