<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Verified - {{ config('app.name') }}</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background-color: #f3f4f6;
            display: flex;
            min-height: 100vh;
            align-items: center;
            justify-content: center;
        }
        .container {
            background: white;
            max-width: 500px;
            width: 90%;
            margin: 20px;
            padding: 48px 32px;
            border-radius: 12px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            max-width: 500px;
            width: 100%;
            padding: 50px 40px;
            text-align: center;
            animation: slideUp 0.5s ease-out;
        }
        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        .success-icon {
            width: 80px;
            height: 80px;
            background: #10b981;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 30px;
            animation: scaleIn 0.5s ease-out 0.2s both;
        }
        @keyframes scaleIn {
            from {
                transform: scale(0);
            }
            to {
                transform: scale(1);
            }
        }
        .success-icon svg {
            width: 50px;
            height: 50px;
            stroke: #ffffff;
            stroke-width: 3;
            fill: none;
            stroke-linecap: round;
            stroke-linejoin: round;
        }
        .checkmark {
            stroke-dasharray: 100;
            stroke-dashoffset: 100;
            animation: drawCheck 0.5s ease-out 0.5s forwards;
        }
        @keyframes drawCheck {
            to {
                stroke-dashoffset: 0;
            }
        }
        h1 {
            font-size: 32px;
            font-weight: 700;
            color: #1f2937;
            margin-bottom: 15px;
        }
        .subtitle {
            font-size: 18px;
            color: #6b7280;
            margin-bottom: 30px;
            line-height: 1.6;
        }
        .user-info {
            background: #f9fafb;
            border-radius: 12px;
            padding: 20px;
            margin: 30px 0;
            border: 2px solid #e5e7eb;
        }
        .user-info p {
            font-size: 14px;
            color: #6b7280;
            margin-bottom: 8px;
        }
        .user-info .email {
            font-size: 16px;
            font-weight: 600;
            color: #10b981;
            word-break: break-all;
        }
        .actions {
            margin-top: 40px;
        }
        .btn {
            display: inline-block;
            padding: 14px 32px;
            border-radius: 50px;
            font-size: 16px;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s ease;
            margin: 8px;
        }
        .btn-primary {
            background: #10b981;
            color: #ffffff;
            box-shadow: 0 4px 15px rgba(16, 185, 129, 0.4);
        }
        .btn-primary:hover {
            background: #059669;
            box-shadow: 0 6px 20px rgba(16, 185, 129, 0.6);
            transform: translateY(-2px);
        }
        .btn-secondary {
            background: #ffffff;
            color: #10b981;
            border: 2px solid #10b981;
        }
        .btn-secondary:hover {
            background: #f0fdf4;
            transform: translateY(-2px);
        }
        .features {
            margin-top: 40px;
            padding-top: 30px;
            border-top: 1px solid #e5e7eb;
        }
        .features h3 {
            font-size: 18px;
            color: #1f2937;
            margin-bottom: 20px;
        }
        .feature-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
            text-align: left;
        }
        .feature-item {
            display: flex;
            align-items: center;
            font-size: 14px;
            color: #6b7280;
        }
        .feature-item::before {
            content: "✓";
            display: inline-block;
            width: 24px;
            height: 24px;
            background: #10b981;
            color: #ffffff;
            border-radius: 50%;
            text-align: center;
            line-height: 24px;
            margin-right: 10px;
            font-weight: bold;
            flex-shrink: 0;
        }
        @media (max-width: 600px) {
            .container {
                padding: 40px 30px;
            }
            h1 {
                font-size: 26px;
            }
            .subtitle {
                font-size: 16px;
            }
            .feature-grid {
                grid-template-columns: 1fr;
            }
            .btn {
                display: block;
                margin: 10px 0;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="success-icon">
            <svg viewBox="0 0 52 52">
                <path class="checkmark" d="M14 27l7.5 7.5L38 18"/>
            </svg>
        </div>

        <h1>Email Verified! 🎉</h1>
        <p class="subtitle">
            Your email address has been successfully verified. You now have full access to all features on {{ config('app.name') }}.
        </p>

        <div class="user-info">
            <p>Verified Email:</p>
            <p class="email">{{ $user->email }}</p>
        </div>

        <div class="actions">
            <a href="{{ config('app.url') }}" class="btn btn-primary">
                Go to Dashboard
            </a>
            <a href="{{ config('app.url') }}/profile" class="btn btn-secondary">
                Complete Profile
            </a>
        </div>

        <div class="features">
            <h3>What's Next?</h3>
            <div class="feature-grid">
                <div class="feature-item">Post your first listing</div>
                <div class="feature-item">Browse marketplace</div>
                <div class="feature-item">Connect with sellers</div>
                <div class="feature-item">Manage your account</div>
            </div>
        </div>
    </div>
</body>
</html>
