<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verification Failed - {{ config('app.name') }}</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background-color: #f3f4f6;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .container {
            background: white;
            max-width: 500px;
            width: 90%;
            margin: 20px;
            padding: 48px 32px;
            border-radius: 12px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            text-align: center;
        }
        .icon {
            width: 80px;
            height: 80px;
            background-color: #ef4444;
            border-radius: 50%;
            margin: 0 auto 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 48px;
            color: white;
            font-weight: bold;
        }
        h1 {
            font-size: 28px;
            font-weight: 700;
            color: #111827;
            margin: 0 0 12px 0;
        }
        p {
            font-size: 16px;
            color: #6b7280;
            line-height: 1.6;
            margin: 0 0 24px 0;
        }
        .error-box {
            background-color: #fef2f2;
            border-left: 4px solid #ef4444;
            padding: 16px;
            border-radius: 8px;
            text-align: left;
            margin: 24px 0;
        }
        .error-box p {
            font-size: 14px;
            color: #991b1b;
            margin: 8px 0;
        }
        .error-box strong {
            color: #7f1d1d;
        }
        .buttons {
            margin-top: 32px;
        }
        .btn {
            display: inline-block;
            padding: 12px 24px;
            margin: 8px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            font-size: 15px;
            transition: all 0.2s;
        }
        .btn-primary {
            background-color: #10b981;
            color: white;
        }
        .btn-primary:hover {
            background-color: #059669;
        }
        .btn-secondary {
            background-color: white;
            color: #10b981;
            border: 2px solid #10b981;
        }
        .btn-secondary:hover {
            background-color: #f0fdf4;
        }
        .help {
            margin-top: 32px;
            padding-top: 32px;
            border-top: 1px solid #e5e7eb;
        }
        .help h3 {
            font-size: 16px;
            color: #111827;
            margin-bottom: 8px;
        }
        .help p {
            font-size: 14px;
        }
        @media (max-width: 600px) {
            .container {
                padding: 32px 24px;
            }
            .btn {
                display: block;
                margin: 8px 0;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="icon">✕</div>
        
        <h1>Verification Link Invalid</h1>
        <p>We couldn't verify your email address. The verification link may have expired or is invalid.</p>
        
        <div class="error-box">
            <p><strong>Common reasons:</strong></p>
            <p>• The verification link has expired (valid for 60 minutes)</p>
            <p>• The link has already been used</p>
            <p>• The link was copied incorrectly</p>
            <p>• Your email has already been verified</p>
        </div>
        
        <div class="buttons">
            <a href="{{ config('app.url') }}/resend-verification" class="btn btn-primary">Resend Verification Email</a>
            <a href="{{ config('app.url') }}/login" class="btn btn-secondary">Back to Login</a>
        </div>
        
        <div class="help">
            <h3>Need Help?</h3>
            <p>If you continue to experience issues, please contact our support team.</p>
        </div>
    </div>
</body>
</html>
