<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verification Failed - {{ config('app.name') }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            background: #10b981;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .container {
            background: #ffffff;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            max-width: 500px;
            width: 100%;
            padding: 50px 40px;
            text-align: center;
            animation: slideUp 0.5s ease-out;
        }
        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        .error-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 30px;
            animation: scaleIn 0.5s ease-out 0.2s both;
        }
        @keyframes scaleIn {
            from {
                transform: scale(0);
            }
            to {
                transform: scale(1);
            }
        }
        .error-icon::before {
            content: "✕";
            font-size: 50px;
            color: #ffffff;
            font-weight: bold;
        }
        h1 {
            font-size: 32px;
            font-weight: 700;
            color: #1f2937;
            margin-bottom: 15px;
        }
        .subtitle {
            font-size: 18px;
            color: #6b7280;
            margin-bottom: 30px;
            line-height: 1.6;
        }
        .error-box {
            background: #fef2f2;
            border-left: 4px solid #ef4444;
            border-radius: 8px;
            padding: 20px;
            margin: 30px 0;
            text-align: left;
        }
        .error-box p {
            font-size: 14px;
            color: #991b1b;
            margin-bottom: 10px;
        }
        .error-box p:last-child {
            margin-bottom: 0;
        }
        .error-box strong {
            color: #7f1d1d;
        }
        .actions {
            margin-top: 40px;
        }
        .btn {
            display: inline-block;
            padding: 14px 32px;
            border-radius: 50px;
            font-size: 16px;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s ease;
            margin: 8px;
        }
        .btn-primary {
            background: #10b981;
            color: #ffffff;
            box-shadow: 0 4px 15px rgba(16, 185, 129, 0.4);
        }
        .btn-primary:hover {
            background: #059669;
            box-shadow: 0 6px 20px rgba(16, 185, 129, 0.6);
            transform: translateY(-2px);
        }
        .btn-secondary {
            background: #ffffff;
            color: #10b981;
            border: 2px solid #10b981;
        }
        .btn-secondary:hover {
            background: #f0fdf4;
            transform: translateY(-2px);
        }
        .help-section {
            margin-top: 40px;
            padding-top: 30px;
            border-top: 1px solid #e5e7eb;
        }
        .help-section h3 {
            font-size: 18px;
            color: #1f2937;
            margin-bottom: 15px;
        }
        .help-section p {
            font-size: 14px;
            color: #6b7280;
            line-height: 1.6;
        }
        @media (max-width: 600px) {
            .container {
                padding: 40px 30px;
            }
            h1 {
                font-size: 26px;
            }
            .subtitle {
                font-size: 16px;
            }
            .btn {
                display: block;
                margin: 10px 0;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="error-icon"></div>

        <h1>Verification Link Invalid</h1>
        <p class="subtitle">
            We couldn't verify your email address. The verification link may have expired or is invalid.
        </p>

        <div class="error-box">
            <p><strong>Common reasons:</strong></p>
            <p>• The verification link has expired (links are valid for 60 minutes)</p>
            <p>• The link has already been used</p>
            <p>• The link was copied incorrectly</p>
            <p>• Your email has already been verified</p>
        </div>

        <div class="actions">
            <a href="{{ config('app.url') }}/resend-verification" class="btn btn-primary">
                Resend Verification Email
            </a>
            <a href="{{ config('app.url') }}/login" class="btn btn-secondary">
                Back to Login
            </a>
        </div>

        <div class="help-section">
            <h3>Need Help?</h3>
            <p>
                If you continue to experience issues, please contact our support team at 
                <strong>{{ config('mail.from.address') }}</strong>
            </p>
        </div>
    </div>
</body>
</html>
